/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages;

import com.datastax.devcenter.cql.ui.databinding.validation.NotEmptyValidator;
import com.datastax.devcenter.cql.ui.providers.SchemaElementLabelProvider;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDialog;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.TableWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.KeyspaceChoosingDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.schema.ISchemaElement;
import com.datastax.devcenter.schema.ITableElement;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public abstract class TableChoosingDDLWizardPage<E extends ITableElement>
extends KeyspaceChoosingDDLWizardPage<E> {
    private final TableWritableList tables = new TableWritableList();
    private ComboViewer tableComboViewer;
    private IObservableValue tableObservable;

    public TableChoosingDDLWizardPage(DDLWizardModel<E> model, DDLWizardDescription description, CqlPreview cqlPreview, DDLWizard.DDLAction ddlAction, String mainHelpUrl) {
        super(model, description, cqlPreview, ddlAction, mainHelpUrl);
    }

    protected ComboViewer getTableComboViewer() {
        return this.tableComboViewer;
    }

    @Override
    protected void createPageSpecificContent(Composite container, DataBindingContext ctx) {
        super.createPageSpecificContent(container, ctx);
        this.separator(container);
        this.layoutTableCombo(container, ctx);
    }

    protected void layoutTableCombo(Composite container, DataBindingContext ctx) {
        new Label(container, 0).setText("Table:");
        Combo combo = new Combo(container, 8);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = 10;
        combo.setLayoutData((Object)data);
        combo.setEnabled(this.isCreation());
        this.tableComboViewer = new ComboViewer(combo);
        this.tableComboViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.tableComboViewer.setInput((Object)this.tables);
        this.tableComboViewer.setLabelProvider((IBaseLabelProvider)new SchemaElementLabelProvider());
        IViewerObservableValue target = ViewersObservables.observeSingleSelection((Viewer)this.tableComboViewer);
        this.tableObservable = BeanProperties.value((String)"table").observe(this.getModel().getCurrent());
        NotEmptyValidator validator = new NotEmptyValidator("Table cannot be empty");
        this.bindValue(ctx, (IObservableValue)target, this.tableObservable, validator);
        Button button = new Button(container, 8);
        button.setText("New...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableChoosingDDLWizardPage.this.openNewTableWizard();
            }
        });
        button.setEnabled(this.isCreation());
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tableObservable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                TableChoosingDDLWizardPage.this.tableChanged((Table)event.getObservableValue().getValue());
            }
        });
    }

    @Override
    protected void postCreateControl() {
        super.postCreateControl();
        this.selectFirstAvailableTable();
        this.tableChanged(((ITableElement)this.getModel().getCurrent()).getTable());
    }

    @Override
    protected void keyspaceChanged(Keyspace keyspace) {
        super.keyspaceChanged(keyspace);
        this.repopulateTableList(keyspace);
    }

    protected void tableChanged(Table table) {
    }

    private void openNewTableWizard() {
        TableWizard wizard = new TableWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)this.getKeyspaceComboViewer().getSelection(), DDLWizard.DDLAction.CREATE, true);
        DDLWizardDialog wizardDialog = new DDLWizardDialog(this.getShell(), wizard);
        if (wizardDialog.open() == 0) {
            Table newTable = (Table)wizard.getModel().getCurrent();
            ArrayList<Table> newKeyspaces = new ArrayList<Table>((Collection<Table>)((Object)this.tables));
            newKeyspaces.add(newTable);
            Collections.sort(newKeyspaces, ISchemaElement.NAME_COMPARATOR);
            this.tables.repopulate(newKeyspaces);
            this.tableComboViewer.refresh();
            this.tableComboViewer.setSelection((ISelection)new StructuredSelection((Object)newTable), true);
            this.getCqlPreview().getCqlContext().updateDatabaseSchemaAndReset(this.getModel().getConnection());
        }
    }

    private void selectFirstAvailableTable() {
        if (!this.tables.isEmpty() && ((ITableElement)this.getModel().getCurrent()).getTable() == null) {
            this.tableObservable.setValue(this.tables.iterator().next());
        }
    }

    private void repopulateTableList(Keyspace keyspace) {
        if (keyspace != null) {
            ArrayList<Table> newTables = new ArrayList<Table>();
            newTables.addAll(keyspace.getTables());
            Collections.sort(newTables, ISchemaElement.NAME_COMPARATOR);
            this.tables.clear();
            this.tables.repopulate(newTables);
            if (this.tableObservable.getValue() != null) {
                Object table = this.tableObservable.getValue();
                if (this.tables.contains(table)) {
                    this.tableComboViewer.setSelection((ISelection)new StructuredSelection(table));
                } else {
                    this.tableObservable.setValue(null);
                }
            }
            if (this.tableObservable.getValue() == null) {
                this.selectFirstAvailableTable();
            }
        } else {
            this.tables.clear();
        }
    }

    private static class TableWritableList
    extends WritableList {
        public TableWritableList() {
            super(new ArrayList(), Table.class);
        }

        public void repopulate(List<Table> newList) {
            super.updateWrappedList(newList);
        }
    }
}

