/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages.index;

import com.datastax.devcenter.cql.cql.IndexColumnDef;
import com.datastax.devcenter.cql.generators.CreateIndexStatementGenerator;
import com.datastax.devcenter.cql.ui.databinding.validation.IdentifierValidator;
import com.datastax.devcenter.cql.ui.providers.cell.BeanPropertyCellLabelProvider;
import com.datastax.devcenter.cql.ui.providers.editing_support.ComboBoxBeanPropertyEditingSupport;
import com.datastax.devcenter.cql.ui.providers.editing_support.TextBeanPropertyEditingSupport;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.TableChoosingDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.cql.util.IndexUtils;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.ElementNameProvider;
import com.datastax.devcenter.schema.Index;
import com.datastax.devcenter.schema.Indices;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Table;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class IndexBasicSettingsDDLWizardPage
extends TableChoosingDDLWizardPage<Indices> {
    private IObservableList indices;
    private TableViewer tableViewer;
    private IViewerObservableValue selectedField;
    private Table selectedTable;
    private Button addButton;
    private AdditionalIndexValidator additionalIndexValidator = new AdditionalIndexValidator();

    public IndexBasicSettingsDDLWizardPage(DDLWizardModel<Indices> model, DDLWizardDescription description, CqlPreview cqlPreview, DDLWizard.DDLAction ddlAction, String mainHelpUrl) {
        super(model, description, cqlPreview, ddlAction, mainHelpUrl);
    }

    @Override
    protected void createPageSpecificContent(Composite container, DataBindingContext ctx) {
        super.createPageSpecificContent(container, ctx);
        this.separator(container);
        this.layoutFieldsTable(container, ctx);
        this.layoutColumnsTableButtons(container, ctx);
        ctx.addValidationStatusProvider((ValidationStatusProvider)this.additionalIndexValidator);
    }

    private void layoutFieldsTable(Composite container, DataBindingContext ctx) {
        this.label(container, "Secondary indices:", 128);
        Composite tableContainer = new Composite(container, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(tableContainer, 68096);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        tableLayout.setColumnData((Widget)this.layoutNameColumn(this.tableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(100));
        tableLayout.setColumnData((Widget)this.layoutFieldColumn(this.tableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(100));
        this.initColumnsTableContents();
        org.eclipse.swt.widgets.Table table = this.tableViewer.getTable();
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 10;
        data.minimumHeight = 10 * table.getItemHeight();
        tableContainer.setLayoutData((Object)data);
        table.setSelection(0);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
    }

    private void initColumnsTableContents() {
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.indices = BeanProperties.list(Indices.class, (String)"indices").observe(this.getModel().getCurrent());
        this.indices.addChangeListener((IChangeListener)this.getCqlPreview());
        this.tableViewer.setInput((Object)this.indices);
        this.selectedField = ViewerProperties.singleSelection().observe((Viewer)this.tableViewer);
    }

    private TableColumn layoutNameColumn(TableViewer tableViewer, DataBindingContext ctx) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        IBeanValueProperty property = BeanProperties.value(Index.class, (String)"name");
        BeanPropertyCellLabelProvider labelProvider = new BeanPropertyCellLabelProvider(property);
        TextBeanPropertyEditingSupport editingSupport = new TextBeanPropertyEditingSupport((ColumnViewer)tableViewer, ctx, property){

            protected boolean canEdit(Object element) {
                return !((Indices)IndexBasicSettingsDDLWizardPage.this.getModel().getInitial()).contains(element);
            }
        };
        editingSupport.addModelChangeListener(this.getCqlPreview());
        editingSupport.setAfterConvertValidator(new IndexNameValidator());
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        viewerColumn.setEditingSupport((EditingSupport)editingSupport);
        TableColumn column = viewerColumn.getColumn();
        column.setText("Index name");
        column.setAlignment(16384);
        return column;
    }

    private TableColumn layoutFieldColumn(TableViewer tableViewer, DataBindingContext ctx) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        IBeanValueProperty property = BeanProperties.value(Index.class, (String)"definition", Index.IndexDefinition.class);
        BeanPropertyCellLabelProvider labelProvider = new BeanPropertyCellLabelProvider(property){

            @Override
            public String getText(Object element) {
                Index index = (Index)element;
                Index.IndexDefinition definition = index.getDefinition();
                return IndexUtils.serialize((IndexColumnDef)CreateIndexStatementGenerator.getIndexColumnDef((Index.IndexDefinition)definition));
            }
        };
        ComboBoxBeanPropertyEditingSupport editingSupport = new ComboBoxBeanPropertyEditingSupport((ColumnViewer)tableViewer, ctx, property, this.getTableColumns()){

            protected boolean canEdit(Object element) {
                return !((Indices)IndexBasicSettingsDDLWizardPage.this.getModel().getInitial()).contains(element);
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                ComboBoxCellEditor cell = (ComboBoxCellEditor)super.getCellEditor(element);
                Index index = (Index)element;
                cell.setItems(IndexBasicSettingsDDLWizardPage.this.getTableColumns(index.getColumn()));
                return cell;
            }
        };
        editingSupport.setAfterGetValidator(new IValidator(){

            public IStatus validate(Object value) {
                IndexColumnDef parsedValue = IndexUtils.parseIndexDefinition((String)((String)value));
                if (parsedValue == null || parsedValue.getColumn() == null) {
                    return ValidationStatus.error((String)String.format("%s is not a valid index definition", value));
                }
                String columnName = parsedValue.getColumn().getName();
                if (IndexBasicSettingsDDLWizardPage.this.selectedTable.getColumn(ModelUtil.stripName((String)columnName)) == null) {
                    return ValidationStatus.error((String)String.format("Column %s doesn't exist in the selected table", columnName));
                }
                return ValidationStatus.ok();
            }
        });
        editingSupport.setModelToTargetConverter((IConverter)new Converter(Index.IndexDefinition.class, String.class){

            public String convert(Object fromObject) {
                Index.IndexDefinition definition = (Index.IndexDefinition)fromObject;
                return IndexUtils.serialize((IndexColumnDef)CreateIndexStatementGenerator.getIndexColumnDef((Index.IndexDefinition)definition));
            }
        });
        editingSupport.setTargetToModelConverter((IConverter)new Converter(String.class, Index.IndexDefinition.class){

            public Index.IndexDefinition convert(Object fromObject) {
                IndexColumnDef parsedDefinition = IndexUtils.parseIndexDefinition((String)((String)fromObject));
                Index.IndexDefinition indexDefinition = new Index.IndexDefinition();
                indexDefinition.setColumn(IndexBasicSettingsDDLWizardPage.this.selectedTable.getColumn(ModelUtil.stripName((String)parsedDefinition.getColumn().getName())));
                indexDefinition.setKeys(parsedDefinition.isKeys());
                indexDefinition.setFull(parsedDefinition.isFull());
                indexDefinition.setEntries(parsedDefinition.isEntries());
                return indexDefinition;
            }
        });
        editingSupport.addModelChangeListener(this.getCqlPreview());
        viewerColumn.setEditingSupport((EditingSupport)editingSupport);
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        TableColumn column = viewerColumn.getColumn();
        column.setText("Column");
        column.setAlignment(16384);
        return column;
    }

    @Override
    protected void tableChanged(Table table) {
        this.selectedTable = table;
        this.resetIndices();
        this.tableViewer.refresh();
        this.addButton.setEnabled(this.getTableColumns().length > 0);
        this.additionalIndexValidator.forceRevalidate();
    }

    public void resetIndices() {
        Indices current = (Indices)this.getModel().getCurrent();
        current.clear();
        if (this.selectedTable == null) {
            return;
        }
        Indices initial = (Indices)this.getModel().getInitial();
        current.addAll((Collection)initial);
        int i = current.size() - 1;
        while (i >= 0) {
            Index index = current.get(i);
            Table indexTable = index.getColumn().getTable();
            Keyspace indexKeyspace = index.getColumn().getKeyspace();
            Keyspace selectedKeyspace = this.selectedTable.getKeyspace();
            if (!indexTable.equals((Object)this.selectedTable) || !indexKeyspace.equals((Object)selectedKeyspace)) {
                current.remove((Object)index);
            }
            --i;
        }
    }

    private String[] getTableColumns() {
        return this.getTableColumns(null);
    }

    private String[] getTableColumns(Column selectedColumn) {
        if (this.selectedTable == null) {
            return new String[0];
        }
        ArrayList columnNames = new ArrayList();
        for (Column column : this.selectedTable.getColumns()) {
            Indices indices = (Indices)this.getModel().getCurrent();
            IndexUtils.addColumnName((Indices)indices, columnNames, (Column)selectedColumn, (Column)column);
        }
        return columnNames.toArray(new String[0]);
    }

    private void layoutColumnsTableButtons(Composite container, DataBindingContext ctx) {
        Composite buttons = this.verticalGroup(container, 1, 128);
        this.layoutAddButton(buttons, ctx);
        this.layoutRemoveButton(buttons, ctx);
    }

    private void layoutAddButton(Composite buttons, DataBindingContext ctx) {
        this.addButton = this.button(buttons, "Add", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String[] availableColumns = IndexBasicSettingsDDLWizardPage.this.getTableColumns();
                IndexColumnDef definition = IndexUtils.parseIndexDefinition((String)availableColumns[0]);
                ArrayList allIndices = new ArrayList();
                allIndices.addAll((Collection)IndexBasicSettingsDDLWizardPage.this.getModel().getCurrent());
                allIndices.addAll((Collection)IndexBasicSettingsDDLWizardPage.this.getModel().getInitial());
                Index index = new Index(ElementNameProvider.availableName(allIndices, (String)"index"));
                index.setColumn(IndexBasicSettingsDDLWizardPage.this.selectedTable.getColumn(ModelUtil.stripName((String)definition.getColumn().getName())));
                index.setFull(definition.isFull());
                index.setKeys(definition.isKeys());
                IndexBasicSettingsDDLWizardPage.this.indices.add((Object)index);
                IndexBasicSettingsDDLWizardPage.this.additionalIndexValidator.forceRevalidate();
                if (IndexBasicSettingsDDLWizardPage.this.getTableColumns().length == 0 && event != null && event.getSource() != null) {
                    Button add = (Button)event.getSource();
                    add.setEnabled(false);
                }
            }
        });
    }

    private void layoutRemoveButton(Composite buttons, DataBindingContext ctx) {
        Button remove = this.button(buttons, "Remove", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Indices indices = (Indices)IndexBasicSettingsDDLWizardPage.this.getModel().getCurrent();
                Index index = (Index)IndexBasicSettingsDDLWizardPage.this.selectedField.getValue();
                indices.remove((Object)index);
                IndexBasicSettingsDDLWizardPage.this.additionalIndexValidator.forceRevalidate();
                if (IndexBasicSettingsDDLWizardPage.this.getTableColumns().length > 0) {
                    IndexBasicSettingsDDLWizardPage.this.addButton.setEnabled(true);
                }
            }
        });
        ComputedValue canRemove = new ComputedValue(){

            protected Object calculate() {
                Index index = (Index)IndexBasicSettingsDDLWizardPage.this.selectedField.getValue();
                if (index != null && !((Indices)IndexBasicSettingsDDLWizardPage.this.getModel().getInitial()).contains((Object)index)) {
                    return true;
                }
                return false;
            }
        };
        this.bindValue(ctx, (IObservableValue)canRemove, (IObservableValue)WidgetProperties.enabled().observe((Widget)remove)).updateTargetToModel();
    }

    private class AdditionalIndexValidator
    extends MultiValidator {
        private AdditionalIndexValidator() {
        }

        protected IStatus validate() {
            if (IndexBasicSettingsDDLWizardPage.this.selectedTable != null && IndexBasicSettingsDDLWizardPage.this.selectedTable.hasCounter()) {
                return ValidationStatus.error((String)"Secondary indexes are not supported on counter tables");
            }
            if (IndexBasicSettingsDDLWizardPage.this.selectedTable != null && IndexBasicSettingsDDLWizardPage.this.getTableColumns().length == 0) {
                return ValidationStatus.warning((String)"All valid columns have been indexed already");
            }
            return ValidationStatus.ok();
        }

        public void forceRevalidate() {
            this.revalidate();
        }
    }

    private class IndexNameValidator
    extends IdentifierValidator {
        protected IndexNameValidator() {
            super("Index name", true);
        }
    }
}

