/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages.keyspace;

import com.datastax.devcenter.common.utils.BeanPropertyHelper;
import com.datastax.devcenter.cql.ui.databinding.binding.NullableGroup;
import com.datastax.devcenter.cql.ui.databinding.binding.NullableResettableBinding;
import com.datastax.devcenter.cql.ui.databinding.binding.ResettableGroup;
import com.datastax.devcenter.cql.ui.databinding.conversion.BooleanObjectToBooleanPrimitiveConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.IntegerObjectToIntegerPrimitiveConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.ObjectToStringPropertyConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.StringToEnumConverter;
import com.datastax.devcenter.cql.ui.databinding.observable.And;
import com.datastax.devcenter.cql.ui.databinding.observable.IsOptionValidForReplicationStrategy;
import com.datastax.devcenter.cql.ui.databinding.validation.IdentifierValidator;
import com.datastax.devcenter.cql.ui.providers.cell.BeanPropertyCellLabelProvider;
import com.datastax.devcenter.cql.ui.providers.editing_support.TextBeanPropertyEditingSupport;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.ConnectionChoosingDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPageOptionsManager;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.options.KeyspaceOptions;
import com.datastax.devcenter.schema.options.KeyspaceReplication;
import com.datastax.devcenter.schema.options.OptionsHelper;
import com.datastax.devcenter.schema.options.ReplicationStrategy;
import com.datastax.driver.core.VersionNumber;
import com.ibm.icu.text.NumberFormat;
import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class KeyspaceBasicSettingsDDLWizardPage
extends ConnectionChoosingDDLWizardPage<Keyspace> {
    private static final int REPLICATION_FACTOR_MIN = 1;
    private static final int REPLICATION_FACTOR_MAX = 100;
    private ComboViewer replicationComboViewer;
    private IObservableValue replicationComboCheckboxSelected;
    private Composite replicationStrategyStack;
    private StackLayout replicationStrategyStackLayout;
    private IObservableList dataCenters;
    private TableViewer tableViewer;
    private IViewerObservableValue selectedDataCenter;
    private KeyspaceOptionsManager optionsMgr;

    public KeyspaceBasicSettingsDDLWizardPage(DDLWizardModel<Keyspace> model, DDLWizardDescription description, CqlPreview cqlPreview, DDLWizard.DDLAction ddlAction, String mainHelpUrl) {
        super(model, description, cqlPreview, ddlAction, mainHelpUrl);
    }

    @Override
    protected void preCreateControl() {
        super.preCreateControl();
        this.optionsMgr = new KeyspaceOptionsManager(this);
        this.optionsMgr.preCreateControl();
        Keyspace keyspace = (Keyspace)this.getModel().getCurrent();
        if (keyspace.getOptions() == null) {
            keyspace.setOptions(new KeyspaceOptions());
        }
        if (keyspace.getOptions().getReplication() == null) {
            keyspace.getOptions().setReplication(new KeyspaceReplication());
        }
    }

    @Override
    protected void postCreateControl() {
        super.postCreateControl();
        if (this.isCreation() && this.replicationComboViewer.getSelection().isEmpty()) {
            this.replicationComboViewer.setSelection((ISelection)new StructuredSelection((Object)ReplicationStrategy.SIMPLE));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.optionsMgr.installListeners();
    }

    @Override
    protected void createPageSpecificContent(Composite container, DataBindingContext ctx) {
        super.createPageSpecificContent(container, ctx);
        this.layoutKeyspaceName(container, ctx);
        this.separator(container);
        this.layoutReplicationStrategyOptionsGroup(container, ctx);
        this.layoutDurableWrites(container, ctx);
        this.optionsMgr.layoutResetLink(container, 2);
        this.optionsMgr.layoutLinkToDocs(container, 2);
    }

    private void layoutKeyspaceName(Composite container, DataBindingContext ctx) {
        this.label(container, "Keyspace name:");
        Text text = new Text(container, 2048);
        GridData data = new GridData(4, 128, true, false);
        data.horizontalIndent = 14;
        text.setLayoutData((Object)data);
        this.emptyCell(container);
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)text);
        IObservableValue model = BeansObservables.observeValue(this.getModel().getCurrent(), (String)"name");
        IdentifierValidator identifierValidator = new IdentifierValidator("Keyspace name");
        this.bindValue(ctx, (IObservableValue)target, model, identifierValidator);
        model.addChangeListener((IChangeListener)this.getCqlPreview());
        text.setEnabled(this.isCreation());
    }

    private void layoutDurableWrites(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 1);
        String property = "options.durableWrites";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Durable writes:", "Durable writes");
        Composite group = this.horizontalGroup(container, 1, 2, 16384);
        Button value = new Button(group, 32);
        GridData data = new GridData(16384, 0x1000000, true, false);
        data.horizontalIndent = 10;
        value.setLayoutData((Object)data);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)value);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new BooleanObjectToBooleanPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutReplicationStrategyOptionsGroup(Composite container, DataBindingContext ctx) {
        this.layoutReplicationStrategyCombo(container, ctx);
        final Group fieldset = this.fieldset(container, "", 1, 3);
        GridData data = new GridData(4, 128, true, true);
        data.horizontalSpan = 3;
        fieldset.setLayoutData((Object)data);
        fieldset.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Table table = KeyspaceBasicSettingsDDLWizardPage.this.tableViewer.getTable();
                table.setSize(table.getSize().x, fieldset.getSize().y - 24);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.replicationStrategyStack = this.stack((Composite)fieldset, 1);
        this.replicationStrategyStackLayout = (StackLayout)this.replicationStrategyStack.getLayout();
        this.layoutSimpleStrategy(this.replicationStrategyStack, ctx);
        this.layoutNetworkTopologyStrategy(this.replicationStrategyStack, ctx);
    }

    private void layoutReplicationStrategyCombo(Composite container, DataBindingContext ctx) {
        DDLWizardPageOptionsManager.OptionToggle optionAlwaysOn = this.optionsMgr.optionAlwaysOn(container, "Replication Strategy:", "Replication Strategy");
        this.replicationComboCheckboxSelected = optionAlwaysOn.getStatus();
        Combo combo = new Combo(container, 8);
        GridData data = new GridData(16384, 0x1000000, true, false);
        data.horizontalIndent = 10;
        combo.setLayoutData((Object)data);
        this.replicationComboViewer = new ComboViewer(combo);
        this.replicationComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        IBeanValueProperty property = BeanProperties.value(ReplicationStrategy.class, (String)"simpleName");
        this.replicationComboViewer.setLabelProvider((IBaseLabelProvider)new BeanPropertyCellLabelProvider(property));
        this.replicationComboViewer.setInput((Object)new ReplicationStrategy[]{ReplicationStrategy.SIMPLE, ReplicationStrategy.NETWORK_TOPOLOGY});
        this.emptyCell(container);
        NullableGroup target = new NullableGroup(this.replicationComboCheckboxSelected, (IObservableValue)WidgetProperties.selection().observe((Widget)combo), (IObservableValue)WidgetProperties.enabled().observe((Widget)combo));
        ResettableGroup model = this.optionsMgr.newResettableGroup("options.replication.strategy");
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new ObjectToStringPropertyConverter(property));
        binding.setTargetToModelConverter((IConverter)new StringToEnumConverter(ReplicationStrategy.class));
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.setReplicationStrategyObservable((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.replicationComboViewer));
    }

    private void layoutSimpleStrategy(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.replication.replicationFactor";
        this.optionsMgr.bindOptionValidityToRowVisibilityInStack(row, property, this.replicationStrategyStack, this.replicationStrategyStackLayout);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.optionAlwaysOn(row, "Replication factor:", "Replication factor");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        GridData data = new GridData(16384, 0x1000000, true, false);
        data.horizontalIndent = 5;
        group.setLayoutData((Object)data);
        Spinner spinner = this.spinner(group, 0, 0, 100, 1);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToReplicationStrategy(ctx, option);
        this.bindWidgetToReplicationStrategyAndOption(ctx, option, (Widget)spinner);
        spinner.setMinimum(1);
    }

    private void layoutNetworkTopologyStrategy(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2, false);
        String property = "options.replication.networkStrategyDataCenters";
        this.optionsMgr.bindOptionValidityToRowVisibilityInStack(row, property, this.replicationStrategyStack, this.replicationStrategyStackLayout);
        this.layoutDataCentersTable(row, ctx);
        this.layoutDataCentersTableButtons(row, ctx);
    }

    private void layoutDataCentersTable(Composite container, DataBindingContext ctx) {
        Composite tableContainer = new Composite(container, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(tableContainer, 68096);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        tableLayout.setColumnData((Widget)this.layoutNameColumn(this.tableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(155));
        tableLayout.setColumnData((Widget)this.layoutRFColumn(this.tableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(100));
        this.initDataCentersTableContents();
        Table table = this.tableViewer.getTable();
        GridData data = new GridData(4, 4, true, false);
        data.minimumHeight = 5 * table.getItemHeight();
        tableContainer.setLayoutData((Object)data);
        table.setSelection(0);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
    }

    private void initDataCentersTableContents() {
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.dataCenters = BeanProperties.list(KeyspaceReplication.class, (String)"networkStrategyDataCenters").observe((Object)((Keyspace)this.getModel().getCurrent()).getOptions().getReplication());
        this.dataCenters.addChangeListener((IChangeListener)this.getCqlPreview());
        this.tableViewer.setInput((Object)this.dataCenters);
        this.selectedDataCenter = ViewerProperties.singleSelection().observe((Viewer)this.tableViewer);
    }

    private TableColumn layoutNameColumn(TableViewer tableViewer, DataBindingContext ctx) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        IBeanValueProperty property = BeanProperties.value(KeyspaceReplication.DataCenter.class, (String)"name");
        BeanPropertyCellLabelProvider labelProvider = new BeanPropertyCellLabelProvider(property);
        TextBeanPropertyEditingSupport editingSupport = new TextBeanPropertyEditingSupport((ColumnViewer)tableViewer, ctx, property);
        editingSupport.addModelChangeListener(this.getCqlPreview());
        viewerColumn.setEditingSupport((EditingSupport)editingSupport);
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        TableColumn column = viewerColumn.getColumn();
        column.setText("Data Center Name");
        column.setAlignment(16384);
        return column;
    }

    private TableColumn layoutRFColumn(TableViewer tableViewer, DataBindingContext ctx) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        IBeanValueProperty property = BeanProperties.value(KeyspaceReplication.DataCenter.class, (String)"replicationFactor");
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        BeanPropertyCellLabelProvider labelProvider = new BeanPropertyCellLabelProvider(property, (IConverter)NumberToStringConverter.fromInteger((NumberFormat)numberFormat, (boolean)false));
        TextBeanPropertyEditingSupport editingSupport = new TextBeanPropertyEditingSupport((ColumnViewer)tableViewer, ctx, property);
        editingSupport.setAfterGetValidator(new IValidator(){

            public IStatus validate(Object value) {
                int rf;
                if (value == null || value.toString().isEmpty()) {
                    return ValidationStatus.error((String)"Replication factor cannot be empty");
                }
                try {
                    rf = Integer.parseInt(value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    return ValidationStatus.error((String)"Replication factor must be an integer");
                }
                if (rf < 1 || rf > 100) {
                    return ValidationStatus.error((String)String.format("Replication factor must be between %d and %d", 1, 100));
                }
                return ValidationStatus.ok();
            }
        });
        editingSupport.addModelChangeListener(this.getCqlPreview());
        viewerColumn.setEditingSupport((EditingSupport)editingSupport);
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        TableColumn column = viewerColumn.getColumn();
        column.setText("Replication Factor");
        column.setAlignment(16384);
        return column;
    }

    private void layoutDataCentersTableButtons(Composite container, DataBindingContext ctx) {
        Composite buttons = this.verticalGroup(container, 1, 128);
        this.layoutAddButton(buttons);
        this.layoutRemoveButton(buttons, ctx);
        this.layoutUpButton(buttons, ctx);
        this.layoutDownButton(buttons, ctx);
    }

    private void layoutAddButton(Composite buttons) {
        Button add = this.button(buttons, "Add", (SelectionListener)new SelectionAdapter(){
            private long counter = 1L;

            public void widgetSelected(SelectionEvent event) {
                KeyspaceReplication.DataCenter datacenter;
                KeyspaceReplication keyspaceReplication = ((Keyspace)KeyspaceBasicSettingsDDLWizardPage.this.getModel().getCurrent()).getOptions().getReplication();
                VersionNumber versionNumber = KeyspaceBasicSettingsDDLWizardPage.this.getModel().getVersionNumber();
                String defaultDC = String.valueOf(OptionsHelper.getOptionDefaultValue((Object)keyspaceReplication, (String)"networkStrategyDataCenters", (VersionNumber)versionNumber));
                String defaultRF = String.valueOf(OptionsHelper.getOptionDefaultValue((Object)keyspaceReplication, (String)"replicationFactor", (VersionNumber)versionNumber));
                while (keyspaceReplication.isDataCenterContain((datacenter = new KeyspaceReplication.DataCenter(String.valueOf(defaultDC) + this.counter++, Integer.valueOf(defaultRF))).getName())) {
                }
                keyspaceReplication.addDataCenter(datacenter);
                KeyspaceBasicSettingsDDLWizardPage.this.tableViewer.reveal((Object)datacenter);
            }
        });
        add.setEnabled(true);
    }

    private void layoutRemoveButton(Composite buttons, DataBindingContext ctx) {
        Button remove = this.button(buttons, "Remove", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                KeyspaceReplication keyspaceReplication = ((Keyspace)KeyspaceBasicSettingsDDLWizardPage.this.getModel().getCurrent()).getOptions().getReplication();
                KeyspaceReplication.DataCenter datacenter = (KeyspaceReplication.DataCenter)KeyspaceBasicSettingsDDLWizardPage.this.selectedDataCenter.getValue();
                keyspaceReplication.removeDataCenter(datacenter);
            }
        });
        ComputedValue canRemove = new ComputedValue(){

            protected Object calculate() {
                KeyspaceReplication.DataCenter datacenter = (KeyspaceReplication.DataCenter)KeyspaceBasicSettingsDDLWizardPage.this.selectedDataCenter.getValue();
                boolean hasMoreThanOneDataCenter = KeyspaceBasicSettingsDDLWizardPage.this.dataCenters.size() > 1;
                boolean isDataCenterSelected = datacenter != null;
                boolean canRemove = hasMoreThanOneDataCenter && isDataCenterSelected;
                return canRemove;
            }
        };
        this.bindValue(ctx, (IObservableValue)canRemove, (IObservableValue)WidgetProperties.enabled().observe((Widget)remove)).updateTargetToModel();
    }

    private void layoutUpButton(Composite buttons, DataBindingContext ctx) {
        Button up = this.button(buttons, "Up", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                KeyspaceReplication.DataCenter datacenter = (KeyspaceReplication.DataCenter)KeyspaceBasicSettingsDDLWizardPage.this.selectedDataCenter.getValue();
                KeyspaceReplication keyspaceReplication = ((Keyspace)KeyspaceBasicSettingsDDLWizardPage.this.getModel().getCurrent()).getOptions().getReplication();
                keyspaceReplication.moveDataCenterUp(datacenter);
            }
        });
        ComputedValue canUp = new ComputedValue(){

            protected Object calculate() {
                KeyspaceReplication.DataCenter value = (KeyspaceReplication.DataCenter)KeyspaceBasicSettingsDDLWizardPage.this.selectedDataCenter.getValue();
                if (value == null) {
                    return false;
                }
                int index = KeyspaceBasicSettingsDDLWizardPage.this.dataCenters.indexOf((Object)value);
                if (index < 1) {
                    return false;
                }
                return true;
            }
        };
        this.bindValue(ctx, (IObservableValue)canUp, (IObservableValue)WidgetProperties.enabled().observe((Widget)up)).updateTargetToModel();
    }

    private void layoutDownButton(Composite buttons, DataBindingContext ctx) {
        Button down = this.button(buttons, "Down", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                KeyspaceReplication.DataCenter datacenter = (KeyspaceReplication.DataCenter)KeyspaceBasicSettingsDDLWizardPage.this.selectedDataCenter.getValue();
                KeyspaceReplication keyspaceReplication = ((Keyspace)KeyspaceBasicSettingsDDLWizardPage.this.getModel().getCurrent()).getOptions().getReplication();
                keyspaceReplication.moveDataCenterDown(datacenter);
            }
        });
        ComputedValue canDown = new ComputedValue(){

            protected Object calculate() {
                KeyspaceReplication.DataCenter value = (KeyspaceReplication.DataCenter)KeyspaceBasicSettingsDDLWizardPage.this.selectedDataCenter.getValue();
                if (value == null) {
                    return false;
                }
                int index = KeyspaceBasicSettingsDDLWizardPage.this.dataCenters.indexOf((Object)value);
                if (index < 0) {
                    return false;
                }
                if (index >= KeyspaceBasicSettingsDDLWizardPage.this.dataCenters.size() - 1) {
                    return false;
                }
                return true;
            }
        };
        this.bindValue(ctx, (IObservableValue)canDown, (IObservableValue)WidgetProperties.enabled().observe((Widget)down)).updateTargetToModel();
    }

    private void bindOptionToReplicationStrategy(DataBindingContext ctx, DDLWizardPageOptionsManager.OptionToggle option) {
        ISWTObservableValue optionEnabled = WidgetProperties.enabled().observe(option.getWidget());
        this.bindValue(ctx, this.replicationComboCheckboxSelected, (IObservableValue)optionEnabled, UpdateValueStrategy.POLICY_UPDATE, UpdateValueStrategy.POLICY_NEVER).updateTargetToModel();
    }

    private void bindWidgetToReplicationStrategyAndOption(DataBindingContext ctx, DDLWizardPageOptionsManager.OptionToggle option, Widget widget) {
        ISWTObservableValue widgetEnabled = WidgetProperties.enabled().observe(widget);
        And comboSelectedAndOptionSelected = new And(this.replicationComboCheckboxSelected, option.getStatus());
        this.bindValue(ctx, (IObservableValue)comboSelectedAndOptionSelected, (IObservableValue)widgetEnabled, UpdateValueStrategy.POLICY_UPDATE, UpdateValueStrategy.POLICY_NEVER).updateTargetToModel();
    }

    class KeyspaceOptionsManager
    extends DDLWizardPageOptionsManager<Keyspace> {
        private IObservableValue replicationStrategyObservable;

        public KeyspaceOptionsManager(DDLWizardPage<Keyspace> ddlWizardPage) {
            super(ddlWizardPage);
        }

        @Override
        public void preCreateControl() {
            super.preCreateControl();
            this.replicationStrategyObservable = BeansObservables.observeValue(KeyspaceBasicSettingsDDLWizardPage.this.getModel().getCurrent(), (String)"options.replication.strategy");
        }

        @Override
        public void installListeners() {
            super.installListeners();
            this.replicationStrategyObservable.addChangeListener(new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    KeyspaceBasicSettingsDDLWizardPage.this.optionsMgr.resetNullsToDefault();
                }
            });
        }

        public void setReplicationStrategyObservable(IObservableValue replicationStrategyObservable) {
            this.replicationStrategyObservable = replicationStrategyObservable;
        }

        @Override
        protected IObservableValue getOptionValidityObservable(String property) {
            IsOptionValidForReplicationStrategy isValidForStrategy = new IsOptionValidForReplicationStrategy(Keyspace.class, property, this.replicationStrategyObservable);
            return isValidForStrategy;
        }

        @Override
        protected void resetToDefault() {
            KeyspaceBasicSettingsDDLWizardPage.this.replicationComboViewer.setSelection((ISelection)new StructuredSelection((Object)ReplicationStrategy.SIMPLE));
            super.resetToDefault();
        }

        @Override
        protected void resetToInitial() {
            ReplicationStrategy strategy = (ReplicationStrategy)BeanPropertyHelper.nullSafeGetProperty(KeyspaceBasicSettingsDDLWizardPage.this.getModel().getInitial(), (String)"options.replication.strategy");
            KeyspaceBasicSettingsDDLWizardPage.this.replicationComboViewer.setSelection((ISelection)new StructuredSelection((Object)strategy));
            super.resetToInitial();
            if (strategy == ReplicationStrategy.NETWORK_TOPOLOGY) {
                KeyspaceReplication currentKeyspaceRepl = ((Keyspace)KeyspaceBasicSettingsDDLWizardPage.this.getModel().getCurrent()).getOptions().getReplication();
                for (KeyspaceReplication.DataCenter currentDC : new ArrayList(currentKeyspaceRepl.getNetworkStrategyDataCenters())) {
                    currentKeyspaceRepl.removeDataCenter(currentDC);
                }
                KeyspaceReplication initialKeyspaceRepl = ((Keyspace)KeyspaceBasicSettingsDDLWizardPage.this.getModel().getInitial()).getOptions().getReplication();
                for (KeyspaceReplication.DataCenter initialDC : initialKeyspaceRepl.getNetworkStrategyDataCenters()) {
                    currentKeyspaceRepl.addDataCenter(new KeyspaceReplication.DataCenter(initialDC.getName(), initialDC.getReplicationFactor()));
                }
            }
        }
    }
}

