/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages.table;

import com.datastax.devcenter.cql.ui.databinding.binding.NullableGroup;
import com.datastax.devcenter.cql.ui.databinding.binding.NullableRadioGroup;
import com.datastax.devcenter.cql.ui.databinding.binding.NullableResettableBinding;
import com.datastax.devcenter.cql.ui.databinding.binding.NullableResettableRadioGroupBinding;
import com.datastax.devcenter.cql.ui.databinding.binding.RadioOption;
import com.datastax.devcenter.cql.ui.databinding.binding.ResettableGroup;
import com.datastax.devcenter.cql.ui.databinding.binding.SpeculativeRetryBinding;
import com.datastax.devcenter.cql.ui.databinding.binding.SpeculativeRetryRadioGroup;
import com.datastax.devcenter.cql.ui.databinding.conversion.BooleanObjectToBooleanPrimitiveConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.DoubleToUnscaledIntegerConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.IntegerObjectToIntegerPrimitiveConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.SpeculativeRetryToPercentileConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.UnscaledIntegerToDoubleConverter;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPageOptionsManager;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.table.TableOptionsDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.options.CompressionAlgorithm;
import com.datastax.devcenter.schema.options.SpeculativeRetry;
import com.datastax.devcenter.schema.options.TableCaching;
import com.datastax.devcenter.schema.options.TableCompression;
import com.datastax.devcenter.schema.options.TableOptions;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class TableAdvancedSettingsDDLWizardPage
extends TableOptionsDDLWizardPage {
    private NullableRadioGroup compressionRadioGroup;
    private DDLWizardPageOptionsManager.OptionToggle compressionOption;
    private TableAdvancedOptionsManager optionsMgr;

    public TableAdvancedSettingsDDLWizardPage(DDLWizardModel<Table> model, DDLWizardDescription description, CqlPreview cqlPreview, DDLWizard.DDLAction ddlAction, String mainHelpUrl) {
        super(model, description, cqlPreview, ddlAction, mainHelpUrl);
    }

    @Override
    protected Layout getLayout() {
        return new GridLayout(1, true);
    }

    @Override
    protected void preCreateControl() {
        super.preCreateControl();
        this.optionsMgr = new TableAdvancedOptionsManager((DDLWizardPage<Table>)this);
        this.optionsMgr.preCreateControl();
        Table current = (Table)this.getModel().getCurrent();
        if (current.getOptions() == null) {
            current.setOptions(new TableOptions());
        }
        if (current.getOptions().getCaching() == null) {
            current.getOptions().setCaching(new TableCaching());
        }
        if (current.getOptions().getCompression() == null) {
            current.getOptions().setCompression(new TableCompression());
        }
    }

    @Override
    protected void createPageSpecificContent(Composite container, DataBindingContext ctx) {
        this.layoutTableOptionsGroup(container, ctx);
        this.layoutCompressionOptionsGroup(container, ctx);
        this.optionsMgr.layoutResetLink(container, 1);
        this.optionsMgr.layoutLinkToDocs(container, 1);
    }

    private void layoutTableOptionsGroup(Composite container, DataBindingContext ctx) {
        Group group = this.fieldset(container, "Table options", 1);
        this.layoutCompactStorage((Composite)group, ctx);
        this.layoutReadRepairChance((Composite)group, ctx);
        this.layoutDCLocalReadRepairChance((Composite)group, ctx);
        this.layoutBloomFilterFPChance((Composite)group, ctx);
        this.layoutReplicateOnWrite((Composite)group, ctx);
        this.layoutDefaultTimeToLive((Composite)group, ctx);
        this.layoutGcGraceSeconds((Composite)group, ctx);
        this.layoutIndexInterval((Composite)group, ctx);
        this.layoutMinIndexInterval((Composite)group, ctx);
        this.layoutMaxIndexInterval((Composite)group, ctx);
        this.layoutMemtableFlushPeriodInMs((Composite)group, ctx);
        this.layoutPopulateIOCacheOnFlush((Composite)group, ctx);
        this.layoutSpeculativeRetry((Composite)group, ctx);
    }

    private void layoutCompressionOptionsGroup(Composite container, DataBindingContext ctx) {
        Group group = this.fieldset(container, "Compression", 1);
        this.layoutSSTableCompression((Composite)group, ctx);
        this.layoutChunkLength((Composite)group, ctx);
        this.layoutCRCCheckChance((Composite)group, ctx);
    }

    private void layoutCompactStorage(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        Button checkbox = this.checkbox(row, "Compact storage", "Compact storage");
        this.dummySpinner(row);
        checkbox.setEnabled(this.isCreation());
        ISWTObservableValue target = WidgetProperties.selection().observe((Widget)checkbox);
        IObservableValue model = BeansObservables.observeValue(this.getModel().getCurrent(), (String)"compactStorage");
        this.bindValue(ctx, (IObservableValue)target, model, null);
        model.addChangeListener((IChangeListener)this.getCqlPreview());
    }

    private void layoutReadRepairChance(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.readRepairChance";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Read repair chance:", "Read repair chance");
        Spinner spinner = this.spinner(row, 1, 0, 10, 1);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setTargetToModelConverter((IConverter)new UnscaledIntegerToDoubleConverter(1));
        binding.setModelToTargetConverter((IConverter)new DoubleToUnscaledIntegerConverter(1));
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutDCLocalReadRepairChance(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.dcLocalReadRepairChance";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "DC-local read repair chance:", "DC-local read repair chance");
        Spinner spinner = this.spinner(row, 1, 0, 10, 1);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setTargetToModelConverter((IConverter)new UnscaledIntegerToDoubleConverter(1));
        binding.setModelToTargetConverter((IConverter)new DoubleToUnscaledIntegerConverter(1));
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutBloomFilterFPChance(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.bloomFilterFPChance";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Bloom filter FP chance:", "Bloom filter FP chance");
        Spinner spinner = this.spinner(row, 2, 1, 100, 1);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setTargetToModelConverter((IConverter)new UnscaledIntegerToDoubleConverter(2));
        binding.setModelToTargetConverter((IConverter)new DoubleToUnscaledIntegerConverter(2));
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutReplicateOnWrite(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.replicateOnWrite";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Replicate on write:", "Replicate on write");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Button value = new Button(group, 32);
        this.dummySpinner(group);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)value);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new BooleanObjectToBooleanPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutDefaultTimeToLive(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.defaultTimeToLive";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Default time to live:", "Default time to live");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Spinner spinner = this.spinner(group, 0, 0, Integer.MAX_VALUE, 1);
        this.label(group, "seconds");
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutGcGraceSeconds(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.gcGraceSeconds";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "GC grace seconds:", "GC grace seconds");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Spinner spinner = this.spinner(group, 0, 0, Integer.MAX_VALUE, 1);
        this.label(group, "seconds");
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutIndexInterval(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.indexInterval";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Index interval:", "Index interval");
        Spinner spinner = this.spinner(row, 0, 0, Integer.MAX_VALUE, 1);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutMinIndexInterval(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.minIndexInterval";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Minimum index interval:", "Minimum index interval");
        Spinner spinner = this.spinner(row, 0, 0, Integer.MAX_VALUE, 1);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutMaxIndexInterval(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.maxIndexInterval";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Maximum index interval:", "Maximum index interval");
        Spinner spinner = this.spinner(row, 0, 0, Integer.MAX_VALUE, 1);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutMemtableFlushPeriodInMs(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.memtableFlushPeriodInMs";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Memtable flush period:", "Memtable flush period");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Spinner spinner = this.spinner(group, 0, 0, Integer.MAX_VALUE, 1);
        this.label(group, "milliseconds");
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutPopulateIOCacheOnFlush(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.populateIOCacheOnFlush";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Populate IO cache on flush:", "Populate IO cache on flush");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Button checkbox = new Button(group, 32);
        this.dummySpinner(group);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)checkbox);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new BooleanObjectToBooleanPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutSpeculativeRetry(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.speculativeRetry";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Speculative retry:", "Speculative retry");
        Composite group = this.horizontalGroup(row, 7, 1, 16384);
        Button always = this.radio(group, "Always");
        Button none = this.radio(group, "None");
        Button percentile = this.radio(group, "Percentile");
        Spinner spinnerPercentile = this.spinner(group, 1, 0, 1000, 10);
        Button millis = this.radio(group, "Milliseconds");
        Spinner spinnerMillis = this.spinner(group, 0, 0, Integer.MAX_VALUE, 1);
        SpeculativeRetryRadioGroup target = new SpeculativeRetryRadioGroup(option.getStatus(), new RadioOption(SpeculativeRetry.ALWAYS, (IObservableValue)WidgetProperties.selection().observe((Widget)always), (IObservableValue)WidgetProperties.enabled().observe((Widget)always)), new RadioOption(SpeculativeRetry.NONE, (IObservableValue)WidgetProperties.selection().observe((Widget)none), (IObservableValue)WidgetProperties.enabled().observe((Widget)none)), new RadioOption(SpeculativeRetry.PERCENTILE, (IObservableValue)WidgetProperties.selection().observe((Widget)percentile), (IObservableValue)WidgetProperties.enabled().observe((Widget)percentile)), new RadioOption(SpeculativeRetry.MILLISECONDS, (IObservableValue)WidgetProperties.selection().observe((Widget)millis), (IObservableValue)WidgetProperties.enabled().observe((Widget)millis)), (IObservableValue)WidgetProperties.selection().observe((Widget)spinnerPercentile), (IObservableValue)WidgetProperties.selection().observe((Widget)spinnerMillis), (IObservableValue)WidgetProperties.enabled().observe((Widget)spinnerPercentile), (IObservableValue)WidgetProperties.enabled().observe((Widget)spinnerMillis));
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        SpeculativeRetryBinding binding = new SpeculativeRetryBinding(ctx, target, model);
        binding.setTargetToModelConverter((IConverter)new SpeculativeRetryToPercentileConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutSSTableCompression(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compression.algorithm";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        this.compressionOption = this.optionsMgr.option(row, "SSTable compression:", "SSTable compression");
        Composite group = this.horizontalGroup(row, 4, 1, 16384);
        Object[] values = new CompressionAlgorithm[]{CompressionAlgorithm.LZ4, CompressionAlgorithm.SNAPPY, CompressionAlgorithm.DEFLATE, CompressionAlgorithm.NONE};
        Button[] buttons = new Button[]{this.radio(group, "LZ4"), this.radio(group, "Snappy"), this.radio(group, "Deflate"), this.radio(group, "None")};
        this.compressionRadioGroup = this.newNullableRadioGroup(this.compressionOption, values, buttons);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableRadioGroupBinding binding = new NullableResettableRadioGroupBinding(ctx, this.compressionRadioGroup, model);
        ((NullableResettableBinding)binding).bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutChunkLength(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compression.chunkLengthKb";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Chunk length:", "Chunk length");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Spinner spinner = this.spinner(group, 0, 4, 1024, 4);
        this.label(group, "KB");
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindCompressionAlgorithmValueToOptionEnablementStatus(option);
        this.updateCompressionOptionEnablementStatus(option);
    }

    private void layoutCRCCheckChance(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compression.crcCheckChance";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "CRC check chance:", "CRC check chance");
        Spinner spinner = this.spinner(row, 1, 0, 10, 1);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setTargetToModelConverter((IConverter)new UnscaledIntegerToDoubleConverter(1));
        binding.setModelToTargetConverter((IConverter)new DoubleToUnscaledIntegerConverter(1));
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindCompressionAlgorithmValueToOptionEnablementStatus(option);
        this.updateCompressionOptionEnablementStatus(option);
    }

    private void bindCompressionAlgorithmValueToOptionEnablementStatus(final DDLWizardPageOptionsManager.OptionToggle option) {
        this.compressionRadioGroup.getValue().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                TableAdvancedSettingsDDLWizardPage.this.updateCompressionOptionEnablementStatus(option);
            }
        });
    }

    private void updateCompressionOptionEnablementStatus(DDLWizardPageOptionsManager.OptionToggle option) {
        boolean useCompression = this.compressionRadioGroup.getValue().getValue() != CompressionAlgorithm.NONE;
        option.getEnabled().setValue((Object)useCompression);
        if (this.isCreation()) {
            if (!useCompression) {
                option.toggle(false);
            }
        } else {
            option.toggle(useCompression);
        }
    }

    class TableAdvancedOptionsManager
    extends TableOptionsDDLWizardPage.TableOptionsManager {
        public TableAdvancedOptionsManager(DDLWizardPage<Table> ddlWizardPage) {
            super(TableAdvancedSettingsDDLWizardPage.this, ddlWizardPage);
        }

        @Override
        protected void resetToDefault() {
            super.resetToDefault();
            if (this.ddlWizardPage.isCreation()) {
                ((Table)this.ddlWizardPage.getModel().getCurrent()).setCompactStorage(false);
            }
        }
    }
}

