/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages.table;

import com.datastax.devcenter.cql.ui.databinding.conversion.CqlDataTypeToStringConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.StringToCqlDataTypeConverter;
import com.datastax.devcenter.cql.ui.databinding.validation.CqlDataTypeValidator;
import com.datastax.devcenter.cql.ui.databinding.validation.IdentifierValidator;
import com.datastax.devcenter.cql.ui.providers.cell.BeanPropertyCellLabelProvider;
import com.datastax.devcenter.cql.ui.providers.cell.CheckboxBeanPropertyCellLabelProvider;
import com.datastax.devcenter.cql.ui.providers.editing_support.CheckboxBeanPropertyEditingSupport;
import com.datastax.devcenter.cql.ui.providers.editing_support.ComboBoxBeanPropertyEditingSupport;
import com.datastax.devcenter.cql.ui.providers.editing_support.TextBeanPropertyEditingSupport;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.KeyspaceChoosingDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.cql.util.TypeParser;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.options.TableOptions;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TableBasicSettingsDDLWizardPage
extends KeyspaceChoosingDDLWizardPage<Table> {
    private IObservableList columns;
    private TableViewer tableViewer;
    private IViewerObservableValue selectedColumn;
    private final TypeParser typeParser;

    public TableBasicSettingsDDLWizardPage(DDLWizardModel<Table> model, DDLWizardDescription description, CqlPreview cqlPreview, TypeParser typeParser, DDLWizard.DDLAction ddlAction, String mainHelpUrl) {
        super(model, description, cqlPreview, ddlAction, mainHelpUrl);
        this.typeParser = typeParser;
    }

    @Override
    protected void preCreateControl() {
        super.preCreateControl();
        Table table = (Table)this.getModel().getCurrent();
        if (table.getOptions() == null) {
            table.setOptions(new TableOptions());
        }
    }

    @Override
    protected void createPageSpecificContent(Composite container, DataBindingContext ctx) {
        super.createPageSpecificContent(container, ctx);
        this.layoutTableName(container, ctx);
        this.separator(container);
        this.layoutColumnsTable(container, ctx);
        this.layoutColumnsTableButtons(container, ctx);
        this.layoutComment(container, ctx);
    }

    private void layoutTableName(Composite container, DataBindingContext ctx) {
        this.label(container, "Table name:");
        Text text = new Text(container, 2048);
        GridData data = new GridData(4, 128, true, false);
        data.horizontalIndent = 10;
        text.setLayoutData((Object)data);
        this.emptyCell(container);
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)text);
        IObservableValue model = BeansObservables.observeValue(this.getModel().getCurrent(), (String)"name");
        IdentifierValidator identifierValidator = new IdentifierValidator("Table name");
        this.bindValue(ctx, (IObservableValue)target, model, identifierValidator);
        model.addChangeListener((IChangeListener)this.getCqlPreview());
        text.setEnabled(this.isCreation());
    }

    private void layoutColumnsTable(Composite container, DataBindingContext ctx) {
        this.label(container, "Columns:", 128);
        Composite tableContainer = new Composite(container, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(tableContainer, 68096);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        tableLayout.setColumnData((Widget)this.layoutNameColumn(this.tableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(100));
        tableLayout.setColumnData((Widget)this.layoutTypeColumn(this.tableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(100));
        tableLayout.setColumnData((Widget)this.layoutPrimaryKeyColumn(this.tableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(50));
        tableLayout.setColumnData((Widget)this.layoutStaticColumn(this.tableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(50));
        this.initColumnsTableContents();
        org.eclipse.swt.widgets.Table table = this.tableViewer.getTable();
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 10;
        data.minimumHeight = 10 * table.getItemHeight();
        tableContainer.setLayoutData((Object)data);
        table.setSelection(0);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
    }

    private void initColumnsTableContents() {
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.columns = BeanProperties.list(Table.class, (String)"columns").observe(this.getModel().getCurrent());
        this.columns.addChangeListener((IChangeListener)this.getCqlPreview());
        this.tableViewer.setInput((Object)this.columns);
        IObservableList primaryKeys = BeanProperties.list(Table.class, (String)"primaryKeys").observe(this.getModel().getCurrent());
        primaryKeys.addChangeListener((IChangeListener)this.getCqlPreview());
        this.selectedColumn = ViewerProperties.singleSelection().observe((Viewer)this.tableViewer);
    }

    private TableColumn layoutNameColumn(TableViewer tableViewer, DataBindingContext ctx) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        IBeanValueProperty property = BeanProperties.value(Column.class, (String)"name");
        BeanPropertyCellLabelProvider labelProvider = new BeanPropertyCellLabelProvider(property){

            @Override
            public String getToolTipText(Object element) {
                if (TableBasicSettingsDDLWizardPage.this.isCreation()) {
                    return null;
                }
                Column column = (Column)element;
                if (column.getOriginalName() == null) {
                    return null;
                }
                if (!column.isPrimaryKey()) {
                    return "Only PRIMARY KEY columns can be renamed";
                }
                return null;
            }
        };
        TextBeanPropertyEditingSupport editingSupport = new TextBeanPropertyEditingSupport((ColumnViewer)tableViewer, ctx, property){

            @Override
            protected CellEditor getCellEditor(Object element) {
                if (TableBasicSettingsDDLWizardPage.this.isCreation()) {
                    return this.cellEditor;
                }
                Column column = (Column)element;
                if (column.getOriginalName() == null) {
                    return this.cellEditor;
                }
                if (!column.isPrimaryKey()) {
                    return null;
                }
                return this.cellEditor;
            }
        };
        editingSupport.addModelChangeListener(this.getCqlPreview());
        editingSupport.setAfterGetValidator(new IdentifierValidator("Column name"));
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        viewerColumn.setEditingSupport((EditingSupport)editingSupport);
        TableColumn column = viewerColumn.getColumn();
        column.setText("Name");
        column.setAlignment(16384);
        return column;
    }

    private TableColumn layoutTypeColumn(TableViewer tableViewer, DataBindingContext ctx) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        IBeanValueProperty property = BeanProperties.value(Column.class, (String)"type");
        BeanPropertyCellLabelProvider labelProvider = new BeanPropertyCellLabelProvider(property, (IConverter)new CqlDataTypeToStringConverter()){

            @Override
            public String getToolTipText(Object element) {
                if (TableBasicSettingsDDLWizardPage.this.isCreation()) {
                    return null;
                }
                if (((Column)element).isPrimaryKey()) {
                    return "Cannot change the type of a PRIMARY KEY column";
                }
                return null;
            }
        };
        ComboBoxBeanPropertyEditingSupport editingSupport = new ComboBoxBeanPropertyEditingSupport((ColumnViewer)tableViewer, ctx, property, this.getAppropriateCqlDataTypes()){

            @Override
            protected CellEditor getCellEditor(Object element) {
                if (TableBasicSettingsDDLWizardPage.this.isCreation()) {
                    return this.cellEditor;
                }
                if (((Column)element).isPrimaryKey()) {
                    return null;
                }
                return this.cellEditor;
            }
        };
        editingSupport.setAfterGetValidator(new CqlDataTypeValidator((ISelectionProvider)this.getKeyspaceComboViewer(), this.typeParser));
        editingSupport.setTargetToModelConverter((IConverter)new StringToCqlDataTypeConverter((ISelectionProvider)this.getKeyspaceComboViewer(), this.typeParser));
        editingSupport.setModelToTargetConverter((IConverter)new CqlDataTypeToStringConverter());
        editingSupport.addModelChangeListener(this.getCqlPreview());
        viewerColumn.setEditingSupport((EditingSupport)editingSupport);
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        TableColumn column = viewerColumn.getColumn();
        column.setText("Type");
        column.setAlignment(16384);
        return column;
    }

    private TableColumn layoutPrimaryKeyColumn(TableViewer tableViewer, DataBindingContext ctx) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        IBeanValueProperty property = BeanProperties.value(Column.class, (String)"primaryKey");
        CheckboxBeanPropertyCellLabelProvider labelProvider = new CheckboxBeanPropertyCellLabelProvider(property);
        if (this.isCreation()) {
            CheckboxBeanPropertyEditingSupport editingSupport = new CheckboxBeanPropertyEditingSupport((ColumnViewer)tableViewer, ctx, property);
            editingSupport.addModelChangeListener(this.getCqlPreview());
            editingSupport.setAfterGetValidator(new PrimaryKeyStructureValidator());
            viewerColumn.setEditingSupport((EditingSupport)editingSupport);
        } else {
            labelProvider.setToolTipText("Primary key structure cannot be changed");
        }
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        TableColumn column = viewerColumn.getColumn();
        column.setText("Primary Key");
        column.setAlignment(0x1000000);
        return column;
    }

    private TableColumn layoutStaticColumn(TableViewer tableViewer, DataBindingContext ctx) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        IBeanValueProperty property = BeanProperties.value(Column.class, (String)"static");
        CheckboxBeanPropertyCellLabelProvider labelProvider = new CheckboxBeanPropertyCellLabelProvider(property);
        if (this.isCreation()) {
            CheckboxBeanPropertyEditingSupport editingSupport = new CheckboxBeanPropertyEditingSupport((ColumnViewer)tableViewer, ctx, property);
            editingSupport.addModelChangeListener(this.getCqlPreview());
            viewerColumn.setEditingSupport((EditingSupport)editingSupport);
        } else {
            labelProvider.setToolTipText("Static attribute cannot be changed");
        }
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        TableColumn column = viewerColumn.getColumn();
        column.setText("Static");
        column.setAlignment(0x1000000);
        return column;
    }

    private void layoutColumnsTableButtons(Composite container, DataBindingContext ctx) {
        Composite buttons = this.verticalGroup(container, 1, 128);
        this.layoutAddButton(buttons);
        this.layoutRemoveButton(buttons, ctx);
        this.layoutUpButton(buttons, ctx);
        this.layoutDownButton(buttons, ctx);
    }

    private void layoutAddButton(Composite buttons) {
        Button add = this.button(buttons, "Add", (SelectionListener)new SelectionAdapter(){
            private long counter = 1L;

            public void widgetSelected(SelectionEvent event) {
                Column column;
                Table table = (Table)TableBasicSettingsDDLWizardPage.this.getModel().getCurrent();
                while (table.isColumnContain((column = new Column("column" + this.counter++, null, (CqlDataType)NativeCqlDataType.TEXT)).getName())) {
                }
                table.addColumn(column);
            }
        });
        add.setEnabled(this.isCreation() || !((Table)this.getModel().getInitial()).isCompactStorage());
    }

    private void layoutRemoveButton(Composite buttons, DataBindingContext ctx) {
        Button remove = this.button(buttons, "Remove", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Table table = (Table)TableBasicSettingsDDLWizardPage.this.getModel().getCurrent();
                Column column = (Column)TableBasicSettingsDDLWizardPage.this.selectedColumn.getValue();
                if (column.isPrimaryKey()) {
                    table.removePrimaryKey(column);
                }
                table.removeColumn(column);
            }
        });
        ComputedValue canRemove = new ComputedValue(){

            protected Object calculate() {
                boolean canRemove;
                Column column = (Column)TableBasicSettingsDDLWizardPage.this.selectedColumn.getValue();
                boolean hasMoreThanOneColumn = TableBasicSettingsDDLWizardPage.this.columns.size() > 1;
                boolean isColumnSelected = column != null;
                boolean isSelectedColumnPrimaryKey = column != null && column.isPrimaryKey();
                boolean hasMoreThanOnePrimaryKey = ((Table)TableBasicSettingsDDLWizardPage.this.getModel().getCurrent()).getPrimaryKeys().size() > 1;
                boolean bl = canRemove = hasMoreThanOneColumn && isColumnSelected && (!isSelectedColumnPrimaryKey || hasMoreThanOnePrimaryKey);
                if (!TableBasicSettingsDDLWizardPage.this.isCreation()) {
                    boolean isCompactStorage = ((Table)TableBasicSettingsDDLWizardPage.this.getModel().getCurrent()).isCompactStorage();
                    canRemove = canRemove && !isSelectedColumnPrimaryKey && !isCompactStorage;
                }
                return canRemove;
            }
        };
        this.bindValue(ctx, (IObservableValue)canRemove, (IObservableValue)WidgetProperties.enabled().observe((Widget)remove)).updateTargetToModel();
    }

    private void layoutUpButton(Composite buttons, DataBindingContext ctx) {
        Button up = this.button(buttons, "Up", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Column column = (Column)TableBasicSettingsDDLWizardPage.this.selectedColumn.getValue();
                Table table = (Table)TableBasicSettingsDDLWizardPage.this.getModel().getCurrent();
                table.moveColumnUp(column);
            }
        });
        ComputedValue canUp = new ComputedValue(){

            protected Object calculate() {
                Column value = (Column)TableBasicSettingsDDLWizardPage.this.selectedColumn.getValue();
                if (value == null) {
                    return false;
                }
                int index = TableBasicSettingsDDLWizardPage.this.columns.indexOf((Object)value);
                if (index < 1) {
                    return false;
                }
                return TableBasicSettingsDDLWizardPage.this.isCreation();
            }
        };
        this.bindValue(ctx, (IObservableValue)canUp, (IObservableValue)WidgetProperties.enabled().observe((Widget)up)).updateTargetToModel();
    }

    private void layoutDownButton(Composite buttons, DataBindingContext ctx) {
        Button down = this.button(buttons, "Down", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Column column = (Column)TableBasicSettingsDDLWizardPage.this.selectedColumn.getValue();
                Table table = (Table)TableBasicSettingsDDLWizardPage.this.getModel().getCurrent();
                table.moveColumnDown(column);
            }
        });
        ComputedValue canDown = new ComputedValue(){

            protected Object calculate() {
                Column value = (Column)TableBasicSettingsDDLWizardPage.this.selectedColumn.getValue();
                if (value == null) {
                    return false;
                }
                int index = TableBasicSettingsDDLWizardPage.this.columns.indexOf((Object)value);
                if (index < 0) {
                    return false;
                }
                if (index >= TableBasicSettingsDDLWizardPage.this.columns.size() - 1) {
                    return false;
                }
                return TableBasicSettingsDDLWizardPage.this.isCreation();
            }
        };
        this.bindValue(ctx, (IObservableValue)canDown, (IObservableValue)WidgetProperties.enabled().observe((Widget)down)).updateTargetToModel();
    }

    private void layoutComment(Composite container, DataBindingContext ctx) {
        this.label(container, "Comment:", 128);
        Text text = new Text(container, 2626);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 10;
        data.minimumHeight = 7 * text.getLineHeight();
        text.setLayoutData((Object)data);
        this.emptyCell(container);
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)text);
        IObservableValue model = BeansObservables.observeValue(this.getModel().getCurrent(), (String)"options.comment");
        this.bindValue(ctx, (IObservableValue)target, model);
        model.addChangeListener((IChangeListener)this.getCqlPreview());
    }

    private class PrimaryKeyStructureValidator
    implements IValidator {
        private PrimaryKeyStructureValidator() {
        }

        public IStatus validate(Object value) {
            boolean isRemovingPrimaryKey;
            boolean bl = isRemovingPrimaryKey = (Boolean)value == false;
            if (isRemovingPrimaryKey && ((Table)TableBasicSettingsDDLWizardPage.this.getModel().getCurrent()).getPrimaryKeys().size() == 1) {
                return ValidationStatus.error((String)"Table must have at least one primary key column");
            }
            return ValidationStatus.ok();
        }
    }
}

