/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages.table;

import com.datastax.devcenter.common.utils.BeanPropertyHelper;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.cql.ui.databinding.binding.NullableGroup;
import com.datastax.devcenter.cql.ui.databinding.binding.NullableRadioGroup;
import com.datastax.devcenter.cql.ui.databinding.binding.NullableResettableBinding;
import com.datastax.devcenter.cql.ui.databinding.binding.NullableResettableRadioGroupBinding;
import com.datastax.devcenter.cql.ui.databinding.binding.RadioOption;
import com.datastax.devcenter.cql.ui.databinding.binding.ResettableGroup;
import com.datastax.devcenter.cql.ui.databinding.binding.RowsCachingBinding;
import com.datastax.devcenter.cql.ui.databinding.binding.RowsCachingRadioGroup;
import com.datastax.devcenter.cql.ui.databinding.conversion.BooleanObjectToBooleanPrimitiveConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.DoubleToUnscaledIntegerConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.IntegerObjectToIntegerPrimitiveConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.ObjectToStringPropertyConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.StringToEnumConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.UnscaledIntegerToDoubleConverter;
import com.datastax.devcenter.cql.ui.databinding.observable.And;
import com.datastax.devcenter.cql.ui.providers.cell.BeanPropertyCellLabelProvider;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPageOptionsManager;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.table.TableOptionsDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.options.Caching;
import com.datastax.devcenter.schema.options.CompactionStrategy;
import com.datastax.devcenter.schema.options.KeysCaching;
import com.datastax.devcenter.schema.options.RowsCaching;
import com.datastax.devcenter.schema.options.TableCompaction;
import com.datastax.devcenter.schema.options.TableOptions;
import com.datastax.devcenter.schema.options.TimestampResolution;
import com.datastax.driver.core.VersionNumber;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class TableCompactionSettingsDDLWizardPage
extends TableOptionsDDLWizardPage {
    protected IObservableValue connectionObservable;
    private IObservableValue compactionComboCheckboxSelected;
    private ComboViewer compactionComboViewer;
    private TableCompactionOptionsManager optionsMgr;
    private Composite cachingStack;
    private StackLayout cachingStackLayout;
    private Composite caching21Group;
    private Composite caching12And20Group;

    public TableCompactionSettingsDDLWizardPage(DDLWizardModel<Table> model, DDLWizardDescription description, CqlPreview cqlPreview, DDLWizard.DDLAction ddlAction, String mainHelpUrl) {
        super(model, description, cqlPreview, ddlAction, mainHelpUrl);
    }

    @Override
    protected Layout getLayout() {
        return new GridLayout(2, false);
    }

    @Override
    protected void preCreateControl() {
        super.preCreateControl();
        this.optionsMgr = new TableCompactionOptionsManager((DDLWizardPage<Table>)this);
        this.optionsMgr.preCreateControl();
        Table table = (Table)this.getModel().getCurrent();
        if (table.getOptions() == null) {
            table.setOptions(new TableOptions());
        }
        if (table.getOptions().getCompaction() == null) {
            table.getOptions().setCompaction(new TableCompaction());
        }
    }

    @Override
    protected void createPageSpecificContent(Composite container, DataBindingContext ctx) {
        this.layoutCompactionOptionsGroup(container, ctx);
        this.layoutCachingOptionsGroup(container, ctx);
        this.optionsMgr.layoutResetLink(container, 2);
        this.optionsMgr.layoutLinkToDocs(container, 2);
    }

    @Override
    protected void postCreateControl() {
        super.postCreateControl();
        if (this.isCreation() && this.compactionComboViewer.getSelection().isEmpty()) {
            this.compactionComboViewer.setSelection((ISelection)new StructuredSelection((Object)CompactionStrategy.SIZE_TIERED));
        }
    }

    @Override
    protected void connectionChanged(Connection connection) {
        this.revealAppropriateCachingOptions();
    }

    private void layoutCompactionOptionsGroup(Composite container, DataBindingContext ctx) {
        this.layoutCompactionCombo(container, ctx);
        Group fieldset = this.fieldset(container, "", 1, 2);
        this.layoutEnabled((Composite)fieldset, ctx);
        this.layoutTombstoneThreshold((Composite)fieldset, ctx);
        this.layoutTombstoneCompactionInterval((Composite)fieldset, ctx);
        this.layoutUncheckedTombstoneCompaction((Composite)fieldset, ctx);
        this.layoutMinThreshold((Composite)fieldset, ctx);
        this.layoutMaxThreshold((Composite)fieldset, ctx);
        this.layoutMinSsTableSize((Composite)fieldset, ctx);
        this.layoutBucketLow((Composite)fieldset, ctx);
        this.layoutBucketHigh((Composite)fieldset, ctx);
        this.layoutColdReadsToOmit((Composite)fieldset, ctx);
        this.layoutBaseTimeSeconds((Composite)fieldset, ctx);
        this.layouTimestampResolution((Composite)fieldset, ctx);
        this.layoutMaxSsTableAgeDays((Composite)fieldset, ctx);
        this.layoutSSTableSize((Composite)fieldset, ctx);
    }

    private void layoutCompactionCombo(Composite container, DataBindingContext ctx) {
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(container, "Strategy:", "Strategy");
        this.compactionComboCheckboxSelected = option.getStatus();
        Combo combo = new Combo(container, 8);
        combo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.compactionComboViewer = new ComboViewer(combo);
        this.compactionComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        IBeanValueProperty property = BeanProperties.value(CompactionStrategy.class, (String)"simpleName");
        this.compactionComboViewer.setLabelProvider((IBaseLabelProvider)new BeanPropertyCellLabelProvider(property));
        this.compactionComboViewer.setInput((Object)new CompactionStrategy[]{CompactionStrategy.SIZE_TIERED, CompactionStrategy.LEVELED, CompactionStrategy.DATE_TIERED});
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)combo);
        ResettableGroup model = this.optionsMgr.newResettableGroup("options.compaction.strategy");
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new ObjectToStringPropertyConverter(property));
        binding.setTargetToModelConverter((IConverter)new StringToEnumConverter(CompactionStrategy.class));
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.compactionStrategyObservable = ViewerProperties.singleSelection().observe((Viewer)this.compactionComboViewer);
    }

    private void layoutEnabled(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.enabled";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Enabled:", "Enabled");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Button checkbox = new Button(group, 32);
        this.dummySpinner(group);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)checkbox);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new BooleanObjectToBooleanPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)checkbox);
    }

    private void layoutTombstoneThreshold(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.tombstoneThreshold";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Tombstone threshold:", "Tombstone threshold");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Spinner spinner = this.spinner(group, 1, 0, 10, 1);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new DoubleToUnscaledIntegerConverter(1));
        binding.setTargetToModelConverter((IConverter)new UnscaledIntegerToDoubleConverter(1));
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)spinner);
    }

    private void layoutTombstoneCompactionInterval(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.tombstoneCompactionInterval";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Tombstone compaction interval:", "Tombstone compaction interval");
        Composite group = this.horizontalGroup(row, 3, 1, 16384);
        Spinner spinner = this.spinner(group, 0, 0, 86400, 1);
        Label label = this.label(group, "seconds");
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)spinner);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)label);
    }

    private void layoutUncheckedTombstoneCompaction(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.uncheckedTombstoneCompaction";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Unchecked tombstone compaction:", "Unchecked tombstone compaction");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Button checkbox = new Button(group, 32);
        this.dummySpinner(group);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)checkbox);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new BooleanObjectToBooleanPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)checkbox);
    }

    private void layoutMaxThreshold(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.maxThreshold";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Max threshold:", "Max threshold");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Spinner spinner = this.spinner(group, 0, 0, 1000, 4);
        Label label = this.label(group, "tables");
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)spinner);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)label);
    }

    private void layoutMinThreshold(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.minThreshold";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Min threshold:", "Min threshold");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Spinner spinner = this.spinner(group, 0, 0, 1000, 4);
        Label label = this.label(group, "tables");
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)spinner);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)label);
    }

    private void layoutBucketHigh(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.bucketHigh";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Bucket high:", "Bucket high");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Spinner spinner = this.spinner(group, 1, 0, 20, 1);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new DoubleToUnscaledIntegerConverter(1));
        binding.setTargetToModelConverter((IConverter)new UnscaledIntegerToDoubleConverter(1));
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)spinner);
    }

    private void layoutBucketLow(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.bucketLow";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Bucket low:", "Bucket low");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Spinner spinner = this.spinner(group, 1, 0, 20, 1);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new DoubleToUnscaledIntegerConverter(1));
        binding.setTargetToModelConverter((IConverter)new UnscaledIntegerToDoubleConverter(1));
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)spinner);
    }

    private void layoutMinSsTableSize(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.minSsTableSize";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Min SSTable size:", "Min SSTable size");
        Composite group = this.horizontalGroup(row, 3, 1, 16384);
        Spinner spinner = this.spinner(group, 0, 0, 0x40000000, 32);
        Label label = this.label(group, "bytes");
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)spinner);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)label);
    }

    private void layoutColdReadsToOmit(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.coldReadsToOmit";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Cold reads to omit:", "Cold reads to omit");
        Composite group = this.horizontalGroup(row, 2, 1, 16384);
        Spinner spinner = this.spinner(group, 2, 0, 100, 1);
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new DoubleToUnscaledIntegerConverter(2));
        binding.setTargetToModelConverter((IConverter)new UnscaledIntegerToDoubleConverter(2));
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)spinner);
    }

    private void layoutBaseTimeSeconds(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.baseTimeSeconds";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Base time:", "Base time");
        Composite group = this.horizontalGroup(row, 3, 1, 16384);
        Spinner spinner = this.spinner(group, 0, 0, 86400, 1);
        Label label = this.label(group, "seconds");
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)spinner);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)label);
    }

    private void layoutMaxSsTableAgeDays(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.maxSsTableAgeDays";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Max SSTable age:", "Max SSTable age");
        Composite group = this.horizontalGroup(row, 3, 1, 16384);
        Spinner spinner = this.spinner(group, 0, 0, 1000, 1);
        Label label = this.label(group, "days");
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)spinner);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)label);
    }

    private void layouTimestampResolution(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.timestampResolution";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "Timestamp resolution:", "Timestamp resolution");
        Composite group = this.horizontalGroup(row, 3, 1, 16384);
        Button microseconds = this.radio(group, "Microseconds");
        Button milliseconds = this.radio(group, "Milliseconds");
        this.dummySpinner(group);
        NullableRadioGroup target = new NullableRadioGroup(option.getStatus(), new RadioOption(TimestampResolution.MICROSECONDS, (IObservableValue)WidgetProperties.selection().observe((Widget)microseconds), (IObservableValue)WidgetProperties.enabled().observe((Widget)microseconds)), new RadioOption(TimestampResolution.MILLISECONDS, (IObservableValue)WidgetProperties.selection().observe((Widget)milliseconds), (IObservableValue)WidgetProperties.enabled().observe((Widget)milliseconds)));
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableRadioGroupBinding binding = new NullableResettableRadioGroupBinding(ctx, target, model);
        ((NullableResettableBinding)binding).bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)microseconds);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)milliseconds);
    }

    private void layoutSSTableSize(Composite container, DataBindingContext ctx) {
        Composite row = this.row(container, 2);
        String property = "options.compaction.ssTableSizeInMB";
        this.optionsMgr.bindOptionValidityToRowVisibility(row, property);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(row, "SSTable size:", "SSTable size");
        Composite group = this.horizontalGroup(row, 3, 1, 16384);
        Spinner spinner = this.spinner(group, 0, 0, 0x100000, 32);
        Label label = this.label(group, "MB");
        NullableGroup target = this.optionsMgr.newNullableGroup(option, (Widget)spinner);
        ResettableGroup model = this.optionsMgr.newResettableGroup(property);
        NullableResettableBinding binding = new NullableResettableBinding(ctx, target, model);
        binding.setModelToTargetConverter((IConverter)new IntegerObjectToIntegerPrimitiveConverter());
        binding.bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
        this.bindOptionToCompactionStrategy(ctx, option);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)spinner);
        this.bindWidgetToCompactionStrategyAndOption(ctx, option, (Widget)label);
    }

    private void layoutCachingOptionsGroup(Composite container, DataBindingContext ctx) {
        Group group = this.fieldset(container, "Caching", 1, 2);
        this.cachingStack = this.stack((Composite)group, 1);
        this.cachingStackLayout = (StackLayout)this.cachingStack.getLayout();
        this.layoutCaching21OptionsGroup(this.cachingStack, ctx);
        this.layoutCaching12And20OptionsGroup(this.cachingStack, ctx);
        this.revealAppropriateCachingOptions();
    }

    private void revealAppropriateCachingOptions() {
        VersionNumber version = this.getModel().getVersionNumber();
        this.cachingStackLayout.topControl = version.compareTo(CqlConstants.CASSANDRA_2_1_0) >= 0 ? this.caching21Group : this.caching12And20Group;
        this.cachingStack.layout();
    }

    private void layoutCaching21OptionsGroup(Composite container, DataBindingContext ctx) {
        this.caching21Group = this.group(container, 2, 1, 4, 1, 128);
        this.layoutKeys(this.caching21Group, ctx);
        this.layoutRowsPerPartition(this.caching21Group, ctx);
    }

    private void layoutCaching12And20OptionsGroup(Composite container, DataBindingContext ctx) {
        this.caching12And20Group = this.group(container, 2, 1, 4, 1, 128);
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(this.caching12And20Group, "Caching:", "Caching");
        Composite group = this.group(this.caching12And20Group, 2, 1, 16384, 2, 128);
        Object[] values = new Object[]{Caching.ALL, Caching.KEYS_ONLY, Caching.NONE, Caching.ROWS_ONLY};
        Button[] buttons = new Button[]{this.radio(group, "All"), this.radio(group, "Keys only"), this.radio(group, "None"), this.radio(group, "Rows only")};
        NullableRadioGroup target = this.newNullableRadioGroup(option, values, buttons);
        ResettableGroup model = this.optionsMgr.newResettableGroup("options.caching.value");
        NullableResettableRadioGroupBinding binding = new NullableResettableRadioGroupBinding(ctx, target, model);
        ((NullableResettableBinding)binding).bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutKeys(Composite container, DataBindingContext ctx) {
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(this.caching21Group, "Keys:", "Keys");
        Composite group = this.horizontalGroup(this.caching21Group, 2, 1, 16384);
        Object[] values = new Object[]{KeysCaching.ALL, KeysCaching.NONE};
        Button[] buttons = new Button[]{this.radio(group, "All"), this.radio(group, "None")};
        NullableRadioGroup target = this.newNullableRadioGroup(option, values, buttons);
        ResettableGroup model = this.optionsMgr.newResettableGroup("options.caching.keys");
        NullableResettableRadioGroupBinding binding = new NullableResettableRadioGroupBinding(ctx, target, model);
        ((NullableResettableBinding)binding).bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void layoutRowsPerPartition(Composite container, DataBindingContext ctx) {
        DDLWizardPageOptionsManager.OptionToggle option = this.optionsMgr.option(this.caching21Group, "Rows per partition:", "Rows per partition");
        Composite group = this.horizontalGroup(this.caching21Group, 4, 1, 16384);
        Button all = this.radio(group, "All");
        Button none = this.radio(group, "None");
        Button other = this.radio(group, "");
        Spinner spinner = this.spinner(group, 0, 0, 100000, 10);
        RowsCachingRadioGroup target = new RowsCachingRadioGroup(option.getStatus(), new RadioOption(RowsCaching.ALL, (IObservableValue)WidgetProperties.selection().observe((Widget)all), (IObservableValue)WidgetProperties.enabled().observe((Widget)all)), new RadioOption(RowsCaching.NONE, (IObservableValue)WidgetProperties.selection().observe((Widget)none), (IObservableValue)WidgetProperties.enabled().observe((Widget)none)), new RadioOption(RowsCaching.OTHER, (IObservableValue)WidgetProperties.selection().observe((Widget)other), (IObservableValue)WidgetProperties.enabled().observe((Widget)other)), (IObservableValue)WidgetProperties.selection().observe((Widget)spinner), (IObservableValue)WidgetProperties.enabled().observe((Widget)spinner));
        ResettableGroup model = this.optionsMgr.newResettableGroup("options.caching.rows");
        RowsCachingBinding binding = new RowsCachingBinding(ctx, target, model);
        ((NullableResettableBinding)binding).bind();
        model.addChangeListener(this.getCqlPreview());
        this.optionsMgr.addBinding(binding);
    }

    private void bindOptionToCompactionStrategy(DataBindingContext ctx, DDLWizardPageOptionsManager.OptionToggle option) {
        ISWTObservableValue optionEnabled = WidgetProperties.enabled().observe(option.getWidget());
        this.bindValue(ctx, this.compactionComboCheckboxSelected, (IObservableValue)optionEnabled, UpdateValueStrategy.POLICY_UPDATE, UpdateValueStrategy.POLICY_NEVER).updateTargetToModel();
    }

    private void bindWidgetToCompactionStrategyAndOption(DataBindingContext ctx, DDLWizardPageOptionsManager.OptionToggle option, Widget widget) {
        ISWTObservableValue widgetEnabled = WidgetProperties.enabled().observe(widget);
        And comboSelectedAndOptionSelected = new And(this.compactionComboCheckboxSelected, option.getStatus());
        this.bindValue(ctx, (IObservableValue)comboSelectedAndOptionSelected, (IObservableValue)widgetEnabled, UpdateValueStrategy.POLICY_UPDATE, UpdateValueStrategy.POLICY_NEVER).updateTargetToModel();
    }

    class TableCompactionOptionsManager
    extends TableOptionsDDLWizardPage.TableOptionsManager {
        public TableCompactionOptionsManager(DDLWizardPage<Table> ddlWizardPage) {
            super(TableCompactionSettingsDDLWizardPage.this, ddlWizardPage);
        }

        @Override
        protected void resetToDefault() {
            TableCompactionSettingsDDLWizardPage.this.compactionComboViewer.setSelection((ISelection)new StructuredSelection((Object)CompactionStrategy.SIZE_TIERED));
            super.resetToDefault();
        }

        @Override
        protected void resetToInitial() {
            CompactionStrategy strategy = (CompactionStrategy)BeanPropertyHelper.nullSafeGetProperty(TableCompactionSettingsDDLWizardPage.this.getModel().getInitial(), (String)"options.compaction.strategy");
            TableCompactionSettingsDDLWizardPage.this.compactionComboViewer.setSelection((ISelection)new StructuredSelection((Object)strategy));
            super.resetToInitial();
        }
    }
}

