/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages.table;

import com.datastax.devcenter.cql.ui.databinding.binding.NullableRadioGroup;
import com.datastax.devcenter.cql.ui.databinding.binding.RadioOption;
import com.datastax.devcenter.cql.ui.databinding.binding.ResettableGroup;
import com.datastax.devcenter.cql.ui.databinding.observable.And;
import com.datastax.devcenter.cql.ui.databinding.observable.GetOptionDefaultValueByVersionAndCompactionStategy;
import com.datastax.devcenter.cql.ui.databinding.observable.IsOptionValidForCompactionStrategy;
import com.datastax.devcenter.cql.ui.databinding.observable.IsOptionValidForVersion;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPageOptionsManager;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.schema.Table;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Widget;

public abstract class TableOptionsDDLWizardPage
extends DDLWizardPage<Table> {
    private DDLWizardPageOptionsManager<Table> optionsMgr;

    public TableOptionsDDLWizardPage(DDLWizardModel<Table> model, DDLWizardDescription description, CqlPreview cqlPreview, DDLWizard.DDLAction ddlAction, String mainHelpUrl) {
        super(model, description, cqlPreview, ddlAction, mainHelpUrl);
    }

    @Override
    protected void preCreateControl() {
        super.preCreateControl();
        this.optionsMgr = new TableOptionsManager(this);
        this.optionsMgr.preCreateControl();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.optionsMgr.installListeners();
    }

    protected NullableRadioGroup newNullableRadioGroup(DDLWizardPageOptionsManager.OptionToggle option, Object[] values, Button[] buttons) {
        return new NullableRadioGroup(option.getStatus(), this.radioOptions(values, buttons));
    }

    protected RadioOption[] radioOptions(Object[] values, Button[] buttons) {
        RadioOption[] options = new RadioOption[values.length];
        int i = 0;
        while (i < values.length) {
            Object value = values[i];
            Button button = buttons[i];
            options[i] = new RadioOption(value, (IObservableValue)WidgetProperties.selection().observe((Widget)button), (IObservableValue)WidgetProperties.enabled().observe((Widget)button));
            ++i;
        }
        return options;
    }

    class TableOptionsManager
    extends DDLWizardPageOptionsManager<Table> {
        protected IObservableValue compactionStrategyObservable;

        public TableOptionsManager(DDLWizardPage<Table> ddlWizardPage) {
            super(ddlWizardPage);
        }

        @Override
        public void preCreateControl() {
            super.preCreateControl();
            this.compactionStrategyObservable = BeansObservables.observeValue(this.ddlWizardPage.getModel().getCurrent(), (String)"options.compaction.strategy");
        }

        @Override
        public void installListeners() {
            super.installListeners();
            this.compactionStrategyObservable.addChangeListener(new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    TableOptionsManager.this.resetNullsToDefault();
                }
            });
        }

        @Override
        public ResettableGroup newResettableGroup(String property) {
            IObservableValue currentValue = BeansObservables.observeValue(this.ddlWizardPage.getModel().getCurrent(), (String)property);
            IObservableValue initialValue = BeansObservables.observeValue(this.ddlWizardPage.getModel().getInitial(), (String)property);
            GetOptionDefaultValueByVersionAndCompactionStategy defaultValue = new GetOptionDefaultValueByVersionAndCompactionStategy(this.ddlWizardPage.getModel().getCurrent(), property, this.versionNumberObservable, this.compactionStrategyObservable);
            return new ResettableGroup(currentValue, initialValue, (IObservableValue)defaultValue);
        }

        @Override
        protected IObservableValue getOptionValidityObservable(String property) {
            IsOptionValidForVersion isValidForVersion = new IsOptionValidForVersion(Table.class, property, this.versionNumberObservable);
            IsOptionValidForCompactionStrategy isValidForStrategy = new IsOptionValidForCompactionStrategy(Table.class, property, this.compactionStrategyObservable, this.versionNumberObservable);
            return new And((IObservableValue)isValidForVersion, (IObservableValue)isValidForStrategy);
        }
    }
}

