/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages.table;

import com.datastax.devcenter.cql.ui.databinding.conversion.StringToEnumConverter;
import com.datastax.devcenter.cql.ui.databinding.observable.And;
import com.datastax.devcenter.cql.ui.databinding.observable.CanBeMovedDown;
import com.datastax.devcenter.cql.ui.databinding.observable.CanBeMovedUp;
import com.datastax.devcenter.cql.ui.databinding.observable.CollectionSize;
import com.datastax.devcenter.cql.ui.databinding.observable.IsGreaterThan;
import com.datastax.devcenter.cql.ui.databinding.observable.IsNull;
import com.datastax.devcenter.cql.ui.databinding.observable.Not;
import com.datastax.devcenter.cql.ui.databinding.validation.EnumValidator;
import com.datastax.devcenter.cql.ui.providers.cell.BeanPropertyCellLabelProvider;
import com.datastax.devcenter.cql.ui.providers.editing_support.ComboBoxBeanPropertyEditingSupport;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.DDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Table;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TablePrimaryKeyDDLWizardPage
extends DDLWizardPage<Table> {
    private TableViewer availableColumnsTableViewer;
    private IObservableList availableColumns;
    private IObservableValue availableColumnSelected;
    private TableViewer partitionKeysTableViewer;
    private IObservableList partitionKeys;
    private IObservableValue partitionKeySelected;
    private TableViewer clusteringColumnsTableViewer;
    private IObservableList clusteringColumns;
    private IObservableValue clusteringColumnSelected;
    private Button partitionKeyTo;
    private Button partitionKeyFrom;
    private Button clusteringColumnTo;
    private Button clusteringColumnFrom;
    private Button partitionKeyUp;
    private Button partitionKeyDown;
    private Button clusteringColumnUp;
    private Button clusteringColumnDown;

    public TablePrimaryKeyDDLWizardPage(DDLWizardModel<Table> model, DDLWizardDescription description, CqlPreview cqlPreview, DDLWizard.DDLAction ddlAction, String mainHelpUrl) {
        super(model, description, cqlPreview, ddlAction, mainHelpUrl);
    }

    @Override
    protected Layout getLayout() {
        return new GridLayout(4, false);
    }

    @Override
    protected void createPageSpecificContent(Composite container, DataBindingContext ctx) {
        this.layoutFirstRow(container);
        this.layoutSecondRow(container, ctx);
        this.layoutThirdRow(container);
        this.layoutFourthRow(container, ctx);
        this.bindButtons(ctx);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        IObservableList columns = BeanProperties.list(Table.class, (String)"columns").observe(this.getModel().getCurrent());
        columns.addChangeListener((IChangeListener)new ColumnsChangeListener());
    }

    private void layoutFirstRow(Composite container) {
        this.label(container, "Available columns:");
        this.emptyCell(container);
        this.label(container, "Partition keys:");
        this.emptyCell(container);
    }

    private void layoutSecondRow(Composite container, DataBindingContext ctx) {
        this.layoutAvailableColumns(container, ctx);
        Composite centralButtons = this.verticalGroup(container, 1, 0x1000000);
        this.layoutPartitionKeyToButton(centralButtons, ctx);
        this.layoutPartitionKeyFromButton(centralButtons, ctx);
        this.layoutPartitionKeys(container, ctx);
        Composite rightButtons = this.verticalGroup(container, 1, 0x1000000);
        this.layoutPartitionKeyUpButton(rightButtons, ctx);
        this.layoutPartitionKeyDownButton(rightButtons, ctx);
    }

    private void layoutThirdRow(Composite container) {
        this.emptyCell(container);
        this.label(container, "Clustering columns:");
        this.emptyCell(container);
    }

    private void layoutFourthRow(Composite container, DataBindingContext ctx) {
        Composite centralButtons = this.verticalGroup(container, 1, 0x1000000);
        this.layoutClusteringColumnToButton(centralButtons, ctx);
        this.layoutClusteringColumnFromButton(centralButtons, ctx);
        this.layoutClusteringColumns(container, ctx);
        Composite rightButtons = this.verticalGroup(container, 1, 0x1000000);
        this.layoutClusteringColumnButtonUp(rightButtons, ctx);
        this.layoutClusteringColumnButtonDown(rightButtons, ctx);
    }

    private void layoutAvailableColumns(Composite container, DataBindingContext ctx) {
        Composite tableContainer = new Composite(container, 0);
        GridData data = new GridData(4, 4, true, true);
        data.verticalSpan = 3;
        tableContainer.setLayoutData((Object)data);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableLayout);
        this.availableColumnsTableViewer = new TableViewer(tableContainer, 68096);
        tableLayout.setColumnData((Widget)this.layoutNameColumn(this.availableColumnsTableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(100));
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.availableColumnsTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.availableColumns = BeanProperties.list(Table.class, (String)"nonPrimaryKeyColumns").observe(this.getModel().getCurrent());
        this.availableColumns.addChangeListener((IChangeListener)this.getCqlPreview());
        this.availableColumnsTableViewer.setInput((Object)this.availableColumns);
        this.availableColumnSelected = ViewerProperties.singleSelection().observe((Viewer)this.availableColumnsTableViewer);
        org.eclipse.swt.widgets.Table table = this.availableColumnsTableViewer.getTable();
        table.setLinesVisible(true);
        table.setEnabled(this.isCreation());
    }

    private void layoutPartitionKeys(Composite container, DataBindingContext ctx) {
        Composite tableContainer = new Composite(container, 0);
        GridData data = new GridData(4, 4, true, true);
        tableContainer.setLayoutData((Object)data);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableLayout);
        this.partitionKeysTableViewer = new TableViewer(tableContainer, 68096);
        tableLayout.setColumnData((Widget)this.layoutNameColumn(this.partitionKeysTableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(100));
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.partitionKeysTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.partitionKeys = BeanProperties.list(Table.class, (String)"partitionKeys").observe(this.getModel().getCurrent());
        this.partitionKeys.addChangeListener((IChangeListener)this.getCqlPreview());
        this.partitionKeysTableViewer.setInput((Object)this.partitionKeys);
        this.partitionKeySelected = ViewerProperties.singleSelection().observe((Viewer)this.partitionKeysTableViewer);
        org.eclipse.swt.widgets.Table table = this.partitionKeysTableViewer.getTable();
        table.setLinesVisible(true);
        table.setEnabled(this.isCreation());
    }

    private void layoutClusteringColumns(Composite container, DataBindingContext ctx) {
        Composite tableContainer = new Composite(container, 0);
        GridData data = new GridData(4, 4, true, true);
        tableContainer.setLayoutData((Object)data);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableLayout);
        this.clusteringColumnsTableViewer = new TableViewer(tableContainer, 68096);
        tableLayout.setColumnData((Widget)this.layoutNameColumn(this.clusteringColumnsTableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(100));
        tableLayout.setColumnData((Widget)this.layoutClusteringOrderColumn(this.clusteringColumnsTableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(50));
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.clusteringColumnsTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.clusteringColumns = BeanProperties.list(Table.class, (String)"clusteringKeys").observe(this.getModel().getCurrent());
        this.clusteringColumns.addChangeListener((IChangeListener)this.getCqlPreview());
        this.clusteringColumnsTableViewer.setInput((Object)this.clusteringColumns);
        this.clusteringColumnSelected = ViewerProperties.singleSelection().observe((Viewer)this.clusteringColumnsTableViewer);
        org.eclipse.swt.widgets.Table table = this.clusteringColumnsTableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setEnabled(this.isCreation());
    }

    private TableColumn layoutNameColumn(TableViewer tableViewer, DataBindingContext ctx) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        IBeanValueProperty property = BeanProperties.value(Column.class, (String)"name");
        viewerColumn.setLabelProvider((CellLabelProvider)new BeanPropertyCellLabelProvider(property));
        TableColumn column = viewerColumn.getColumn();
        column.setText("Name");
        column.setAlignment(16384);
        return column;
    }

    private TableColumn layoutClusteringOrderColumn(TableViewer tableViewer, DataBindingContext ctx) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        IBeanValueProperty property = BeanProperties.value(Column.class, (String)"clusteringOrder");
        viewerColumn.setLabelProvider((CellLabelProvider)new BeanPropertyCellLabelProvider(property));
        ComboBoxBeanPropertyEditingSupport editingSupport = new ComboBoxBeanPropertyEditingSupport((ColumnViewer)tableViewer, ctx, property, Table.ClusteringOrder.ASC.name(), Table.ClusteringOrder.DESC.name());
        editingSupport.addModelChangeListener(this.getCqlPreview());
        editingSupport.setTargetToModelConverter((IConverter)new StringToEnumConverter(Table.ClusteringOrder.class));
        viewerColumn.setEditingSupport((EditingSupport)editingSupport);
        editingSupport.setAfterGetValidator(new EnumValidator<Table.ClusteringOrder>(Table.ClusteringOrder.class, "Invalid clustering order"));
        TableColumn column = viewerColumn.getColumn();
        column.setText("Order");
        column.setAlignment(16384);
        return column;
    }

    private void layoutPartitionKeyToButton(Composite container, DataBindingContext ctx) {
        this.partitionKeyTo = this.button(container, ">", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Table table = (Table)TablePrimaryKeyDDLWizardPage.this.getModel().getCurrent();
                table.addPartitionKey((Column)TablePrimaryKeyDDLWizardPage.this.availableColumnSelected.getValue());
            }
        });
        this.partitionKeyTo.setEnabled(false);
    }

    private void layoutPartitionKeyFromButton(Composite container, DataBindingContext ctx) {
        this.partitionKeyFrom = this.button(container, "<", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Table table = (Table)TablePrimaryKeyDDLWizardPage.this.getModel().getCurrent();
                table.removePartitionKey((Column)TablePrimaryKeyDDLWizardPage.this.partitionKeySelected.getValue());
            }
        });
        this.partitionKeyFrom.setEnabled(false);
    }

    private void layoutClusteringColumnToButton(Composite container, DataBindingContext ctx) {
        this.clusteringColumnTo = this.button(container, ">", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Table table = (Table)TablePrimaryKeyDDLWizardPage.this.getModel().getCurrent();
                table.addClusteringKey((Column)TablePrimaryKeyDDLWizardPage.this.availableColumnSelected.getValue());
            }
        });
        this.clusteringColumnTo.setEnabled(false);
    }

    private void layoutClusteringColumnFromButton(Composite container, DataBindingContext ctx) {
        this.clusteringColumnFrom = this.button(container, "<", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Table table = (Table)TablePrimaryKeyDDLWizardPage.this.getModel().getCurrent();
                table.removeClusteringKey((Column)TablePrimaryKeyDDLWizardPage.this.clusteringColumnSelected.getValue());
            }
        });
        this.clusteringColumnFrom.setEnabled(false);
    }

    private void layoutPartitionKeyUpButton(Composite container, DataBindingContext ctx) {
        this.partitionKeyUp = this.button(container, "Up", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Table table = (Table)TablePrimaryKeyDDLWizardPage.this.getModel().getCurrent();
                table.movePartitionKeyUp((Column)TablePrimaryKeyDDLWizardPage.this.partitionKeySelected.getValue());
            }
        });
        this.partitionKeyUp.setEnabled(false);
    }

    private void layoutPartitionKeyDownButton(Composite container, DataBindingContext ctx) {
        this.partitionKeyDown = this.button(container, "Down", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Table table = (Table)TablePrimaryKeyDDLWizardPage.this.getModel().getCurrent();
                table.movePartitionKeyDown((Column)TablePrimaryKeyDDLWizardPage.this.partitionKeySelected.getValue());
            }
        });
        this.partitionKeyDown.setEnabled(false);
    }

    private void layoutClusteringColumnButtonUp(Composite container, DataBindingContext ctx) {
        this.clusteringColumnUp = this.button(container, "Up", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Table table = (Table)TablePrimaryKeyDDLWizardPage.this.getModel().getCurrent();
                table.moveClusteringKeyUp((Column)TablePrimaryKeyDDLWizardPage.this.clusteringColumnSelected.getValue());
            }
        });
        this.clusteringColumnUp.setEnabled(false);
    }

    private void layoutClusteringColumnButtonDown(Composite container, DataBindingContext ctx) {
        this.clusteringColumnDown = this.button(container, "Down", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Table table = (Table)TablePrimaryKeyDDLWizardPage.this.getModel().getCurrent();
                table.moveClusteringKeyDown((Column)TablePrimaryKeyDDLWizardPage.this.clusteringColumnSelected.getValue());
            }
        });
        this.clusteringColumnDown.setEnabled(false);
    }

    private void bindButtons(DataBindingContext ctx) {
        this.bindPartitionKeyToButton(ctx);
        this.bindPartitionKeyFromButton(ctx);
        this.bindClusteringColumnToButton(ctx);
        this.bindClusteringColumnFromButton(ctx);
        this.bindPartitionKeyUpButton(ctx);
        this.bindPartitionKeyDownButton(ctx);
        this.bindClusteringColumnUpButton(ctx);
        this.bindClusteringColumnDownButton(ctx);
    }

    private void bindPartitionKeyToButton(DataBindingContext ctx) {
        Not target = new Not((IObservableValue)new IsNull(this.availableColumnSelected));
        ISWTObservableValue model = WidgetProperties.enabled().observe((Widget)this.partitionKeyTo);
        this.bindValue(ctx, (IObservableValue)target, (IObservableValue)model, null);
    }

    private void bindPartitionKeyFromButton(DataBindingContext ctx) {
        And target = new And((IObservableValue)new Not((IObservableValue)new IsNull(this.partitionKeySelected)), (IObservableValue)new IsGreaterThan((IObservableValue)new CollectionSize((IObservableCollection)this.partitionKeys), Observables.constantObservableValue((Object)1, Integer.class)));
        ISWTObservableValue model = WidgetProperties.enabled().observe((Widget)this.partitionKeyFrom);
        this.bindValue(ctx, (IObservableValue)target, (IObservableValue)model, null);
    }

    private void bindClusteringColumnToButton(DataBindingContext ctx) {
        Not target = new Not((IObservableValue)new IsNull(this.availableColumnSelected));
        ISWTObservableValue model = WidgetProperties.enabled().observe((Widget)this.clusteringColumnTo);
        this.bindValue(ctx, (IObservableValue)target, (IObservableValue)model, null);
    }

    private void bindClusteringColumnFromButton(DataBindingContext ctx) {
        Not target = new Not((IObservableValue)new IsNull(this.clusteringColumnSelected));
        ISWTObservableValue model = WidgetProperties.enabled().observe((Widget)this.clusteringColumnFrom);
        this.bindValue(ctx, (IObservableValue)target, (IObservableValue)model, null);
    }

    private void bindPartitionKeyUpButton(DataBindingContext ctx) {
        CanBeMovedUp target = new CanBeMovedUp(this.partitionKeySelected, this.partitionKeys);
        ISWTObservableValue model = WidgetProperties.enabled().observe((Widget)this.partitionKeyUp);
        this.bindValue(ctx, (IObservableValue)target, (IObservableValue)model, null);
    }

    private void bindPartitionKeyDownButton(DataBindingContext ctx) {
        CanBeMovedDown target = new CanBeMovedDown(this.partitionKeySelected, this.partitionKeys);
        ISWTObservableValue model = WidgetProperties.enabled().observe((Widget)this.partitionKeyDown);
        this.bindValue(ctx, (IObservableValue)target, (IObservableValue)model, null);
    }

    private void bindClusteringColumnUpButton(DataBindingContext ctx) {
        CanBeMovedUp target = new CanBeMovedUp(this.clusteringColumnSelected, this.clusteringColumns);
        ISWTObservableValue model = WidgetProperties.enabled().observe((Widget)this.clusteringColumnUp);
        this.bindValue(ctx, (IObservableValue)target, (IObservableValue)model, null);
    }

    private void bindClusteringColumnDownButton(DataBindingContext ctx) {
        CanBeMovedDown target = new CanBeMovedDown(this.clusteringColumnSelected, this.clusteringColumns);
        ISWTObservableValue model = WidgetProperties.enabled().observe((Widget)this.clusteringColumnDown);
        this.bindValue(ctx, (IObservableValue)target, (IObservableValue)model, null);
    }

    private class ColumnsChangeListener
    implements IChangeListener,
    PropertyChangeListener {
        public ColumnsChangeListener() {
            this.installPropertyListeners();
        }

        public void handleChange(ChangeEvent event) {
            this.installPropertyListeners();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object column = evt.getSource();
            TablePrimaryKeyDDLWizardPage.this.availableColumnsTableViewer.update(column, new String[]{"name"});
            TablePrimaryKeyDDLWizardPage.this.partitionKeysTableViewer.update(column, new String[]{"name"});
            TablePrimaryKeyDDLWizardPage.this.clusteringColumnsTableViewer.update(column, new String[]{"name"});
        }

        private void installPropertyListeners() {
            for (Column column : ((Table)TablePrimaryKeyDDLWizardPage.this.getModel().getCurrent()).getColumns()) {
                column.removePropertyChangeListener((PropertyChangeListener)this);
                column.addPropertyChangeListener("name", (PropertyChangeListener)this);
            }
        }
    }
}

