/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.pages.usertype;

import com.datastax.devcenter.cql.ui.databinding.conversion.CqlDataTypeToStringConverter;
import com.datastax.devcenter.cql.ui.databinding.conversion.StringToCqlDataTypeConverter;
import com.datastax.devcenter.cql.ui.databinding.validation.CqlDataTypeValidator;
import com.datastax.devcenter.cql.ui.databinding.validation.IdentifierValidator;
import com.datastax.devcenter.cql.ui.providers.cell.BeanPropertyCellLabelProvider;
import com.datastax.devcenter.cql.ui.providers.editing_support.ComboBoxBeanPropertyEditingSupport;
import com.datastax.devcenter.cql.ui.providers.editing_support.TextBeanPropertyEditingSupport;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizard;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardDescription;
import com.datastax.devcenter.cql.ui.wizards.ddl.DDLWizardModel;
import com.datastax.devcenter.cql.ui.wizards.ddl.pages.KeyspaceChoosingDDLWizardPage;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreview;
import com.datastax.devcenter.cql.util.TypeParser;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UserTypeBasicSettingsDDLWizardPage
extends KeyspaceChoosingDDLWizardPage<UserType> {
    private IObservableList fields;
    private TableViewer tableViewer;
    private IViewerObservableValue selectedField;
    private final TypeParser typeParser;

    public UserTypeBasicSettingsDDLWizardPage(DDLWizardModel<UserType> model, DDLWizardDescription description, CqlPreview cqlPreview, TypeParser typeParser, DDLWizard.DDLAction ddlAction, String mainHelpUrl) {
        super(model, description, cqlPreview, ddlAction, mainHelpUrl);
        this.typeParser = typeParser;
    }

    @Override
    protected void preCreateControl() {
        super.preCreateControl();
    }

    @Override
    protected void createPageSpecificContent(Composite container, DataBindingContext ctx) {
        super.createPageSpecificContent(container, ctx);
        this.layoutTypeName(container, ctx);
        this.separator(container);
        this.layoutFieldsTable(container, ctx);
        this.layoutColumnsTableButtons(container, ctx);
    }

    private void layoutTypeName(Composite container, DataBindingContext ctx) {
        this.label(container, "Type name:");
        Text text = new Text(container, 2048);
        GridData data = new GridData(4, 128, true, false);
        data.horizontalIndent = 10;
        text.setLayoutData((Object)data);
        this.emptyCell(container);
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)text);
        IObservableValue model = BeansObservables.observeValue(this.getModel().getCurrent(), (String)"name");
        IdentifierValidator identifierValidator = new IdentifierValidator("Type name");
        this.bindValue(ctx, (IObservableValue)target, model, identifierValidator);
        model.addChangeListener((IChangeListener)this.getCqlPreview());
        text.setEnabled(this.isCreation());
    }

    private void layoutFieldsTable(Composite container, DataBindingContext ctx) {
        this.label(container, "Fields:", 128);
        Composite tableContainer = new Composite(container, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(tableContainer, 68096);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        tableLayout.setColumnData((Widget)this.layoutNameColumn(this.tableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(100));
        tableLayout.setColumnData((Widget)this.layoutTypeColumn(this.tableViewer, ctx), (ColumnLayoutData)new ColumnWeightData(100));
        this.initColumnsTableContents();
        Table table = this.tableViewer.getTable();
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 10;
        data.minimumHeight = 10 * table.getItemHeight();
        tableContainer.setLayoutData((Object)data);
        table.setSelection(0);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
    }

    private void initColumnsTableContents() {
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.fields = BeanProperties.list(UserType.class, (String)"fields").observe(this.getModel().getCurrent());
        this.fields.addChangeListener((IChangeListener)this.getCqlPreview());
        this.tableViewer.setInput((Object)this.fields);
        this.selectedField = ViewerProperties.singleSelection().observe((Viewer)this.tableViewer);
    }

    private TableColumn layoutNameColumn(TableViewer tableViewer, DataBindingContext ctx) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        IBeanValueProperty property = BeanProperties.value(UserTypeField.class, (String)"name");
        BeanPropertyCellLabelProvider labelProvider = new BeanPropertyCellLabelProvider(property);
        TextBeanPropertyEditingSupport editingSupport = new TextBeanPropertyEditingSupport((ColumnViewer)tableViewer, ctx, property);
        editingSupport.addModelChangeListener(this.getCqlPreview());
        editingSupport.setAfterGetValidator(new IdentifierValidator("Field name"));
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        viewerColumn.setEditingSupport((EditingSupport)editingSupport);
        TableColumn column = viewerColumn.getColumn();
        column.setText("Name");
        column.setAlignment(16384);
        return column;
    }

    private TableColumn layoutTypeColumn(TableViewer tableViewer, DataBindingContext ctx) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        IBeanValueProperty property = BeanProperties.value(UserTypeField.class, (String)"type");
        BeanPropertyCellLabelProvider labelProvider = new BeanPropertyCellLabelProvider(property, (IConverter)new CqlDataTypeToStringConverter());
        ComboBoxBeanPropertyEditingSupport editingSupport = new ComboBoxBeanPropertyEditingSupport((ColumnViewer)tableViewer, ctx, property, this.getAppropriateCqlDataTypes());
        editingSupport.setAfterGetValidator(new CqlDataTypeValidator((ISelectionProvider)this.getKeyspaceComboViewer(), this.typeParser));
        editingSupport.setTargetToModelConverter((IConverter)new StringToCqlDataTypeConverter((ISelectionProvider)this.getKeyspaceComboViewer(), this.typeParser));
        editingSupport.setModelToTargetConverter((IConverter)new CqlDataTypeToStringConverter());
        editingSupport.addModelChangeListener(this.getCqlPreview());
        viewerColumn.setEditingSupport((EditingSupport)editingSupport);
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        TableColumn column = viewerColumn.getColumn();
        column.setText("Type");
        column.setAlignment(16384);
        return column;
    }

    @Override
    protected String[] getAppropriateCqlDataTypes() {
        List<String> filteredCqlDataTypes = this.getVersionFilteredCqlDataTypes();
        filteredCqlDataTypes.remove("counter");
        return filteredCqlDataTypes.toArray(new String[filteredCqlDataTypes.size()]);
    }

    private void layoutColumnsTableButtons(Composite container, DataBindingContext ctx) {
        Composite buttons = this.verticalGroup(container, 1, 128);
        this.layoutAddButton(buttons);
        this.layoutRemoveButton(buttons, ctx);
        this.layoutUpButton(buttons, ctx);
        this.layoutDownButton(buttons, ctx);
    }

    private void layoutAddButton(Composite buttons) {
        Button add = this.button(buttons, "Add", (SelectionListener)new SelectionAdapter(){
            private long counter = 1L;

            public void widgetSelected(SelectionEvent event) {
                UserTypeField field;
                UserType userType = (UserType)UserTypeBasicSettingsDDLWizardPage.this.getModel().getCurrent();
                while (userType.isFieldContain((field = new UserTypeField("field" + this.counter++, null, (CqlDataType)NativeCqlDataType.TEXT)).getName())) {
                }
                userType.addField(field);
                UserTypeBasicSettingsDDLWizardPage.this.tableViewer.reveal((Object)field);
            }
        });
        add.setEnabled(true);
    }

    private void layoutRemoveButton(Composite buttons, DataBindingContext ctx) {
        Button remove = this.button(buttons, "Remove", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UserType userType = (UserType)UserTypeBasicSettingsDDLWizardPage.this.getModel().getCurrent();
                UserTypeField field = (UserTypeField)UserTypeBasicSettingsDDLWizardPage.this.selectedField.getValue();
                userType.removeField(field);
            }
        });
        ComputedValue canRemove = new ComputedValue(){

            protected Object calculate() {
                boolean canRemove;
                UserTypeField field = (UserTypeField)UserTypeBasicSettingsDDLWizardPage.this.selectedField.getValue();
                boolean hasMoreThanOneColumn = UserTypeBasicSettingsDDLWizardPage.this.fields.size() > 1;
                boolean isFieldSelected = field != null;
                boolean removingNewField = field != null && ((UserType)UserTypeBasicSettingsDDLWizardPage.this.getModel().getInitial()).getField(field.getName()) == null;
                boolean bl = canRemove = hasMoreThanOneColumn && isFieldSelected;
                if (!UserTypeBasicSettingsDDLWizardPage.this.isCreation()) {
                    canRemove = canRemove && removingNewField;
                }
                return canRemove;
            }
        };
        this.bindValue(ctx, (IObservableValue)canRemove, (IObservableValue)WidgetProperties.enabled().observe((Widget)remove)).updateTargetToModel();
    }

    private void layoutUpButton(Composite buttons, DataBindingContext ctx) {
        Button up = this.button(buttons, "Up", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UserTypeField field = (UserTypeField)UserTypeBasicSettingsDDLWizardPage.this.selectedField.getValue();
                UserType userType = (UserType)UserTypeBasicSettingsDDLWizardPage.this.getModel().getCurrent();
                userType.moveFieldUp(field);
            }
        });
        ComputedValue canUp = new ComputedValue(){

            protected Object calculate() {
                UserTypeField value = (UserTypeField)UserTypeBasicSettingsDDLWizardPage.this.selectedField.getValue();
                if (value == null) {
                    return false;
                }
                int index = UserTypeBasicSettingsDDLWizardPage.this.fields.indexOf((Object)value);
                if (index < 1) {
                    return false;
                }
                return UserTypeBasicSettingsDDLWizardPage.this.isCreation();
            }
        };
        this.bindValue(ctx, (IObservableValue)canUp, (IObservableValue)WidgetProperties.enabled().observe((Widget)up)).updateTargetToModel();
    }

    private void layoutDownButton(Composite buttons, DataBindingContext ctx) {
        Button down = this.button(buttons, "Down", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UserTypeField field = (UserTypeField)UserTypeBasicSettingsDDLWizardPage.this.selectedField.getValue();
                UserType table = (UserType)UserTypeBasicSettingsDDLWizardPage.this.getModel().getCurrent();
                table.moveFieldDown(field);
            }
        });
        ComputedValue canDown = new ComputedValue(){

            protected Object calculate() {
                UserTypeField value = (UserTypeField)UserTypeBasicSettingsDDLWizardPage.this.selectedField.getValue();
                if (value == null) {
                    return false;
                }
                int index = UserTypeBasicSettingsDDLWizardPage.this.fields.indexOf((Object)value);
                if (index < 0) {
                    return false;
                }
                if (index >= UserTypeBasicSettingsDDLWizardPage.this.fields.size() - 1) {
                    return false;
                }
                return UserTypeBasicSettingsDDLWizardPage.this.isCreation();
            }
        };
        this.bindValue(ctx, (IObservableValue)canDown, (IObservableValue)WidgetProperties.enabled().observe((Widget)down)).updateTargetToModel();
    }
}

