/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.ui.wizards.ddl.preview;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.ui.editor.embedded.EmbeddedCqlEditor;
import com.datastax.devcenter.cql.ui.editor.embedded.EmbeddedCqlEditorValidationStatusProvider;
import com.datastax.devcenter.cql.ui.wizards.ddl.preview.CqlPreviewContentProvider;
import com.datastax.devcenter.schema.Keyspace;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;

public class CqlPreview
implements IChangeListener,
IExpansionListener {
    private static final GridData EXPANDED = new GridData(4, 4, true, true);
    private static final GridData COLLAPSED;
    private final EmbeddedCqlEditor editor;
    private final CqlPreviewContentProvider contentProvider;
    private Composite outer;
    private ExpandableComposite expandable;
    private volatile boolean empty = true;

    static {
        CqlPreview.EXPANDED.heightHint = 200;
        CqlPreview.EXPANDED.minimumHeight = 200;
        COLLAPSED = new GridData(4, 1024, true, false);
    }

    public CqlPreview(EmbeddedCqlEditor editor, CqlPreviewContentProvider contentProvider) {
        this.editor = editor;
        this.contentProvider = contentProvider;
    }

    public void createControl(Composite container) {
        this.createOuterContainer(container);
        this.createExpandable();
        this.createEditor();
    }

    public EmbeddedCqlEditorValidationStatusProvider createValidationStatusProvider() {
        return this.editor.createValidationStatusProvider();
    }

    public CqlContext getCqlContext() {
        return this.editor.getCqlContext();
    }

    public void updatePreview() {
        String text = this.contentProvider.getPreviewText();
        this.editor.updateContents(text);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void connectionChanged(Connection connection) {
        CqlContext cqlContext = this.getCqlContext();
        cqlContext.updateDatabaseSchemaAndReset(connection);
        this.updatePreview();
    }

    public void keyspaceChanged(Keyspace keyspace) {
        CqlContext cqlContext = this.getCqlContext();
        cqlContext.setDefaultKeyspaceName(keyspace == null ? null : keyspace.getName());
        this.updatePreview();
    }

    public void handleChange(ChangeEvent event) {
        this.updatePreview();
    }

    public void expansionStateChanging(ExpansionEvent e) {
    }

    public void expansionStateChanged(ExpansionEvent e) {
        boolean expanded = e.getState();
        this.expandable.setExpanded(expanded);
        this.expandable.setLayoutData((Object)(expanded ? EXPANDED : COLLAPSED));
        this.outer.setLayoutData((Object)(expanded ? EXPANDED : COLLAPSED));
        this.outer.getParent().layout();
    }

    private void createOuterContainer(Composite container) {
        this.outer = new Composite(container, 0);
        this.outer.setLayoutData((Object)EXPANDED);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        this.outer.setLayout((Layout)layout);
    }

    private void createExpandable() {
        this.expandable = new ExpandableComposite(this.outer, 0);
        this.expandable.setText("CQL Preview:");
        this.expandable.setExpanded(true);
        this.expandable.setLayoutData((Object)EXPANDED);
        this.expandable.addExpansionListener((IExpansionListener)this);
    }

    private void createEditor() {
        this.editor.createControl((Composite)this.expandable);
        this.addModelListener(new IXtextModelListener(){

            public void modelChanged(XtextResource resource) {
                CqlPreview.this.empty = CqlPreview.this.verifyEmptyCqlPreview(resource);
            }
        });
        XtextSourceViewer viewer = this.editor.getViewer();
        StyledText text = viewer.getTextWidget();
        text.setLayoutData((Object)EXPANDED);
        this.expandable.setClient(viewer.getControl());
    }

    private boolean verifyEmptyCqlPreview(XtextResource resource) {
        for (EObject obj : resource.getContents()) {
            if (!(obj instanceof Statements)) continue;
            return ((Statements)obj).getStatements().isEmpty();
        }
        return true;
    }

    public void dispose() {
        this.editor.dispose();
    }

    public void addModelListener(IXtextModelListener listener) {
        this.editor.addModelListener(listener);
    }
}

