/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.json.ui.contentassist;

import com.datastax.devcenter.cql.cql.EmbeddedJSONString;
import com.datastax.devcenter.cql.ui.UiConstant;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.json.ui.contentassist.AbstractJsonProposalProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class JsonProposalProvider
extends AbstractJsonProposalProvider {
    protected void proposeText(String proposalText, int cursorPositionInProposal, ContentAssistContext context, ICompletionProposalAcceptor acceptor, UiConstant.ImageType imageType) {
        StyledString styledDescription = new StyledString(proposalText);
        styledDescription.append(" (" + imageType.getName() + ")", StyledString.QUALIFIER_STYLER);
        int replacementOffset = context.getReplaceRegion().getOffset();
        int replacementLength = context.getReplaceRegion().getLength();
        if (this.isValidProposal(proposalText, context.getPrefix(), context)) {
            ConfigurableCompletionProposal proposal = new ConfigurableCompletionProposal(proposalText, replacementOffset, replacementLength, cursorPositionInProposal);
            acceptor.accept((ICompletionProposal)proposal);
        }
    }

    @Override
    public void complete_T_COMMA(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText(",", context, acceptor, UiConstant.ImageType.PUNCTUATION);
    }

    @Override
    public void complete_T_L_BRACKET(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("[", context, acceptor, UiConstant.ImageType.PUNCTUATION);
    }

    @Override
    public void complete_T_R_BRACKET(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText("]", context, acceptor, UiConstant.ImageType.PUNCTUATION);
    }

    @Override
    public void complete_T_L_BRACE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (ModelUtil.getAncestorOfType((EObject)model, EmbeddedJSONString.class) != null) {
            if (!context.getPrefix().equals("{")) {
                this.proposeText("{", context, acceptor, UiConstant.ImageType.PUNCTUATION);
            }
        } else {
            this.proposeText("{", context, acceptor, UiConstant.ImageType.PUNCTUATION);
        }
    }

    @Override
    public void complete_T_R_BRACE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (ModelUtil.getAncestorOfType((EObject)model, EmbeddedJSONString.class) != null) {
            if (!context.getPrefix().equals("}")) {
                this.proposeText("}", context, acceptor, UiConstant.ImageType.PUNCTUATION);
            }
        } else {
            this.proposeText("}", context, acceptor, UiConstant.ImageType.PUNCTUATION);
        }
    }

    @Override
    public void complete_T_COLON(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeText(":", context, acceptor, UiConstant.ImageType.PUNCTUATION);
    }

    protected void proposeText(String enter, ContentAssistContext context, ICompletionProposalAcceptor acceptor, UiConstant.ImageType imageType) {
        this.proposeText(enter, enter, context, acceptor, imageType);
    }

    protected void proposeText(String enter, String description, ContentAssistContext context, ICompletionProposalAcceptor acceptor, UiConstant.ImageType imageType) {
        StyledString styledDescription = new StyledString(description);
        if (imageType == UiConstant.ImageType.KEYWORD) {
            styledDescription = new StyledString(description, StyledString.DECORATIONS_STYLER);
        }
        styledDescription.append(" (" + imageType.getName() + ")", StyledString.QUALIFIER_STYLER);
        acceptor.accept(this.createCompletionProposal(enter, styledDescription, imageType.getImage(), imageType.getPriority(), context.getPrefix(), context));
    }
}

