/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.json.ui.outline;

import com.datastax.devcenter.json.json.JsonArray;
import com.datastax.devcenter.json.json.JsonArrayValue;
import com.datastax.devcenter.json.json.JsonBooleanValue;
import com.datastax.devcenter.json.json.JsonMember;
import com.datastax.devcenter.json.json.JsonNullValue;
import com.datastax.devcenter.json.json.JsonNumberValue;
import com.datastax.devcenter.json.json.JsonObject;
import com.datastax.devcenter.json.json.JsonObjectValue;
import com.datastax.devcenter.json.json.JsonStringValue;
import com.datastax.devcenter.json.json.JsonValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;

public class JsonOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    public void createChildren(IOutlineNode parent, EObject modelElement) {
        if (modelElement != null && parent.hasChildren()) {
            if (modelElement instanceof JsonMember) {
                JsonMember jsonMember = (JsonMember)modelElement;
                if (jsonMember.getValue() != null) {
                    if (jsonMember.getValue() instanceof JsonObjectValue) {
                        JsonObjectValue jsonObject = (JsonObjectValue)jsonMember.getValue();
                        this.createChildrenDispatcher.invoke(new Object[]{parent, jsonObject.getValue()});
                    } else if (jsonMember.getValue() instanceof JsonArrayValue) {
                        JsonArrayValue arrayValue = (JsonArrayValue)jsonMember.getValue();
                        this.createChildrenDispatcher.invoke(new Object[]{parent, arrayValue.getValue()});
                    }
                }
            } else {
                this.createChildrenDispatcher.invoke(new Object[]{parent, modelElement});
            }
        }
    }

    protected Object _text(Object obj) {
        if (obj instanceof JsonObject) {
            return "{}";
        }
        if (obj instanceof JsonArray) {
            return "[]";
        }
        if (obj instanceof JsonMember) {
            JsonMember member = (JsonMember)obj;
            if (member.getValue() != null) {
                if (member.getValue() instanceof JsonArrayValue) {
                    return member.getKey() + " : []";
                }
                if (member.getValue() instanceof JsonObjectValue) {
                    return member.getKey() + " : {}";
                }
                return member.getKey() + " : " + this.getValueForMember(member.getValue());
            }
            return "";
        }
        if (obj instanceof JsonValue) {
            return this.getValueForMember((JsonValue)obj);
        }
        return super._text(obj);
    }

    private String getValueForMember(JsonValue value) {
        if (value != null) {
            if (value instanceof JsonStringValue) {
                return ((JsonStringValue)value).getValue();
            }
            if (value instanceof JsonBooleanValue) {
                return ((JsonBooleanValue)value).getValue();
            }
            if (value instanceof JsonNumberValue) {
                return ((JsonNumberValue)value).getValue();
            }
            if (value instanceof JsonNullValue) {
                return ((JsonNullValue)value).getValue();
            }
            return "";
        }
        return "";
    }

    protected boolean _isLeaf(EObject modelElement) {
        if (modelElement instanceof JsonArrayValue || modelElement instanceof JsonObjectValue) {
            return false;
        }
        if (modelElement instanceof JsonMember) {
            JsonMember member = (JsonMember)modelElement;
            return !(member.getValue() instanceof JsonArrayValue) && !(member.getValue() instanceof JsonObjectValue);
        }
        return false;
    }
}

