/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.json.ui.util;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

public abstract class AbstractJsonSerializer<T>
extends JsonSerializer<T> {
    public void serialize(GettableByIndexData value, int fieldIndex, DataType.Name typeName, List<DataType> typeArguments, JsonGenerator jgen, SerializerProvider provider) throws JsonMappingException, JsonProcessingException, IOException {
        Class type1 = typeArguments.size() > 0 ? typeArguments.get(0).getName().asJavaClass() : null;
        Class type2 = typeArguments.size() > 1 ? typeArguments.get(1).getName().asJavaClass() : null;
        switch (typeName) {
            case UUID: {
                provider.findValueSerializer(UUID.class).serialize((Object)value.getUUID(fieldIndex), jgen, provider);
                break;
            }
            case ASCII: {
                provider.findValueSerializer(String.class).serialize((Object)value.getString(fieldIndex), jgen, provider);
                break;
            }
            case BIGINT: {
                provider.findValueSerializer(Long.class).serialize((Object)value.getLong(fieldIndex), jgen, provider);
                break;
            }
            case BLOB: {
                provider.findValueSerializer(ByteBuffer.class).serialize((Object)value.getBytes(fieldIndex), jgen, provider);
                break;
            }
            case BOOLEAN: {
                provider.findValueSerializer(Boolean.class).serialize((Object)value.getBool(fieldIndex), jgen, provider);
                break;
            }
            case DECIMAL: {
                provider.findValueSerializer(BigDecimal.class).serialize((Object)value.getDecimal(fieldIndex), jgen, provider);
                break;
            }
            case DOUBLE: {
                provider.findValueSerializer(Double.class).serialize((Object)value.getDouble(fieldIndex), jgen, provider);
                break;
            }
            case FLOAT: {
                provider.findValueSerializer(Float.class).serialize((Object)Float.valueOf(value.getFloat(fieldIndex)), jgen, provider);
                break;
            }
            case INT: {
                provider.findValueSerializer(Integer.class).serialize((Object)value.getInt(fieldIndex), jgen, provider);
                break;
            }
            case TEXT: {
                provider.findValueSerializer(String.class).serialize((Object)value.getString(fieldIndex), jgen, provider);
                break;
            }
            case INET: {
                provider.findValueSerializer(InetAddress.class).serialize((Object)value.getInet(fieldIndex), jgen, provider);
                break;
            }
            case TIMESTAMP: {
                provider.findValueSerializer(Date.class).serialize((Object)value.getDate(fieldIndex), jgen, provider);
                break;
            }
            case VARINT: {
                provider.findValueSerializer(BigInteger.class).serialize((Object)value.getVarint(fieldIndex), jgen, provider);
                break;
            }
            case TIMEUUID: {
                provider.findValueSerializer(UUID.class).serialize((Object)value.getUUID(fieldIndex), jgen, provider);
                break;
            }
            case COUNTER: {
                provider.findValueSerializer(Long.class).serialize((Object)value.getLong(fieldIndex), jgen, provider);
                break;
            }
            case VARCHAR: {
                provider.findValueSerializer(String.class).serialize((Object)value.getString(fieldIndex), jgen, provider);
                break;
            }
            case LIST: {
                provider.findValueSerializer(List.class).serialize((Object)value.getList(fieldIndex, type1), jgen, provider);
                break;
            }
            case SET: {
                provider.findValueSerializer(Set.class).serialize((Object)value.getSet(fieldIndex, type1), jgen, provider);
                break;
            }
            case MAP: {
                provider.findValueSerializer(Map.class).serialize((Object)value.getMap(fieldIndex, type1, type2), jgen, provider);
                break;
            }
            case UDT: {
                provider.findValueSerializer(UDTValue.class).serialize((Object)value.getUDTValue(fieldIndex), jgen, provider);
                break;
            }
            case TUPLE: {
                provider.findValueSerializer(TupleValue.class).serialize((Object)value.getTupleValue(fieldIndex), jgen, provider);
                break;
            }
            default: {
                provider.findValueSerializer(String.class).serialize((Object)value.getString(fieldIndex), jgen, provider);
            }
        }
    }

    public void serialize(Object value, Class<?> clazz, JsonGenerator jgen, SerializerProvider provider) throws JsonMappingException, JsonProcessingException, IOException {
        provider.findValueSerializer(clazz).serialize(value, jgen, provider);
    }
}

