/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.json.ui.util;

import com.datastax.devcenter.json.ui.util.JsonUtil;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.utils.Bytes;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CqlResultsSerializer {
    private static List<Class<?>> JSON_DATA_TYPES = ImmutableList.of(UDTValue.class, TupleValue.class, Map.class, Collection.class);

    public static String serialize(Object object) {
        try {
            if (CqlResultsSerializer.shouldRenderAsJson(object)) {
                return JsonUtil.serialize(object);
            }
        }
        catch (Exception exception) {
            return CqlResultsSerializer.serializeSimpleType(object);
        }
        return CqlResultsSerializer.serializeSimpleType(object);
    }

    private static String serializeSimpleType(Object object) {
        if (object instanceof ByteBuffer) {
            return Bytes.toHexString((ByteBuffer)((ByteBuffer)object));
        }
        if (object instanceof InetAddress) {
            return ((InetAddress)object).getHostAddress();
        }
        return String.valueOf(object);
    }

    public static boolean shouldRenderAsJson(Object object) {
        for (Class<?> clazz : JSON_DATA_TYPES) {
            if (!clazz.isInstance(object)) continue;
            return true;
        }
        return false;
    }
}

