/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.json.ui.util;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.util.DefaultPrettyPrinter;

public class JsonResultsPrettyPrinter
extends DefaultPrettyPrinter {
    private int numberOfTopLevelFieldsPassed = 0;
    private int numberOfTopLevelFieldsBeforeFirstLineBreak = 1;

    public JsonResultsPrettyPrinter(int numberOfTopLevelFieldsBeforeFirstLineBreak) {
        this.numberOfTopLevelFieldsBeforeFirstLineBreak = numberOfTopLevelFieldsBeforeFirstLineBreak;
    }

    public void beforeObjectEntries(JsonGenerator jg) throws IOException, JsonGenerationException {
        if (this.shouldWriteIndentation()) {
            this._objectIndenter.writeIndentation(jg, this._nesting);
        }
    }

    public void writeStartObject(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw('{');
        if (!this._objectIndenter.isInline()) {
            ++this._nesting;
        }
    }

    public void writeEndObject(JsonGenerator jg, int nrOfEntries) throws IOException, JsonGenerationException {
        if (!this._objectIndenter.isInline()) {
            --this._nesting;
        }
        if (nrOfEntries > 0 && this.shouldWriteIndentation()) {
            this._objectIndenter.writeIndentation(jg, this._nesting);
        } else {
            jg.writeRaw(' ');
        }
        jg.writeRaw('}');
    }

    public boolean shouldWriteIndentation() {
        return this.numberOfTopLevelFieldsPassed >= this.numberOfTopLevelFieldsBeforeFirstLineBreak;
    }

    public void writeObjectEntrySeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeRaw(',');
        if (this._nesting == 1) {
            ++this.numberOfTopLevelFieldsPassed;
        }
        if (this.shouldWriteIndentation()) {
            this._objectIndenter.writeIndentation(jg, this._nesting);
        }
    }
}

