/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.json.ui.util;

import com.datastax.devcenter.json.ui.util.BlobJsonSerializer;
import com.datastax.devcenter.json.ui.util.InetAddressJsonSerializer;
import com.datastax.devcenter.json.ui.util.JsonResultsPrettyPrinter;
import com.datastax.devcenter.json.ui.util.TupleValueJsonSerializer;
import com.datastax.devcenter.json.ui.util.UdtValueJsonSerializer;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.ser.CustomSerializerFactory;

public class JsonUtil {
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectWriter JSON_SERIALIZATION_WRITER;

    static {
        CustomSerializerFactory factory = new CustomSerializerFactory();
        UdtValueJsonSerializer udtSerializer = new UdtValueJsonSerializer();
        TupleValueJsonSerializer tupleSerializer = new TupleValueJsonSerializer();
        BlobJsonSerializer blobSerializer = new BlobJsonSerializer();
        InetAddressJsonSerializer inetSerializer = new InetAddressJsonSerializer();
        factory.addSpecificMapping(UDTValue.class, (JsonSerializer)udtSerializer);
        factory.addSpecificMapping(TupleValue.class, (JsonSerializer)tupleSerializer);
        factory.addGenericMapping(ByteBuffer.class, (JsonSerializer)blobSerializer);
        factory.addSpecificMapping(InetAddress.class, (JsonSerializer)inetSerializer);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializerFactory((SerializerFactory)factory);
        JSON_SERIALIZATION_WRITER = mapper.writer();
    }

    public static String formatJsonForCodeFolding(String unformatted, int numberOfTopLevelFieldsBeforeLineBreak) throws JsonParseException, JsonMappingException, IOException {
        return JsonUtil.formatJsonWithPrinter(unformatted, (PrettyPrinter)new JsonResultsPrettyPrinter(numberOfTopLevelFieldsBeforeLineBreak));
    }

    public static String formatJsonWithPrinter(String unformatted, PrettyPrinter printer) throws IOException, JsonParseException, JsonMappingException, JsonGenerationException {
        Object json = JSON_OBJECT_MAPPER.readValue(unformatted, Object.class);
        return JSON_OBJECT_MAPPER.prettyPrintingWriter(printer).writeValueAsString(json);
    }

    public static String serialize(Object value) throws JsonGenerationException, JsonMappingException, IOException {
        return JSON_SERIALIZATION_WRITER.writeValueAsString(value);
    }
}

