/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.json.ui.util;

import com.datastax.devcenter.json.ui.util.AbstractJsonSerializer;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.SerializerProvider;

public class UdtValueJsonSerializer
extends AbstractJsonSerializer<UDTValue> {
    public void serialize(UDTValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        UserType userType = value.getType();
        Collection fieldNames = userType.getFieldNames();
        jgen.writeStartObject();
        int fieldIndex = 0;
        for (String fieldName : fieldNames) {
            jgen.writeFieldName(fieldName);
            DataType.Name typeName = userType.getFieldType(fieldName).getName();
            List typeArguments = userType.getFieldType(fieldName).getTypeArguments();
            this.serialize((GettableByIndexData)value, fieldIndex, typeName, typeArguments, jgen, provider);
            ++fieldIndex;
        }
        jgen.writeEndObject();
    }
}

