/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public abstract class NewContainerWizardPage
extends NewElementWizardPage {
    protected static final String CONTAINER = "NewContainerWizardPage.container";
    protected IStatus fContainerStatus;
    private StringButtonDialogField fContainerDialogField;
    private IPackageFragmentRoot fCurrRoot;
    private IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    public NewContainerWizardPage(String name) {
        super(name);
        ContainerFieldAdapter adapter = new ContainerFieldAdapter();
        this.fContainerDialogField = new StringButtonDialogField(adapter);
        this.fContainerDialogField.setDialogFieldListener(adapter);
        this.fContainerDialogField.setLabelText(this.getContainerLabel());
        this.fContainerDialogField.setButtonLabel(NewWizardMessages.NewContainerWizardPage_container_button);
        this.fContainerStatus = new StatusInfo();
        this.fCurrRoot = null;
    }

    protected String getContainerLabel() {
        return NewWizardMessages.NewContainerWizardPage_container_label;
    }

    protected void initContainerPage(IJavaElement elem) {
        IPackageFragmentRoot initRoot = null;
        if (elem != null) {
            initRoot = JavaModelUtil.getPackageFragmentRoot(elem);
            try {
                IJavaProject jproject;
                if ((initRoot == null || initRoot.getKind() != 1) && (jproject = elem.getJavaProject()) != null) {
                    initRoot = null;
                    if (jproject.exists()) {
                        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                        int i = 0;
                        while (i < roots.length) {
                            if (roots[i].getKind() == 1) {
                                initRoot = roots[i];
                                break;
                            }
                            ++i;
                        }
                    }
                    if (initRoot == null) {
                        initRoot = jproject.getPackageFragmentRoot(jproject.getResource());
                    }
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        this.setPackageFragmentRoot(initRoot, true);
    }

    protected IJavaElement getInitialJavaElement(IStructuredSelection selection) {
        IJavaElement jelem;
        block12: {
            IAdaptable adaptable;
            Object selectedElement;
            jelem = null;
            if (!(selection == null || selection.isEmpty() || !((selectedElement = selection.getFirstElement()) instanceof IAdaptable) || (jelem = (IJavaElement)(adaptable = (IAdaptable)selectedElement).getAdapter(IJavaElement.class)) != null && jelem.exists())) {
                jelem = null;
                IResource resource = (IResource)adaptable.getAdapter(IResource.class);
                if (resource != null && resource.getType() != 8) {
                    while (jelem == null && resource.getType() != 4) {
                        resource = resource.getParent();
                        jelem = (IJavaElement)resource.getAdapter(IJavaElement.class);
                    }
                    if (jelem == null) {
                        jelem = JavaCore.create((IResource)resource);
                    }
                }
            }
            if (jelem == null) {
                Object elem;
                IWorkbenchPart part = JavaPlugin.getActivePage().getActivePart();
                if (part instanceof ContentOutline) {
                    part = JavaPlugin.getActivePage().getActiveEditor();
                }
                if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IJavaElement) {
                    jelem = (IJavaElement)elem;
                }
            }
            if (jelem == null || jelem.getElementType() == 1) {
                try {
                    IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
                    if (projects.length != 1) break block12;
                    IClasspathEntry[] rawClasspath = projects[0].getRawClasspath();
                    int i = 0;
                    while (i < rawClasspath.length) {
                        if (rawClasspath[i].getEntryKind() == 3) {
                            jelem = projects[0];
                            break;
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
        }
        return jelem;
    }

    protected ITextSelection getCurrentTextSelection() {
        ISelection selection;
        ISelectionProvider selectionProvider;
        IWorkbenchPart part = JavaPlugin.getActivePage().getActivePart();
        if (part instanceof IEditorPart && (selectionProvider = part.getSite().getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    protected void createContainerControls(Composite parent, int nColumns) {
        this.fContainerDialogField.doFillIntoGrid(parent, nColumns);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getTextControl(null), this.getMaxFieldWidth());
        BidiUtils.applyBidiProcessing((Text)this.fContainerDialogField.getTextControl(null), (String)"file");
    }

    protected void setFocusOnContainer() {
        this.fContainerDialogField.setFocus();
    }

    private void containerChangeControlPressed(DialogField field) {
        IPackageFragmentRoot root;
        if (field == this.fContainerDialogField && (root = this.chooseContainer()) != null) {
            this.setPackageFragmentRoot(root, true);
        }
    }

    private void containerDialogFieldChanged(DialogField field) {
        if (field == this.fContainerDialogField) {
            this.fContainerStatus = this.containerChanged();
        }
        this.handleFieldChanged(CONTAINER);
    }

    protected IStatus containerChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrRoot = null;
        String str = this.getPackageFragmentRootText();
        if (str.length() == 0) {
            status.setError(NewWizardMessages.NewContainerWizardPage_error_EnterContainerName);
            return status;
        }
        Path path = new Path(str);
        IResource res = this.fWorkspaceRoot.findMember((IPath)path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ProjectClosed, BasicElementLabels.getPathLabel(proj.getFullPath(), false)));
                    return status;
                }
                IJavaProject jproject = JavaCore.create((IProject)proj);
                this.fCurrRoot = jproject.getPackageFragmentRoot(res);
                if (res.exists()) {
                    if (res.isVirtual()) {
                        status.setError(NewWizardMessages.NewContainerWizardPage_error_FolderIsVirtual);
                        return status;
                    }
                    try {
                        if (!proj.hasNature("org.eclipse.jdt.core.javanature")) {
                            if (resType == 4) {
                                status.setError(NewWizardMessages.NewContainerWizardPage_warning_NotAJavaProject);
                            } else {
                                status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotInAJavaProject);
                            }
                            return status;
                        }
                        if (this.fCurrRoot.isArchive()) {
                            status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ContainerIsBinary, BasicElementLabels.getPathLabel((IPath)path, false)));
                            return status;
                        }
                        if (this.fCurrRoot.getKind() == 2) {
                            status.setWarning(Messages.format(NewWizardMessages.NewContainerWizardPage_warning_inside_classfolder, BasicElementLabels.getPathLabel((IPath)path, false)));
                        } else if (!jproject.isOnClasspath((IJavaElement)this.fCurrRoot)) {
                            status.setWarning(Messages.format(NewWizardMessages.NewContainerWizardPage_warning_NotOnClassPath, BasicElementLabels.getPathLabel((IPath)path, false)));
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotOnClassPath);
                    }
                    catch (CoreException coreException) {
                        status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotAJavaProject);
                    }
                }
                return status;
            }
            status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_NotAFolder, BasicElementLabels.getPathLabel((IPath)path, false)));
            return status;
        }
        status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ContainerDoesNotExist, BasicElementLabels.getPathLabel((IPath)path, false)));
        return status;
    }

    protected void handleFieldChanged(String fieldName) {
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.fWorkspaceRoot;
    }

    public IJavaProject getJavaProject() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            return root.getJavaProject();
        }
        return null;
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fCurrRoot;
    }

    public String getPackageFragmentRootText() {
        return this.fContainerDialogField.getText();
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot root, boolean canBeModified) {
        this.fCurrRoot = root;
        String str = root == null ? "" : root.getPath().makeRelative().toString();
        this.fContainerDialogField.setText(str);
        this.fContainerDialogField.setEnabled(canBeModified);
    }

    protected IPackageFragmentRoot chooseContainer() {
        IPackageFragmentRoot initElement = this.getPackageFragmentRoot();
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e.getStatus());
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)this.fWorkspaceRoot));
        dialog.setInitialSelection((Object)initElement);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    private class ContainerFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private ContainerFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            NewContainerWizardPage.this.containerChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            NewContainerWizardPage.this.containerDialogFieldChanged(field);
        }
    }
}

