/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2;

import java.util.Collections;
import org.eclipse.xtext.formatting2.ITextReplacement;
import org.eclipse.xtext.formatting2.ITextSegment;
import org.eclipse.xtext.formatting2.internal.TextReplacementList;

public class TextReplacements {
    public static String apply(CharSequence input, Iterable<? extends ITextReplacement> replacements) {
        return TextReplacements.doApply(input, 0, replacements);
    }

    public static String apply(ITextSegment input, Iterable<? extends ITextReplacement> replacements) {
        return TextReplacements.doApply(input.getText(), input.getOffset(), replacements);
    }

    private static String doApply(CharSequence input, int offset, Iterable<? extends ITextReplacement> replacements) {
        TextReplacementList<? extends ITextReplacement> list = new TextReplacementList<ITextReplacement>(replacements);
        Collections.sort(list);
        int lastOffset = 0;
        StringBuilder result = new StringBuilder();
        for (ITextReplacement iTextReplacement : list) {
            result.append(input.subSequence(lastOffset, iTextReplacement.getOffset() - offset));
            result.append(iTextReplacement.getReplacementText());
            lastOffset = iTextReplacement.getOffset() - offset + iTextReplacement.getLength();
        }
        result.append(input.subSequence(lastOffset, input.length()));
        return result.toString();
    }
}

