/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql;

import com.datastax.devcenter.common.metrics.Metrics;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.FieldEntity;
import com.datastax.devcenter.cql.cql.IndexEntity;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.TriggerEntity;
import com.datastax.devcenter.cql.cql.TypeEntity;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.SchemaInitializer;
import com.datastax.devcenter.schema.StatementIndexMap;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.driver.core.VersionNumber;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class CqlContext {
    private final List<Schema> schemaList = new ArrayList<Schema>();
    private volatile int indexToCheck = 0;
    private final StatementIndexMap statementIndexMap = new StatementIndexMap();
    private volatile Schema databaseSchema;
    private VersionNumber cassandraVersion;
    private String defaultKeyspaceName;
    private final SchemaInitializer schemaInitializer;

    public CqlContext(SchemaInitializer schemaInitializer) {
        this.schemaInitializer = schemaInitializer;
        this.updateDatabaseSchemaAndReset(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDatabaseSchemaAndReset(Connection connection) {
        List<Schema> list = this.schemaList;
        synchronized (list) {
            this.schemaList.clear();
            this.indexToCheck = 0;
            this.statementIndexMap.clear();
            this.databaseSchema = this.schemaInitializer.init(connection);
            this.databaseSchema.rebuildIndex();
            this.databaseSchema.setDefaultKeyspaceName(this.defaultKeyspaceName);
            this.schemaList.add(this.databaseSchema);
            this.cassandraVersion = connection == null || connection.isClosed() ? CqlConstants.defaultCassandraVersion() : connection.getCassandraVersion();
        }
    }

    public StatementIndexMap getStatementIndexMap() {
        return this.statementIndexMap;
    }

    public int getIndexToCheck() {
        return this.indexToCheck;
    }

    public CqlContext setIndexToCheck(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("try to set index to check as " + i);
        }
        this.indexToCheck = i;
        return this;
    }

    public Schema getDatabaseSchema() {
        return this.getSchema(0);
    }

    public Schema getSchemaToCheck() {
        return this.getSchema(this.indexToCheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema getLastSchema() {
        List<Schema> list = this.schemaList;
        synchronized (list) {
            return this.schemaList.get(this.schemaList.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CqlContext duplicateLastSchema() {
        List<Schema> list = this.schemaList;
        synchronized (list) {
            this.schemaList.add(this.getLastSchema().deepCopy(null));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema getSchema(int index) {
        Metrics.setMaxGaugeValue((String)"max_cql_statements_in_script", (int)(index + 1));
        List<Schema> list = this.schemaList;
        synchronized (list) {
            if (index >= this.schemaList.size()) {
                return this.getLastSchema();
            }
            return this.schemaList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CqlContext updateStatementIndexMap(List<CqlStatement> stmts) {
        List<Schema> list = this.schemaList;
        synchronized (list) {
            this.schemaList.clear();
            this.schemaList.add(this.databaseSchema);
            this.statementIndexMap.clear();
            int index = 0;
            for (CqlStatement stmt : stmts) {
                this.statementIndexMap.setStatementIndex(stmt, ++index);
            }
        }
        return this;
    }

    public Table getTableMeta(EObject o) {
        CqlStatement stmt = ModelUtil.getCqlStatement(o);
        if (stmt == null) {
            return null;
        }
        TableEntity table = ModelUtil.getTable(stmt);
        if (table == null) {
            return null;
        }
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace(stmt);
        Table cfMeta = this.getSchemaToCheck().getTable(keyspaceEntity, table);
        return cfMeta;
    }

    public Column getColumnMeta(EObject o, ColumnEntity columnEntity) {
        CqlStatement stmt = ModelUtil.getCqlStatement(o);
        if (stmt == null) {
            return null;
        }
        TableEntity tableEntity = ModelUtil.getTable(stmt);
        if (tableEntity == null || columnEntity == null) {
            return null;
        }
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace(stmt);
        Column columnMeta = this.getSchemaToCheck().getColumn(keyspaceEntity, tableEntity, columnEntity);
        return columnMeta;
    }

    public UserType getUserTypeMeta(EObject o) {
        CqlStatement stmt = ModelUtil.getCqlStatement(o);
        if (stmt == null) {
            return null;
        }
        TypeEntity typeEntity = ModelUtil.getUserType(stmt);
        if (typeEntity == null) {
            return null;
        }
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace(stmt);
        UserType userTypeMeta = this.getSchemaToCheck().getUserType(keyspaceEntity, typeEntity);
        return userTypeMeta;
    }

    public UserType getUserTypeMeta(EObject o, String userTypeName) {
        CqlStatement stmt = ModelUtil.getCqlStatement(o);
        if (stmt == null) {
            return null;
        }
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace(stmt);
        String keyspaceName = this.getSchemaToCheck().getKeyspaceName(keyspaceEntity);
        UserType userType = this.getSchemaToCheck().getUserType(keyspaceName, userTypeName);
        return userType;
    }

    public boolean isTableExistInCurrentContext(KeyspaceEntity keyspaceEntity, TableEntity tableEntity) {
        return this.isTableExist(keyspaceEntity, tableEntity, this.getSchemaToCheck());
    }

    public boolean isTableExistInDatabase(KeyspaceEntity keyspaceEntity, TableEntity tableEntity) {
        return this.isTableExist(keyspaceEntity, tableEntity, this.getDatabaseSchema());
    }

    private boolean isTableExist(KeyspaceEntity keyspaceEntity, TableEntity tableEntity, Schema schema) {
        String currentContextKeyspaceName = this.getSchemaToCheck().getKeyspaceName(keyspaceEntity);
        return schema != null && tableEntity != null && schema.getTable(currentContextKeyspaceName, tableEntity) != null;
    }

    public boolean isIdExistInTableInCurrentContext(ColumnEntity columnEntity, KeyspaceEntity keyspaceEntity, TableEntity tableEntity) {
        return this.isIdExistInTable(columnEntity, keyspaceEntity, tableEntity, this.getSchemaToCheck());
    }

    public boolean isIdExistInTableInDatabase(ColumnEntity columnEntity, KeyspaceEntity keyspaceEntity, TableEntity tableEntity) {
        return this.isIdExistInTable(columnEntity, keyspaceEntity, tableEntity, this.getDatabaseSchema());
    }

    private boolean isIdExistInTable(ColumnEntity columnEntity, KeyspaceEntity keyspaceEntity, TableEntity tableEntity, Schema schema) {
        String currentContextKeyspaceName = this.getSchemaToCheck().getKeyspaceName(keyspaceEntity);
        Table table = schema.getTable(currentContextKeyspaceName, tableEntity);
        return columnEntity != null && table != null && table.getColumn(ModelUtil.stripName(columnEntity.getName())) != null;
    }

    public boolean isTypeExistInCurrentContext(KeyspaceEntity keyspaceEntity, TypeEntity typeEntity) {
        return this.isTypeExist(keyspaceEntity, typeEntity, this.getSchemaToCheck());
    }

    public boolean isTypeExistInDatabase(KeyspaceEntity keyspaceEntity, TypeEntity typeEntity) {
        return this.isTypeExist(keyspaceEntity, typeEntity, this.getDatabaseSchema());
    }

    private boolean isTypeExist(KeyspaceEntity keyspaceEntity, TypeEntity typeEntity, Schema schema) {
        String currentContextKeyspaceName = this.getSchemaToCheck().getKeyspaceName(keyspaceEntity);
        return schema != null && typeEntity != null && schema.getUserType(currentContextKeyspaceName, typeEntity) != null;
    }

    public boolean isFieldExistInTypeInCurrentContext(FieldEntity fieldEntity, KeyspaceEntity keyspaceEntity, TypeEntity typeEntity) {
        return this.isFieldExistInType(fieldEntity, keyspaceEntity, typeEntity, this.getSchemaToCheck());
    }

    public boolean isFieldExistInTypeInDatabase(FieldEntity fieldEntity, KeyspaceEntity keyspaceEntity, TypeEntity typeEntity) {
        return this.isFieldExistInType(fieldEntity, keyspaceEntity, typeEntity, this.getDatabaseSchema());
    }

    private boolean isFieldExistInType(FieldEntity fieldEntity, KeyspaceEntity keyspaceEntity, TypeEntity typeEntity, Schema schema) {
        String currentContextKeyspaceName = this.getSchemaToCheck().getKeyspaceName(keyspaceEntity);
        UserType userType = schema.getUserType(currentContextKeyspaceName, typeEntity);
        return fieldEntity != null && userType != null && userType.getField(ModelUtil.stripName(fieldEntity.getName())) != null;
    }

    public boolean isFieldExistInTypeInCurrentContext(UserTypeField userTypeField, KeyspaceEntity keyspaceEntity, String userTypeName) {
        return this.isFieldExistInType(userTypeField, keyspaceEntity, userTypeName, this.getSchemaToCheck());
    }

    public boolean isFieldExistInTypeInDatabase(UserTypeField userTypeField, KeyspaceEntity keyspaceEntity, String userTypeName) {
        return this.isFieldExistInType(userTypeField, keyspaceEntity, userTypeName, this.getDatabaseSchema());
    }

    private boolean isFieldExistInType(UserTypeField userTypeField, KeyspaceEntity keyspaceEntity, String userTypeName, Schema schema) {
        String currentContextKeyspaceName = this.getSchemaToCheck().getKeyspaceName(keyspaceEntity);
        UserType userType = schema.getUserType(currentContextKeyspaceName, userTypeName);
        return userTypeField != null && userType != null && userType.getField(ModelUtil.stripName(userTypeField.getName())) != null;
    }

    public boolean isKeyspaceExistInCurrentContext(KeyspaceEntity keyspaceEntity) {
        return this.isKeyspaceExist(keyspaceEntity, this.getSchemaToCheck());
    }

    public boolean isKeyspaceExistInDatabase(KeyspaceEntity keyspaceEntity) {
        return this.isKeyspaceExist(keyspaceEntity, this.getDatabaseSchema());
    }

    private boolean isKeyspaceExist(KeyspaceEntity keyspaceEntity, Schema schema) {
        return keyspaceEntity != null && schema != null && schema.getKeyspace(ModelUtil.stripName(keyspaceEntity.getName())) != null;
    }

    public boolean isIndexExistInCurrentContext(IndexEntity indexEntity) {
        return this.isIndexExist(indexEntity, this.getSchemaToCheck());
    }

    public boolean isIndexExistInDatabase(IndexEntity indexEntity) {
        return this.isIndexExist(indexEntity, this.getDatabaseSchema());
    }

    private boolean isIndexExist(IndexEntity indexEntity, Schema schema) {
        return indexEntity != null && schema != null && schema.getIndex(ModelUtil.stripName(indexEntity.getName())) != null;
    }

    public boolean isTriggerExistInCurrentContext(TriggerEntity triggerEntity) {
        return this.isTriggerExist(triggerEntity, this.getSchemaToCheck());
    }

    public boolean isTriggerExistInDatabase(TriggerEntity triggerEntity) {
        return this.isTriggerExist(triggerEntity, this.getDatabaseSchema());
    }

    private boolean isTriggerExist(TriggerEntity triggerEntity, Schema schema) {
        return triggerEntity != null && schema != null && schema.getTrigger(ModelUtil.stripName(triggerEntity.getName())) != null;
    }

    public boolean isUserExistInCurrentContext(String userName) {
        return this.isUserExist(userName, this.getSchemaToCheck());
    }

    public boolean isUserExistInDatabase(String userName) {
        return this.isUserExist(userName, this.getDatabaseSchema());
    }

    private boolean isUserExist(String userName, Schema schema) {
        return schema != null && schema.isUserExist(userName);
    }

    public boolean isUserOrRoleExistInCurrentContext(String userOrRoleName) {
        return this.isUserOrRoleExist(userOrRoleName, this.getSchemaToCheck());
    }

    public boolean isUserOrRoleExistInDatabase(String userOrRoleName) {
        return this.isUserOrRoleExist(userOrRoleName, this.getDatabaseSchema());
    }

    private boolean isUserOrRoleExist(String userOrRoleName, Schema schema) {
        return schema != null && schema.isUserExist(userOrRoleName);
    }

    public VersionNumber getCassandraVersion() {
        return this.cassandraVersion;
    }

    public CqlContext setCurrentVersion(VersionNumber version) {
        this.cassandraVersion = version;
        return this;
    }

    public boolean isCurrentVersionGreaterOrEqual(VersionNumber version) {
        return this.getCassandraVersion().compareTo(version) >= 0;
    }

    public VersionNumber getBestMatchForCurrentVersion(VersionNumber ... versions) {
        VersionNumber currentVersion = this.getCassandraVersion();
        VersionNumber[] versionNumberArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            VersionNumber version = versionNumberArray[n2];
            if (currentVersion.getMajor() == version.getMajor() && currentVersion.getMinor() == version.getMinor()) {
                return version;
            }
            ++n2;
        }
        return versions[versions.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        List<Schema> list = this.schemaList;
        synchronized (list) {
            int idx = 0;
            while (idx < this.schemaList.size()) {
                sb.append("#" + idx + "\n");
                sb.append(this.schemaList.get(idx).toString());
                ++idx;
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CqlContext setDefaultKeyspaceName(String keyspaceName) {
        this.defaultKeyspaceName = keyspaceName;
        List<Schema> list = this.schemaList;
        synchronized (list) {
            for (Schema schema : this.schemaList) {
                schema.setDefaultKeyspaceName(keyspaceName);
            }
            this.databaseSchema.setDefaultKeyspaceName(keyspaceName);
        }
        return this;
    }
}

