/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql;

import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.SchemaInitializer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class CqlContextProvider {
    @Inject
    private SchemaInitializer schemaInitializer;
    private final ConcurrentMap<String, CqlContext> contexts = new ConcurrentHashMap<String, CqlContext>();

    public CqlContext get(EObject eObject) {
        URI uri = ModelUtil.getAncestorOfType(eObject, Statements.class).eResource().getURI();
        return this.get(uri);
    }

    public CqlContext get(URI resourceURI) {
        return this.get(resourceURI.toString());
    }

    public CqlContext get(String resourceURI) {
        CqlContext context = (CqlContext)this.contexts.get(resourceURI);
        if (context == null) {
            context = new CqlContext(this.schemaInitializer);
            CqlContext previousContext = this.contexts.putIfAbsent(resourceURI, context);
            context = previousContext != null ? previousContext : context;
        }
        return context;
    }

    public CqlContext renameResource(String currentURI, String newURI) {
        CqlContext context = (CqlContext)this.contexts.remove(currentURI);
        if (context != null) {
            this.contexts.put(newURI, context);
        }
        return context;
    }

    public CqlContext removeContext(URI resourceURI) {
        return (CqlContext)this.contexts.remove(resourceURI.toString());
    }

    public CqlContext removeContext(String resourceURI) {
        return (CqlContext)this.contexts.remove(resourceURI);
    }
}

