/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.CqlContextProvider;
import com.datastax.devcenter.cql.cql.BooleanValue;
import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.ConstantValue;
import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.FieldEntity;
import com.datastax.devcenter.cql.cql.InsertStatement;
import com.datastax.devcenter.cql.cql.JSONInsertStatement;
import com.datastax.devcenter.cql.cql.JsonArrayLiteral;
import com.datastax.devcenter.cql.cql.JsonMapLiteral;
import com.datastax.devcenter.cql.cql.JsonSetLiteral;
import com.datastax.devcenter.cql.cql.JsonTupleLiteral;
import com.datastax.devcenter.cql.cql.JsonUserTypeLiteral;
import com.datastax.devcenter.cql.cql.MapEntry;
import com.datastax.devcenter.cql.cql.StandardInsertStatement;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.cql.StringValue;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.UserTypeEntry;
import com.datastax.devcenter.cql.cql.Value;
import com.datastax.devcenter.cql.parser.antlr.CqlLiteralParser;
import com.datastax.devcenter.cql.parser.antlr.JsonLiteralParser;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.json.json.JsonArrayValue;
import com.datastax.devcenter.json.json.JsonBooleanValue;
import com.datastax.devcenter.json.json.JsonMember;
import com.datastax.devcenter.json.json.JsonNullValue;
import com.datastax.devcenter.json.json.JsonNumberValue;
import com.datastax.devcenter.json.json.JsonObject;
import com.datastax.devcenter.json.json.JsonObjectValue;
import com.datastax.devcenter.json.json.JsonStringValue;
import com.datastax.devcenter.json.json.JsonValue;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IDerivedStateComputer;

public class CqlDerivedStateComputer
implements IDerivedStateComputer {
    @Inject
    private JsonLiteralParser jsonLiteralParser;
    @Inject
    private CqlLiteralParser cqlLiteralParser;
    @Inject
    private CqlContextProvider contextProvider;

    public void installDerivedState(DerivedStateAwareResource resource, boolean preLinkingPhase) {
        if (resource.getContents().isEmpty()) {
            return;
        }
        for (EObject nextObject : resource.getContents()) {
            if (!(nextObject instanceof Statements)) continue;
            Statements stmts = (Statements)nextObject;
            this.rebuildSchema(stmts);
            for (CqlStatement cqlStmt : stmts.getStatements()) {
                InsertStatement insert;
                if (!(cqlStmt instanceof InsertStatement) || (insert = (InsertStatement)cqlStmt).getJsonInsertPart() == null) continue;
                this.produceInsertTermsFromJSON(insert);
            }
        }
    }

    private void rebuildSchema(Statements stmts) {
        try {
            CqlContext context = this.contextProvider.get(stmts);
            context.updateStatementIndexMap((List<CqlStatement>)stmts.getStatements());
        }
        catch (Exception ex) {
            DevCenterLogger.error((Throwable)ex, (String)ex.toString(), (String)this.getClass().getName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
        }
    }

    private void produceInsertTermsFromJSON(InsertStatement insertStatement) {
        JsonObject topLevel;
        JSONInsertStatement jsonPart = insertStatement.getJsonInsertPart();
        if (jsonPart != null && jsonPart.getEmbeddJSONString() != null && (topLevel = jsonPart.getEmbeddJSONString().getValue()) != null) {
            StandardInsertStatement standard = CqlFactory.eINSTANCE.createStandardInsertStatement();
            insertStatement.setSyntheticStandardInsertPart(standard);
            for (JsonMember member : topLevel.getMembers()) {
                ColumnEntity columnEntity = CqlFactory.eINSTANCE.createColumnEntity();
                columnEntity.setSourceObject(member.getKey());
                if (member.getKey() == null) continue;
                String columnName = ModelUtil.stripName(member.getKey().getValue());
                columnName = columnName.replace("\\\"", "\"");
                columnEntity.setName(columnName);
                JsonValue jsonValue = member.getValue();
                Term t = this.convertJsonValueToCqlTerm(jsonValue);
                standard.getColumns().add((Object)columnEntity);
                standard.getTerms().add((Object)t);
            }
        }
    }

    private Term convertJsonValueToCqlTerm(JsonValue jsonValue) {
        Term term = CqlFactory.eINSTANCE.createTerm();
        term.setSourceObject(jsonValue);
        if (jsonValue instanceof JsonBooleanValue) {
            this.convertJsonToCQL((JsonBooleanValue)jsonValue, term);
        } else if (jsonValue instanceof JsonNumberValue) {
            this.convertJsonToCQL((JsonNumberValue)jsonValue, term);
        } else if (jsonValue instanceof JsonStringValue) {
            this.convertJsonToCQL((JsonStringValue)jsonValue, term);
        } else if (jsonValue instanceof JsonArrayValue) {
            this.convertJsonToCQL((JsonArrayValue)jsonValue, term);
        } else if (jsonValue instanceof JsonObjectValue) {
            this.convertJsonToCQL((JsonObjectValue)jsonValue, term);
        } else if (jsonValue instanceof JsonNullValue) {
            this.convertJsonToCQL((JsonNullValue)jsonValue, term);
        }
        return term;
    }

    private void convertJsonToCQL(JsonNullValue jsonValue, Term term) {
        Value value = CqlFactory.eINSTANCE.createValue();
        value.setSourceObject(jsonValue);
        value.setNil(true);
        term.setValue(value);
    }

    private void convertJsonToCQL(JsonObjectValue jsonObject, Term term) {
        Value value = CqlFactory.eINSTANCE.createValue();
        JsonUserTypeLiteral literal = this.convertToUDT(jsonObject, value);
        literal.setMapVersion(this.convertToMapLiteral(jsonObject));
        term.setValue(value);
    }

    private JsonUserTypeLiteral convertToUDT(JsonObjectValue jsonObject, Value value) {
        JsonUserTypeLiteral literal = new JsonUserTypeLiteral();
        value.setUserType(literal);
        for (JsonMember member : jsonObject.getValue().getMembers()) {
            if (member.getKey() == null) continue;
            JsonValue jsonValue = member.getValue();
            Term valueTerm = this.convertJsonValueToCqlTerm(jsonValue);
            UserTypeEntry entry = CqlFactory.eINSTANCE.createUserTypeEntry();
            Term keyTerm = CqlFactory.eINSTANCE.createTerm();
            String keyName = member.getKey().getValue();
            keyTerm.setValue(this.convertToCqlStringConstant(keyName));
            this.interpretJSONLiteralAlternatives(keyTerm, keyName);
            FieldEntity field = CqlFactory.eINSTANCE.createFieldEntity();
            field.setName(keyName);
            entry.setUserTypeField(field);
            entry.setValue(valueTerm);
            literal.getEntries().add((Object)entry);
        }
        return literal;
    }

    private JsonMapLiteral convertToMapLiteral(JsonObjectValue jsonObject) {
        JsonMapLiteral map = new JsonMapLiteral();
        for (JsonMember member : jsonObject.getValue().getMembers()) {
            if (member.getKey() == null) continue;
            JsonValue jsonValue = member.getValue();
            Term valueTerm = this.convertJsonValueToCqlTerm(jsonValue);
            MapEntry entry = CqlFactory.eINSTANCE.createMapEntry();
            Term keyTerm = CqlFactory.eINSTANCE.createTerm();
            String key = member.getKey().getValue();
            keyTerm.setValue(this.convertToCqlStringConstant(key));
            this.interpretJSONLiteralAlternatives(keyTerm, key);
            entry.setKey(keyTerm);
            entry.setValue(valueTerm);
            map.getEntries().add((Object)entry);
        }
        return map;
    }

    private void interpretJSONLiteralAlternatives(Term term, String potentialLiteral) {
        try {
            ConstantValue constantValue;
            Term cqlTerm;
            JsonValue jsonLiteral;
            String stripped = ModelUtil.stripName(potentialLiteral).replaceAll("\\\\\"", "\"");
            IParseResult parseResult = this.jsonLiteralParser.doParse(stripped);
            if (!parseResult.hasSyntaxErrors() && (jsonLiteral = (JsonValue)parseResult.getRootASTElement()) != null && (cqlTerm = this.convertJsonValueToCqlTerm(jsonLiteral)) != null) {
                term.setAlternateValue(cqlTerm.getValue());
            }
            if (term.getAlternateValue() == null && !(parseResult = this.cqlLiteralParser.doParse(stripped)).hasSyntaxErrors() && (constantValue = (ConstantValue)parseResult.getRootASTElement()) != null) {
                Value value = CqlFactory.eINSTANCE.createValue();
                value.setConstant(constantValue);
                term.setAlternateValue(value);
            }
        }
        catch (Exception exception) {}
    }

    private void convertJsonToCQL(JsonArrayValue jsonValue, Term term) {
        JsonArrayLiteral cqlJsonArray = new JsonArrayLiteral();
        JsonSetLiteral setVersion = new JsonSetLiteral();
        JsonTupleLiteral tupleVersion = new JsonTupleLiteral();
        cqlJsonArray.setTupleVersion(tupleVersion);
        cqlJsonArray.setSetVersion(setVersion);
        for (JsonValue jv : jsonValue.getValue().getValue()) {
            Term convertedTermForArray = this.convertJsonValueToCqlTerm(jv);
            Term convertedTermForTuple = this.convertJsonValueToCqlTerm(jv);
            Term convertedTermForSet = this.convertJsonValueToCqlTerm(jv);
            cqlJsonArray.getValues().add((Object)convertedTermForArray);
            tupleVersion.getValues().add((Object)convertedTermForTuple);
            setVersion.getValues().add((Object)convertedTermForSet);
        }
        Value value = CqlFactory.eINSTANCE.createValue();
        value.setCollection(cqlJsonArray);
        term.setValue(value);
    }

    private void convertJsonToCQL(JsonStringValue str, Term term) {
        String stringValue = ModelUtil.quote(ModelUtil.stripName(str.getValue()));
        Value value = this.convertToCqlStringConstant(stringValue);
        term.setValue(value);
        this.interpretJSONLiteralAlternatives(term, stringValue);
    }

    private Value convertToCqlStringConstant(String stringValue) {
        StringValue constant = CqlFactory.eINSTANCE.createStringValue();
        constant.setValue(ModelUtil.quote(ModelUtil.stripName(stringValue)));
        Value value = CqlFactory.eINSTANCE.createValue();
        value.setConstant(constant);
        return value;
    }

    private void convertJsonToCQL(JsonNumberValue jsonNumber, Term term) {
        ConstantValue constant = null;
        if (NativeCqlDataType.INT.validate(jsonNumber.getValue())) {
            constant = CqlFactory.eINSTANCE.createIntegerValue();
            constant.setValue(jsonNumber.getValue());
        } else {
            constant = CqlFactory.eINSTANCE.createFloatValue();
            constant.setValue(jsonNumber.getValue());
        }
        Value value = CqlFactory.eINSTANCE.createValue();
        value.setConstant(constant);
        term.setValue(value);
    }

    private void convertJsonToCQL(JsonBooleanValue booleanValue, Term term) {
        BooleanValue constant = CqlFactory.eINSTANCE.createBooleanValue();
        constant.setValue(booleanValue.getValue());
        Value value = CqlFactory.eINSTANCE.createValue();
        value.setConstant(constant);
        term.setValue(value);
    }

    public void discardDerivedState(DerivedStateAwareResource resource) {
        if (resource.getContents().isEmpty()) {
            return;
        }
        for (EObject e : resource.getContents()) {
            InsertStatement insert;
            if (e instanceof Term) {
                ((Term)e).setAlternateValue(null);
                ((Term)e).setSourceObject(null);
            }
            if (e instanceof ColumnEntity) {
                ((ColumnEntity)e).setSourceObject(null);
            }
            if (e instanceof Value) {
                ((Value)e).setSourceObject(null);
            }
            if (!(e instanceof InsertStatement) || (insert = (InsertStatement)e).getSyntheticStandardInsertPart() == null) continue;
            insert.setSyntheticStandardInsertPart(null);
        }
    }
}

