/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.generators;

import com.datastax.devcenter.common.utils.BeanPropertyHelper;
import com.datastax.devcenter.cql.cql.AlterKeyspaceStatement;
import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.MapLiteral;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.cql.TableProperty;
import com.datastax.devcenter.cql.generators.DDLStatementGenerationContext;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.util.CqlGrammarHelper;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.options.KeyspaceOptions;
import com.datastax.devcenter.schema.options.KeyspaceReplication;
import com.datastax.devcenter.schema.options.OptionsHelper;
import com.datastax.devcenter.schema.options.ReplicationStrategy;
import com.datastax.driver.core.VersionNumber;
import java.util.List;
import java.util.Map;

public class AlterKeyspaceStatementGenerator
implements DDLStatementGenerator<Keyspace> {
    @Override
    public Statements generate(DDLStatementGenerationContext<Keyspace> context) {
        Keyspace initial = context.getInitial();
        Keyspace current = context.getCurrent();
        Statements statements = CqlFactory.eINSTANCE.createStatements();
        VersionNumber version = context.getVersionNumber();
        AlterKeyspaceStatement tableProperties = this.alterKeyspaceProperties(initial, current, version);
        if (!tableProperties.getProperties().isEmpty()) {
            statements.getStatements().add((Object)tableProperties);
        }
        return statements;
    }

    private AlterKeyspaceStatement newAlterKeyspaceStatement(Keyspace initial) {
        AlterKeyspaceStatement stmt = CqlFactory.eINSTANCE.createAlterKeyspaceStatement();
        stmt.setKeyspace(CqlFactory.eINSTANCE.createKeyspaceEntity());
        stmt.getKeyspace().setName(ModelUtil.escapeName(initial.getName()));
        return stmt;
    }

    private AlterKeyspaceStatement alterKeyspaceProperties(Keyspace initial, Keyspace current, VersionNumber version) {
        AlterKeyspaceStatement stmt = this.newAlterKeyspaceStatement(initial);
        KeyspaceOptions initialOptions = initial.getOptions() == null ? new KeyspaceOptions() : initial.getOptions();
        KeyspaceOptions currentOptions = current.getOptions() == null ? new KeyspaceOptions() : current.getOptions();
        ReplicationStrategy initialStrategy = (ReplicationStrategy)BeanPropertyHelper.nullSafeGetProperty((Object)initialOptions, (String)"replication.strategy");
        ReplicationStrategy currentStrategy = (ReplicationStrategy)BeanPropertyHelper.nullSafeGetProperty((Object)currentOptions, (String)"replication.strategy");
        Map<String, Object> options = OptionsHelper.getAlteredOptions((Object)initialOptions, (Object)currentOptions, version, initialStrategy, currentStrategy, false);
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            CqlGrammarHelper.addProperty((List<TableProperty>)stmt.getProperties(), entry.getKey(), entry.getValue());
        }
        this.alterReplicationProperties(stmt, initialOptions, currentOptions, version, initialStrategy, currentStrategy);
        return stmt;
    }

    private void alterReplicationProperties(AlterKeyspaceStatement stmt, KeyspaceOptions initial, KeyspaceOptions current, VersionNumber version, ReplicationStrategy initialStrategy, ReplicationStrategy currentStrategy) {
        KeyspaceReplication initialReplication = initial.getReplication() == null ? new KeyspaceReplication() : initial.getReplication();
        KeyspaceReplication currentReplication = current.getReplication() == null ? new KeyspaceReplication() : current.getReplication();
        this.addSubProperties(stmt, initialReplication, currentReplication, "replication", version, initialStrategy, currentStrategy);
    }

    private void addSubProperties(AlterKeyspaceStatement stmt, Object initial, Object current, String rootProperty, VersionNumber version, ReplicationStrategy initialStrategy, ReplicationStrategy currentStrategy) {
        Map<String, Object> options = OptionsHelper.getAlteredOptions(initial, current, version, initialStrategy, currentStrategy, true);
        if (!options.isEmpty()) {
            MapLiteral map = CqlGrammarHelper.mapLiteral();
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                this.addMapEntry(map, entry);
            }
            CqlGrammarHelper.addProperty((List<TableProperty>)stmt.getProperties(), rootProperty, map);
        }
    }

    private void addMapEntry(MapLiteral map, Map.Entry<String, Object> entry) {
        if (entry.getKey().equals("data_center")) {
            List datacenters = (List)entry.getValue();
            for (KeyspaceReplication.DataCenter datacenter : datacenters) {
                CqlGrammarHelper.addMapEntry(map, datacenter.getName(), datacenter.getReplicationFactor());
            }
        } else {
            CqlGrammarHelper.addMapEntry(map, entry.getKey(), entry.getValue());
        }
    }
}

