/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.generators;

import com.datastax.devcenter.common.utils.BeanPropertyHelper;
import com.datastax.devcenter.cql.cql.AlterTableStatement;
import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.MapLiteral;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.cql.TableProperty;
import com.datastax.devcenter.cql.generators.DDLStatementGenerationContext;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.util.CqlGrammarHelper;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.options.CompactionStrategy;
import com.datastax.devcenter.schema.options.CompressionAlgorithm;
import com.datastax.devcenter.schema.options.OptionsHelper;
import com.datastax.devcenter.schema.options.TableCaching;
import com.datastax.devcenter.schema.options.TableCompaction;
import com.datastax.devcenter.schema.options.TableCompression;
import com.datastax.devcenter.schema.options.TableOptions;
import com.datastax.driver.core.VersionNumber;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AlterTableStatementGenerator
implements DDLStatementGenerator<Table> {
    @Override
    public Statements generate(DDLStatementGenerationContext<Table> context) {
        Table initial = context.getInitial();
        Table current = context.getCurrent();
        Statements statements = CqlFactory.eINSTANCE.createStatements();
        ArrayList<Column> initialCols = new ArrayList<Column>(initial.getColumns());
        ArrayList<AlterTableStatement> adds = new ArrayList<AlterTableStatement>();
        ArrayList<AlterTableStatement> drops = new ArrayList<AlterTableStatement>();
        ArrayList<AlterTableStatement> alters = new ArrayList<AlterTableStatement>();
        for (Column currentCol : current.getColumns()) {
            if (currentCol.getOriginalName() == null) {
                adds.add(this.addColumn(currentCol));
                continue;
            }
            Column initialCol = initial.getColumn(currentCol.getOriginalName());
            if (!initialCol.getName().equals(currentCol.getName())) {
                alters.add(this.renameColumn(initialCol, currentCol));
            }
            if (!initialCol.getType().equals(currentCol.getType())) {
                alters.add(this.alterColumnType(initialCol, currentCol));
            }
            initialCols.remove(initialCol);
        }
        for (Column initialCol : initialCols) {
            drops.add(this.dropColumn(initialCol));
        }
        statements.getStatements().addAll(drops);
        statements.getStatements().addAll(alters);
        statements.getStatements().addAll(adds);
        VersionNumber version = context.getVersionNumber();
        AlterTableStatement tableProperties = this.alterTableProperties(initial, current, version);
        if (!tableProperties.getProperties().isEmpty()) {
            statements.getStatements().add((Object)tableProperties);
        }
        return statements;
    }

    private AlterTableStatement newAlterTableStatement(Table initial) {
        AlterTableStatement stmt = CqlFactory.eINSTANCE.createAlterTableStatement();
        stmt.setTable(CqlFactory.eINSTANCE.createTableEntity());
        stmt.getTable().setName(ModelUtil.escapeName(initial.getName()));
        if (initial.getKeyspace() != null) {
            KeyspaceEntity keyspacenEntity = CqlFactory.eINSTANCE.createKeyspaceEntity();
            keyspacenEntity.setName(ModelUtil.escapeName(initial.getKeyspace().getName()));
            stmt.setKeyspace(keyspacenEntity);
        }
        return stmt;
    }

    private AlterTableStatement renameColumn(Column initialCol, Column currentCol) {
        AlterTableStatement stmt = this.newAlterTableStatement(initialCol.getTable());
        stmt.setOperation("rename");
        stmt.getOldColumns().add((Object)CqlGrammarHelper.columnEntity(initialCol));
        stmt.getNewColumns().add((Object)CqlGrammarHelper.columnEntity(currentCol));
        return stmt;
    }

    private AlterTableStatement alterColumnType(Column initialCol, Column currentCol) {
        AlterTableStatement stmt = this.newAlterTableStatement(initialCol.getTable());
        stmt.setOperation("alter");
        stmt.setColumn(CqlGrammarHelper.columnEntity(currentCol));
        stmt.setType(currentCol.getType().toGrammarType());
        return stmt;
    }

    private AlterTableStatement addColumn(Column currentCol) {
        AlterTableStatement stmt = this.newAlterTableStatement(currentCol.getTable());
        stmt.setOperation("add");
        stmt.setAddColumn(CqlGrammarHelper.columnEntity(currentCol));
        stmt.setType(currentCol.getType().toGrammarType());
        return stmt;
    }

    private AlterTableStatement dropColumn(Column initialCol) {
        AlterTableStatement stmt = this.newAlterTableStatement(initialCol.getTable());
        stmt.setOperation("drop");
        stmt.setColumn(CqlGrammarHelper.columnEntity(initialCol));
        return stmt;
    }

    private AlterTableStatement alterTableProperties(Table initial, Table current, VersionNumber version) {
        AlterTableStatement stmt = this.newAlterTableStatement(initial);
        stmt.setOperation("with");
        TableOptions initialOptions = initial.getOptions() == null ? new TableOptions() : initial.getOptions();
        TableOptions currentOptions = current.getOptions() == null ? new TableOptions() : current.getOptions();
        CompactionStrategy initialStrategy = (CompactionStrategy)BeanPropertyHelper.nullSafeGetProperty((Object)initialOptions, (String)"compaction.strategy");
        CompactionStrategy currentStrategy = (CompactionStrategy)BeanPropertyHelper.nullSafeGetProperty((Object)currentOptions, (String)"compaction.strategy");
        Map<String, Object> options = OptionsHelper.getAlteredOptions((Object)initialOptions, (Object)currentOptions, version, initialStrategy, currentStrategy, false);
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            CqlGrammarHelper.addProperty((List<TableProperty>)stmt.getProperties(), entry.getKey(), entry.getValue());
        }
        this.alterCachingProperties(stmt, initialOptions, currentOptions, version, initialStrategy, currentStrategy);
        this.alterCompressionProperties(stmt, initialOptions, currentOptions, version, initialStrategy, currentStrategy);
        this.alterCompactionProperties(stmt, initialOptions, currentOptions, version, initialStrategy, currentStrategy);
        return stmt;
    }

    private void alterCachingProperties(AlterTableStatement stmt, TableOptions initial, TableOptions current, VersionNumber version, CompactionStrategy initialStrategy, CompactionStrategy currentStrategy) {
        TableCaching currentCaching;
        TableCaching initialCaching = initial.getCaching() == null ? new TableCaching() : initial.getCaching();
        TableCaching tableCaching = currentCaching = current.getCaching() == null ? new TableCaching() : current.getCaching();
        if (version.compareTo(CqlConstants.CASSANDRA_2_1_0) >= 0) {
            Map<String, Object> options = OptionsHelper.getAlteredOptions((Object)initialCaching, (Object)currentCaching, version, initialStrategy, currentStrategy, true);
            this.addSubProperties(stmt, "caching", options);
        } else {
            Map<String, Object> options = OptionsHelper.getAlteredOptions((Object)initialCaching, (Object)currentCaching, version, initialStrategy, currentStrategy, false);
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                CqlGrammarHelper.addProperty((List<TableProperty>)stmt.getProperties(), entry.getKey(), entry.getValue());
            }
        }
    }

    private void alterCompactionProperties(AlterTableStatement stmt, TableOptions initial, TableOptions current, VersionNumber version, CompactionStrategy initialStrategy, CompactionStrategy currentStrategy) {
        TableCompaction initialCompaction = initial.getCompaction() == null ? new TableCompaction() : initial.getCompaction();
        TableCompaction currentCompaction = current.getCompaction() == null ? new TableCompaction() : current.getCompaction();
        Map<String, Object> options = OptionsHelper.getAlteredOptions((Object)initialCompaction, (Object)currentCompaction, version, initialStrategy, currentStrategy, true);
        this.addSubProperties(stmt, "compaction", options);
    }

    private void alterCompressionProperties(AlterTableStatement stmt, TableOptions initial, TableOptions current, VersionNumber version, CompactionStrategy initialStrategy, CompactionStrategy currentStrategy) {
        TableCompression initialCompression = initial.getCompression() == null ? new TableCompression() : initial.getCompression();
        TableCompression currentCompression = current.getCompression() == null ? new TableCompression() : current.getCompression();
        Map<String, Object> options = OptionsHelper.getAlteredOptions((Object)initialCompression, (Object)currentCompression, version, initialStrategy, currentStrategy, true);
        if (currentCompression.getAlgorithm() == CompressionAlgorithm.NONE) {
            if (initialCompression.getAlgorithm() != currentCompression.getAlgorithm()) {
                MapLiteral map = CqlGrammarHelper.mapLiteral();
                CqlGrammarHelper.addMapEntry(map, "sstable_compression", "");
                CqlGrammarHelper.addProperty((List<TableProperty>)stmt.getProperties(), "compression", map);
            }
        } else {
            this.addSubProperties(stmt, "compression", options);
        }
    }

    private void addSubProperties(AlterTableStatement stmt, String rootProperty, Map<String, Object> options) {
        if (!options.isEmpty()) {
            MapLiteral map = CqlGrammarHelper.mapLiteral();
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                CqlGrammarHelper.addMapEntry(map, entry.getKey(), entry.getValue());
            }
            CqlGrammarHelper.addProperty((List<TableProperty>)stmt.getProperties(), rootProperty, map);
        }
    }
}

