/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.generators;

import com.datastax.devcenter.cql.cql.AlterTypeStatement;
import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.generators.DDLStatementGenerationContext;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.util.CqlGrammarHelper;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import java.util.ArrayList;
import java.util.List;

public class AlterTypeStatementGenerator
implements DDLStatementGenerator<UserType> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statements generate(DDLStatementGenerationContext<UserType> context) {
        List<UserTypeField> currentFields;
        UserType initial = context.getInitial();
        UserType current = context.getCurrent();
        Statements statements = CqlFactory.eINSTANCE.createStatements();
        ArrayList<AlterTypeStatement> adds = new ArrayList<AlterTypeStatement>();
        ArrayList<AlterTypeStatement> alters = new ArrayList<AlterTypeStatement>();
        List<UserTypeField> list = currentFields = current.getFields();
        synchronized (list) {
            for (UserTypeField currentField : currentFields) {
                if (currentField.getOriginalName() == null) {
                    adds.add(this.addField(currentField));
                    continue;
                }
                UserTypeField initialField = initial.getField(currentField.getOriginalName());
                if (!initialField.getName().equals(currentField.getName())) {
                    alters.add(this.renameField(initialField, currentField));
                }
                if (initialField.getType().equals(currentField.getType())) continue;
                alters.add(this.alterFieldType(initialField, currentField));
            }
        }
        statements.getStatements().addAll(alters);
        statements.getStatements().addAll(adds);
        return statements;
    }

    private AlterTypeStatement newAlterTypeStatement(UserType initial) {
        AlterTypeStatement stmt = CqlFactory.eINSTANCE.createAlterTypeStatement();
        stmt.setUserType(CqlFactory.eINSTANCE.createTypeEntity());
        stmt.getUserType().setName(ModelUtil.escapeName(initial.getName()));
        if (initial.getKeyspace() != null) {
            KeyspaceEntity keyspacenEntity = CqlFactory.eINSTANCE.createKeyspaceEntity();
            keyspacenEntity.setName(ModelUtil.escapeName(initial.getKeyspace().getName()));
            stmt.setKeyspace(keyspacenEntity);
        }
        return stmt;
    }

    private AlterTypeStatement renameField(UserTypeField initialField, UserTypeField currentField) {
        AlterTypeStatement stmt = this.newAlterTypeStatement(initialField.getUserType());
        stmt.setOperation("rename");
        stmt.getOlduserTypeFields().add((Object)CqlGrammarHelper.fieldEntity(initialField));
        stmt.getNewuserTypeFields().add((Object)CqlGrammarHelper.fieldEntity(currentField));
        return stmt;
    }

    private AlterTypeStatement alterFieldType(UserTypeField initialField, UserTypeField currentField) {
        AlterTypeStatement stmt = this.newAlterTypeStatement(initialField.getUserType());
        stmt.setOperation("alter");
        stmt.setUserTypeField(CqlGrammarHelper.fieldEntity(currentField));
        stmt.setType(currentField.getType().toGrammarType());
        return stmt;
    }

    private AlterTypeStatement addField(UserTypeField currentField) {
        AlterTypeStatement stmt = this.newAlterTypeStatement(currentField.getUserType());
        stmt.setOperation("add");
        stmt.setAdduserTypeField(CqlGrammarHelper.fieldEntity(currentField));
        stmt.setType(currentField.getType().toGrammarType());
        return stmt;
    }
}

