/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.generators;

import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.CreateIndexStatement;
import com.datastax.devcenter.cql.cql.IndexColumnDef;
import com.datastax.devcenter.cql.cql.IndexEntity;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.generators.DDLStatementGenerationContext;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.util.CqlGrammarHelper;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.Index;
import com.datastax.devcenter.schema.Indices;

public class CreateIndexStatementGenerator
implements DDLStatementGenerator<Indices> {
    @Override
    public Statements generate(DDLStatementGenerationContext<Indices> context) {
        Indices initial = context.getInitial();
        Indices current = context.getCurrent();
        Statements statements = CqlFactory.eINSTANCE.createStatements();
        for (Index index : current) {
            if (initial.contains(index)) continue;
            CreateIndexStatement stmt = CqlFactory.eINSTANCE.createCreateIndexStatement();
            IndexEntity indexEntity = CqlFactory.eINSTANCE.createIndexEntity();
            String indexName = index.getName();
            if (indexName != null) {
                if (context.getVersionNumber().compareTo(CqlConstants.CASSANDRA_2_1_0) >= 0) {
                    indexName = ModelUtil.escapeName(indexName);
                }
                indexEntity.setName(indexName);
            }
            stmt.setIndex(indexEntity);
            if (current.getKeyspace() != null) {
                KeyspaceEntity keyspaceEntity = CqlFactory.eINSTANCE.createKeyspaceEntity();
                keyspaceEntity.setName(ModelUtil.escapeName(current.getKeyspace().getName()));
                stmt.setKeyspace(keyspaceEntity);
            }
            stmt.setIndexColumnDef(CreateIndexStatementGenerator.getIndexColumnDef(index.getDefinition()));
            TableEntity tableEntity = CqlFactory.eINSTANCE.createTableEntity();
            tableEntity.setName(ModelUtil.escapeName(current.getTable().getName()));
            stmt.setTable(tableEntity);
            statements.getStatements().add((Object)stmt);
        }
        return statements;
    }

    public static IndexColumnDef getIndexColumnDef(Index.IndexDefinition definition) {
        IndexColumnDef indexColumnDef = CqlFactory.eINSTANCE.createIndexColumnDef();
        indexColumnDef.setColumn(CqlGrammarHelper.columnEntity(definition.getColumn()));
        indexColumnDef.setKeys(definition.isKeys());
        indexColumnDef.setFull(definition.isFull());
        indexColumnDef.setEntries(definition.isEntries());
        return indexColumnDef;
    }
}

