/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.generators;

import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.CreateKeyspaceStatement;
import com.datastax.devcenter.cql.cql.MapLiteral;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.cql.TableProperty;
import com.datastax.devcenter.cql.generators.DDLStatementGenerationContext;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.util.CqlGrammarHelper;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.options.KeyspaceOptions;
import com.datastax.devcenter.schema.options.KeyspaceReplication;
import com.datastax.devcenter.schema.options.OptionsHelper;
import com.datastax.driver.core.VersionNumber;
import java.util.List;
import java.util.Map;

public class CreateKeyspaceStatementGenerator
implements DDLStatementGenerator<Keyspace> {
    @Override
    public Statements generate(DDLStatementGenerationContext<Keyspace> context) {
        Keyspace keyspace = context.getCurrent();
        Statements statements = CqlFactory.eINSTANCE.createStatements();
        CreateKeyspaceStatement stmt = CqlFactory.eINSTANCE.createCreateKeyspaceStatement();
        stmt.setKeyspace(CqlFactory.eINSTANCE.createKeyspaceEntity());
        stmt.getKeyspace().setName(ModelUtil.escapeName(keyspace.getName()));
        VersionNumber version = context.getVersionNumber();
        this.generateKeyspaceProperties(stmt, keyspace, version);
        statements.getStatements().add((Object)stmt);
        return statements;
    }

    private void generateKeyspaceProperties(CreateKeyspaceStatement stmt, Keyspace keyspace, VersionNumber version) {
        KeyspaceOptions options = keyspace.getOptions();
        if (options != null) {
            Map<String, Object> map = OptionsHelper.getNonNullOptions(options, version);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                CqlGrammarHelper.addProperty((List<TableProperty>)stmt.getProperties(), entry.getKey(), entry.getValue());
            }
            this.generateReplicationProperties(stmt, options, version);
        }
    }

    private void generateReplicationProperties(CreateKeyspaceStatement stmt, KeyspaceOptions options, VersionNumber version) {
        KeyspaceReplication replication = options.getReplication();
        if (replication != null && replication.getStrategy() != null) {
            this.addSubProperties(stmt, replication, "replication", version);
        }
    }

    private void addSubProperties(CreateKeyspaceStatement stmt, Object current, String rootProperty, VersionNumber version) {
        Map<String, Object> options = OptionsHelper.getNonNullOptions(current, version);
        if (!options.isEmpty()) {
            MapLiteral map = CqlGrammarHelper.mapLiteral();
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                this.addMapEntry(map, entry);
            }
            CqlGrammarHelper.addProperty((List<TableProperty>)stmt.getProperties(), rootProperty, map);
        }
    }

    private void addMapEntry(MapLiteral map, Map.Entry<String, Object> entry) {
        if (entry.getKey().equals("data_center")) {
            List datacenters = (List)entry.getValue();
            for (KeyspaceReplication.DataCenter datacenter : datacenters) {
                CqlGrammarHelper.addMapEntry(map, datacenter.getName(), datacenter.getReplicationFactor());
            }
        } else {
            CqlGrammarHelper.addMapEntry(map, entry.getKey(), entry.getValue());
        }
    }
}

