/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.generators;

import com.datastax.devcenter.cql.cql.ColumnDef;
import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.CreateTableStatement;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.MapLiteral;
import com.datastax.devcenter.cql.cql.PrimaryKeyDefinition;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.cql.TableOrdering;
import com.datastax.devcenter.cql.cql.TableProperty;
import com.datastax.devcenter.cql.generators.DDLStatementGenerationContext;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.util.CqlGrammarHelper;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.options.CompressionAlgorithm;
import com.datastax.devcenter.schema.options.OptionsHelper;
import com.datastax.devcenter.schema.options.TableCaching;
import com.datastax.devcenter.schema.options.TableCompaction;
import com.datastax.devcenter.schema.options.TableCompression;
import com.datastax.devcenter.schema.options.TableOptions;
import com.datastax.driver.core.VersionNumber;
import java.util.List;
import java.util.Map;

public class CreateTableStatementGenerator
implements DDLStatementGenerator<Table> {
    @Override
    public Statements generate(DDLStatementGenerationContext<Table> context) {
        Table table = context.getCurrent();
        Statements statements = CqlFactory.eINSTANCE.createStatements();
        CreateTableStatement stmt = CqlFactory.eINSTANCE.createCreateTableStatement();
        stmt.setTable(CqlFactory.eINSTANCE.createTableEntity());
        stmt.getTable().setName(ModelUtil.escapeName(table.getName()));
        if (table.getKeyspace() != null) {
            KeyspaceEntity keyspacenEntity = CqlFactory.eINSTANCE.createKeyspaceEntity();
            keyspacenEntity.setName(ModelUtil.escapeName(table.getKeyspace().getName()));
            stmt.setKeyspace(keyspacenEntity);
        }
        for (Column column : table.getColumns()) {
            ColumnDef columnDef = CqlGrammarHelper.columnDef(column);
            stmt.getColumnDefinitions().add((Object)columnDef);
        }
        stmt.getColumnDefinitions().add((Object)this.createPrimaryKeyColumnDef(table));
        TableProperty clusteringOrders = this.createClusteringOrders(table);
        if (!clusteringOrders.getOrderings().isEmpty()) {
            stmt.getProperties().add((Object)clusteringOrders);
        }
        if (table.isCompactStorage()) {
            TableProperty property = CqlFactory.eINSTANCE.createTableProperty();
            property.setCompactStorage(true);
            stmt.getProperties().add((Object)property);
        }
        VersionNumber version = context.getVersionNumber();
        this.generateTableProperties(stmt, table, version);
        statements.getStatements().add((Object)stmt);
        return statements;
    }

    private ColumnDef createPrimaryKeyColumnDef(Table table) {
        ColumnDef columnDef = CqlFactory.eINSTANCE.createColumnDef();
        columnDef.setPrimaryKey(true);
        PrimaryKeyDefinition pkDef = CqlFactory.eINSTANCE.createPrimaryKeyDefinition();
        if (table.getPartitionKeys().size() == 1) {
            pkDef.setGroup(false);
            pkDef.setColumn(CqlGrammarHelper.columnEntity(table.getPartitionKeys().get(0)));
        } else {
            pkDef.setGroup(true);
            for (Column column : table.getPartitionKeys()) {
                pkDef.getColumns().add((Object)CqlGrammarHelper.columnEntity(column));
            }
        }
        columnDef.getPrimaryKeyDefinitions().add((Object)pkDef);
        for (Column column : table.getClusteringKeys()) {
            PrimaryKeyDefinition clusteringKey = CqlFactory.eINSTANCE.createPrimaryKeyDefinition();
            clusteringKey.setColumn(CqlGrammarHelper.columnEntity(column));
            columnDef.getPrimaryKeyDefinitions().add((Object)clusteringKey);
        }
        return columnDef;
    }

    private void generateTableProperties(CreateTableStatement stmt, Table table, VersionNumber version) {
        TableOptions options = table.getOptions();
        if (options != null) {
            Map<String, Object> map = OptionsHelper.getNonNullOptions(options, version);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                CqlGrammarHelper.addProperty((List<TableProperty>)stmt.getProperties(), entry.getKey(), entry.getValue());
            }
            this.generateCachingProperties(stmt, options, version);
            this.generateCompressionProperties(stmt, options, version);
            this.generateCompactionProperties(stmt, options, version);
        }
    }

    private void generateCachingProperties(CreateTableStatement stmt, TableOptions options, VersionNumber version) {
        TableCaching caching = options.getCaching();
        if (caching != null) {
            if (version.compareTo(CqlConstants.CASSANDRA_2_1_0) >= 0) {
                this.addSubProperties(stmt, caching, "caching", version);
            } else {
                CqlGrammarHelper.addProperty((List<TableProperty>)stmt.getProperties(), "caching", (Object)caching.getValue());
            }
        }
    }

    private void generateCompactionProperties(CreateTableStatement stmt, TableOptions options, VersionNumber version) {
        TableCompaction compaction = options.getCompaction();
        if (compaction != null && compaction.getStrategy() != null) {
            this.addSubProperties(stmt, compaction, "compaction", version);
        }
    }

    private void generateCompressionProperties(CreateTableStatement stmt, TableOptions options, VersionNumber version) {
        TableCompression compression = options.getCompression();
        if (compression != null) {
            if (compression.getAlgorithm() == CompressionAlgorithm.NONE) {
                MapLiteral map = CqlGrammarHelper.mapLiteral();
                CqlGrammarHelper.addMapEntry(map, "sstable_compression", "");
                CqlGrammarHelper.addProperty((List<TableProperty>)stmt.getProperties(), "compression", map);
            } else {
                this.addSubProperties(stmt, compression, "compression", version);
            }
        }
    }

    private TableProperty createClusteringOrders(Table table) {
        TableProperty clustering = CqlFactory.eINSTANCE.createTableProperty();
        clustering.setClustering(true);
        if (this.shouldIncludeOrderByDirective(table)) {
            for (Column column : table.getClusteringKeys()) {
                Table.ClusteringOrder clusteringOrder = table.getClusteringOrder(column.getName());
                TableOrdering tableOrdering = CqlFactory.eINSTANCE.createTableOrdering();
                tableOrdering.setColumn(CqlGrammarHelper.columnEntity(column));
                tableOrdering.setOrder(clusteringOrder.getOrder());
                clustering.getOrderings().add((Object)tableOrdering);
            }
        }
        return clustering;
    }

    private boolean shouldIncludeOrderByDirective(Table table) {
        for (Column clustering : table.getClusteringKeys()) {
            if (clustering.getClusteringOrder() != Table.ClusteringOrder.DESC) continue;
            return true;
        }
        return false;
    }

    private void addSubProperties(CreateTableStatement stmt, Object current, String rootProperty, VersionNumber version) {
        Map<String, Object> options = OptionsHelper.getNonNullOptions(current, version);
        if (!options.isEmpty()) {
            MapLiteral map = CqlGrammarHelper.mapLiteral();
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                CqlGrammarHelper.addMapEntry(map, entry.getKey(), entry.getValue());
            }
            CqlGrammarHelper.addProperty((List<TableProperty>)stmt.getProperties(), rootProperty, map);
        }
    }
}

