/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.generators;

import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.CreateTypeStatement;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.cql.TypeFieldDef;
import com.datastax.devcenter.cql.generators.DDLStatementGenerationContext;
import com.datastax.devcenter.cql.generators.DDLStatementGenerator;
import com.datastax.devcenter.cql.util.CqlGrammarHelper;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import java.util.List;

public class CreateTypeStatementGenerator
implements DDLStatementGenerator<UserType> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statements generate(DDLStatementGenerationContext<UserType> context) {
        List<UserTypeField> fields;
        UserType userType = context.getCurrent();
        Statements statements = CqlFactory.eINSTANCE.createStatements();
        CreateTypeStatement stmt = CqlFactory.eINSTANCE.createCreateTypeStatement();
        stmt.setUserType(CqlFactory.eINSTANCE.createTypeEntity());
        stmt.getUserType().setName(ModelUtil.escapeName(userType.getName()));
        if (userType.getKeyspace() != null) {
            KeyspaceEntity keyspaceEntity = CqlFactory.eINSTANCE.createKeyspaceEntity();
            keyspaceEntity.setName(ModelUtil.escapeName(userType.getKeyspace().getName()));
            stmt.setKeyspace(keyspaceEntity);
        }
        List<UserTypeField> list = fields = userType.getFields();
        synchronized (list) {
            for (UserTypeField userTypeField : fields) {
                TypeFieldDef fieldDef = CqlGrammarHelper.fieldDef(userTypeField);
                stmt.getUserTypeFieldDefs().add((Object)fieldDef);
            }
        }
        statements.getStatements().add((Object)stmt);
        return statements;
    }
}

