/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.parser.antlr.lexer;

import com.datastax.devcenter.cql.parser.antlr.CqlAntlrTokenFileProvider;
import com.datastax.devcenter.json.parser.antlr.JsonAntlrTokenFileProvider;
import com.datastax.devcenter.json.parser.antlr.lexer.InternalJsonLexer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.RuntimeErrorException;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.eclipse.xtext.parser.antlr.AbstractSplittingTokenSource;
import org.eclipse.xtext.parser.antlr.AntlrTokenDefProvider;
import org.eclipse.xtext.parser.antlr.IAntlrTokenFileProvider;
import org.eclipse.xtext.parser.antlr.ITokenAcceptor;

public class CustomTokenSource
extends AbstractSplittingTokenSource {
    private static int MAX_SIZE = 2;
    private List<Token> previousTokens = new LinkedList<Token>();
    private boolean syntheticEndQuote;
    private static Map<Integer, String> jsonTokenDefs;
    private static Map<Integer, String> cqlTokenDefs;
    private static Map<Integer, Integer> jsonToCqlTokenMappings;

    public CustomTokenSource(TokenSource lexer) {
        this.loadJsonToCqlTokenMappings();
        this.setDelegate(lexer);
    }

    private void loadJsonToCqlTokenMappings() {
        if (jsonTokenDefs == null) {
            this.loadJsonTokenDefs();
        }
        if (cqlTokenDefs == null) {
            this.loadCqlTokenDefs();
        }
        if (jsonToCqlTokenMappings == null) {
            this.loadTokenMappings(jsonTokenDefs, cqlTokenDefs);
        }
    }

    private synchronized void loadJsonTokenDefs() {
        if (jsonTokenDefs != null) {
            return;
        }
        AntlrTokenDefProvider tokenDefProvider = this.instantiateTokenFileProvider(JsonAntlrTokenFileProvider.class);
        jsonTokenDefs = tokenDefProvider.getTokenDefMap();
    }

    private synchronized void loadCqlTokenDefs() {
        if (cqlTokenDefs != null) {
            return;
        }
        AntlrTokenDefProvider tokenDefProvider = this.instantiateTokenFileProvider(CqlAntlrTokenFileProvider.class);
        cqlTokenDefs = tokenDefProvider.getTokenDefMap();
    }

    private AntlrTokenDefProvider instantiateTokenFileProvider(Class<? extends IAntlrTokenFileProvider> providerClazz) {
        AntlrTokenDefProvider tokenDefProvider = new AntlrTokenDefProvider();
        try {
            tokenDefProvider.setAntlrTokenFileProvider(providerClazz.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unexpected Exception instantiating token file provider", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unexpected Exception instantiating token file provider", e);
        }
        return tokenDefProvider;
    }

    private synchronized void loadTokenMappings(Map<Integer, String> jsonTokenDefs, Map<Integer, String> cqlTokenDefs) {
        if (jsonToCqlTokenMappings != null) {
            return;
        }
        jsonToCqlTokenMappings = new HashMap<Integer, Integer>();
        jsonToCqlTokenMappings.put(-1, -1);
        HashMap<String, Integer> reverseCqlKeywordTokenMap = new HashMap<String, Integer>();
        for (Integer tokenID : cqlTokenDefs.keySet()) {
            reverseCqlKeywordTokenMap.put(cqlTokenDefs.get(tokenID), tokenID);
        }
        for (Integer tokenID : jsonTokenDefs.keySet()) {
            jsonToCqlTokenMappings.put(tokenID, (Integer)reverseCqlKeywordTokenMap.get(jsonTokenDefs.get(tokenID)));
        }
    }

    protected boolean shouldSplitToken(Token candidate) {
        return this.shouldProduceCustomTokens(candidate);
    }

    public boolean shouldProduceCustomTokens(Token candidate) {
        if (candidate == null || candidate.getText() == null) {
            return false;
        }
        boolean shouldSplit = false;
        if (this.isInsertJson(candidate)) {
            shouldSplit = true;
        } else if (this.isFromJsonInvocation(candidate)) {
            shouldSplit = true;
        } else if (!candidate.getText().trim().isEmpty()) {
            this.previousTokens.add(candidate);
        }
        if (shouldSplit) {
            this.previousTokens.clear();
        }
        this.maintainLookbackTokens();
        return shouldSplit;
    }

    public boolean isFromJsonInvocation(Token candidate) {
        return this.previousTokens.size() > 1 && candidate.getType() == 141 && this.previousTokens.get(this.previousTokens.size() - 1).getText().equals("(") && this.previousTokens.get(this.previousTokens.size() - 2).getText().equalsIgnoreCase("fromJson");
    }

    public boolean isInsertJson(Token candidate) {
        return this.previousTokens.size() > 0 && this.previousTokens.get(this.previousTokens.size() - 1).getText().equalsIgnoreCase("JSON") && candidate.getType() == 141;
    }

    public void maintainLookbackTokens() {
        if (this.previousTokens.size() > MAX_SIZE) {
            this.previousTokens.remove(0);
        }
    }

    protected void doSplitToken(Token split, ITokenAcceptor acceptor) {
        this.produceCustomTokens(split, acceptor);
    }

    public List<Token> produceCustomTokens(Token split, ITokenAcceptor acceptor) {
        LinkedList<Token> customTokens = new LinkedList<Token>();
        CommonToken originalToken = (CommonToken)split;
        int originalOffset = originalToken.getStartIndex();
        int lastLine = String.valueOf(originalToken.getLine()) + originalToken.getText() != null ? originalToken.getText().split("\n").length - 1 : 0;
        customTokens.add(this.generateFirstQuote(split.getChannel(), acceptor, originalToken, originalOffset));
        customTokens.addAll(this.generateTokensWithinQuotes(split, acceptor, originalToken, originalOffset));
        if (originalToken.getText().endsWith("'") && !this.syntheticEndQuote) {
            customTokens.add(this.generateLastQuote(split.getChannel(), acceptor, originalToken, lastLine));
        }
        return customTokens;
    }

    private Token generateFirstQuote(int channel, ITokenAcceptor acceptor, CommonToken originalToken, int originalOffset) {
        CommonToken token = new CommonToken(originalToken.getInputStream(), 140, channel, originalOffset, originalOffset);
        token.setLine(originalToken.getLine());
        token.setCharPositionInLine(originalToken.getCharPositionInLine());
        this.acceptToken(acceptor, (Token)token);
        return token;
    }

    private List<Token> generateTokensWithinQuotes(Token split, ITokenAcceptor acceptor, CommonToken originalToken, int originalOffset) {
        LinkedList<Token> customTokens = new LinkedList<Token>();
        if (split.getText().length() > 2) {
            String withoutQuotes = split.getText().substring(1, split.getText().length() - 1);
            ANTLRStringStream jsonStream = new ANTLRStringStream(withoutQuotes);
            InternalJsonLexer jsonLexer = new InternalJsonLexer((CharStream)jsonStream);
            CommonToken nextToken = (CommonToken)jsonLexer.nextToken();
            Integer cqlTokenType = jsonToCqlTokenMappings.get(nextToken.getType());
            if (cqlTokenType != null) {
                nextToken.setType(cqlTokenType.intValue());
            }
            try {
                while (nextToken != null && nextToken != Token.EOF_TOKEN) {
                    CommonToken adjustedToken = this.createToken(nextToken, null, null, split.getChannel(), originalOffset + nextToken.getStartIndex() + 1, originalOffset + nextToken.getStopIndex() + 1, null);
                    adjustedToken.setLine(originalToken.getLine() + nextToken.getLine() - 1);
                    this.acceptToken(acceptor, (Token)adjustedToken);
                    customTokens.add((Token)adjustedToken);
                    nextToken = (CommonToken)jsonLexer.nextToken();
                    Integer cqlType = jsonToCqlTokenMappings.get(nextToken.getType());
                    if (cqlType == null) continue;
                    nextToken.setType(cqlType.intValue());
                }
            }
            catch (Error ex) {
                throw new RuntimeErrorException(ex);
            }
        }
        return customTokens;
    }

    private Token generateLastQuote(int channel, ITokenAcceptor acceptor, CommonToken originalToken, int lastLine) {
        CommonToken finalQuote = new CommonToken(originalToken.getInputStream(), 140, channel, originalToken.getStopIndex(), originalToken.getStopIndex());
        finalQuote.setLine(lastLine);
        this.acceptToken(acceptor, (Token)finalQuote);
        return finalQuote;
    }

    private void acceptToken(ITokenAcceptor acceptor, Token token) {
        if (acceptor != null) {
            acceptor.accept(token);
        }
    }

    public void setSyntheticEndQuote(boolean b) {
        this.syntheticEndQuote = b;
    }
}

