/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.scoping;

import com.datastax.devcenter.cql.cql.ColumnDef;
import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.CreateKeyspaceStatement;
import com.datastax.devcenter.cql.cql.CreateTableStatement;
import com.datastax.devcenter.cql.cql.CreateTypeStatement;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.RulesWithColumnRef;
import com.datastax.devcenter.cql.cql.RulesWithKeyspaceRef;
import com.datastax.devcenter.cql.cql.RulesWithTableRef;
import com.datastax.devcenter.cql.cql.RulesWithTypeRef;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.TypeEntity;
import com.datastax.devcenter.cql.cql.UseStatement;
import com.datastax.devcenter.cql.util.ModelUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;

public class CqlScopeProvider
extends AbstractDeclarativeScopeProvider {
    public IScope scope_KeyspaceEntity(RulesWithKeyspaceRef ruleWithKeyspaceRef, EReference eRef) {
        ArrayList<KeyspaceEntity> elements = new ArrayList<KeyspaceEntity>();
        CqlStatement cqlStatement = ModelUtil.getCqlStatement(ruleWithKeyspaceRef);
        List<KeyspaceEntity> keyspaces = this.getCurrentKeyspaces(cqlStatement);
        elements.addAll(keyspaces);
        return Scopes.scopeFor(elements);
    }

    public IScope scope_TableEntity(RulesWithTableRef ruleWithTableRef, EReference eRef) {
        KeyspaceEntity scopedKeyspace;
        ArrayList<TableEntity> elements = new ArrayList<TableEntity>();
        CqlStatement cqlStatement = ModelUtil.getCqlStatement(ruleWithTableRef);
        Map<KeyspaceEntity, List<TableEntity>> keyspaceTableMap = this.getCurrentTables(cqlStatement);
        List<TableEntity> scopedTables = keyspaceTableMap.get(scopedKeyspace = this.getCurrentKeyspace(cqlStatement));
        if (scopedTables != null) {
            elements.addAll(scopedTables);
        }
        return Scopes.scopeFor(elements);
    }

    public IScope scope_ColumnEntity(RulesWithColumnRef ruleWithColumnRef, EReference eRef) {
        ArrayList<ColumnEntity> elements = new ArrayList<ColumnEntity>();
        CqlStatement cqlStmt = ModelUtil.getCqlStatement(ruleWithColumnRef);
        CreateTableStatement createTableStatement = null;
        if (cqlStmt instanceof RulesWithTableRef) {
            RulesWithTableRef ruleWithTableRef = (RulesWithTableRef)((Object)cqlStmt);
            TableEntity tableEntity = ruleWithTableRef.getTable();
            if (tableEntity != null) {
                createTableStatement = (CreateTableStatement)tableEntity.eContainer();
            }
        } else if (cqlStmt instanceof CreateTableStatement) {
            createTableStatement = (CreateTableStatement)cqlStmt;
        } else {
            System.err.println("Rule " + ruleWithColumnRef + " has parent " + cqlStmt + " but does not have a Table Reference!");
        }
        if (createTableStatement != null) {
            for (ColumnDef c : createTableStatement.getColumnDefinitions()) {
                if (c.getColumn() == null) continue;
                elements.add(c.getColumn());
            }
        }
        return Scopes.scopeFor(elements);
    }

    public IScope scope_TypeEntity(RulesWithTypeRef ruleWithTypeRef, EReference eRef) {
        KeyspaceEntity scopedKeyspace;
        ArrayList<TypeEntity> elements = new ArrayList<TypeEntity>();
        CqlStatement cqlStatement = ModelUtil.getCqlStatement(ruleWithTypeRef);
        Map<KeyspaceEntity, List<TypeEntity>> keyspaceUserTypeMap = this.getCurrentUserTypes(cqlStatement);
        List<TypeEntity> scopedTypes = keyspaceUserTypeMap.get(scopedKeyspace = this.getCurrentKeyspace(cqlStatement));
        if (scopedTypes != null) {
            elements.addAll(scopedTypes);
        }
        return Scopes.scopeFor(elements);
    }

    private List<KeyspaceEntity> getCurrentKeyspaces(CqlStatement currentCqlStatement) {
        ArrayList<KeyspaceEntity> keyspaceList = new ArrayList<KeyspaceEntity>();
        Statements statements = (Statements)currentCqlStatement.eContainer();
        for (CqlStatement stmt : statements.getStatements()) {
            if (stmt instanceof CreateKeyspaceStatement) {
                KeyspaceEntity keyspace = ((CreateKeyspaceStatement)stmt).getKeyspace();
                if (keyspace == null) {
                    System.err.println("Can't find keyspace for " + currentCqlStatement);
                    continue;
                }
                this.addOrReplaceKeyspace(keyspaceList, keyspace);
            }
            if (stmt == currentCqlStatement) break;
        }
        return keyspaceList;
    }

    private void addOrReplaceKeyspace(List<KeyspaceEntity> keyspaces, KeyspaceEntity keyspace) {
        Iterator<KeyspaceEntity> it = keyspaces.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(keyspace.getName())) continue;
            it.remove();
        }
        keyspaces.add(keyspace);
    }

    private Map<KeyspaceEntity, List<TableEntity>> getCurrentTables(CqlStatement currentCqlStatement) {
        HashMap<KeyspaceEntity, List<TableEntity>> keyspaceTableMap = new HashMap<KeyspaceEntity, List<TableEntity>>();
        Statements statements = (Statements)currentCqlStatement.eContainer();
        for (CqlStatement stmt : statements.getStatements()) {
            if (stmt instanceof CreateTableStatement) {
                KeyspaceEntity keyspace = ((CreateTableStatement)stmt).getKeyspace();
                if (keyspace == null) {
                    keyspace = this.getCurrentKeyspace(stmt);
                }
                if (keyspace == null) {
                    System.err.println("Can't find keyspace for " + currentCqlStatement);
                    continue;
                }
                ArrayList<TableEntity> tables = (ArrayList<TableEntity>)keyspaceTableMap.get(keyspace);
                if (tables == null) {
                    tables = new ArrayList<TableEntity>();
                    keyspaceTableMap.put(keyspace, tables);
                }
                TableEntity table = ((CreateTableStatement)stmt).getTable();
                this.addOrReplaceTable(tables, table);
            }
            if (stmt == currentCqlStatement) break;
        }
        return keyspaceTableMap;
    }

    private void addOrReplaceTable(List<TableEntity> tables, TableEntity table) {
        Iterator<TableEntity> it = tables.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(table.getName())) continue;
            it.remove();
        }
        tables.add(table);
    }

    private Map<KeyspaceEntity, List<TypeEntity>> getCurrentUserTypes(CqlStatement currentCqlStatement) {
        HashMap<KeyspaceEntity, List<TypeEntity>> keyspaceTableMap = new HashMap<KeyspaceEntity, List<TypeEntity>>();
        Statements statements = (Statements)currentCqlStatement.eContainer();
        for (CqlStatement stmt : statements.getStatements()) {
            if (stmt instanceof CreateTypeStatement) {
                KeyspaceEntity keyspace = ((CreateTypeStatement)stmt).getKeyspace();
                if (keyspace == null) {
                    keyspace = this.getCurrentKeyspace(stmt);
                }
                if (keyspace == null) {
                    System.err.println("Can't find keyspace for " + currentCqlStatement);
                    continue;
                }
                ArrayList<TypeEntity> types = (ArrayList<TypeEntity>)keyspaceTableMap.get(keyspace);
                if (types == null) {
                    types = new ArrayList<TypeEntity>();
                    keyspaceTableMap.put(keyspace, types);
                }
                TypeEntity type = ((CreateTypeStatement)stmt).getUserType();
                this.addOrReplaceUserType(types, type);
            }
            if (stmt == currentCqlStatement) break;
        }
        return keyspaceTableMap;
    }

    private void addOrReplaceUserType(List<TypeEntity> types, TypeEntity type) {
        Iterator<TypeEntity> it = types.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(type.getName())) continue;
            it.remove();
        }
        types.add(type);
    }

    private KeyspaceEntity getCurrentKeyspace(CqlStatement currentCqlStatement) {
        KeyspaceEntity keyspace = null;
        if (currentCqlStatement instanceof RulesWithKeyspaceRef && (keyspace = ((RulesWithKeyspaceRef)((Object)currentCqlStatement)).getKeyspace()) != null) {
            return keyspace;
        }
        Statements stmts = (Statements)currentCqlStatement.eContainer();
        for (CqlStatement stmt : stmts.getStatements()) {
            if (stmt instanceof UseStatement) {
                keyspace = ((RulesWithKeyspaceRef)((Object)stmt)).getKeyspace();
            }
            if (stmt == currentCqlStatement) break;
        }
        return keyspace;
    }
}

