/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.util;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.cql.cql.AlterRoleStatement;
import com.datastax.devcenter.cql.cql.AlterTableStatement;
import com.datastax.devcenter.cql.cql.AlterTypeStatement;
import com.datastax.devcenter.cql.cql.AlterUserStatement;
import com.datastax.devcenter.cql.cql.ColumnDef;
import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.CreateAggregateFunctionStatement;
import com.datastax.devcenter.cql.cql.CreateFunctionStatement;
import com.datastax.devcenter.cql.cql.CreateIndexStatement;
import com.datastax.devcenter.cql.cql.CreateKeyspaceStatement;
import com.datastax.devcenter.cql.cql.CreateRoleStatement;
import com.datastax.devcenter.cql.cql.CreateTableStatement;
import com.datastax.devcenter.cql.cql.CreateTriggerStatement;
import com.datastax.devcenter.cql.cql.CreateTypeStatement;
import com.datastax.devcenter.cql.cql.CreateUserStatement;
import com.datastax.devcenter.cql.cql.DropFunctionStatement;
import com.datastax.devcenter.cql.cql.DropIndexStatement;
import com.datastax.devcenter.cql.cql.DropKeyspaceStatement;
import com.datastax.devcenter.cql.cql.DropRoleStatement;
import com.datastax.devcenter.cql.cql.DropTableStatement;
import com.datastax.devcenter.cql.cql.DropTriggerStatement;
import com.datastax.devcenter.cql.cql.DropTypeStatement;
import com.datastax.devcenter.cql.cql.DropUserStatement;
import com.datastax.devcenter.cql.cql.FieldEntity;
import com.datastax.devcenter.cql.cql.FunctionParameter;
import com.datastax.devcenter.cql.cql.GrantStatement;
import com.datastax.devcenter.cql.cql.IndexColumnDef;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.MapEntry;
import com.datastax.devcenter.cql.cql.PrimaryKeyDefinition;
import com.datastax.devcenter.cql.cql.Property;
import com.datastax.devcenter.cql.cql.RevokeStatement;
import com.datastax.devcenter.cql.cql.RoleOption;
import com.datastax.devcenter.cql.cql.Statements;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.TableOrdering;
import com.datastax.devcenter.cql.cql.TableProperty;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.TypeEntity;
import com.datastax.devcenter.cql.cql.TypeFieldDef;
import com.datastax.devcenter.cql.cql.UseStatement;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.FunctionUtil;
import com.datastax.devcenter.cql.validation.assignment.Assignment;
import com.datastax.devcenter.schema.BuiltInFunctionsRegistry;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Index;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.Trigger;
import com.datastax.devcenter.schema.User;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.options.Caching;
import com.datastax.devcenter.schema.options.CompressionAlgorithm;
import com.datastax.devcenter.schema.options.KeyspaceReplication;
import com.datastax.devcenter.schema.options.OptionsHelper;
import com.datastax.devcenter.schema.options.ReplicationStrategy;
import com.datastax.devcenter.schema.options.TableCaching;
import com.datastax.devcenter.schema.options.TableCompaction;
import com.datastax.devcenter.schema.options.TableCompression;
import com.datastax.devcenter.schema.options.TableOptions;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CqlDataTypeFactory;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;

public class ChangeSchema {
    public static void of(Statements stmts, Schema schema) {
        EList<CqlStatement> cqlStatements = stmts.getStatements();
        int i = 0;
        while (i < cqlStatements.size()) {
            ChangeSchema.of((CqlStatement)cqlStatements.get(i), schema, i);
            ++i;
        }
    }

    public static void of(CqlStatement stmt, Schema schema, int statementIndex) {
        if (stmt instanceof CreateKeyspaceStatement) {
            ChangeSchema.of((CreateKeyspaceStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof DropKeyspaceStatement) {
            ChangeSchema.of((DropKeyspaceStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof CreateTableStatement) {
            ChangeSchema.of((CreateTableStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof AlterTableStatement) {
            ChangeSchema.of((AlterTableStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof DropTableStatement) {
            ChangeSchema.of((DropTableStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof CreateTypeStatement) {
            ChangeSchema.of((CreateTypeStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof AlterTypeStatement) {
            ChangeSchema.of((AlterTypeStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof DropTypeStatement) {
            ChangeSchema.of((DropTypeStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof CreateIndexStatement) {
            ChangeSchema.of((CreateIndexStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof DropIndexStatement) {
            ChangeSchema.of((DropIndexStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof UseStatement) {
            ChangeSchema.of((UseStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof CreateUserStatement) {
            ChangeSchema.of((CreateUserStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof AlterUserStatement) {
            ChangeSchema.of((AlterUserStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof DropUserStatement) {
            ChangeSchema.of((DropUserStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof CreateRoleStatement) {
            ChangeSchema.of((CreateRoleStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof AlterRoleStatement) {
            ChangeSchema.of((AlterRoleStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof DropRoleStatement) {
            ChangeSchema.of((DropRoleStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof GrantStatement) {
            ChangeSchema.of((GrantStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof RevokeStatement) {
            ChangeSchema.of((RevokeStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof CreateTriggerStatement) {
            ChangeSchema.of((CreateTriggerStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof DropTriggerStatement) {
            ChangeSchema.of((DropTriggerStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof CreateFunctionStatement) {
            ChangeSchema.of((CreateFunctionStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof CreateAggregateFunctionStatement) {
            ChangeSchema.of((CreateAggregateFunctionStatement)stmt, schema, statementIndex);
        } else if (stmt instanceof DropFunctionStatement) {
            ChangeSchema.of((DropFunctionStatement)stmt, schema, statementIndex);
        }
    }

    public static void of(CreateKeyspaceStatement stmt, Schema schema, int statementIndex) {
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace(stmt);
        if (keyspaceEntity != null) {
            Keyspace keyspace = new Keyspace(ModelUtil.stripName(keyspaceEntity.getName()), statementIndex);
            schema.addKeyspace(keyspace, stmt.isIfNotExists());
            for (TableProperty keyspaceProperty : stmt.getProperties()) {
                if (!(keyspaceProperty instanceof Property)) continue;
                Property property = (Property)keyspaceProperty;
                String name = property.getName();
                if (name.equalsIgnoreCase("replication")) {
                    keyspace.getOptions().setReplication(ChangeSchema.createReplicationProperties(property));
                    continue;
                }
                String value = property.getPropertyValue().getValue();
                try {
                    OptionsHelper.setOptionValue(keyspace.getOptions(), ModelUtil.stripName(name), ModelUtil.stripName(value));
                }
                catch (Exception e) {
                    String msg = String.format("Error decoding '%s'='%s': %s", name, value, e.toString());
                    DevCenterLogger.error((String)msg, (String)ChangeSchema.class.getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                }
            }
        }
    }

    private static KeyspaceReplication createReplicationProperties(Property property) {
        KeyspaceReplication replication = new KeyspaceReplication();
        EList<MapEntry> entries = property.getPropertyMap().getEntries();
        for (MapEntry entry : entries) {
            String key = ModelUtil.stripName(entry.getKey().getValue().getConstant().getValue());
            String value = ModelUtil.stripName(entry.getValue().getValue().getConstant().getValue());
            try {
                if ("class".equalsIgnoreCase(key)) {
                    replication.setStrategy(ReplicationStrategy.lookup(value));
                    continue;
                }
                if ("replication_factor".equalsIgnoreCase(key)) {
                    replication.setReplicationFactor(Integer.valueOf(value));
                    continue;
                }
                KeyspaceReplication.DataCenter datacenter = new KeyspaceReplication.DataCenter(key, Integer.valueOf(value));
                replication.addDataCenter(datacenter);
            }
            catch (Exception e) {
                String msg = String.format("Error decoding '%s'='%s': %s", key, value, e.toString());
                DevCenterLogger.error((String)msg, (String)ChangeSchema.class.getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
            }
        }
        return replication;
    }

    public static void of(DropKeyspaceStatement stmt, Schema schema, int statementIndex) {
        String ksField;
        String string = ksField = stmt.getKeyspace() == null ? null : stmt.getKeyspace().getName();
        if (ksField != null) {
            schema.removeKeyspace(ModelUtil.stripName(ksField));
        }
    }

    public static void of(CreateTableStatement stmt, Schema schema, int statementIndex) {
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace(stmt);
        Keyspace ksMeta = schema.getKeyspace(keyspaceEntity);
        if (ksMeta != null) {
            TableEntity tableEntity = ModelUtil.getTable(stmt);
            Table cfMeta = new Table(ModelUtil.stripName(tableEntity.getName()));
            cfMeta.setStatementIndex(statementIndex);
            ksMeta.addTable(cfMeta);
            for (ColumnDef columnDef : stmt.getColumnDefinitions()) {
                Column colMeta;
                ColumnEntity columnEntity = columnDef.getColumn();
                if (columnEntity != null) {
                    colMeta = new Column(ModelUtil.stripName(columnEntity.getName()), CqlDataTypeFactory.fromGrammarType(columnDef.getType(), ksMeta));
                    colMeta.setStatic(columnDef.isStaticColumn());
                    colMeta.setStatementIndex(statementIndex);
                    cfMeta.addColumn(colMeta);
                }
                if (!columnDef.isPrimaryKey()) continue;
                if (columnEntity != null) {
                    colMeta = cfMeta.getColumn(ModelUtil.stripName(columnEntity.getName()));
                    cfMeta.addPartitionKey(colMeta);
                }
                if (columnDef.getPrimaryKeyDefinitions() == null) continue;
                int i = 0;
                for (PrimaryKeyDefinition pkdef : columnDef.getPrimaryKeyDefinitions()) {
                    Column colMeta2;
                    if (i == 0) {
                        if (pkdef.getColumn() != null) {
                            colMeta2 = cfMeta.getColumn(ModelUtil.stripName(pkdef.getColumn().getName()));
                            cfMeta.addPartitionKey(colMeta2);
                        } else if (pkdef.getColumns() != null) {
                            for (ColumnEntity tCol : pkdef.getColumns()) {
                                Column colMeta3 = cfMeta.getColumn(ModelUtil.stripName(tCol.getName()));
                                cfMeta.addPartitionKey(colMeta3);
                            }
                        }
                    } else {
                        colMeta2 = cfMeta.getColumn(ModelUtil.stripName(pkdef.getColumn().getName()));
                        cfMeta.addClusteringKey(colMeta2);
                    }
                    ++i;
                }
            }
            for (TableProperty tableProperty : stmt.getProperties()) {
                String name;
                if (tableProperty.isCompactStorage()) {
                    cfMeta.setCompactStorage(true);
                }
                if (tableProperty.isClustering() && tableProperty.getOrderings() != null) {
                    for (TableOrdering order : tableProperty.getOrderings()) {
                        if (order.getColumn() == null) continue;
                        String clusteringOrderByName = ModelUtil.stripName(order.getColumn().getName());
                        if (order.getOrder().equalsIgnoreCase("ASC")) {
                            cfMeta.addClusteringOrder(clusteringOrderByName, Table.ClusteringOrder.ASC);
                            continue;
                        }
                        if (!order.getOrder().equalsIgnoreCase("DESC")) continue;
                        cfMeta.addClusteringOrder(clusteringOrderByName, Table.ClusteringOrder.DESC);
                    }
                }
                if (!(tableProperty instanceof Property)) continue;
                Property property = (Property)tableProperty;
                if (cfMeta.getOptions() == null) {
                    cfMeta.setOptions(new TableOptions());
                }
                if ((name = property.getName()).equalsIgnoreCase("caching")) {
                    cfMeta.getOptions().setCaching(ChangeSchema.createCachingProperties(property));
                    continue;
                }
                if (name.equalsIgnoreCase("compaction")) {
                    cfMeta.getOptions().setCompaction(ChangeSchema.createCompactionProperties(property));
                    continue;
                }
                if (name.equalsIgnoreCase("compression")) {
                    cfMeta.getOptions().setCompression(ChangeSchema.createCompressionProperties(property));
                    continue;
                }
                String value = property.getPropertyValue().getValue();
                try {
                    OptionsHelper.setOptionValue(cfMeta.getOptions(), ModelUtil.stripName(name), ModelUtil.stripName(value));
                }
                catch (Exception e) {
                    String msg = String.format("Error decoding '%s'='%s': %s", name, value, e.toString());
                    DevCenterLogger.error((String)msg, (String)ChangeSchema.class.getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                }
            }
        }
    }

    private static TableCompression createCompressionProperties(Property property) {
        TableCompression compression = new TableCompression();
        EList<MapEntry> entries = property.getPropertyMap().getEntries();
        ChangeSchema.decodeMapEntries(compression, entries);
        if (compression.getAlgorithm() == null) {
            compression.setAlgorithm(CompressionAlgorithm.NONE);
        }
        return compression;
    }

    private static TableCompaction createCompactionProperties(Property property) {
        TableCompaction compaction = new TableCompaction();
        EList<MapEntry> entries = property.getPropertyMap().getEntries();
        ChangeSchema.decodeMapEntries(compaction, entries);
        return compaction;
    }

    private static TableCaching createCachingProperties(Property property) {
        TableCaching caching = new TableCaching();
        if (property.getPropertyValue() != null) {
            String value = ModelUtil.stripName(property.getPropertyValue().getValue());
            try {
                caching.setValue(Caching.lookup(value));
            }
            catch (Exception e) {
                String msg = String.format("Error decoding '%s': %s", value, e.toString());
                DevCenterLogger.error((String)msg, (String)ChangeSchema.class.getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
            }
        } else if (property.getPropertyMap() != null) {
            ChangeSchema.decodeMapEntries(caching, property.getPropertyMap().getEntries());
        }
        return caching;
    }

    private static void decodeMapEntries(Object bean, List<MapEntry> entries) {
        for (MapEntry entry : entries) {
            String key = ModelUtil.stripName(entry.getKey().getValue().getConstant().getValue());
            String value = ModelUtil.stripName(entry.getValue().getValue().getConstant().getValue());
            try {
                OptionsHelper.setOptionValue(bean, key, value);
            }
            catch (Exception e) {
                String msg = String.format("Error decoding '%s'='%s': %s", key, value, e.toString());
                DevCenterLogger.error((String)msg, (String)ChangeSchema.class.getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
            }
        }
    }

    public static void of(AlterTableStatement stmt, Schema schema, int statementIndex) {
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace(stmt);
        Keyspace ksMeta = schema.getKeyspace(keyspaceEntity);
        Table cfMeta = schema.getTable(keyspaceEntity, stmt.getTable());
        if (cfMeta != null) {
            String op = stmt.getOperation().toLowerCase();
            CqlDataType targetDataType = CqlDataTypeFactory.fromGrammarType(stmt.getType(), ksMeta);
            if (op.equals("alter")) {
                Column colMeta = cfMeta.getColumn(ModelUtil.stripName(stmt.getColumn().getName()));
                if (colMeta != null && targetDataType != null && targetDataType.isCompatibleWith(colMeta.getType())) {
                    colMeta.setType(targetDataType);
                    colMeta.setStatementIndex(statementIndex);
                }
            } else if (op.equals("add")) {
                String addColumnName = stmt.getAddColumn().getName();
                if (!StringUtils.isEmpty((String)addColumnName)) {
                    Column colMeta = new Column(ModelUtil.stripName(addColumnName), targetDataType);
                    colMeta.setStatementIndex(statementIndex);
                    cfMeta.addColumn(colMeta);
                }
            } else if (op.equals("drop")) {
                cfMeta.removeColumn(ModelUtil.stripName(stmt.getColumn().getName()));
            } else if (op.equals("rename")) {
                int numOldColumn = stmt.getOldColumns().size();
                int numNewColumn = stmt.getNewColumns().size();
                int goThrough = Math.min(numOldColumn, numNewColumn);
                int i = 0;
                while (i < goThrough) {
                    String oldColumnName = ModelUtil.stripName(((ColumnEntity)stmt.getOldColumns().get(i)).getName());
                    String newColumnName = ModelUtil.stripName(((ColumnEntity)stmt.getNewColumns().get(i)).getName());
                    if (oldColumnName != null && newColumnName != null) {
                        cfMeta.renameColumn(oldColumnName, newColumnName, statementIndex);
                    }
                    ++i;
                }
            }
        }
    }

    public static void of(DropTableStatement stmt, Schema schema, int statementIndex) {
        Keyspace ksMeta = schema.getKeyspace(stmt.getKeyspace());
        if (ksMeta != null) {
            ksMeta.removeTable(ModelUtil.stripName(stmt.getTable().getName()));
        }
    }

    public static void of(CreateTypeStatement stmt, Schema schema, int statementIndex) {
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace(stmt);
        Keyspace ksMeta = schema.getKeyspace(keyspaceEntity);
        if (ksMeta != null) {
            TypeEntity typeEntity = ModelUtil.getUserType(stmt);
            UserType userTypefMeta = new UserType(ModelUtil.stripName(typeEntity.getName()));
            userTypefMeta.setStatementIndex(statementIndex);
            ksMeta.addUserType(userTypefMeta);
            for (TypeFieldDef typeColumnDef : stmt.getUserTypeFieldDefs()) {
                FieldEntity fieldEntity = typeColumnDef.getUserTypeField();
                if (fieldEntity == null) continue;
                UserTypeField colMeta = new UserTypeField(ModelUtil.stripName(fieldEntity.getName()), CqlDataTypeFactory.fromGrammarType(typeColumnDef.getType(), ksMeta));
                colMeta.setStatementIndex(statementIndex);
                userTypefMeta.addField(colMeta);
            }
        }
    }

    public static void of(CreateFunctionStatement stmt, Schema lastSchema, int statementIndex) {
        KeyspaceEntity keyspaceEntity;
        Keyspace ksMeta;
        if (stmt != null && (ksMeta = lastSchema.getKeyspace(keyspaceEntity = stmt.getFunction() != null ? stmt.getFunction().getKeyspace() : null)) != null) {
            CqlDataType returnType = CqlDataTypeFactory.fromGrammarType(stmt.getReturnType(), ksMeta);
            SchemaFunction function = new SchemaFunction(ModelUtil.stripName(stmt.getFunction().getName()), statementIndex).returnType(returnType);
            for (FunctionParameter functionParameter : stmt.getFunctionParameters()) {
                function.addFunctionParameter(ModelUtil.stripName(functionParameter.getName()), CqlDataTypeFactory.fromGrammarType(functionParameter.getType(), ksMeta));
            }
            ksMeta.addFunction(function);
        }
    }

    public static void of(CreateAggregateFunctionStatement stmt, Schema lastSchema, int statementIndex) {
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace(stmt);
        Keyspace ksMeta = lastSchema.getKeyspace(keyspaceEntity);
        if (ksMeta != null) {
            CqlDataType returnType = null;
            String finalFunctionName = stmt.getFinalFunction() != null ? stmt.getFinalFunction().getName() : null;
            returnType = finalFunctionName != null ? ChangeSchema.findFinalFunctionReturnType(ksMeta, finalFunctionName) : ChangeSchema.findScalarFunctionStateValueType(ksMeta, stmt.getStateFunction().getName());
            if (returnType != null) {
                SchemaFunction function = new SchemaFunction(ModelUtil.stripName(stmt.getFunction().getName()), statementIndex).returnType(returnType).aggregate(true).containingStatementTypeRestriction(CqlPackage.Literals.SELECTOR_FUNCTION);
                int index = 0;
                while (index < stmt.getFunctionParameterTypes().size()) {
                    function.addFunctionParameter("p" + (index + 1), CqlDataTypeFactory.fromGrammarType((Type)stmt.getFunctionParameterTypes().get(0), ksMeta));
                    ++index;
                }
                ksMeta.addFunction(function);
            }
        }
    }

    public static void of(DropFunctionStatement stmt, Schema lastSchema, int statementIndex) {
        SchemaFunction matchingFunction;
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace(stmt);
        Keyspace ksMeta = lastSchema.getKeyspace(keyspaceEntity);
        List<Assignment> signature = FunctionUtil.createAssignmentsFromTypes(stmt.getTypes(), ksMeta);
        List<SchemaFunction> matchingFunctions = null;
        matchingFunctions = stmt.getTypes() != null && stmt.getTypes().size() > 0 ? FunctionUtil.findMatchingFunctions(stmt.getFunction(), signature, lastSchema, true) : FunctionUtil.findFunctionsByName(stmt.getFunction(), lastSchema);
        if (matchingFunctions.size() == 1 && (matchingFunction = matchingFunctions.get(0)).isAggregate() == stmt.isAggregate()) {
            ksMeta.removeFunction(matchingFunction);
        }
    }

    private static CqlDataType findScalarFunctionStateValueType(Keyspace ksMeta, String stateFunction) {
        SchemaFunction function = ChangeSchema.findFunctionInCollection(stateFunction, ksMeta.getFunctions());
        if (function == null) {
            function = ChangeSchema.findFunctionInCollection(stateFunction, BuiltInFunctionsRegistry.getBuiltInFunctions());
        }
        CqlDataType stateCqlDataType = null;
        if (function != null && function.getFunctionParameters() != null && function.getFunctionParameters().size() > 0) {
            stateCqlDataType = function.getFunctionParameters().get(0).getType();
        }
        return stateCqlDataType;
    }

    private static CqlDataType findFinalFunctionReturnType(Keyspace ksMeta, String finalFunctionName) {
        SchemaFunction function = ChangeSchema.findFunctionInCollection(finalFunctionName, ksMeta.getFunctions());
        if (function == null) {
            function = ChangeSchema.findFunctionInCollection(finalFunctionName, BuiltInFunctionsRegistry.getBuiltInFunctions());
        }
        if (function != null) {
            return function.getReturnType();
        }
        return null;
    }

    private static SchemaFunction findFunctionInCollection(String functionName, Collection<SchemaFunction> functions) {
        SchemaFunction function = null;
        for (SchemaFunction f : functions) {
            if (!f.getName().equalsIgnoreCase(functionName)) continue;
            function = f;
            break;
        }
        return function;
    }

    public static void of(AlterTypeStatement stmt, Schema schema, int statementIndex) {
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace(stmt);
        Keyspace ksMeta = schema.getKeyspace(keyspaceEntity);
        UserType userTypeMeta = schema.getUserType(keyspaceEntity, stmt.getUserType());
        if (userTypeMeta != null) {
            String op = stmt.getOperation().toLowerCase();
            CqlDataType targetDataType = CqlDataTypeFactory.fromGrammarType(stmt.getType(), ksMeta);
            if (op.equals("alter")) {
                UserTypeField userTypeFieldMeta = userTypeMeta.getField(ModelUtil.stripName(stmt.getUserTypeField().getName()));
                if (userTypeFieldMeta != null && targetDataType != null && targetDataType.isCompatibleWith(userTypeFieldMeta.getType())) {
                    userTypeFieldMeta.setType(targetDataType);
                    userTypeFieldMeta.setStatementIndex(statementIndex);
                }
            } else if (op.equals("add")) {
                UserTypeField userTypeColumnMeta = new UserTypeField(ModelUtil.stripName(stmt.getAdduserTypeField().getName()), targetDataType);
                userTypeColumnMeta.setStatementIndex(statementIndex);
                userTypeMeta.addField(userTypeColumnMeta);
            } else if (op.equals("rename")) {
                int numOldFields = stmt.getOlduserTypeFields().size();
                int numNewFields = stmt.getNewuserTypeFields().size();
                int goThrough = Math.min(numOldFields, numNewFields);
                int i = 0;
                while (i < goThrough) {
                    String oldFieldName = ModelUtil.stripName(((FieldEntity)stmt.getOlduserTypeFields().get(i)).getName());
                    String newFieldName = ModelUtil.stripName(((FieldEntity)stmt.getNewuserTypeFields().get(i)).getName());
                    if (oldFieldName != null && newFieldName != null) {
                        userTypeMeta.renameField(oldFieldName, newFieldName, statementIndex);
                    }
                    ++i;
                }
            }
        }
    }

    public static void of(DropTypeStatement stmt, Schema schema, int statementIndex) {
        Keyspace ksMeta = schema.getKeyspace(stmt.getKeyspace());
        String userTypeName = stmt.getUserType().getName();
        if (ksMeta != null && !ChangeSchema.isTypeStillReferenced(ksMeta, userTypeName)) {
            ksMeta.removeUserType(ModelUtil.stripName(userTypeName));
        }
    }

    private static boolean isTypeStillReferenced(Keyspace keyspaceMeta, String userTypeName) {
        UserType droppedUserTypeMeta = keyspaceMeta.getUserType(userTypeName);
        if (droppedUserTypeMeta != null) {
            for (UserType userType : keyspaceMeta.getUserTypes()) {
                for (UserTypeField typeField : userType.getFields()) {
                    CqlDataType fieldCqlDataType = typeField.getType();
                    if (fieldCqlDataType == null || !fieldCqlDataType.isReachableFrom(droppedUserTypeMeta)) continue;
                    return true;
                }
            }
            for (Table table : keyspaceMeta.getTables()) {
                for (Column column : table.getColumns()) {
                    CqlDataType colCqlDataType = column.getType();
                    if (colCqlDataType == null || !colCqlDataType.isReachableFrom(droppedUserTypeMeta)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void of(CreateIndexStatement stmt, Schema schema, int statementIndex) {
        Table cfMeta;
        Index indexMeta = null;
        indexMeta = stmt.getIndex() != null ? new Index(ModelUtil.stripName(stmt.getIndex().getName()), statementIndex) : new Index(String.valueOf(ModelUtil.stripName(stmt.getTable().getName())) + "_" + ModelUtil.stripName(stmt.getIndexColumnDef().getColumn().getName()) + "_idx", statementIndex);
        indexMeta.setCustomClassName(stmt.getIndexClass());
        IndexColumnDef indexColumnDef = stmt.getIndexColumnDef();
        if (indexColumnDef != null) {
            indexMeta.setFull(indexColumnDef.isFull());
            indexMeta.setKeys(indexColumnDef.isKeys());
            indexMeta.setEntries(indexColumnDef.isEntries());
        }
        if ((cfMeta = schema.getTable(stmt.getKeyspace(), stmt.getTable())) == null) {
            return;
        }
        String columnField = ModelUtil.stripName(stmt.getIndexColumnDef().getColumn().getName());
        if (columnField == null) {
            return;
        }
        Column columnMeta = cfMeta.getColumn(columnField);
        if (columnMeta == null) {
            return;
        }
        columnMeta.setIndex(indexMeta);
        indexMeta.setColumn(columnMeta);
        schema.addIndex(indexMeta);
    }

    public static void of(DropIndexStatement stmt, Schema schema, int statementIndex) {
        schema.removeIndex(ModelUtil.stripName(stmt.getIndex().getName()));
    }

    public static void of(CreateTriggerStatement stmt, Schema schema, int statementIndex) {
        if (stmt.getTrigger() == null || stmt.getTable() == null || stmt.getTriggerClass() == null) {
            return;
        }
        Trigger triggerMeta = new Trigger(ModelUtil.stripName(stmt.getTrigger().getName()), statementIndex);
        triggerMeta.setTriggerClassName(stmt.getTriggerClass());
        Table cfMeta = schema.getTable(stmt.getKeyspace(), stmt.getTable());
        if (cfMeta == null) {
            return;
        }
        triggerMeta.setTable(cfMeta);
        schema.addTrigger(triggerMeta);
    }

    public static void of(DropTriggerStatement stmt, Schema schema, int statementIndex) {
        schema.removeTrigger(ModelUtil.stripName(stmt.getTrigger().getName()));
    }

    public static void of(UseStatement stmt, Schema schema, int statementIndex) {
        schema.setCurrentKeyspaceName(ModelUtil.stripName(stmt.getKeyspace().getName()));
    }

    public static void of(CreateUserStatement stmt, Schema schema, int statementIndex) {
        String userName;
        if (stmt.getUser() != null && !StringUtils.isEmpty((String)(userName = ModelUtil.stripName(stmt.getUser().getName())))) {
            User newUser = new User(userName.toLowerCase(), statementIndex);
            newUser.setCanLogin(true);
            newUser.setSuperuser(stmt.isSuperuser());
            schema.addUser(newUser, stmt.isIfNotExists());
        }
    }

    public static void of(AlterUserStatement stmt, Schema schema, int statementIndex) {
        User user;
        String userName;
        if (stmt.getUser() != null && !StringUtils.isEmpty((String)(userName = ModelUtil.stripName(stmt.getUser().getName()))) && (user = schema.getUser(userName)) != null) {
            user.setSuperuser(stmt.isSuperuser());
            user.setStatementIndex(statementIndex);
        }
    }

    public static void of(DropUserStatement stmt, Schema schema, int statementIndex) {
        String userName;
        if (stmt.getUser() != null && !StringUtils.isEmpty((String)(userName = ModelUtil.stripName(stmt.getUser().getName())))) {
            schema.removeUser(userName);
        }
    }

    public static void of(CreateRoleStatement stmt, Schema schema, int statementIndex) {
        String userName;
        if (stmt.getUserOrRole() != null && !StringUtils.isEmpty((String)(userName = ModelUtil.stripName(stmt.getUserOrRole().getName())))) {
            User newUser = new User(userName, statementIndex);
            ChangeSchema.setRoleOptions(newUser, stmt.getRoleOptions());
            schema.addUser(newUser, stmt.isIfNotExists());
        }
    }

    private static void setRoleOptions(User user, EList<RoleOption> options) {
        boolean canLogin = false;
        boolean isSuperuser = false;
        if (options != null) {
            for (RoleOption option : options) {
                if (option.getLogin() != null) {
                    canLogin = Boolean.valueOf(option.getLogin());
                    continue;
                }
                if (option.getSuperuser() == null) continue;
                isSuperuser = Boolean.valueOf(option.getSuperuser());
            }
        }
        user.setCanLogin(canLogin);
        user.setSuperuser(isSuperuser);
    }

    public static void of(AlterRoleStatement stmt, Schema schema, int statementIndex) {
        User user;
        String userName;
        if (stmt.getUserOrRole() != null && !StringUtils.isEmpty((String)(userName = ModelUtil.stripName(stmt.getUserOrRole().getName()))) && (user = schema.getUser(userName)) != null) {
            ChangeSchema.setRoleOptions(user, stmt.getRoleOptions());
        }
    }

    public static void of(DropRoleStatement stmt, Schema schema, int statementIndex) {
        String userName;
        if (stmt.getUserOrRole() != null && !StringUtils.isEmpty((String)(userName = ModelUtil.stripName(stmt.getUserOrRole().getName())))) {
            schema.removeUser(userName).setStatementIndex(statementIndex);
        }
    }

    public static void of(GrantStatement stmt, Schema schema, int statementIndex) {
    }

    public static void of(RevokeStatement stmt, Schema schema, int statementIndex) {
    }
}

