/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.util;

import com.datastax.devcenter.cql.cql.CollectionLiteral;
import com.datastax.devcenter.cql.cql.ColumnDef;
import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.FieldEntity;
import com.datastax.devcenter.cql.cql.ListLiteral;
import com.datastax.devcenter.cql.cql.MapEntry;
import com.datastax.devcenter.cql.cql.MapLiteral;
import com.datastax.devcenter.cql.cql.Property;
import com.datastax.devcenter.cql.cql.PropertyValue;
import com.datastax.devcenter.cql.cql.SetLiteral;
import com.datastax.devcenter.cql.cql.TableProperty;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.TupleLiteral;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.TypeFieldDef;
import com.datastax.devcenter.cql.cql.UserTypeEntry;
import com.datastax.devcenter.cql.cql.UserTypeLiteral;
import com.datastax.devcenter.cql.cql.Value;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.options.ClassOption;
import com.datastax.devcenter.schema.types.CqlDataType;
import java.util.List;

public class CqlGrammarHelper {
    public static ColumnEntity columnEntity(Column column) {
        ColumnEntity columnEntity = CqlFactory.eINSTANCE.createColumnEntity();
        columnEntity.setName(ModelUtil.escapeName(column.getName()));
        return columnEntity;
    }

    public static ColumnDef columnDef(Column column) {
        ColumnDef columnDef = CqlFactory.eINSTANCE.createColumnDef();
        ColumnEntity columnEntity = CqlGrammarHelper.columnEntity(column);
        columnDef.setColumn(columnEntity);
        columnDef.setStaticColumn(column.isStatic());
        CqlDataType cqlType = column.getType();
        Type type = cqlType.toGrammarType();
        columnDef.setType(type);
        return columnDef;
    }

    public static FieldEntity fieldEntity(UserTypeField userTypeField) {
        FieldEntity fieldEntity = CqlFactory.eINSTANCE.createFieldEntity();
        fieldEntity.setName(ModelUtil.escapeName(userTypeField.getName()));
        return fieldEntity;
    }

    public static TypeFieldDef fieldDef(UserTypeField userTypeField) {
        TypeFieldDef fieldDef = CqlFactory.eINSTANCE.createTypeFieldDef();
        FieldEntity fieldEntity = CqlGrammarHelper.fieldEntity(userTypeField);
        fieldDef.setUserTypeField(fieldEntity);
        CqlDataType cqlType = userTypeField.getType();
        Type type = cqlType.toGrammarType();
        fieldDef.setType(type);
        return fieldDef;
    }

    public static Property property(String name, Object value) {
        Property property = CqlFactory.eINSTANCE.createProperty();
        property.setName(name);
        if (value instanceof Number || value instanceof Boolean) {
            PropertyValue propertyValue = CqlFactory.eINSTANCE.createPropertyValue();
            propertyValue.setValue(value.toString());
            property.setPropertyValue(propertyValue);
        } else if (value instanceof MapLiteral) {
            property.setPropertyMap((MapLiteral)value);
        } else {
            PropertyValue propertyValue = CqlFactory.eINSTANCE.createPropertyValue();
            String escaped = ModelUtil.escapeStringLiteral(value.toString());
            propertyValue.setValue(escaped);
            property.setPropertyValue(propertyValue);
        }
        return property;
    }

    public static void addProperty(List<TableProperty> properties, String name, Object value) {
        if (value instanceof MapLiteral) {
            MapLiteral map = (MapLiteral)value;
            properties.add(CqlGrammarHelper.property(name, map));
        } else if (value != null) {
            properties.add(CqlGrammarHelper.property(name, value));
        }
    }

    public static ListLiteral listLiteral() {
        return CqlFactory.eINSTANCE.createListLiteral();
    }

    public static void addListEntry(ListLiteral list, Object value) {
        list.getValues().add((Object)CqlGrammarHelper.term(value));
    }

    public static SetLiteral setLiteral() {
        return CqlFactory.eINSTANCE.createSetLiteral();
    }

    public static void addSetEntry(SetLiteral set, Object value) {
        set.getValues().add((Object)CqlGrammarHelper.term(value));
    }

    public static MapLiteral mapLiteral() {
        return CqlFactory.eINSTANCE.createMapLiteral();
    }

    public static MapEntry mapEntry(Object key, Object value) {
        MapEntry entry = CqlFactory.eINSTANCE.createMapEntry();
        entry.setKey(CqlGrammarHelper.term(key));
        entry.setValue(CqlGrammarHelper.term(value));
        return entry;
    }

    public static void addMapEntry(MapLiteral map, Object key, Object value) {
        if (key != null && value != null) {
            MapEntry entry = CqlGrammarHelper.mapEntry(key, value);
            map.getEntries().add((Object)entry);
        }
    }

    public static TupleLiteral tupleLiteral() {
        return CqlFactory.eINSTANCE.createTupleLiteral();
    }

    public static void addTupleEntry(TupleLiteral tuple, Object value) {
        tuple.getValues().add((Object)CqlGrammarHelper.term(value));
    }

    public static UserTypeLiteral userTypeLiteral() {
        return CqlFactory.eINSTANCE.createUserTypeLiteral();
    }

    public static UserTypeEntry userTypeEntry(String field, Object value) {
        UserTypeEntry entry = CqlFactory.eINSTANCE.createUserTypeEntry();
        FieldEntity fieldEntity = CqlFactory.eINSTANCE.createFieldEntity();
        fieldEntity.setName(field);
        entry.setUserTypeField(fieldEntity);
        entry.setValue(CqlGrammarHelper.term(value));
        return entry;
    }

    public static void addUserTypeEntry(UserTypeLiteral userType, String field, Object value) {
        if (field != null && value != null) {
            UserTypeEntry entry = CqlGrammarHelper.userTypeEntry(field, value);
            userType.getEntries().add((Object)entry);
        }
    }

    public static Term term(Object value) {
        Term term = CqlFactory.eINSTANCE.createTerm();
        Value val = CqlGrammarHelper.value(value);
        term.setValue(val);
        return term;
    }

    public static Value value(Object value) {
        Value val = CqlFactory.eINSTANCE.createValue();
        if (value == null) {
            val.setNil(true);
        } else if (value instanceof CollectionLiteral) {
            val.setCollection((CollectionLiteral)value);
        } else if (value instanceof TupleLiteral) {
            val.setTupleLiteral((TupleLiteral)value);
        } else if (value instanceof UserTypeLiteral) {
            val.setUserType((UserTypeLiteral)value);
        } else if (value instanceof Number) {
            if (value instanceof Integer || value instanceof Short) {
                val.setConstant(CqlFactory.eINSTANCE.createIntegerValue());
            } else if (value instanceof Float || value instanceof Double) {
                val.setConstant(CqlFactory.eINSTANCE.createFloatValue());
            }
            val.getConstant().setValue(value.toString());
        } else if (value instanceof Boolean) {
            val.setConstant(CqlFactory.eINSTANCE.createBooleanValue());
            val.getConstant().setValue(value.toString());
        } else if (value instanceof ClassOption) {
            val.setConstant(CqlFactory.eINSTANCE.createStringValue());
            val.getConstant().setValue(ModelUtil.escapeStringLiteral(((ClassOption)value).getSimpleName()));
        } else {
            val.setConstant(CqlFactory.eINSTANCE.createStringValue());
            String valueString = ModelUtil.escapeStringLiteral(value.toString());
            val.getConstant().setValue(valueString);
        }
        return val;
    }
}

