/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.util;

import com.datastax.devcenter.cql.CqlStandaloneSetupGenerated;
import com.datastax.devcenter.cql.cql.IndexColumnDef;
import com.datastax.devcenter.cql.parser.antlr.CqlParser;
import com.datastax.devcenter.cql.services.CqlGrammarAccess;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Index;
import com.datastax.devcenter.schema.Indices;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.google.common.base.Objects;
import com.google.inject.Injector;
import java.io.StringReader;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.serializer.ISerializer;

public class IndexUtils {
    private static Injector injector;
    private static ParserRule typeRule;
    private static ISerializer serializer;

    static {
        CqlStandaloneSetupGenerated activator = new CqlStandaloneSetupGenerated();
        injector = activator.createInjector();
        serializer = (ISerializer)injector.getInstance(ISerializer.class);
        CqlGrammarAccess access = (CqlGrammarAccess)((Object)injector.getInstance(CqlGrammarAccess.class));
        typeRule = access.getIndexColumnDefRule();
    }

    public static IndexColumnDef parseIndexDefinition(String index) {
        CqlParser parser = (CqlParser)((Object)injector.getInstance(CqlParser.class));
        IParseResult result = parser.parse(typeRule, new StringReader(index));
        if (result.hasSyntaxErrors()) {
            return null;
        }
        return (IndexColumnDef)result.getRootASTElement();
    }

    public static void addColumnName(Indices indices, List<String> columnNames, Column selectedColumn, Column column) {
        if (!(Objects.equal((Object)selectedColumn, (Object)column) || IndexUtils.isColumnIndexable(column) && !IndexUtils.isColumnIndexed(column, indices))) {
            return;
        }
        CqlDataType type = column.getType();
        String name = ModelUtil.escapeName(column.getName());
        if (!type.isCollection() || !type.isFrozen()) {
            columnNames.add(name);
        }
        if (type.isMap() && !type.isFrozen()) {
            columnNames.add(String.format("KEYS (%s)", name));
            columnNames.add(String.format("ENTRIES (%s)", name));
        } else if (type.isCollection() && type.isFrozen()) {
            columnNames.add(String.format("FULL (%s)", name));
        }
    }

    private static boolean isColumnIndexable(Column column) {
        return !column.isCounter() && !column.isPartitionKey();
    }

    private static boolean isColumnIndexed(Column column, Indices indices) {
        for (Index index : indices) {
            String indexColumn = index.getColumn().getName();
            String indexKeyspace = index.getColumn().getKeyspace().getName();
            if (!indexColumn.equals(column.getName()) || !indexKeyspace.equals(column.getKeyspace().getName())) continue;
            return true;
        }
        return false;
    }

    public static String serialize(IndexColumnDef definition) {
        return serializer.serialize((EObject)definition);
    }
}

