/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.util;

import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.CreateAggregateFunctionStatement;
import com.datastax.devcenter.cql.cql.CreateFunctionStatement;
import com.datastax.devcenter.cql.cql.CreateKeyspaceStatement;
import com.datastax.devcenter.cql.cql.CreateTableStatement;
import com.datastax.devcenter.cql.cql.CreateTypeStatement;
import com.datastax.devcenter.cql.cql.DropFunctionStatement;
import com.datastax.devcenter.cql.cql.FunctionDeclarationStatement;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.MapEntry;
import com.datastax.devcenter.cql.cql.MapLiteral;
import com.datastax.devcenter.cql.cql.Property;
import com.datastax.devcenter.cql.cql.Relation;
import com.datastax.devcenter.cql.cql.Resource;
import com.datastax.devcenter.cql.cql.RulesWithKeyspaceRef;
import com.datastax.devcenter.cql.cql.RulesWithResource;
import com.datastax.devcenter.cql.cql.RulesWithTableRef;
import com.datastax.devcenter.cql.cql.RulesWithTypeRef;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.SelectorFunction;
import com.datastax.devcenter.cql.cql.StatementsWithIfExists;
import com.datastax.devcenter.cql.cql.StatementsWithIfNotExists;
import com.datastax.devcenter.cql.cql.StatementsWithProperties;
import com.datastax.devcenter.cql.cql.StatementsWithUsing;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.TableProperty;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.TokenRelation;
import com.datastax.devcenter.cql.cql.TypeEntity;
import com.datastax.devcenter.cql.cql.UsingClause;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;

public class ModelUtil {
    public static CqlStatement getCqlStatement(EObject o) {
        return ModelUtil.getAncestorOfType(o, CqlStatement.class);
    }

    public static <T> T getAncestorOfType(EObject o, Class<T> type) {
        return ModelUtil.getAncestorOfType(o, type, null);
    }

    public static <T> T getAncestorOfType(EObject descendant, Class<T> type, Integer maxAncestors) {
        EObject goal = descendant;
        Optional maxLevelsUp = Optional.fromNullable((Object)maxAncestors);
        int numberOfLevelsUp = 0;
        while (goal != null && !type.isAssignableFrom(goal.getClass())) {
            if (maxLevelsUp.isPresent() && ++numberOfLevelsUp > (Integer)maxLevelsUp.get()) {
                return null;
            }
            goal = goal.eContainer();
        }
        return (T)goal;
    }

    public static <T> boolean isAstChildOf(EObject o, Class<T> type) {
        return ModelUtil.getAncestorOfType(o, type) != null;
    }

    public static KeyspaceEntity getKeyspace(CqlStatement stmt) {
        Object ddl;
        if (stmt instanceof RulesWithKeyspaceRef) {
            return ((RulesWithKeyspaceRef)((Object)stmt)).getKeyspace();
        }
        if (stmt instanceof CreateKeyspaceStatement) {
            return ((CreateKeyspaceStatement)stmt).getKeyspace();
        }
        if (stmt instanceof FunctionDeclarationStatement ? (ddl = (FunctionDeclarationStatement)((Object)stmt)).getFunction() != null && ddl.getFunction().getKeyspace() != null : stmt instanceof DropFunctionStatement && (ddl = (DropFunctionStatement)stmt).getFunction() != null && ddl.getFunction().getKeyspace() != null) {
            return ddl.getFunction().getKeyspace();
        }
        Resource r = ModelUtil.getResource(stmt);
        if (r != null) {
            if (r.getDataResource() != null) {
                return r.getDataResource().getKeyspace();
            }
            if (r.getFunctionResource() != null) {
                return r.getFunctionResource().getKeyspace();
            }
        }
        return null;
    }

    public static TableEntity getTable(CqlStatement stmt) {
        if (stmt instanceof RulesWithTableRef) {
            return ((RulesWithTableRef)((Object)stmt)).getTable();
        }
        if (stmt instanceof CreateTableStatement) {
            return ((CreateTableStatement)stmt).getTable();
        }
        Resource r = ModelUtil.getResource(stmt);
        if (r != null && r.getDataResource() != null) {
            return r.getDataResource().getTable();
        }
        return null;
    }

    public static TypeEntity getUserType(CqlStatement stmt) {
        if (stmt instanceof RulesWithTypeRef) {
            return ((RulesWithTypeRef)((Object)stmt)).getUserType();
        }
        if (stmt instanceof CreateTypeStatement) {
            return ((CreateTypeStatement)stmt).getUserType();
        }
        return null;
    }

    public static Resource getResource(CqlStatement stmt) {
        if (stmt instanceof RulesWithResource) {
            return ((RulesWithResource)((Object)stmt)).getResource();
        }
        return null;
    }

    public static UsingClause getUsingClause(CqlStatement stmt) {
        if (stmt instanceof StatementsWithUsing) {
            return ((StatementsWithUsing)((Object)stmt)).getUsingClause();
        }
        return null;
    }

    public static Collection<? extends TableProperty> getPropertyList(CqlStatement stmt) {
        if (stmt instanceof StatementsWithProperties) {
            return ((StatementsWithProperties)((Object)stmt)).getProperties();
        }
        return new ArrayList();
    }

    public static boolean hasIfExistsClause(EObject stmt) {
        return stmt instanceof StatementsWithIfExists && ((StatementsWithIfExists)stmt).isIfExists();
    }

    public static boolean hasIfNotExistsClause(CqlStatement stmt) {
        return stmt instanceof StatementsWithIfNotExists && ((StatementsWithIfNotExists)((Object)stmt)).isIfNotExists();
    }

    public static boolean isOptionPairExist(Property property, String requiredOptionName, String requiredOptionValue) {
        MapLiteral mapLiteral;
        if (property != null && (mapLiteral = property.getPropertyMap()) != null) {
            for (MapEntry mapEntry : mapLiteral.getEntries()) {
                if (!requiredOptionName.equals(ModelUtil.termToString(mapEntry.getKey())) || !requiredOptionValue.equals(ModelUtil.termToString(mapEntry.getValue()))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOptionNameExist(Property property, String dependentOptionName) {
        MapLiteral mapLiteral;
        if (property != null && (mapLiteral = property.getPropertyMap()) != null) {
            for (MapEntry mapEntry : mapLiteral.getEntries()) {
                if (!dependentOptionName.equals(ModelUtil.termToString(mapEntry.getKey()))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPropertyNamesExist(Collection<? extends TableProperty> propertyList, String dependentPropertyName) {
        if (propertyList != null) {
            for (TableProperty tableProperty : propertyList) {
                String name;
                if (tableProperty.isClustering() || tableProperty.isCompactStorage() || (name = ((Property)tableProperty).getName()) == null || !name.equalsIgnoreCase(dependentPropertyName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInFunction(EObject o, String functionName) {
        TokenRelation tokenRelation;
        if (functionName.toLowerCase().equals("token") && (tokenRelation = ModelUtil.getAncestorOfType(o, TokenRelation.class)) != null) {
            return true;
        }
        SelectorFunction selectorFunction = ModelUtil.getAncestorOfType(o, SelectorFunction.class);
        if (selectorFunction != null && selectorFunction.getFunctionName() != null && selectorFunction.getFunctionName().getName().toLowerCase().equals(functionName.toLowerCase())) {
            return true;
        }
        Term term = ModelUtil.getAncestorOfType(o, Term.class);
        return term != null && term.getFunctionName() != null && term.getFunctionName().getName().toLowerCase().equals(functionName.toLowerCase());
    }

    public static String termToString(Term term) {
        if (term != null && term.getValue() != null && term.getValue().getConstant() != null) {
            return term.getValue().getConstant().getValue();
        }
        return "";
    }

    public static String escapeName(String name) {
        if (name == null) {
            return null;
        }
        if (!name.toLowerCase().equals(name) || name.indexOf("\"") >= 0) {
            return "\"" + name.replace("\"", "\"\"") + "\"";
        }
        return name;
    }

    public static String escapeStringLiteral(String name) {
        if (name == null) {
            return null;
        }
        return "'" + name.replace("'", "''") + "'";
    }

    public static String stripName(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("\"") && name.endsWith("\"")) {
            return name.substring(1, name.length() - 1).replace("\"\"", "\"");
        }
        if (name.startsWith("'") && name.endsWith("'")) {
            return name.substring(1, name.length() - 1).replace("''", "'");
        }
        return name.toLowerCase();
    }

    public static String quote(String toWrap) {
        return ModelUtil.wrap(toWrap, "'");
    }

    public static String doubleQuote(String toWrap) {
        return ModelUtil.wrap(toWrap, "\"");
    }

    private static String wrap(String toWrap, String with) {
        return String.valueOf(with) + toWrap + with;
    }

    public static boolean isUnquotedMixedCase(String name) {
        return name == null ? false : !name.toLowerCase().equals(name) && !name.startsWith("\"");
    }

    public static boolean containsEscapedQuote(String name) {
        return name == null ? false : name.contains("\"");
    }

    public static boolean syntaxErrorsExistWithin(EObject entity) {
        XtextResource resource;
        if (entity == null) {
            throw new IllegalArgumentException("Null EObject provided to syntax errors check");
        }
        if (entity.eResource() != null && entity.eResource() instanceof XtextResource && (resource = (XtextResource)entity.eResource()).getParseResult() != null) {
            ICompositeNode entityNode = NodeModelUtils.getNode((EObject)entity);
            for (INode error : resource.getParseResult().getSyntaxErrors()) {
                if (!ModelUtil.nodeContainsOtherNode((INode)entityNode, error)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean nodeContainsOtherNode(INode node, INode other) {
        return ModelUtil.nodeRangeContainsOtherRange(node.getOffset(), node.getEndOffset(), other.getOffset(), other.getEndOffset());
    }

    private static boolean nodeRangeContainsOtherRange(int nodeStart, int nodeEnd, int otherStart, int otherEnd) {
        return nodeStart <= otherStart && otherEnd <= nodeEnd;
    }

    public static boolean containedInFunctionDDL(EObject o) {
        return ModelUtil.getAncestorOfType(o, DropFunctionStatement.class) != null || ModelUtil.getAncestorOfType(o, CreateFunctionStatement.class) != null || ModelUtil.getAncestorOfType(o, CreateAggregateFunctionStatement.class) != null;
    }

    public static boolean isSolrQuery(SelectStatement selectStmt) {
        if (selectStmt == null || selectStmt.getWhereClause() == null || selectStmt.getWhereClause().getRelations() == null) {
            return false;
        }
        EList<Relation> relations = selectStmt.getWhereClause().getRelations();
        for (Relation relation : relations) {
            ColumnEntity column = relation.getColumn();
            if (column == null || column.getName() == null || !column.getName().equals("solr_query")) continue;
            return true;
        }
        return false;
    }
}

