/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.util;

import com.datastax.devcenter.cql.util.LevenshteinDistance;
import com.datastax.devcenter.cql.util.StrDistance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class StrDistanceList {
    List<StrDistance> list = new ArrayList<StrDistance>();
    String strBase;
    int proposeSize;
    int maxDist;

    public StrDistanceList(String strBase) {
        this(strBase, 4);
    }

    public StrDistanceList(String strBase, int proposeSize) {
        this.strBase = strBase;
        this.proposeSize = proposeSize;
        this.maxDist = 3;
    }

    public void addStr(String str) {
        int dist;
        if (!str.equals(this.strBase) && (dist = LevenshteinDistance.computeLevenshteinDistance(str, this.strBase)) <= this.maxDist) {
            this.list.add(new StrDistance(str, dist));
        }
    }

    public void sortList() {
        Collections.sort(this.list, new Comparator<StrDistance>(){

            @Override
            public int compare(StrDistance lhs, StrDistance rhs) {
                return lhs.compareTo(rhs);
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (StrDistance sd : this.list) {
            sb.append(sd);
        }
        return sb.toString();
    }

    public List<StrDistance> getInstances() {
        if (this.list.size() <= this.proposeSize) {
            return new ArrayList<StrDistance>(this.list);
        }
        return this.list.subList(0, this.proposeSize);
    }
}

