/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.util;

import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.parser.antlr.CqlParser;
import com.datastax.devcenter.cql.services.CqlGrammarAccess;
import com.google.inject.Provider;
import java.io.StringReader;
import javax.inject.Inject;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.parser.IParseResult;

public class TypeParser {
    private final Provider<CqlParser> cqlParserProvider;
    private final ParserRule typeRule;

    @Inject
    public TypeParser(Provider<CqlParser> cqlParserProvider, CqlGrammarAccess access) {
        this.cqlParserProvider = cqlParserProvider;
        this.typeRule = access.getTypeRule();
    }

    public Type parse(String expression) {
        CqlParser parser = (CqlParser)((Object)this.cqlParserProvider.get());
        IParseResult result = parser.parse(this.typeRule, new StringReader(expression));
        if (result.hasSyntaxErrors()) {
            return null;
        }
        Type type = (Type)result.getRootASTElement();
        return type;
    }
}

