/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.AlterTableStatement;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Keyword;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CqlDataTypeFactory;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import com.datastax.devcenter.schema.types.UnknownCqlDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class AlterTableStatementValidator
extends UtilityValidator {
    @Check
    public void alterCounterPrimaryKey(AlterTableStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta != null && stmt.getOperation() != null && stmt.getOperation().equalsIgnoreCase("alter") && stmt.getType() != null && stmt.getType().getNativeType() != null && stmt.getType().getNativeType().equalsIgnoreCase("counter") && stmt.getColumn() != null && tableMeta.isPrimaryKeyContain(ModelUtil.stripName(stmt.getColumn().getName()))) {
            this.error("counter type is not supported for PRIMARY KEY part", (EStructuralFeature)CqlPackage.Literals.ALTER_TABLE_STATEMENT__TYPE, "COUNTER_TYPE_IS_NOT_SUPPORTED_FOR_PRIMARY_KEY_PART", new String[0]);
        }
    }

    @Check
    public void addNonCounterColumnInCounterFamily(AlterTableStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta.hasCounter() && !NativeCqlDataType.COUNTER.matches(stmt.getType()) && Keyword.ADD.matches(stmt.getOperation())) {
            this.error("For a table with counter columns, all columns except the primary key must be of type counter", (EStructuralFeature)CqlPackage.Literals.ALTER_TABLE_STATEMENT__TYPE, "CANNOT_ADD_A_NON_COUNTER_COLUMN_IN_A_COUNTER_COLUMN_FAMILY", new String[0]);
        }
    }

    @Check
    public void addCounterColumnInNonCounterFamily(AlterTableStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (!tableMeta.hasCounter() && NativeCqlDataType.COUNTER.matches(stmt.getType()) && Keyword.ADD.matches(stmt.getOperation())) {
            this.error("For a table without counter columns, new columns cannot be of type counter", (EStructuralFeature)CqlPackage.Literals.ALTER_TABLE_STATEMENT__TYPE, "CANNOT_ADD_A_COUNTER_COLUMN_IN_A_NON_COUNTER_COLUMN_FAMILY", new String[0]);
        }
    }

    @Check
    public void addColumnToCompactStorageTable(AlterTableStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta != null && tableMeta.isCompactStorage() && stmt.getOperation() != null && stmt.getOperation().equalsIgnoreCase("add")) {
            this.error("Cannot add new column to a compact storage table", (EStructuralFeature)CqlPackage.Literals.ALTER_TABLE_STATEMENT__OPERATION, "CANNOT_ADD_NEW_COLUMN_TO_A_COMPACT_CF", new String[0]);
        }
    }

    @Check
    public void dropColumnOfCompactTable(AlterTableStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta != null && tableMeta.isCompactStorage() && stmt.getOperation() != null && stmt.getOperation().equalsIgnoreCase("drop")) {
            this.error("Cannot drop columns from a compact storage table", (EStructuralFeature)CqlPackage.Literals.ALTER_TABLE_STATEMENT__OPERATION, "CANNOT_DROP_COLUMNS_FROM_A_COMPACT_CF", new String[0]);
        }
    }

    @Check
    public void dropPrimaryKey(AlterTableStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta != null && stmt.getColumn() != null && stmt.getOperation() != null && stmt.getOperation().equalsIgnoreCase("drop") && tableMeta.isPrimaryKeyContain(ModelUtil.stripName(stmt.getColumn().getName()))) {
            this.error("Cannot drop PRIMARY KEY part", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "CANNOT_DROP_PRIMARY_KEY_PART_", new String[0]);
        }
    }

    @Check
    public void checkAlterTableAlterTypeCompatibility(AlterTableStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta != null && stmt.getColumn() != null && stmt.getOperation() != null && stmt.getOperation().equalsIgnoreCase("alter")) {
            CqlDataType currentCqlDataType;
            Column tableColumn;
            Keyspace keyspaceMeta = tableMeta.getKeyspace();
            CqlDataType alterCqlDataType = CqlDataTypeFactory.fromGrammarType(stmt.getType(), keyspaceMeta);
            if (UnknownCqlDataType.INSTANCE != alterCqlDataType && (tableColumn = tableMeta.getColumn(stmt.getColumn().getName())) != null && !alterCqlDataType.isCompatibleWith(currentCqlDataType = tableColumn.getType())) {
                this.error("Incompatible data types", (EStructuralFeature)CqlPackage.Literals.ALTER_TABLE_STATEMENT__TYPE, "INCOMPATIBLE_DATA_TYPES", new String[0]);
            }
        }
    }
}

