/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.AlterTypeStatement;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CqlDataTypeFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class AlterTypeStatementValidator
extends UtilityValidator {
    @Check
    public void checkCannotAddCounterType(AlterTypeStatement stmt) {
        Type fieldType;
        if ((stmt.getOperation().equalsIgnoreCase("alter") || stmt.getOperation().equalsIgnoreCase("add")) && (fieldType = stmt.getType()) != null && fieldType.getNativeType() != null && fieldType.getNativeType().equalsIgnoreCase("counter")) {
            this.error("counters are not allowed in User-Defined types", (EStructuralFeature)CqlPackage.Literals.ALTER_TYPE_STATEMENT__TYPE, "COUNTERS_ARE_NOT_ALLOWED_INSIDE_USER_DEFINED_TYPES", new String[0]);
        }
    }

    @Check
    public void checkUserTypeForCyclesAndTypeCompatibility(AlterTypeStatement stmt) {
        UserType userTypeMeta = this.contextProvider.get(stmt).getUserTypeMeta(stmt);
        if (userTypeMeta != null) {
            Keyspace keyspaceMeta = userTypeMeta.getKeyspace();
            CqlDataType fieldCqlDataType = CqlDataTypeFactory.fromGrammarType(stmt.getType(), keyspaceMeta);
            if (fieldCqlDataType != null) {
                CqlDataType currentCqlDataType;
                UserTypeField userTypeField;
                if (fieldCqlDataType.isReachableFrom(userTypeMeta)) {
                    this.error("Cannot add type because it would create a cycle", (EStructuralFeature)CqlPackage.Literals.ALTER_TYPE_STATEMENT__TYPE, "CANNOT_ADD_TYPE_BECAUSE_IT_WOULD_CREATE_A_CYCLE", new String[0]);
                }
                if (stmt.getOperation() != null && stmt.getOperation().equalsIgnoreCase("alter") && stmt.getUserTypeField() != null && (userTypeField = userTypeMeta.getField(stmt.getUserTypeField().getName())) != null && !fieldCqlDataType.isCompatibleWith(currentCqlDataType = userTypeField.getType())) {
                    this.error("Incompatible data types", (EStructuralFeature)CqlPackage.Literals.ALTER_TYPE_STATEMENT__TYPE, "INCOMPATIBLE_DATA_TYPES", new String[0]);
                }
            }
        }
    }
}

