/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.BatchStatement;
import com.datastax.devcenter.cql.cql.ColumnOperation;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.DeleteStatement;
import com.datastax.devcenter.cql.cql.InsertStatement;
import com.datastax.devcenter.cql.cql.Relation;
import com.datastax.devcenter.cql.cql.TokenRelation;
import com.datastax.devcenter.cql.cql.UpdateStatement;
import com.datastax.devcenter.cql.cql.UsingClause;
import com.datastax.devcenter.cql.cql.UsingClauseOption;
import com.datastax.devcenter.cql.cql.WhereClause;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class BatchModificationStatementValidator
extends UtilityValidator {
    @Check
    public void nonPrimaryKeyFoundIntWhereClause(WhereClause whereClause) {
        CqlStatement stmt = ModelUtil.getCqlStatement(whereClause);
        Table tableMeta = this.getTableMeta(whereClause);
        if (!this.isModificationStatement(stmt) || whereClause.getRelations() == null || tableMeta == null) {
            return;
        }
        int i = 0;
        while (i < whereClause.getRelations().size()) {
            String name;
            Relation rel = (Relation)whereClause.getRelations().get(i);
            if (rel.getColumn() != null && !tableMeta.isPrimaryKeyContain(name = ModelUtil.stripName(rel.getColumn().getName()))) {
                this.error(String.format("Non PRIMARY KEY %s found in where clause", name), (EStructuralFeature)CqlPackage.Literals.WHERE_CLAUSE__RELATIONS, i, "NON_PRIMARY_KEY_FOUND_IN_WHERE_CLAUSE", new String[0]);
            }
            ++i;
        }
    }

    private boolean isModificationStatement(CqlStatement stmt) {
        return stmt instanceof UpdateStatement || stmt instanceof InsertStatement || stmt instanceof DeleteStatement;
    }

    @Check
    public void invalidOperatorForPrimaryKeyPart(Relation rel) {
        if (!this.isModificationStatement(ModelUtil.getCqlStatement(rel)) || rel.getColumn() == null || rel.getType() == null) {
            return;
        }
        Table tableMeta = this.getTableMeta(rel);
        if (tableMeta == null) {
            return;
        }
        String name = ModelUtil.stripName(rel.getColumn().getName());
        if (!rel.getType().equals("=") && !rel.isIn() && !(rel instanceof TokenRelation) && tableMeta.isPrimaryKeyContain(name)) {
            this.error(String.format("Invalid operator %s for PRIMARY KEY part %s", rel.getType(), name), (EStructuralFeature)CqlPackage.Literals.RELATION__TYPE, "INVALID_OPERATOR_FOR_PRIMARY_KEY_PART_", new String[0]);
        }
    }

    @Check
    public void nullForPartitionKey(Relation rel) {
        Table tableMeta = this.getTableMeta(rel);
        if (tableMeta == null || rel.getColumn() == null || rel.getTerm() == null) {
            return;
        }
        if (this.isNull(rel.getTerm()) && tableMeta.isPrimaryKeyContain(ModelUtil.stripName(rel.getColumn().getName()))) {
            this.error(String.format("Invalid null value for primary key part %s", ModelUtil.stripName(rel.getColumn().getName())), (EStructuralFeature)CqlPackage.Literals.RELATION__TERM, "INVALID_NULL_VALUE_FOR_PARTITION_KEY_PART_", new String[0]);
        }
    }

    @Check
    public void contionalUpdateForCounterTable(UpdateStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta == null || !this.isConditional(stmt)) {
            return;
        }
        for (Column col : tableMeta.getColumns()) {
            if (!col.getType().equals(NativeCqlDataType.COUNTER)) continue;
            this.error("Conditional updates are not supported on tables with counter columns", (EStructuralFeature)CqlPackage.Literals.UPDATE_STATEMENT__CONDITION, "CONDITIONAL_UPDATES_ARE_NOT_SUPPORTED_ON_COUNTER_TABLES", new String[0]);
        }
    }

    @Check
    public void inInPartionKeyWithConditionUpdate(WhereClause whereClause) {
        UpdateStatement stmt = ModelUtil.getAncestorOfType(whereClause, UpdateStatement.class);
        if (stmt == null) {
            return;
        }
        Table tableMeta = this.getTableMeta(whereClause);
        if (tableMeta == null) {
            return;
        }
        if (this.isConditional(stmt)) {
            int i = 0;
            while (i < whereClause.getRelations().size()) {
                Relation rel = (Relation)whereClause.getRelations().get(i);
                if (rel.isIn() && rel.getColumn() != null && tableMeta.isPartitionKeyContain(ModelUtil.stripName(rel.getColumn().getName()))) {
                    this.error("IN on the partition key is not supported with conditional updates", (EStructuralFeature)CqlPackage.Literals.WHERE_CLAUSE__RELATIONS, i, "IN_ON_THE_PARTITION_KEY_IS_NOT_SUPPORTED_WITH_CONDITIONAL_UPDATES", new String[0]);
                }
                ++i;
            }
        }
    }

    @Check
    public void customTimestampsNotAllowedInCondition(UsingClause usingClause) {
        if (this.isConditional(ModelUtil.getAncestorOfType(usingClause, UpdateStatement.class)) || this.isConditional(ModelUtil.getAncestorOfType(usingClause, InsertStatement.class))) {
            int i = 0;
            while (i < usingClause.getOptions().size()) {
                if (((UsingClauseOption)usingClause.getOptions().get(i)).isTimestampOption()) {
                    this.error("Custom timestamps are not allowed when conditions are used", (EStructuralFeature)CqlPackage.Literals.USING_CLAUSE__OPTIONS, i, "CUSTOM_TIMIESTAMPS_ARE_NOT_ALLOWED_WHEN_CONDITIONS_ARE_USED", new String[0]);
                }
                ++i;
            }
        }
    }

    private boolean hasTtlOption(UsingClause usingClause) {
        if (usingClause == null) {
            return false;
        }
        for (UsingClauseOption op : usingClause.getOptions()) {
            if (!op.isTtlOption()) continue;
            return true;
        }
        return false;
    }

    private boolean hasTimestampOption(UsingClause usingClause) {
        if (usingClause == null) {
            return false;
        }
        for (UsingClauseOption op : usingClause.getOptions()) {
            if (!op.isTimestampOption()) continue;
            return true;
        }
        return false;
    }

    @Check
    public void globalTtl(BatchStatement stmt) {
        UsingClause usingClause = stmt.getUsingClause();
        if (this.hasTtlOption(usingClause)) {
            this.error("Global TTL on the BATCH statement is not supported.", (EStructuralFeature)CqlPackage.Literals.USING_CLAUSE_OPTION__TTL, "TTL_NOT_ALLOWED_IN_BATCH_STATEMENT", new String[0]);
        }
    }

    @Check
    public void timestampEitherGlobalOrIndividual(BatchStatement stmt) {
        UsingClause batchUsingClause = stmt.getUsingClause();
        boolean batchHasTimestamp = this.hasTimestampOption(batchUsingClause);
        if (!batchHasTimestamp) {
            return;
        }
        boolean modHasTimestamp = false;
        int i = 0;
        while (i < stmt.getStatements().size()) {
            CqlStatement modStmt = (CqlStatement)stmt.getStatements().get(i);
            UsingClause modUsingClause = ModelUtil.getUsingClause(modStmt);
            if (this.hasTimestampOption(modUsingClause)) {
                this.error("Timestamp must be set either on BATCH or individual statements", (EStructuralFeature)CqlPackage.Literals.BATCH_STATEMENT__STATEMENTS, i, "TIMESTAMP_MUST_BE_SET_EITHER_ON_BATCH_OR_INDIVIDUAL_STATEMENTS", new String[0]);
                modHasTimestamp = true;
            }
            ++i;
        }
        if (modHasTimestamp) {
            this.error("Timestamp must be set either on BATCH or individual statements", (EStructuralFeature)CqlPackage.Literals.USING_CLAUSE_OPTION__TIMESTAMP, "TIMESTAMP_MUST_BE_SET_EITHER_ON_BATCH_OR_INDIVIDUAL_STATEMENTS", new String[0]);
        }
    }

    private boolean isUpdateCounter(CqlStatement stmt) {
        if (stmt instanceof UpdateStatement) {
            UpdateStatement updateStmt = (UpdateStatement)stmt;
            Table tableMeta = this.getTableMeta(updateStmt);
            if (tableMeta == null || updateStmt.getOperations() == null) {
                return false;
            }
            for (ColumnOperation colop : updateStmt.getOperations()) {
                Column col;
                if (colop.getColumn() == null || (col = tableMeta.getColumn(ModelUtil.stripName(colop.getColumn().getName()))) == null || !col.getType().equals(NativeCqlDataType.COUNTER)) continue;
                return true;
            }
        }
        return false;
    }

    @Check
    public void mutationInNotCounterBatch(BatchStatement stmt) {
        if (stmt.isCounter()) {
            return;
        }
        int i = 0;
        while (i < stmt.getStatements().size()) {
            CqlStatement mutStmt = (CqlStatement)stmt.getStatements().get(i);
            if (this.isUpdateCounter(mutStmt)) {
                this.error("Counter mutations are only allowed in COUNTER batches", (EStructuralFeature)CqlPackage.Literals.BATCH_STATEMENT__STATEMENTS, i, "COUNTER_MUTATIONS_ARE_ONLY_ALLOWED_IN_COUNTER_BATCHES", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void nonMutationInCounterBatch(BatchStatement stmt) {
        if (!stmt.isCounter()) {
            return;
        }
        int i = 0;
        while (i < stmt.getStatements().size()) {
            CqlStatement mutStmt = (CqlStatement)stmt.getStatements().get(i);
            if (!this.isUpdateCounter(mutStmt)) {
                this.error("Only counter mutations are allowed in COUNTER batches", (EStructuralFeature)CqlPackage.Literals.BATCH_STATEMENT__STATEMENTS, i, "ONLY_COUNTER_MUTATIONS_ARE_ALLOWED_IN_COUNTER_BATCHES", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void conditionalUpdate(UpdateStatement stmt) {
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_6)) {
            return;
        }
        if (ModelUtil.getAncestorOfType(stmt, BatchStatement.class) != null && this.isConditional(stmt)) {
            this.error("Conditional updates are not allowed in batches", (EStructuralFeature)CqlPackage.Literals.UPDATE_STATEMENT__CONDITION, "CONDITIONAL_UPDATES_ARE_NOT_ALLOWED_IN_BATCHES", new String[0]);
        }
    }
}

