/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.CqlContextProvider;
import com.datastax.devcenter.cql.cql.BatchStatement;
import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.FieldEntity;
import com.datastax.devcenter.cql.cql.FunctionArgs;
import com.datastax.devcenter.cql.cql.IndexEntity;
import com.datastax.devcenter.cql.cql.InsertStatement;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.Selector;
import com.datastax.devcenter.cql.cql.SelectorFunction;
import com.datastax.devcenter.cql.cql.StandardInsertStatement;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.TokenRelation;
import com.datastax.devcenter.cql.cql.TriggerEntity;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.TypeEntity;
import com.datastax.devcenter.cql.cql.TypoStatement;
import com.datastax.devcenter.cql.cql.UserOrRoleEntity;
import com.datastax.devcenter.cql.util.ChangeSchema;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.AbstractCqlJavaValidator;
import com.datastax.devcenter.cql.validation.AlterTableStatementValidator;
import com.datastax.devcenter.cql.validation.AlterTypeStatementValidator;
import com.datastax.devcenter.cql.validation.BatchModificationStatementValidator;
import com.datastax.devcenter.cql.validation.CreateDropAlterKeyspaceValidator;
import com.datastax.devcenter.cql.validation.CreateDropIndexStatementValidator;
import com.datastax.devcenter.cql.validation.CreateDropTypeStatementValidator;
import com.datastax.devcenter.cql.validation.CreateTableStatementValidator;
import com.datastax.devcenter.cql.validation.DataTypeValidator;
import com.datastax.devcenter.cql.validation.DeleteStatementValidator;
import com.datastax.devcenter.cql.validation.ExistenceValidator;
import com.datastax.devcenter.cql.validation.FunctionValidator;
import com.datastax.devcenter.cql.validation.GrantRevokeStatementValidator;
import com.datastax.devcenter.cql.validation.InsertStatementValidator;
import com.datastax.devcenter.cql.validation.PropertyMapValidator;
import com.datastax.devcenter.cql.validation.RelationValidator;
import com.datastax.devcenter.cql.validation.RoleStatementsValidator;
import com.datastax.devcenter.cql.validation.SelectStatementValidator;
import com.datastax.devcenter.cql.validation.UDFValidator;
import com.datastax.devcenter.cql.validation.UpdateStatementValidator;
import com.datastax.devcenter.cql.validation.UserStatementValidator;
import com.datastax.devcenter.cql.validation.UsingClauseValidator;
import com.datastax.devcenter.cql.validation.VersionCompatibleValidator;
import com.datastax.devcenter.cql.validation.WhereClauseValidator;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CqlDataTypeFactory;
import com.google.inject.Inject;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ComposedChecks;

@ComposedChecks(validators={AlterTableStatementValidator.class, AlterTypeStatementValidator.class, UsingClauseValidator.class, BatchModificationStatementValidator.class, CreateDropAlterKeyspaceValidator.class, CreateDropIndexStatementValidator.class, CreateTableStatementValidator.class, CreateDropTypeStatementValidator.class, DeleteStatementValidator.class, FunctionValidator.class, RelationValidator.class, UDFValidator.class, DataTypeValidator.class, SelectStatementValidator.class, InsertStatementValidator.class, UpdateStatementValidator.class, UserStatementValidator.class, RoleStatementsValidator.class, GrantRevokeStatementValidator.class, WhereClauseValidator.class, PropertyMapValidator.class, ExistenceValidator.class, VersionCompatibleValidator.class})
public class CqlJavaValidator
extends AbstractCqlJavaValidator {
    @Inject
    private CqlContextProvider contextProvider;
    @Inject
    private ISerializer serializer;

    CqlJavaValidator() {
    }

    @Check
    public void changeSchema(CqlStatement stmt) {
        CqlContext context;
        if (stmt.eContainer() instanceof BatchStatement) {
            return;
        }
        int statementIndex = (context = this.contextProvider.get(stmt)).getStatementIndexMap().getStatementIndex(stmt);
        context.setIndexToCheck(statementIndex > 0 ? statementIndex - 1 : 0);
        context.duplicateLastSchema();
        Schema lastSchema = context.getLastSchema();
        ChangeSchema.of(stmt, lastSchema, statementIndex);
    }

    @Check
    public void checkTokenArguements(TokenRelation tokenRelation) {
        if (tokenRelation.getArgs() == null || tokenRelation.getArgs().getColumns() == null) {
            return;
        }
        Table cfMeta = this.contextProvider.get(tokenRelation).getTableMeta(tokenRelation);
        List<Column> partitionKeys = cfMeta.getPartitionKeys();
        boolean notMatch = false;
        if (partitionKeys.size() != tokenRelation.getArgs().getColumns().size()) {
            notMatch = true;
        } else {
            int i = 0;
            while (i < partitionKeys.size()) {
                Column pk = partitionKeys.get(i);
                String tokenArgName = ((ColumnEntity)tokenRelation.getArgs().getColumns().get(i)).getName();
                if (!pk.getName().equals(ModelUtil.stripName(tokenArgName))) {
                    notMatch = true;
                    break;
                }
                ++i;
            }
        }
        if (notMatch) {
            String[] pks = new String[partitionKeys.size()];
            int i = 0;
            while (i < partitionKeys.size()) {
                pks[i] = partitionKeys.get(i).getName();
                ++i;
            }
            this.error("Token arguments should match partition key", (EStructuralFeature)CqlPackage.Literals.TOKEN_RELATION__ARGS, "TOKEN_ARGS_DISMATCH_PARITION_KEY", pks);
        }
    }

    @Check
    public void checkTokenArguments(Term term) {
        if (!ModelUtil.isInFunction(term, "token")) {
            return;
        }
        Table cfMeta = this.contextProvider.get(term).getTableMeta(term);
        List<Column> partitionKeys = cfMeta.getPartitionKeys();
        if (partitionKeys.size() != term.getArgs().getArgs().size()) {
            this.error("Should have " + partitionKeys.size() + " arguments", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_FUNCTION_ARGS__ARGS);
        }
    }

    @Check
    public void checkTokenArguments(FunctionArgs args) {
        if (!ModelUtil.isInFunction(args, "token")) {
            return;
        }
        Table cfMeta = this.contextProvider.get(args).getTableMeta(args);
        List<Column> partitionKeys = cfMeta.getPartitionKeys();
        int i = 0;
        while (i < Math.min(partitionKeys.size(), args.getArgs().size())) {
            Column colMeta = partitionKeys.get(i);
            if (!colMeta.getType().validate((Term)args.getArgs().get(i))) {
                this.error("This token argument should be " + colMeta.getType().toString() + " type", (EStructuralFeature)CqlPackage.Literals.FUNCTION_ARGS__ARGS, i, "TOKEN_ARGS_WRONG_TYPE", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void markTypoStatement(TypoStatement stmt) {
        EList<String> typos = stmt.getTypos();
        String[] data = new String[]{""};
        data = typos.size() > 1 ? new String[]{(String)typos.get(0), (String)typos.get(1)} : new String[]{(String)typos.get(0)};
        this.error("You made a type...sorry typo", (EStructuralFeature)CqlPackage.Literals.TYPO_STATEMENT__TYPOS, "TYPO_STATEMENT", data);
    }

    @Check
    public void checkCompleteSelector(Selector selector) {
        if (selector != null && selector.getColumn() != null) {
            int numberOfSelectorSeparators;
            int numberIdents = 1;
            if (selector.getUserTypeFields() != null) {
                numberIdents += selector.getUserTypeFields().size();
            }
            int n = numberOfSelectorSeparators = selector.getSelectorSeparators() != null ? selector.getSelectorSeparators().size() : 0;
            if (numberOfSelectorSeparators == numberIdents) {
                this.error("Incomplete Selector.  Remove extra '.'", (EStructuralFeature)CqlPackage.Literals.SELECTOR__SELECTOR_SEPARATORS, numberOfSelectorSeparators - 1, "INCOMPLETE_SELECTOR_DANGLING_SEPARATOR", new String[0]);
            }
        }
    }

    @Check
    public void checkTokenArguments(SelectorFunction func) {
        if (!ModelUtil.isInFunction(func, "token") || func.getArgs() == null || func.getArgs().getSelectors() == null) {
            return;
        }
        Table cfMeta = this.contextProvider.get(func).getTableMeta(func);
        List<Column> partitionKeys = cfMeta.getPartitionKeys();
        boolean notMatch = false;
        if (partitionKeys.size() != func.getArgs().getSelectors().size()) {
            notMatch = true;
        } else {
            int i = 0;
            while (i < partitionKeys.size()) {
                Column pk = partitionKeys.get(i);
                Selector sel = (Selector)func.getArgs().getSelectors().get(i);
                if (sel.getColumn() != null && !pk.getName().equals(ModelUtil.stripName(sel.getColumn().getName()))) {
                    notMatch = true;
                    break;
                }
                ++i;
            }
        }
        if (notMatch) {
            String[] pks = new String[partitionKeys.size()];
            int i = 0;
            while (i < partitionKeys.size()) {
                pks[i] = partitionKeys.get(i).getName();
                ++i;
            }
            this.error("Token arguments should match partition key", (EStructuralFeature)CqlPackage.Literals.SELECTOR_FUNCTION__ARGS, "TOKEN_ARGS_DISMATCH_PARITION_KEY", pks);
        }
    }

    @Check
    public void checkNaming(TableEntity table) {
        if (ModelUtil.containsEscapedQuote(ModelUtil.stripName(table.getName()))) {
            this.error("table name cannot contain escaped quote(\")", (EStructuralFeature)CqlPackage.Literals.TABLE_ENTITY__NAME, "INVALID_NAME_BECAUSE_IT_CONTAINS_ESCAPED_QUOTE", new String[0]);
        } else if (ModelUtil.isUnquotedMixedCase(table.getName())) {
            this.warning("unquoted table name is case insensitive", (EStructuralFeature)CqlPackage.Literals.TABLE_ENTITY__NAME, "caseInsensitiveName", new String[0]);
        }
        CqlContext context = this.contextProvider.get(table);
        CqlStatement stmt = ModelUtil.getCqlStatement(table);
        KeyspaceEntity keyspace = ModelUtil.getKeyspace(stmt);
        if (keyspace == null && StringUtils.isEmpty((String)context.getSchemaToCheck().getCurrentKeyspaceName())) {
            this.error("no keyspace has been specified", (EStructuralFeature)CqlPackage.Literals.TABLE_ENTITY__NAME, "EMPTY_CURRENT_KEYSPACE", new String[0]);
        }
    }

    @Check
    public void checkTableNameLength(TableEntity table) {
        int maxLength = 48;
        if (table.getName() != null && table.getName().length() > maxLength) {
            this.error("Table name is too long (max size is " + maxLength + " characters)", (EStructuralFeature)CqlPackage.Literals.TABLE_ENTITY__NAME, "TABLE_NAME_IS_TOO_LONG", new String[0]);
        }
    }

    @Check
    public void checkKeyspaceNameLength(KeyspaceEntity keyspace) {
        int maxLength = 48;
        if (keyspace != null && keyspace.getName() != null && keyspace.getName().length() > maxLength) {
            this.error("Keyspace name is too long (max size is " + maxLength + " characters)", (EStructuralFeature)CqlPackage.Literals.KEYSPACE_ENTITY__NAME, "KEYSPACE_NAME_IS_TOO_LONG", new String[0]);
        }
    }

    @Check
    public void checkNaming(ColumnEntity column) {
        if (ModelUtil.containsEscapedQuote(ModelUtil.stripName(column.getName()))) {
            this.error("column name cannot contain escaped quote(\")", (EStructuralFeature)CqlPackage.Literals.COLUMN_ENTITY__NAME, "INVALID_NAME_BECAUSE_IT_CONTAINS_ESCAPED_QUOTE", new String[0]);
        } else if (ModelUtil.isUnquotedMixedCase(column.getName())) {
            this.warning("unquoted column name is case insensitive", (EStructuralFeature)CqlPackage.Literals.COLUMN_ENTITY__NAME, "caseInsensitiveName", new String[0]);
        }
    }

    @Check
    public void checkNaming(TypeEntity type) {
        if (ModelUtil.containsEscapedQuote(ModelUtil.stripName(type.getName()))) {
            this.error("type name cannot contain escaped quote(\")", (EStructuralFeature)CqlPackage.Literals.TYPE_ENTITY__NAME, "INVALID_NAME_BECAUSE_IT_CONTAINS_ESCAPED_QUOTE", new String[0]);
        } else if (ModelUtil.isUnquotedMixedCase(type.getName())) {
            this.warning("unquoted type name is case insensitive", (EStructuralFeature)CqlPackage.Literals.TYPE_ENTITY__NAME, "caseInsensitiveName", new String[0]);
        }
        CqlContext context = this.contextProvider.get(type);
        CqlStatement stmt = ModelUtil.getCqlStatement(type);
        KeyspaceEntity keyspace = ModelUtil.getKeyspace(stmt);
        if (keyspace == null && StringUtils.isEmpty((String)context.getSchemaToCheck().getCurrentKeyspaceName())) {
            this.error("no keyspace has been specified", (EStructuralFeature)CqlPackage.Literals.TYPE_ENTITY__NAME, "EMPTY_CURRENT_KEYSPACE", new String[0]);
        }
    }

    @Check
    public void checkNaming(FieldEntity field) {
        InsertStatement insert = ModelUtil.getAncestorOfType(field, InsertStatement.class);
        if (insert != null && insert.getJsonInsertPart() != null) {
            return;
        }
        if (ModelUtil.containsEscapedQuote(ModelUtil.stripName(field.getName()))) {
            this.error("field name cannot contain escaped quote(\")", (EStructuralFeature)CqlPackage.Literals.FIELD_ENTITY__NAME, "INVALID_NAME_BECAUSE_IT_CONTAINS_ESCAPED_QUOTE", new String[0]);
        } else if (ModelUtil.isUnquotedMixedCase(field.getName())) {
            this.warning("unquoted field name is case insensitive", (EStructuralFeature)CqlPackage.Literals.FIELD_ENTITY__NAME, "caseInsensitiveName", new String[0]);
        }
    }

    @Check
    public void checkNaming(UserOrRoleEntity userOrRole) {
        if (ModelUtil.containsEscapedQuote(ModelUtil.stripName(userOrRole.getName()))) {
            this.error("role name cannot contain escaped quote(\")", (EStructuralFeature)CqlPackage.Literals.USER_OR_ROLE_ENTITY__NAME, "INVALID_NAME_BECAUSE_IT_CONTAINS_ESCAPED_QUOTE", new String[0]);
        } else if (ModelUtil.isUnquotedMixedCase(userOrRole.getName())) {
            this.warning("unquoted role name is case insensitive", (EStructuralFeature)CqlPackage.Literals.USER_OR_ROLE_ENTITY__NAME, "caseInsensitiveName", new String[0]);
        }
    }

    @Check
    public void checkUserTypeKeyspaceNames(Type type) {
        if (type.getUserType() != null) {
            String udtKeyspaceName;
            CqlContext context = this.contextProvider.get(type);
            CqlStatement stmt = ModelUtil.getCqlStatement(type);
            KeyspaceEntity stmtKeyspace = ModelUtil.getKeyspace(stmt);
            String stmtKeyspaceName = stmtKeyspace != null ? stmtKeyspace.getName() : context.getSchemaToCheck().getCurrentKeyspaceName();
            KeyspaceEntity udtKeyspace = type.getUdtKeyspace();
            String string = udtKeyspaceName = udtKeyspace != null ? udtKeyspace.getName() : stmtKeyspaceName;
            if (!(udtKeyspaceName.equalsIgnoreCase(stmtKeyspaceName) || ModelUtil.containedInFunctionDDL(type) && udtKeyspaceName.equalsIgnoreCase("system"))) {
                this.error(String.format("Statement on keyspace %s cannot refer to a user type in keyspace %s; user types can only be used in the keyspace they are defined in", stmtKeyspaceName, udtKeyspaceName), (EStructuralFeature)CqlPackage.Literals.TYPE__UDT_KEYSPACE, "STATEMENT_ON_KEYSPACE_CANNOT_REFER_TO_A_USER_TYPE_IN_KEYSPACE_USER_TYPES_CAN_ONLY_BE_USED_IN_THE_KEYSPACE_THEY_ARE_DEFINED_IN", new String[0]);
            }
        }
    }

    @Check
    public void checkNaming(KeyspaceEntity keyspace) {
        if (ModelUtil.containsEscapedQuote(ModelUtil.stripName(keyspace.getName()))) {
            this.error("keyspace name cannot contain escaped quote(\")", (EStructuralFeature)CqlPackage.Literals.KEYSPACE_ENTITY__NAME, "INVALID_NAME_BECAUSE_IT_CONTAINS_ESCAPED_QUOTE", new String[0]);
        } else if (!ModelUtil.syntaxErrorsExistWithin(keyspace) && ModelUtil.isUnquotedMixedCase(keyspace.getName())) {
            this.warning("unquoted keyspace name is case insensitive", (EStructuralFeature)CqlPackage.Literals.KEYSPACE_ENTITY__NAME, "caseInsensitiveName", new String[0]);
        }
    }

    @Check
    public void checkNaming(IndexEntity index) {
        if (!ModelUtil.syntaxErrorsExistWithin(index) && index.getName() != null) {
            String indexName = index.getName();
            if (ModelUtil.containsEscapedQuote(ModelUtil.stripName(indexName))) {
                this.error("index name cannot contain escaped quote(\")", (EStructuralFeature)CqlPackage.Literals.INDEX_ENTITY__NAME, "INVALID_NAME_BECAUSE_IT_CONTAINS_ESCAPED_QUOTE", new String[0]);
            } else {
                CqlContext cqlContext = this.contextProvider.get(index);
                if (ModelUtil.isUnquotedMixedCase(indexName) && cqlContext.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_1_0)) {
                    this.warning("unquoted index name is case insensitive", (EStructuralFeature)CqlPackage.Literals.INDEX_ENTITY__NAME, "caseInsensitiveName", new String[0]);
                }
            }
        }
    }

    @Check
    public void checkNaming(TriggerEntity trigger) {
        if (ModelUtil.containsEscapedQuote(ModelUtil.stripName(trigger.getName()))) {
            this.error("trigger name cannot contain escaped quote(\")", (EStructuralFeature)CqlPackage.Literals.TRIGGER_ENTITY__NAME, "INVALID_NAME_BECAUSE_IT_CONTAINS_ESCAPED_QUOTE", new String[0]);
        } else if (ModelUtil.isUnquotedMixedCase(trigger.getName())) {
            this.warning("unquoted trigger name is case insensitive", (EStructuralFeature)CqlPackage.Literals.TRIGGER_ENTITY__NAME, "caseInsensitiveName", new String[0]);
        }
    }

    @Check
    public void checkFunctionArguments(Term term) {
        if (term == null || term.getFunctionName() == null) {
            return;
        }
        String name = term.getFunctionName().getName();
        if (term.getArgs() == null || term.getArgs().getArgs() == null) {
            return;
        }
        this.assertNoArgument(name, (List<? extends Object>)term.getArgs().getArgs(), (EStructuralFeature)CqlPackage.Literals.RULES_WITH_FUNCTION_ARGS__ARGS);
    }

    @Check
    public void checkFunctionArguments(SelectorFunction selectorFunction) {
        if (selectorFunction == null || selectorFunction.getFunctionName() == null) {
            return;
        }
        String name = selectorFunction.getFunctionName().getName();
        if (selectorFunction.getArgs() == null || selectorFunction.getArgs().getSelectors() == null) {
            return;
        }
        this.assertNoArgument(name, (List<? extends Object>)selectorFunction.getArgs().getSelectors(), (EStructuralFeature)CqlPackage.Literals.SELECTOR_FUNCTION__ARGS);
    }

    private void assertNoArgument(String name, List<? extends Object> list, EStructuralFeature feature) {
        if (list != null && name.toLowerCase().equals("now") && list.size() > 0) {
            this.error("function now() doesn't have arguments", feature);
        }
        if (list != null && name.toLowerCase().equals("uuid") && list.size() > 0) {
            this.error("function uuid() doesn't have arguments", feature);
        }
    }

    @Check
    public void insertIntoColumnTermNeedToBeSameLength(StandardInsertStatement stmt) {
        if (stmt.getColumns() != null && stmt.getColumns().size() > 0) {
            if (stmt.getColumns().size() != stmt.getTerms().size()) {
                int column_size = stmt.getColumns().size();
                int term_size = stmt.getTerms().size();
                int idx = Math.min(column_size, term_size);
                while (idx < Math.max(column_size, term_size)) {
                    if (idx < column_size) {
                        this.error("numbers of identities and terms are unequal", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMNS_REF__COLUMNS, idx, "COLUMNS_TERMS_NOT_EQUAL_LENGTH", new String[0]);
                    }
                    if (idx < term_size) {
                        this.error("numbers of identities and terms are unequal", (EStructuralFeature)CqlPackage.Literals.STANDARD_INSERT_STATEMENT__TERMS, idx, "COLUMNS_TERMS_NOT_EQUAL_LENGTH", new String[0]);
                    }
                    ++idx;
                }
            }
        } else {
            this.error("no arguments", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMNS_REF__COLUMNS);
        }
    }

    @Check
    public void checkCast(Term term) {
        if (term == null || term.getCastType() == null) {
            return;
        }
        Type castType = term.getCastType();
        Term castTerm = term.getTerm();
        CqlDataType castCqlDataType = CqlDataTypeFactory.fromGrammarType(castType, null);
        if (!castCqlDataType.validate(castTerm)) {
            String termStr = this.serializer.serialize((EObject)castTerm);
            this.error(String.format("Cannot cast value %s to type %s", termStr, castCqlDataType), (EStructuralFeature)CqlPackage.Literals.TERM__CAST_TYPE, "NOT_EQUAL_TYPE", new String[0]);
        }
    }
}

