/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.CreateIndexStatement;
import com.datastax.devcenter.cql.cql.IndexColumnDef;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.Index;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class CreateDropIndexStatementValidator
extends UtilityValidator {
    @Check
    public void indexOnCounter(CreateIndexStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta == null || stmt.getIndexColumnDef().getColumn() == null) {
            return;
        }
        Column columnMeta = tableMeta.getColumn(ModelUtil.stripName(stmt.getIndexColumnDef().getColumn().getName()));
        if (columnMeta != null && columnMeta.getType().equals(NativeCqlDataType.COUNTER)) {
            this.error("Secondary indexes are not supported on counter tables", (EStructuralFeature)CqlPackage.Literals.CREATE_INDEX_STATEMENT__INDEX_COLUMN_DEF, "SECONDARY_INDEXES_ARE_NOT_SUPPORTED_ON_COUNTER_TABLES", new String[0]);
        }
    }

    @Check
    public void customIndexNeedClass(CreateIndexStatement stmt) {
        if (stmt.isCustom() && (stmt.getIndexClass() == null || stmt.getIndexClass().equals(""))) {
            this.error("CUSTOM index requires specifying the index class", (EStructuralFeature)CqlPackage.Literals.CREATE_INDEX_STATEMENT__CUSTOM, "CUSTOM_INDEX_REQUIRES_SPECIFIYING_THE_INDEX_CLASS", new String[0]);
        }
    }

    @Check
    public void customIndexClassForNonCustomIndex(CreateIndexStatement stmt) {
        if (!stmt.isCustom() && stmt.getIndexClass() != null) {
            this.error("Cannot specify index class for a non-CUSTOM index", (EStructuralFeature)CqlPackage.Literals.CREATE_INDEX_STATEMENT__INDEX_CLASS, "CANNOT_SPECIFY_INDEX_CLASS_FOR_A_NON_CUSTOM_INDEX", new String[0]);
        }
    }

    @Check
    public void customIndexOptionsForNonCustomIndex(CreateIndexStatement stmt) {
        if (!stmt.isCustom() && !stmt.getProperties().isEmpty()) {
            this.error("Cannot specify options for a non-CUSTOM index", (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_PROPERTIES__PROPERTIES, "CANNOT_SPECIFY_OPTIONS_FOR_A_NON_CUSTOM_INDEX", new String[0]);
        }
    }

    @Check
    public void indexOnCompactTable(CreateIndexStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta != null && tableMeta.isCompactStorage()) {
            this.error("Secondary index on compact table is not yet supported", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_TABLE_REF__TABLE, "SECONDARY_INDEX_ON_COLUMN_IS_NOT_YET_SUPPORTED_FOR_COMPACT_TABLE", new String[0]);
        }
    }

    @Check
    public void indexOnPartitionKey(IndexColumnDef rule) {
        CreateIndexStatement stmt = ModelUtil.getAncestorOfType(rule, CreateIndexStatement.class);
        if (stmt == null) {
            return;
        }
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta != null && stmt.getIndexColumnDef().getColumn() != null && tableMeta.isPartitionKeyContain(ModelUtil.stripName(stmt.getIndexColumnDef().getColumn().getName()))) {
            this.error("Cannot add secondary index to already primarily indexed column", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "CANNOT_ADD_SECONDARY_INDEX_TO_ALREADY_PRIMARILY_INDEXED_COLUMN", new String[0]);
        }
    }

    @Check
    public void indexOnMapKeys(IndexColumnDef rule) {
        CreateIndexStatement stmt = ModelUtil.getAncestorOfType(rule, CreateIndexStatement.class);
        if (stmt == null) {
            return;
        }
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta == null) {
            return;
        }
        String colName = this.getOrResolveColumnName(rule);
        Column colMeta = tableMeta.getColumn(colName);
        if (colMeta != null && rule.isKeys() && !colMeta.getType().isMap()) {
            this.error("Cannot create index on keys of column with non-map type", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "CANNOT_CREATE_INDEX_ON_KEYS_OF_COLUMN_WITH_NON-MAP_TYPE", new String[0]);
        }
    }

    @Check
    public void checkSingleIndexOnMapColumn(IndexColumnDef rule) {
        CreateIndexStatement stmt = ModelUtil.getAncestorOfType(rule, CreateIndexStatement.class);
        if (stmt == null || this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0) && ModelUtil.hasIfNotExistsClause(stmt)) {
            return;
        }
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta == null) {
            return;
        }
        String colName = this.getOrResolveColumnName(rule);
        Column colMeta = tableMeta.getColumn(colName);
        if (colMeta != null && colMeta.getType().isMap()) {
            Schema schema = this.getSchemaToCheck(rule);
            for (Index existingIndex : schema.getIndices()) {
                Column indexCol = existingIndex.getColumn();
                if (!indexCol.getType().isMap() || !indexCol.getName().equals(colName)) continue;
                if (rule.isKeys()) {
                    this.error("Cannot create index on keys, an index on values already exists and indexing a map on both keys and values at the same time is not currently supported", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "CANNOT_CREATE_INDEX_ON_FEATURES_KEYS_AN_INDEX_ON_FEATURES_VALUES_ALREADY_EXISTS_AND_INDEXING_A_MAP_ON_BOTH_KEYS_AND_VALUES_AT_THE_SAME_TIME_IS_NOT_CURRENTLY_SUPPORTED", new String[0]);
                    continue;
                }
                if (rule.isFull()) continue;
                this.error("Cannot create index on values, an index on keys already exists and indexing a map on both keys and values at the same time is not currently supported", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "CANNOT_CREATE_INDEX_ON_FEATURES_KEYS_AN_INDEX_ON_FEATURES_VALUES_ALREADY_EXISTS_AND_INDEXING_A_MAP_ON_BOTH_KEYS_AND_VALUES_AT_THE_SAME_TIME_IS_NOT_CURRENTLY_SUPPORTED", new String[0]);
            }
        }
    }

    @Check
    public void fullIndexOnCollection(IndexColumnDef indexColumnDef) {
        CqlDataType columnType;
        CreateIndexStatement stmt = ModelUtil.getAncestorOfType(indexColumnDef, CreateIndexStatement.class);
        if (!indexColumnDef.isFull() || stmt == null || !this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_1_3)) {
            return;
        }
        ColumnEntity indexColumn = indexColumnDef.getColumn();
        Table tableMeta = this.getTableMeta(stmt);
        if (indexColumn == null || tableMeta == null) {
            return;
        }
        Column columnMeta = tableMeta.getColumn(ModelUtil.stripName(indexColumn.getName()));
        if (columnMeta != null && (!(columnType = columnMeta.getType()).isCollection() || columnType.isCollection() && !columnType.isFrozen())) {
            this.error("full() indexes can only be created on frozen collections", (EStructuralFeature)CqlPackage.Literals.INDEX_COLUMN_DEF__FULL, "FULL_INDEXES_CAN_ONLY_BE_CREATED_ON_FROZEN_COLLECTIONS", new String[0]);
        }
    }

    @Check
    public void indexOnFrozenCollection(IndexColumnDef indexColumnDef) {
        CqlDataType columnType;
        CreateIndexStatement stmt = ModelUtil.getAncestorOfType(indexColumnDef, CreateIndexStatement.class);
        if (indexColumnDef.isFull() || stmt == null || !this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_1_3)) {
            return;
        }
        ColumnEntity indexColumn = indexColumnDef.getColumn();
        Table tableMeta = this.getTableMeta(stmt);
        if (indexColumn == null || tableMeta == null) {
            return;
        }
        Column columnMeta = tableMeta.getColumn(ModelUtil.stripName(indexColumn.getName()));
        if (columnMeta != null && (columnType = columnMeta.getType()).isCollection() && columnType.isFrozen()) {
            this.error("Frozen collections currently only support full-collection indexes", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "FROZEN_COLLECTIONS_CURRENTLY_ONLY_SUPPORT_FULL_COLLECTION_INDEXES", new String[0]);
        }
    }

    @Check
    public void entriesIndexOnMap(IndexColumnDef indexColumnDef) {
        CqlDataType columnType;
        CreateIndexStatement stmt = ModelUtil.getAncestorOfType(indexColumnDef, CreateIndexStatement.class);
        if (!indexColumnDef.isEntries() || stmt == null || !this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_2_0)) {
            return;
        }
        ColumnEntity indexColumn = indexColumnDef.getColumn();
        Table tableMeta = this.getTableMeta(stmt);
        if (indexColumn == null || tableMeta == null) {
            return;
        }
        Column columnMeta = tableMeta.getColumn(ModelUtil.stripName(indexColumn.getName()));
        if (columnMeta != null && (!(columnType = columnMeta.getType()).isMap() || columnType.isMap() && columnType.isFrozen())) {
            this.error(String.format("Cannot create index on entries of column %s; only non-frozen maps support entries indexes", indexColumn.getName()), (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "CANNOT_CREATE_ENTRIES_INDEX_ONLY_NON_FROZEN_MAPS_SUPPORT_ENTRIES_INDEX", new String[0]);
        }
    }

    @Check
    public void multipleIndicesOnColumn(IndexColumnDef indexColumnDef) {
        ColumnEntity indexColumn = indexColumnDef.getColumn();
        CreateIndexStatement stmt = ModelUtil.getAncestorOfType(indexColumnDef, CreateIndexStatement.class);
        if (stmt == null || indexColumn == null) {
            return;
        }
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta == null) {
            return;
        }
        Column columnMeta = tableMeta.getColumn(ModelUtil.stripName(indexColumn.getName()));
        if (columnMeta != null) {
            if (columnMeta.getType().isMap()) {
                return;
            }
            if (columnMeta.getIndex() != null && !ModelUtil.hasIfNotExistsClause(stmt)) {
                this.error("Index already exists on column " + indexColumn.getName(), (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "INDEX_ALREADY_EXISTS", new String[0]);
            }
        }
    }
}

