/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.CreateTypeStatement;
import com.datastax.devcenter.cql.cql.DropTypeStatement;
import com.datastax.devcenter.cql.cql.TypeFieldDef;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CqlDataTypeFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class CreateDropTypeStatementValidator
extends UtilityValidator {
    @Check
    public void checkUserTypeForCycles(CreateTypeStatement stmt) {
        UserType userTypeMeta = this.contextProvider.get(stmt).getUserTypeMeta(stmt);
        if (userTypeMeta != null) {
            Keyspace keyspaceMeta = userTypeMeta.getKeyspace();
            int fieldIndex = 0;
            for (TypeFieldDef f : stmt.getUserTypeFieldDefs()) {
                CqlDataType fieldCqlDataType = CqlDataTypeFactory.fromGrammarType(f.getType(), keyspaceMeta);
                if (fieldCqlDataType != null && fieldCqlDataType.isReachableFrom(userTypeMeta)) {
                    this.error("Cannot add type because it would create a cycle", (EStructuralFeature)CqlPackage.Literals.CREATE_TYPE_STATEMENT__USER_TYPE_FIELD_DEFS, fieldIndex, "CANNOT_ADD_TYPE_BECAUSE_IT_WOULD_CREATE_A_CYCLE", new String[0]);
                }
                ++fieldIndex;
            }
        }
    }

    @Check
    public void checkUserTypeReferences(DropTypeStatement stmt) {
        UserType droppedUserTypeMeta = this.contextProvider.get(stmt).getUserTypeMeta(stmt);
        if (droppedUserTypeMeta != null) {
            Keyspace keyspaceMeta = droppedUserTypeMeta.getKeyspace();
            for (UserType userType : keyspaceMeta.getUserTypes()) {
                for (UserTypeField typeField : userType.getFields()) {
                    CqlDataType fieldCqlDataType = typeField.getType();
                    if (fieldCqlDataType == null || !fieldCqlDataType.isReachableFrom(droppedUserTypeMeta)) continue;
                    this.error(String.format("Cannot drop type because it is referenced by field %s in User-defined type %s", typeField.getName(), userType.getName()), (EStructuralFeature)CqlPackage.Literals.RULES_WITH_TYPE_REF__USER_TYPE, "CANNOT_DROP_TYPE_BECAUSE_IT_IS_REFERENCED_BY_A_FIELD_OR_COLMN", new String[0]);
                }
            }
            for (Table table : keyspaceMeta.getTables()) {
                for (Column column : table.getColumns()) {
                    CqlDataType colCqlDataType = column.getType();
                    if (colCqlDataType == null || !colCqlDataType.isReachableFrom(droppedUserTypeMeta)) continue;
                    this.error(String.format("Cannot drop type because it is referenced by column %s in table %s", column.getName(), table.getName()), (EStructuralFeature)CqlPackage.Literals.RULES_WITH_TYPE_REF__USER_TYPE, "CANNOT_DROP_TYPE_BECAUSE_IT_IS_REFERENCED_BY_A_FIELD_OR_COLMN", new String[0]);
                }
            }
        }
    }
}

