/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.ColumnDef;
import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.CreateTableStatement;
import com.datastax.devcenter.cql.cql.PrimaryKeyDefinition;
import com.datastax.devcenter.cql.cql.TableOrdering;
import com.datastax.devcenter.cql.cql.TableProperty;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class CreateTableStatementValidator
extends UtilityValidator {
    private boolean isCompositePrimaryKey(ColumnDef columnDef) {
        return columnDef.isPrimaryKey() && columnDef.getColumn() == null;
    }

    @Check
    public void addNonCounterColumnInCounterFamily(CreateTableStatement stmt) {
        List<String> primaryKeys = this.collectPrimaryKeyNames((List<ColumnDef>)stmt.getColumnDefinitions());
        if (this.hasCounter(stmt.getColumnDefinitions())) {
            int i = 0;
            while (i < stmt.getColumnDefinitions().size()) {
                ColumnDef tc = (ColumnDef)stmt.getColumnDefinitions().get(i);
                if (!(this.isCompositePrimaryKey(tc) || this.isCounter(tc) || tc.getColumn().getName() == null || primaryKeys.contains(tc.getColumn().getName()))) {
                    this.error("For a table with counter columns, all columns except the primary key must be type counter", (EStructuralFeature)CqlPackage.Literals.CREATE_TABLE_STATEMENT__COLUMN_DEFINITIONS, i, "CANNOT_ADD_A_NON_COUNTER_COLUMN_IN_A_COUNTER_COLUMN_FAMILY", new String[0]);
                }
                ++i;
            }
        }
    }

    @Check
    public void noMoreThanOneNonPrimaryKeyForCompactStorage(CreateTableStatement stmt) {
        if (this.hasCompactStorage((List<TableProperty>)stmt.getProperties()) && this.collectClusteringKeyNames((List<ColumnDef>)stmt.getColumnDefinitions()).size() > 0) {
            List<String> primaryKeyNames = this.collectPrimaryKeyNames((List<ColumnDef>)stmt.getColumnDefinitions());
            int nonPrimaryKey = 0;
            int i = 0;
            while (i < stmt.getColumnDefinitions().size()) {
                ColumnDef tc = (ColumnDef)stmt.getColumnDefinitions().get(i);
                if (!this.isCompositePrimaryKey(tc)) {
                    String defName = tc.getColumn().getName();
                    if (!primaryKeyNames.contains(defName)) {
                        ++nonPrimaryKey;
                    }
                    if (nonPrimaryKey > 1) {
                        this.error("COMPACT STORAGE with composite PRIMARY KEY allows no more than one column not part of the PRIMARY KEY", (EStructuralFeature)CqlPackage.Literals.CREATE_TABLE_STATEMENT__COLUMN_DEFINITIONS, i, "COMPACT_STORAGE_WITH_COMPOSITE_PRIMARY_KEY_ALLOWS_NO_MORE_THAN_ONE_COLUMN_NOT_PART_OF_THE_PRIMARY_KEY", new String[0]);
                    }
                }
                ++i;
            }
        }
    }

    @Check
    public void sameClusteringOrder(TableProperty tableProperty) {
        if (tableProperty.isClustering() && tableProperty.getOrderings() != null) {
            CreateTableStatement stmt = ModelUtil.getAncestorOfType(tableProperty, CreateTableStatement.class);
            if (stmt == null) {
                return;
            }
            List<String> cks = this.collectClusteringKeyNames((List<ColumnDef>)stmt.getColumnDefinitions());
            int i = 0;
            while (i < tableProperty.getOrderings().size()) {
                TableOrdering ordering = (TableOrdering)tableProperty.getOrderings().get(i);
                if (ordering.getColumn() != null) {
                    String n = ordering.getColumn().getName();
                    if (i < cks.size() && !cks.get(i).equals(n)) {
                        this.error(String.format("The order of columns in CLUSTERING ORDER directive must be the one of the clustering key, expecting %s", cks.get(i)), (EStructuralFeature)CqlPackage.Literals.TABLE_PROPERTY__ORDERINGS, i, "THE_ORDER_OF_COLUMNS_IN_THE_CLUSTERING_ORDER_DIRECTIVE_MUST_BE_THE_ONE_OF_THE_CLUSTERING_KEY_MUST_APPEAR_BEFORE", new String[0]);
                    }
                }
                ++i;
            }
        }
    }

    @Check
    public void missingClusteringOrder(TableOrdering order) {
        if (order.getOrder() == null) {
            this.error("CLUSTERING ORDER is mandatory in CREATE TABLE statement, either ASC or DESC", (EStructuralFeature)CqlPackage.Literals.TABLE_ORDERING__ORDER, "MISSING_CLUSTERING_ORDER_FOR_COLUMN_", new String[0]);
        }
    }

    @Check
    public void missingClustering(TableProperty tableProperty) {
        if (tableProperty.isClustering() && tableProperty.getOrderings() != null) {
            CreateTableStatement stmt = ModelUtil.getAncestorOfType(tableProperty, CreateTableStatement.class);
            this.collectClusteringKeyNames((List<ColumnDef>)stmt.getColumnDefinitions());
            tableProperty.getOrderings();
        }
    }

    @Check
    public void counterPrimaryKeyPart(ColumnDef columnDef) {
        if (columnDef.isPrimaryKey() && columnDef.getType() != null && columnDef.getType().getNativeType() != null && columnDef.getType().getNativeType().equalsIgnoreCase("counter")) {
            this.error("counter type is not supported for PRIMARY KEY part", (EStructuralFeature)CqlPackage.Literals.COLUMN_DEF__TYPE, "COUNTER_TYPE_IS_NOT_SUPPORTED_FOR_PRIMARY_KEY_PART", new String[0]);
        }
    }

    @Check
    public void counterPrimaryKeyPart(PrimaryKeyDefinition pkdef) {
        CreateTableStatement stmt = ModelUtil.getAncestorOfType(pkdef, CreateTableStatement.class);
        if (stmt == null) {
            return;
        }
        HashSet<String> counters = new HashSet<String>();
        for (ColumnDef colDef : stmt.getColumnDefinitions()) {
            if (colDef.getType() == null || colDef.getType().getNativeType() == null || !colDef.getType().getNativeType().equalsIgnoreCase("counter") || colDef.getColumn().getName() == null) continue;
            counters.add(colDef.getColumn().getName());
        }
        if (pkdef.getColumn() != null && counters.contains(pkdef.getColumn().getName())) {
            this.error("counter type is not supported for PRIMARY KEY part", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "COUNTER_TYPE_IS_NOT_SUPPORTED_FOR_PRIMARY_KEY_PART", new String[0]);
        }
        int i = 0;
        while (i < pkdef.getColumns().size()) {
            ColumnEntity col = (ColumnEntity)pkdef.getColumns().get(i);
            if (col != null && counters.contains(col.getName())) {
                this.error("counter type is not supported for PRIMARY KEY part", (EStructuralFeature)CqlPackage.Literals.COLUMN_ENTITY__NAME, i, "COUNTER_TYPE_IS_NOT_SUPPORTED_FOR_PRIMARY_KEY_PART", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void staticPrimaryKeyPart(ColumnDef columnDef) {
        if (columnDef.isPrimaryKey() && columnDef.isStaticColumn()) {
            this.error("Static column cannot be part of the PRIMARY KEY", (EStructuralFeature)CqlPackage.Literals.COLUMN_DEF__TYPE, "STATIC_COLUMN_CANNOT_BE_PART_OF_THE_PRIMARY_KEY", new String[0]);
        }
    }

    @Check
    public void staticPrimaryKeyPart(PrimaryKeyDefinition pkdef) {
        CreateTableStatement stmt = ModelUtil.getAncestorOfType(pkdef, CreateTableStatement.class);
        if (stmt == null) {
            return;
        }
        HashSet<String> staticCols = new HashSet<String>();
        for (ColumnDef colDef : stmt.getColumnDefinitions()) {
            if (!colDef.isStaticColumn() || colDef.getColumn().getName() == null) continue;
            staticCols.add(colDef.getColumn().getName());
        }
        if (pkdef.getColumn() != null && staticCols.contains(pkdef.getColumn().getName())) {
            this.error("Static column cannot be part of the PRIMARY KEY", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "STATIC_COLUMN_CANNOT_BE_PART_OF_THE_PRIMARY_KEY", new String[0]);
        }
        for (ColumnEntity tableColRef : pkdef.getColumns()) {
            if (!staticCols.contains(tableColRef.getName())) continue;
            this.error("Static column cannot be part of the PRIMARY KEY", (EStructuralFeature)CqlPackage.Literals.PRIMARY_KEY_DEFINITION__COLUMNS, "STATIC_COLUMN_CANNOT_BE_PART_OF_THE_PRIMARY_KEY", new String[0]);
        }
    }

    @Check
    public void checkStaticRequiresClusteringColumn(CreateTableStatement stmt) {
        boolean hasStaticColumn = false;
        boolean hasClusteringColumns = false;
        for (ColumnDef colDef : stmt.getColumnDefinitions()) {
            if (colDef.isStaticColumn()) {
                hasStaticColumn = true;
            }
            if (colDef.getPrimaryKeyDefinitions() == null || colDef.getPrimaryKeyDefinitions().size() <= 1) continue;
            hasClusteringColumns = true;
        }
        if (hasStaticColumn && !hasClusteringColumns) {
            int colIndex = 0;
            while (colIndex < stmt.getColumnDefinitions().size()) {
                ColumnDef colDef = (ColumnDef)stmt.getColumnDefinitions().get(colIndex);
                if (colDef.getColumn().getName() != null && colDef.isStaticColumn()) {
                    this.error("Static columns are only useful (and thus allowed) if the table has at least one clustering column", (EStructuralFeature)CqlPackage.Literals.CREATE_TABLE_STATEMENT__COLUMN_DEFINITIONS, colIndex, "Static columns are only useful (and thus allowed) if the table has at least one clustering column", new String[0]);
                }
                ++colIndex;
            }
        }
    }

    @Check
    public void checkStaticCompactStorage(ColumnDef columnDef) {
        CreateTableStatement stmt = ModelUtil.getAncestorOfType(columnDef, CreateTableStatement.class);
        if (stmt == null) {
            return;
        }
        for (TableProperty prop : stmt.getProperties()) {
            if (!prop.isCompactStorage() || !columnDef.isStaticColumn()) continue;
            this.error("Static columns are not supported in COMPACT STORAGE tables", (EStructuralFeature)CqlPackage.Literals.COLUMN_DEF__TYPE, "Static columns are not supported in COMPACT STORAGE tables", new String[0]);
        }
    }

    @Check
    public void checkCreateDuplicateColumnName(CreateTableStatement stmt) {
        if (stmt.getColumnDefinitions() == null) {
            return;
        }
        HashSet<String> declaredColumns = new HashSet<String>();
        int i = 0;
        while (i < stmt.getColumnDefinitions().size()) {
            ColumnDef colDef = (ColumnDef)stmt.getColumnDefinitions().get(i);
            if (colDef.getColumn() != null && colDef.getColumn().getName() != null) {
                String colName = colDef.getColumn().getName();
                if (declaredColumns.contains(colName)) {
                    this.error(String.format("Multiple definition of column %s", ModelUtil.stripName(colName)), (EStructuralFeature)CqlPackage.Literals.CREATE_TABLE_STATEMENT__COLUMN_DEFINITIONS, i, "MULTIPLE_DEFINITION_OF_IDENTIFIER_", new String[0]);
                } else {
                    declaredColumns.add(colName);
                }
            }
            ++i;
        }
    }

    @Check
    public void checkPrimaryKeyDeclaredOnlyOnce(CreateTableStatement stmt) {
        if (ModelUtil.syntaxErrorsExistWithin(stmt)) {
            return;
        }
        LinkedList<Integer> pks = new LinkedList<Integer>();
        int i = 0;
        while (i < stmt.getColumnDefinitions().size()) {
            ColumnDef colDef = (ColumnDef)stmt.getColumnDefinitions().get(i);
            if (colDef.isPrimaryKey()) {
                pks.add(i);
            }
            ++i;
        }
        if (pks.size() > 1) {
            for (Integer i2 : pks) {
                this.error("You must specify one and only one PRIMARY KEY", (EStructuralFeature)CqlPackage.Literals.CREATE_TABLE_STATEMENT__COLUMN_DEFINITIONS, i2, "YOU_MUST_SPECIFY_ONE_AND_ONLY_ONE_PRIMARY_KEY", new String[0]);
            }
        } else if (pks.size() == 0) {
            this.error("You must specify one and only one PRIMARY KEY", (EStructuralFeature)CqlPackage.Literals.CREATE_TABLE_STATEMENT__COLUMN_DEFINITIONS, "YOU_MUST_SPECIFY_ONE_AND_ONLY_ONE_PRIMARY_KEY", new String[0]);
        }
    }

    private int indexOfCompactStorage(List<TableProperty> props) {
        if (props == null) {
            return -1;
        }
        int i = 0;
        while (i < props.size()) {
            TableProperty prop = props.get(i);
            if (prop.isCompactStorage()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private <T> List<T> converToList(Set<T> elements) {
        LinkedList<T> r = new LinkedList<T>();
        for (T t : elements) {
            r.add(t);
        }
        return r;
    }

    private List<String> collectPrimaryKeyNames(List<ColumnDef> columnDefs) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (columnDefs == null) {
            return Collections.emptyList();
        }
        for (ColumnDef columnDef : columnDefs) {
            if (columnDef.isPrimaryKey() && columnDef.getColumn() != null && columnDef.getColumn().getName() != null) {
                keys.add(columnDef.getColumn().getName());
            }
            if (columnDef.getPrimaryKeyDefinitions() == null) continue;
            for (PrimaryKeyDefinition pkdef : columnDef.getPrimaryKeyDefinitions()) {
                if (pkdef.getColumn() != null) {
                    keys.add(pkdef.getColumn().getName());
                    continue;
                }
                if (pkdef.getColumns() == null) continue;
                for (ColumnEntity tableColRef : pkdef.getColumns()) {
                    keys.add(tableColRef.getName());
                }
            }
        }
        return this.converToList(keys);
    }

    private List<String> collectClusteringKeyNames(List<ColumnDef> columnDefs) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (columnDefs == null) {
            return Collections.emptyList();
        }
        for (ColumnDef tableColumn : columnDefs) {
            if (tableColumn.getPrimaryKeyDefinitions() == null) continue;
            int i = 1;
            while (i < tableColumn.getPrimaryKeyDefinitions().size()) {
                PrimaryKeyDefinition pkdef = (PrimaryKeyDefinition)tableColumn.getPrimaryKeyDefinitions().get(i);
                if (pkdef.getColumn() != null) {
                    keys.add(pkdef.getColumn().getName());
                }
                ++i;
            }
        }
        return this.converToList(keys);
    }

    @Check
    public void allArePrimaryKeyForCompactStorage(CreateTableStatement stmt) {
        if (this.hasCompactStorage((List<TableProperty>)stmt.getProperties()) && stmt.getColumnDefinitions() != null) {
            List<String> primaryKeys = this.collectPrimaryKeyNames((List<ColumnDef>)stmt.getColumnDefinitions());
            boolean hasNonPrimaryKey = false;
            for (ColumnDef colDef : stmt.getColumnDefinitions()) {
                if (colDef.isPrimaryKey() || colDef.getColumn().getName() == null || primaryKeys.contains(colDef.getColumn().getName())) continue;
                hasNonPrimaryKey = true;
                break;
            }
            if (!hasNonPrimaryKey) {
                int idx = this.indexOfCompactStorage((List<TableProperty>)stmt.getProperties());
                this.error("No definition found that is not part of the PRIMARY KEY while using COMPACT STORAGE", (EStructuralFeature)CqlPackage.Literals.STATEMENTS_WITH_PROPERTIES__PROPERTIES, idx, "NO_DEFINITION_FOUND_THAT_IS_NOT_PART_OF_THE_PRIMARY_KEY", new String[0]);
            }
        }
    }

    @Check
    public void CollectionInCompactStorage(ColumnDef columnDef) {
        CreateTableStatement stmt = ModelUtil.getAncestorOfType(columnDef, CreateTableStatement.class);
        if (stmt == null) {
            return;
        }
        for (TableProperty prop : stmt.getProperties()) {
            if (!prop.isCompactStorage() || columnDef.getType() == null || columnDef.getType().getCollectionType() == null) continue;
            this.error("Collection types are not supported with COMPACT STORAGE", (EStructuralFeature)CqlPackage.Literals.COLUMN_DEF__TYPE, "COLLECTION_TYPES_ARE_NOT_SUPPORTED_WITH_COMPACT_STORAGE", new String[0]);
        }
    }

    @Check
    public void ClusteringOrderNonClusteringKey(TableProperty prop) {
        if (!prop.isClustering()) {
            return;
        }
        CreateTableStatement stmt = ModelUtil.getAncestorOfType(prop, CreateTableStatement.class);
        HashSet<String> clusteringKeys = new HashSet<String>();
        for (ColumnDef columnDef : stmt.getColumnDefinitions()) {
            if (!columnDef.isPrimaryKey()) continue;
            int i = 1;
            while (i < columnDef.getPrimaryKeyDefinitions().size()) {
                PrimaryKeyDefinition pkdef = (PrimaryKeyDefinition)columnDef.getPrimaryKeyDefinitions().get(i);
                if (pkdef.getColumn() != null) {
                    clusteringKeys.add(pkdef.getColumn().getName());
                }
                ++i;
            }
        }
        int i = 0;
        while (i < prop.getOrderings().size()) {
            TableOrdering ordering = (TableOrdering)prop.getOrderings().get(i);
            if (ordering.getColumn() != null && !clusteringKeys.contains(ordering.getColumn().getName())) {
                this.error("Only clustering key columns can be defined in CLUSTERING ORDER directive", (EStructuralFeature)CqlPackage.Literals.TABLE_PROPERTY__ORDERINGS, i, "ONLY_CLUSTERING_KEY_COLUMNS_CAN_BE_DEFINED_IN_CLUSTERING_ORDER_DIRECTIVE", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void checkPartitionKeyIsNotCollection(ColumnDef tableColumn) {
        if (tableColumn.isPrimaryKey() && tableColumn.getType() != null && tableColumn.getType().getCollectionType() != null) {
            this.error("Partition key cannot be collection type", (EStructuralFeature)CqlPackage.Literals.COLUMN_DEF__TYPE, "COLLECTIVE_PARTITION_KEY", new String[0]);
        }
    }

    @Check
    public void checkPartitionKeyIsNotCollection(PrimaryKeyDefinition pkDef) {
        CreateTableStatement stmt = ModelUtil.getAncestorOfType(pkDef, CreateTableStatement.class);
        if (stmt == null) {
            return;
        }
        if (pkDef.getColumn() != null) {
            for (ColumnDef columnDef : stmt.getColumnDefinitions()) {
                if (this.isCompositePrimaryKey(columnDef) || !columnDef.getColumn().getName().equals(pkDef.getColumn().getName())) continue;
                if (columnDef.getType().getCollectionType() == null) break;
                this.error("Partition key cannot be collection type", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "COLLECTIVE_PARTITION_KEY", new String[0]);
                break;
            }
        }
        if (pkDef.getColumns() != null) {
            int i = 0;
            while (i < pkDef.getColumns().size()) {
                String columnName = ((ColumnEntity)pkDef.getColumns().get(i)).getName();
                for (ColumnDef tableColumn : stmt.getColumnDefinitions()) {
                    if (!tableColumn.getColumn().getName().equals(columnName)) continue;
                    if (tableColumn.getType().getCollectionType() == null) break;
                    this.error("Partition key cannot be collection type", (EStructuralFeature)CqlPackage.Literals.PRIMARY_KEY_DEFINITION__COLUMNS, i, "COLLECTIVE_PARTITION_KEY", new String[0]);
                    break;
                }
                ++i;
            }
        }
    }

    private boolean hasCompactStorage(List<TableProperty> props) {
        if (props == null) {
            return false;
        }
        for (TableProperty prop : props) {
            if (!prop.isCompactStorage()) continue;
            return true;
        }
        return false;
    }
}

