/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.CollectionType;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.ListType;
import com.datastax.devcenter.cql.cql.MapType;
import com.datastax.devcenter.cql.cql.SetType;
import com.datastax.devcenter.cql.cql.TupleType;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.TypeFieldDef;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class DataTypeValidator
extends UtilityValidator {
    @Check
    public void checkNestedMap(MapType mapType) {
        if (this.isFrozenCollectionSupported()) {
            if (!this.isFrozen(mapType)) {
                if (this.isCollectionType(mapType.getT1()) || this.isTupleType(mapType.getT1())) {
                    this.error("Non-frozen collections are not allowed inside collections", (EStructuralFeature)CqlPackage.Literals.MAP_TYPE__T1, "NON_FROZEN_COLLECTIONS_ARE_NOT_ALLOWED_INSIDE_COLLECTIONS", new String[0]);
                }
                if (this.isCollectionType(mapType.getT2()) || this.isTupleType(mapType.getT2())) {
                    this.error("Non-frozen collections are not allowed inside collections", (EStructuralFeature)CqlPackage.Literals.MAP_TYPE__T2, "NON_FROZEN_COLLECTIONS_ARE_NOT_ALLOWED_INSIDE_COLLECTIONS", new String[0]);
                }
            }
        } else {
            if (this.isCollectionType(mapType.getT1())) {
                this.error("Map type cannot contain another collection", (EStructuralFeature)CqlPackage.Literals.MAP_TYPE__T1, "MAP_TYPE_CANNOT_CONTAIN_ANOTHER_COLLECTION", new String[0]);
            }
            if (this.isCollectionType(mapType.getT2())) {
                this.error("Map type cannot contain another collection", (EStructuralFeature)CqlPackage.Literals.MAP_TYPE__T2, "MAP_TYPE_CANNOT_CONTAIN_ANOTHER_COLLECTION", new String[0]);
            }
        }
    }

    @Check
    public void checkNestedList(ListType listType) {
        if (this.isFrozenCollectionSupported()) {
            if (!this.isFrozen(listType) && (this.isCollectionType(listType.getT()) || this.isTupleType(listType.getT()))) {
                this.error("Non-frozen collections are not allowed inside collections", (EStructuralFeature)CqlPackage.Literals.LIST_TYPE__T, "NON_FROZEN_COLLECTIONS_ARE_NOT_ALLOWED_INSIDE_COLLECTIONS", new String[0]);
            }
        } else if (this.isCollectionType(listType.getT())) {
            this.error("List type cannot contain another collection", (EStructuralFeature)CqlPackage.Literals.LIST_TYPE__T, "LIST_TYPE_CANNOT_CONTAIN_ANOTHER_COLLECTION", new String[0]);
        }
    }

    @Check
    public void checkNestedSet(SetType setType) {
        if (this.isFrozenCollectionSupported()) {
            if (!this.isFrozen(setType) && (this.isCollectionType(setType.getT()) || this.isTupleType(setType.getT()))) {
                this.error("Non-frozen collections are not allowed inside collections", (EStructuralFeature)CqlPackage.Literals.SET_TYPE__T, "NON_FROZEN_COLLECTIONS_ARE_NOT_ALLOWED_INSIDE_COLLECTIONS", new String[0]);
            }
        } else if (this.isCollectionType(setType.getT())) {
            this.error("Set type cannot contain another collection", (EStructuralFeature)CqlPackage.Literals.SET_TYPE__T, "SET_TYPE_CANNOT_CONTAIN_ANOTHER_COLLECTION", new String[0]);
        }
    }

    @Check
    public void checkCounterInCollection(CollectionType collectionType) {
        SetType setType;
        if (collectionType instanceof MapType) {
            MapType mapType = (MapType)collectionType;
            if (this.isCounterType(mapType.getT1())) {
                this.error("Counters are not allowed inside a collection", (EStructuralFeature)CqlPackage.Literals.MAP_TYPE__T1, "COUNTERS_ARE_NOT_ALLOWED_INSIDE_A_COLLECTION", new String[0]);
            }
            if (this.isCounterType(mapType.getT2())) {
                this.error("Counters are not allowed inside a collection", (EStructuralFeature)CqlPackage.Literals.MAP_TYPE__T2, "COUNTERS_ARE_NOT_ALLOWED_INSIDE_A_COLLECTION", new String[0]);
            }
        } else if (collectionType instanceof ListType) {
            ListType listType = (ListType)collectionType;
            if (this.isCounterType(listType.getT())) {
                this.error("Counters are not allowed inside a collection", (EStructuralFeature)CqlPackage.Literals.LIST_TYPE__T, "COUNTERS_ARE_NOT_ALLOWED_INSIDE_A_COLLECTION", new String[0]);
            }
        } else if (collectionType instanceof SetType && this.isCounterType((setType = (SetType)collectionType).getT())) {
            this.error("Counters are not allowed inside a collection", (EStructuralFeature)CqlPackage.Literals.SET_TYPE__T, "COUNTERS_ARE_NOT_ALLOWED_INSIDE_A_COLLECTION", new String[0]);
        }
    }

    @Check
    public void checkCounterInTuple(TupleType tupleType) {
        for (Type tupleElementType : tupleType.getTupleTypes()) {
            if (!this.isCounterType(tupleElementType)) continue;
            this.error("Counters are not allowed in tuples", (EStructuralFeature)CqlPackage.Literals.TUPLE_TYPE__TUPLE_TYPES, "COUNTERS_ARE_NOT_ALLOWED_INSIDE_TUPLES", new String[0]);
        }
    }

    @Check
    public void checkCounterInTypeField(TypeFieldDef typeFieldDef) {
        Type userType = typeFieldDef.getType();
        if (this.isCounterType(userType)) {
            this.error("Counters are not allowed in User-Defined types", (EStructuralFeature)CqlPackage.Literals.TYPE_FIELD_DEF__TYPE, "COUNTERS_ARE_NOT_ALLOWED_INSIDE_USER_DEFINED_TYPES", new String[0]);
        }
    }

    @Check
    public void checkFrozenTypes(Type type) {
        Type frozenType = type.getFrozenType();
        if (frozenType != null) {
            if (this.isCollectionType(frozenType) && !this.isFrozenCollectionSupported()) {
                this.error("frozen<> is currently only allowed on User-Defined and tuple types", (EStructuralFeature)CqlPackage.Literals.TYPE__COLLECTION_TYPE, "FROZEN_IS_CURRENTLY_ONLY_ALLOWED_ON_USER_DEFINED_AND_TUPLE_TYPES", new String[0]);
            }
            if (this.isCustomType(frozenType)) {
                if (this.isFrozenCollectionSupported()) {
                    this.error("frozen<> is only allowed on collections, tuples, and user-defined types", (EStructuralFeature)CqlPackage.Literals.TYPE__CUSTOM_TYPE, "FROZEN_IS_ONLY_ALLOWED_ON_COLLECTIONS_TUPLES_AND_USER_DEFINED_TYPES", new String[0]);
                } else {
                    this.error("frozen<> is currently only allowed on User-Defined and tuple types", (EStructuralFeature)CqlPackage.Literals.TYPE__CUSTOM_TYPE, "FROZEN_IS_CURRENTLY_ONLY_ALLOWED_ON_USER_DEFINED_AND_TUPLE_TYPES", new String[0]);
                }
            }
            if (this.isNativeType(frozenType)) {
                if (this.isFrozenCollectionSupported()) {
                    this.error("frozen<> is only allowed on collections, tuples, and user-defined types", (EStructuralFeature)CqlPackage.Literals.TYPE__NATIVE_TYPE, "FROZEN_IS_ONLY_ALLOWED_ON_COLLECTIONS_TUPLES_AND_USER_DEFINED_TYPES", new String[0]);
                } else {
                    this.error("frozen<> is currently only allowed on User-Defined and tuple types", (EStructuralFeature)CqlPackage.Literals.TYPE__NATIVE_TYPE, "FROZEN_IS_CURRENTLY_ONLY_ALLOWED_ON_USER_DEFINED_AND_TUPLE_TYPES", new String[0]);
                }
            }
            if (this.isFrozenType(frozenType)) {
                this.warning("frozen<> unnecessarily nested", (EStructuralFeature)CqlPackage.Literals.TYPE__NATIVE_TYPE, "FROZEN_KEYWORD_UNNECESSARILY_NESTED", new String[0]);
            }
            if (ModelUtil.containedInFunctionDDL(type)) {
                this.error("The function arguments should not be frozen; remove the frozen<> modifier", (EStructuralFeature)CqlPackage.Literals.TYPE__CUSTOM_TYPE, "FROZEN_IS_NOT_ALLOWED_ON_FUNCTION_ARGUMENTS", new String[0]);
            }
        } else if (!ModelUtil.containedInFunctionDDL(type)) {
            if (this.isTupleType(type) && !this.isContainerFrozen(type) && this.isFrozenRequiredForTuples()) {
                this.error("Non-frozen tuples are not supported, please use frozen<>", (EStructuralFeature)CqlPackage.Literals.TYPE__TUPLE, "NON_FROZEN_TUPLES_ARE_NOT_SUPPORTED", new String[0]);
            } else if (this.isUserType(type)) {
                if (this.isFrozenCollectionSupported()) {
                    if (!this.isFrozen(type)) {
                        this.error("Non-frozen User-defined types are not supported, please use frozen<>", (EStructuralFeature)CqlPackage.Literals.TYPE__FROZEN_TYPE, "NON_FROZEN_USER_DEFINED_TYPES_ARE_NOT_SUPPORTED", new String[0]);
                    }
                } else if (!this.isContainerFrozen(type)) {
                    this.error("Non-frozen User-defined types are not supported, please use frozen<>", (EStructuralFeature)CqlPackage.Literals.TYPE__FROZEN_TYPE, "NON_FROZEN_USER_DEFINED_TYPES_ARE_NOT_SUPPORTED", new String[0]);
                }
            }
        }
    }
}

