/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.DeleteOp;
import com.datastax.devcenter.cql.cql.DeleteStatement;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.MapCqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import com.datastax.devcenter.schema.types.SetCqlDataType;
import java.util.HashSet;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class DeleteStatementValidator
extends UtilityValidator {
    @Check
    public void deletePrimaryKey(DeleteStatement stmt) {
        Table tableMeta = this.getTableMeta(stmt);
        if (tableMeta == null) {
            return;
        }
        HashSet<String> pks = new HashSet<String>();
        for (Column col : tableMeta.getClusteringKeys()) {
            pks.add(col.getName());
        }
        for (Column col : tableMeta.getPartitionKeys()) {
            pks.add(col.getName());
        }
        int i = 0;
        while (i < stmt.getSelections().size()) {
            DeleteOp op = (DeleteOp)stmt.getSelections().get(i);
            if (op.getColumn() != null && pks.contains(ModelUtil.stripName(op.getColumn().getName()))) {
                this.error("Cannot delete PRIMARY KEY part", (EStructuralFeature)CqlPackage.Literals.DELETE_STATEMENT__SELECTIONS, i, "INVALID_IDENTIFIER_FOR_DELETION_SHOULD_NOT_BE_A_PRIMARY_KEY_PART", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void deleteOp(DeleteOp deleteOp) {
        if (deleteOp.getTerm() == null) {
            return;
        }
        Schema schema = this.getSchemaToCheck(deleteOp);
        Table cfMeta = this.getTableMeta(deleteOp);
        Column colMeta = this.getColumnMetadata(deleteOp.getColumn(), cfMeta);
        if (colMeta == null) {
            return;
        }
        CqlDataType colType = colMeta.getType();
        if (colType != null) {
            if (colType.isCollection() && colType.isFrozen()) {
                this.error("Invalid delete operation for frozen collection column", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "INVALID_DELETE_OPERATION_FOR_FROZEN_COLLECTION_COLUMN", new String[0]);
            } else if (!colType.isCollection()) {
                this.error("Invalid delete operation for non-collection column", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, "INVALID_DELETE_OPERATION_FOR_NON_COLLECTION_COLUMN", new String[0]);
            } else {
                CqlDataType elementType = colType.isMap() ? ((MapCqlDataType)colType).getKeyType() : (colType.isSet() ? ((SetCqlDataType)colType).getElementType() : NativeCqlDataType.INT);
                this.validateTermAgainstColumnType(deleteOp.getTerm(), elementType, colMeta, schema, cfMeta.getKeyspace(), (EStructuralFeature)CqlPackage.Literals.DELETE_OP__TERM);
            }
        }
    }
}

