/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.cql.AlterTableStatement;
import com.datastax.devcenter.cql.cql.AlterTypeStatement;
import com.datastax.devcenter.cql.cql.ColumnDef;
import com.datastax.devcenter.cql.cql.ColumnEntity;
import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.CqlStatement;
import com.datastax.devcenter.cql.cql.CreateIndexStatement;
import com.datastax.devcenter.cql.cql.CreateKeyspaceStatement;
import com.datastax.devcenter.cql.cql.CreateRoleStatement;
import com.datastax.devcenter.cql.cql.CreateTableStatement;
import com.datastax.devcenter.cql.cql.CreateTriggerStatement;
import com.datastax.devcenter.cql.cql.CreateTypeStatement;
import com.datastax.devcenter.cql.cql.CreateUserStatement;
import com.datastax.devcenter.cql.cql.DropFunctionStatement;
import com.datastax.devcenter.cql.cql.DropIndexStatement;
import com.datastax.devcenter.cql.cql.DropTriggerStatement;
import com.datastax.devcenter.cql.cql.FieldEntity;
import com.datastax.devcenter.cql.cql.FunctionDeclarationStatement;
import com.datastax.devcenter.cql.cql.GrantStatement;
import com.datastax.devcenter.cql.cql.IndexEntity;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.PrimaryKeyDefinition;
import com.datastax.devcenter.cql.cql.RevokeStatement;
import com.datastax.devcenter.cql.cql.RulesWithColumnRef;
import com.datastax.devcenter.cql.cql.RulesWithColumnsRef;
import com.datastax.devcenter.cql.cql.RulesWithKeyspaceRef;
import com.datastax.devcenter.cql.cql.RulesWithTableRef;
import com.datastax.devcenter.cql.cql.RulesWithTypeRef;
import com.datastax.devcenter.cql.cql.RulesWithUserOrRoleRef;
import com.datastax.devcenter.cql.cql.RulesWithUserRef;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.Selector;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.TableOrdering;
import com.datastax.devcenter.cql.cql.TriggerEntity;
import com.datastax.devcenter.cql.cql.TypeEntity;
import com.datastax.devcenter.cql.cql.UserEntity;
import com.datastax.devcenter.cql.cql.UserOrRoleEntity;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.CqlConstants;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.types.UserDefinedTypeCqlDataType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.validation.Check;

public class ExistenceValidator
extends UtilityValidator {
    private static final String ALTER_TABLE_OP_DROP = "drop";
    private static final String ALTER_TABLE_OP_ALTER = "alter";
    private static final String ALTER_TABLE_OP_ADD = "add";
    private static final String ALTER_TABLE_OP_RENAME = "rename";
    private static final String KEYSPACE_ENTITY = "Keyspace";
    private static final String TABLE_ENTITY = "Table";
    private static final String COLUMN_ENTITY = "Column";
    private static final String TYPE_ENTITY = "Type";
    private static final String FIELD_ENTITY = "Field";
    private static final String TRIGGER_ENTITY = "Trigger";
    private static final String INDEX_ENTITY = "Index";
    private static final String USER_OR_ROLE_ENTITY = "User or Role";
    private static final String ENTITY_ALREADY_EXISTS = "%s %s already exists";
    private static final String ENTITY_ALREADY_EXISTS_IN_CONTEXT = "%s %s already exists in current context, but not in the database";
    private static final String ENTITY_ALREADY_EXISTS_IN_ENTITY = "%s %s already exists in %s %s";
    private static final String ENTITY_ALREADY_EXISTS_IN_ENTITY_IN_CONTEXT = "%s %s already exists in %s %s in current context, but not in the database";
    private static final String ENTITY_DOES_NOT_EXIST = "%s %s doesn't exist";
    private static final String ENTITY_DOES_NOT_EXIST_IN_CONTEXT = "%s %s doesn't exist in current context, but does in the database";
    private static final String ENTITY_DOES_NOT_EXIST_IN_ENTITY = "%s %s doesn't exist in %s %s";
    private static final String ENTITY_DOES_NOT_EXIST_IN_ENTITY_IN_CONTEXT = "%s %s doesn't exist in %s %s in current context, but does in the database";
    private static final String PK_COLUMN_MUST_BE_DECLARED = "Primary key column %s must be declared in table %s";
    private static final String PK_PARTITION_KEY_NOT_FIRST = "The partition key must come first in the primary key definition";
    private static final String PK_COLUMN_REPEATED = "Primary key column %s cannot be repeated";

    @Check
    public void checkKeyspaceExist(RulesWithKeyspaceRef rule) {
        KeyspaceEntity keyspaceEntity = rule.getKeyspace();
        if (keyspaceEntity == null) {
            return;
        }
        CqlStatement stmt = ModelUtil.getCqlStatement(rule);
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0) && ModelUtil.hasIfExistsClause(stmt)) {
            return;
        }
        String keyspaceName = ModelUtil.stripName(this.getOrResolveKeyspaceName(rule));
        this.assertKeyspaceExists(this.contextProvider.get(rule), keyspaceEntity, keyspaceName, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_KEYSPACE_REF__KEYSPACE);
    }

    private void assertKeyspaceExists(CqlContext context, KeyspaceEntity keyspaceEntity, String keyspaceName, EStructuralFeature feature) {
        if (!context.isKeyspaceExistInCurrentContext(keyspaceEntity)) {
            if (!context.isKeyspaceExistInDatabase(keyspaceEntity)) {
                this.error(String.format(ENTITY_DOES_NOT_EXIST, KEYSPACE_ENTITY, keyspaceName), feature, "KeyspaceNotExist", new String[]{keyspaceName});
            } else {
                this.warning(String.format(ENTITY_DOES_NOT_EXIST_IN_CONTEXT, KEYSPACE_ENTITY, keyspaceName), feature, "KeyspaceNotExist", new String[]{keyspaceName});
            }
        }
    }

    @Check
    public void checkKeyspaceNotExist(CreateKeyspaceStatement stmt) {
        CqlContext context = this.contextProvider.get(stmt);
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0) && ModelUtil.hasIfNotExistsClause(stmt)) {
            return;
        }
        this.assertKeyspaceDoesNotExist(context, stmt.getKeyspace(), (EStructuralFeature)CqlPackage.Literals.CREATE_KEYSPACE_STATEMENT__KEYSPACE);
    }

    private void assertKeyspaceDoesNotExist(CqlContext context, KeyspaceEntity keyspaceEntity, EStructuralFeature feature) {
        if (context.isKeyspaceExistInCurrentContext(keyspaceEntity)) {
            String keyspaceName = ModelUtil.stripName(keyspaceEntity.getName());
            if (context.isKeyspaceExistInDatabase(keyspaceEntity)) {
                this.error(String.format(ENTITY_ALREADY_EXISTS, KEYSPACE_ENTITY, keyspaceName), feature, "KeyspaceExist", new String[]{keyspaceName});
            } else {
                this.warning(String.format(ENTITY_ALREADY_EXISTS_IN_CONTEXT, KEYSPACE_ENTITY, keyspaceName), feature, "KeyspaceExist", new String[]{keyspaceName});
            }
        }
    }

    @Check
    public void checkTableExist(RulesWithTableRef rule) {
        TableEntity tableEntity = rule.getTable();
        if (tableEntity == null) {
            return;
        }
        CqlStatement stmt = ModelUtil.getCqlStatement(rule);
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0) && ModelUtil.hasIfExistsClause(stmt)) {
            return;
        }
        String keyspaceName = ModelUtil.stripName(this.getOrResolveKeyspaceName((RulesWithKeyspaceRef)((Object)rule)));
        if (keyspaceName == null) {
            return;
        }
        String tableName = ModelUtil.stripName(this.getOrResolveTableName(rule));
        this.assertTableExistInKeyspace(this.contextProvider.get(rule), ModelUtil.getKeyspace(stmt), keyspaceName, rule.getTable(), tableName, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_TABLE_REF__TABLE);
    }

    private void assertTableExistInKeyspace(CqlContext context, KeyspaceEntity keyspaceEntity, String keyspaceName, TableEntity tableEntity, String tableName, EStructuralFeature feature) {
        if (!context.isTableExistInCurrentContext(keyspaceEntity, tableEntity)) {
            if (!context.isTableExistInDatabase(keyspaceEntity, tableEntity)) {
                this.error(String.format(ENTITY_DOES_NOT_EXIST_IN_ENTITY, TABLE_ENTITY, tableName, KEYSPACE_ENTITY.toLowerCase(), keyspaceName), feature, "TableNotExist", new String[]{tableName});
            } else {
                this.warning(String.format(ENTITY_DOES_NOT_EXIST_IN_ENTITY_IN_CONTEXT, TABLE_ENTITY, tableName, KEYSPACE_ENTITY.toLowerCase(), keyspaceName), feature, "TableNotExist", new String[]{tableName});
            }
        }
    }

    @Check
    public void checkTableNotExist(CreateTableStatement stmt) {
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0) && ModelUtil.hasIfNotExistsClause(stmt)) {
            return;
        }
        String keyspaceName = ModelUtil.stripName(this.getOrResolveKeyspaceName(stmt));
        this.assertTableNotExistInKeyspace(this.contextProvider.get(stmt), stmt.getKeyspace(), keyspaceName, stmt.getTable(), (EStructuralFeature)CqlPackage.Literals.CREATE_TABLE_STATEMENT__TABLE);
    }

    private void assertTableNotExistInKeyspace(CqlContext context, KeyspaceEntity keyspaceEntity, String keyspaceName, TableEntity tableEntity, EStructuralFeature feature) {
        if (context.isTableExistInCurrentContext(keyspaceEntity, tableEntity)) {
            String tableName = ModelUtil.stripName(tableEntity.getName());
            if (context.isTableExistInDatabase(keyspaceEntity, tableEntity)) {
                this.error(String.format(ENTITY_ALREADY_EXISTS_IN_ENTITY, TABLE_ENTITY, tableName, KEYSPACE_ENTITY.toLowerCase(), keyspaceName), feature, "TableExist", new String[]{tableName});
            } else {
                this.warning(String.format(ENTITY_ALREADY_EXISTS_IN_ENTITY_IN_CONTEXT, TABLE_ENTITY, tableName, KEYSPACE_ENTITY.toLowerCase(), keyspaceName), feature, "TableExist", new String[]{tableName});
            }
        }
    }

    @Check
    public void checkTypeExist(RulesWithTypeRef rule) {
        Object ddl;
        TypeEntity typeEntity = rule.getUserType();
        if (typeEntity == null) {
            return;
        }
        CqlStatement stmt = ModelUtil.getCqlStatement(rule);
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_1_0) && ModelUtil.hasIfExistsClause(stmt)) {
            return;
        }
        String keyspaceName = null;
        if (stmt instanceof RulesWithKeyspaceRef) {
            keyspaceName = ModelUtil.stripName(this.getOrResolveKeyspaceName((RulesWithKeyspaceRef)((Object)stmt)));
        } else if (stmt instanceof FunctionDeclarationStatement) {
            ddl = (FunctionDeclarationStatement)((Object)stmt);
            if (ddl.getFunction() != null && ddl.getFunction().getKeyspace() != null) {
                keyspaceName = ModelUtil.stripName(ddl.getFunction().getKeyspace().getName());
            }
        } else if (stmt instanceof DropFunctionStatement && (ddl = (DropFunctionStatement)stmt).getFunction() != null && ddl.getFunction().getKeyspace() != null) {
            keyspaceName = ModelUtil.stripName(ddl.getFunction().getKeyspace().getName());
        }
        String typeName = ModelUtil.stripName(this.getOrResolveTypeName(rule));
        if (keyspaceName != null) {
            this.assertTypeExistInKeyspace(this.contextProvider.get(rule), ModelUtil.getKeyspace(stmt), keyspaceName, rule.getUserType(), typeName, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_TYPE_REF__USER_TYPE);
        }
    }

    private void assertTypeExistInKeyspace(CqlContext context, KeyspaceEntity keyspaceEntity, String keyspaceName, TypeEntity typeEntity, String typeName, EStructuralFeature feature) {
        if (!context.isTypeExistInCurrentContext(keyspaceEntity, typeEntity)) {
            if (!context.isTypeExistInDatabase(keyspaceEntity, typeEntity)) {
                this.error(String.format(ENTITY_DOES_NOT_EXIST_IN_ENTITY, TYPE_ENTITY, typeName, KEYSPACE_ENTITY.toLowerCase(), keyspaceName), feature, "TypeNotExist", new String[]{typeName});
            } else {
                this.warning(String.format(ENTITY_DOES_NOT_EXIST_IN_ENTITY_IN_CONTEXT, TYPE_ENTITY, typeName, KEYSPACE_ENTITY.toLowerCase(), keyspaceName), feature, "TypeNotExist", new String[]{typeName});
            }
        }
    }

    @Check
    public void checkTypeNotExist(CreateTypeStatement stmt) {
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_1_0) && ModelUtil.hasIfNotExistsClause(stmt)) {
            return;
        }
        String keyspaceName = ModelUtil.stripName(this.getOrResolveKeyspaceName(stmt));
        this.assertTypeNotExistInKeyspace(this.contextProvider.get(stmt), stmt.getKeyspace(), keyspaceName, stmt.getUserType(), (EStructuralFeature)CqlPackage.Literals.CREATE_TYPE_STATEMENT__USER_TYPE);
    }

    private void assertTypeNotExistInKeyspace(CqlContext context, KeyspaceEntity keyspaceEntity, String keyspaceName, TypeEntity typeEntity, EStructuralFeature feature) {
        if (context.isTypeExistInCurrentContext(keyspaceEntity, typeEntity)) {
            String typeName = ModelUtil.stripName(typeEntity.getName());
            if (context.isTypeExistInDatabase(keyspaceEntity, typeEntity)) {
                this.error(String.format(ENTITY_ALREADY_EXISTS_IN_ENTITY, TYPE_ENTITY, typeName, KEYSPACE_ENTITY.toLowerCase(), keyspaceName), feature, "TypeExist", new String[]{typeName});
            } else {
                this.warning(String.format(ENTITY_ALREADY_EXISTS_IN_ENTITY_IN_CONTEXT, TYPE_ENTITY, typeName, KEYSPACE_ENTITY.toLowerCase(), keyspaceName), feature, "TypeExist", new String[]{typeName});
            }
        }
    }

    @Check
    public void checkUsernameExist(RulesWithUserRef rule) {
        CqlStatement stmt = ModelUtil.getCqlStatement(rule);
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_1_0) && ModelUtil.hasIfExistsClause(stmt)) {
            return;
        }
        String userName = ModelUtil.stripName(this.getOrResolveUserName(rule));
        if (StringUtils.isEmpty((String)userName)) {
            return;
        }
        this.assertUserExists(this.contextProvider.get(rule), userName, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_USER_REF__USER);
    }

    private void assertUserExists(CqlContext context, String userName, EStructuralFeature feature) {
        String userNameLowerCase;
        if (userName != null && !context.isUserExistInCurrentContext(userNameLowerCase = userName.toLowerCase())) {
            if (!context.isUserExistInDatabase(userNameLowerCase)) {
                this.error(String.format(ENTITY_DOES_NOT_EXIST, USER_OR_ROLE_ENTITY, userName), feature, "USER_DOES_NOT_EXIST", new String[]{userName});
            } else {
                this.warning(String.format(ENTITY_DOES_NOT_EXIST_IN_CONTEXT, USER_OR_ROLE_ENTITY, userName), feature, "USER_DOES_NOT_EXIST", new String[]{userName});
            }
        }
    }

    @Check
    public void checkUsernameNotExist(CreateUserStatement stmt) {
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_1_0) && ModelUtil.hasIfNotExistsClause(stmt)) {
            return;
        }
        UserEntity userEntity = stmt.getUser();
        if (userEntity != null) {
            String userName = ModelUtil.stripName(userEntity.getName());
            this.assertUserDoesNotExist(this.contextProvider.get(stmt), userName, (EStructuralFeature)CqlPackage.Literals.CREATE_USER_STATEMENT__USER);
        }
    }

    private void assertUserDoesNotExist(CqlContext context, String userName, EStructuralFeature feature) {
        String userNameLowerCase;
        String string = userNameLowerCase = userName == null ? null : userName.toLowerCase();
        if (context.isUserExistInCurrentContext(userNameLowerCase)) {
            if (context.isUserExistInDatabase(userNameLowerCase)) {
                this.error(String.format(ENTITY_ALREADY_EXISTS, USER_OR_ROLE_ENTITY, userName), feature, "USER_ALREADY_EXISTS", new String[]{userName});
            } else {
                this.warning(String.format(ENTITY_ALREADY_EXISTS_IN_CONTEXT, USER_OR_ROLE_ENTITY, userName), feature, "USER_ALREADY_EXISTS", new String[]{userName});
            }
        }
    }

    @Check
    public void checkUserOrRoleExist(RulesWithUserOrRoleRef rule) {
        CqlStatement stmt = ModelUtil.getCqlStatement(rule);
        if (ModelUtil.hasIfExistsClause(stmt)) {
            return;
        }
        String userOrRoleName = ModelUtil.stripName(this.getOrResolveUserOrRoleName(rule));
        if (StringUtils.isEmpty((String)userOrRoleName)) {
            return;
        }
        this.assertUserOrRoleExists(this.contextProvider.get(rule), userOrRoleName, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_USER_OR_ROLE_REF__USER_OR_ROLE);
    }

    @Check
    public void checkUserOrRoleExist(GrantStatement stmt) {
        String userOrRoleName = ModelUtil.stripName(this.getOrResolveUserOrRoleName(stmt));
        if (StringUtils.isEmpty((String)userOrRoleName)) {
            return;
        }
        this.assertUserOrRoleExists(this.contextProvider.get(stmt), userOrRoleName, (EStructuralFeature)CqlPackage.Literals.GRANT_STATEMENT__GRANTEE);
    }

    @Check
    public void checkUserOrRoleExist(RevokeStatement stmt) {
        String userOrRoleName = ModelUtil.stripName(this.getOrResolveUserOrRoleName(stmt));
        if (StringUtils.isEmpty((String)userOrRoleName)) {
            return;
        }
        this.assertUserOrRoleExists(this.contextProvider.get(stmt), userOrRoleName, (EStructuralFeature)CqlPackage.Literals.REVOKE_STATEMENT__REVOKEE);
    }

    private void assertUserOrRoleExists(CqlContext context, String userOrRoleName, EStructuralFeature feature) {
        if (!context.isUserOrRoleExistInCurrentContext(userOrRoleName)) {
            if (!context.isUserOrRoleExistInDatabase(userOrRoleName)) {
                this.error(String.format(ENTITY_DOES_NOT_EXIST, USER_OR_ROLE_ENTITY, userOrRoleName), feature, "USER_OR_ROLE_DOES_NOT_EXIST", new String[]{userOrRoleName});
            } else {
                this.warning(String.format(ENTITY_DOES_NOT_EXIST_IN_CONTEXT, USER_OR_ROLE_ENTITY, userOrRoleName), feature, "USER_OR_ROLE_DOES_NOT_EXIST", new String[]{userOrRoleName});
            }
        }
    }

    @Check
    public void checkUserOrRoleNotExist(CreateRoleStatement stmt) {
        if (ModelUtil.hasIfNotExistsClause(stmt)) {
            return;
        }
        UserOrRoleEntity userOrRoleEntity = stmt.getUserOrRole();
        if (userOrRoleEntity != null) {
            String userOrRoleName = ModelUtil.stripName(userOrRoleEntity.getName());
            this.assertUserOrRoleDoesNotExist(this.contextProvider.get(stmt), userOrRoleName, (EStructuralFeature)CqlPackage.Literals.CREATE_ROLE_STATEMENT__USER_OR_ROLE);
        }
    }

    private void assertUserOrRoleDoesNotExist(CqlContext context, String userOrRoleName, EStructuralFeature feature) {
        if (context.isUserOrRoleExistInCurrentContext(userOrRoleName)) {
            if (context.isUserOrRoleExistInDatabase(userOrRoleName)) {
                this.error(String.format(ENTITY_ALREADY_EXISTS, USER_OR_ROLE_ENTITY, userOrRoleName), feature, "USER_OR_ROLE_ALREADY_EXISTS", new String[]{userOrRoleName});
            } else {
                this.warning(String.format(ENTITY_ALREADY_EXISTS_IN_CONTEXT, USER_OR_ROLE_ENTITY, userOrRoleName), feature, "USER_OR_ROLE_ALREADY_EXISTS", new String[]{userOrRoleName});
            }
        }
    }

    @Check
    public void checkIndexExist(DropIndexStatement stmt) {
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0) && ModelUtil.hasIfExistsClause(stmt)) {
            return;
        }
        IndexEntity indexEntity = stmt.getIndex();
        if (indexEntity == null) {
            return;
        }
        String indexName = this.getOrResolveIndexName(stmt);
        this.assertIndexExist(this.contextProvider.get(stmt), indexEntity, indexName, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_INDEX_REF__INDEX);
    }

    private void assertIndexExist(CqlContext context, IndexEntity indexEntity, String indexName, EStructuralFeature feature) {
        if (!context.isIndexExistInCurrentContext(indexEntity)) {
            if (!context.isIndexExistInDatabase(indexEntity)) {
                this.error(String.format(ENTITY_DOES_NOT_EXIST, INDEX_ENTITY, indexName), feature, "IndexNotExist", new String[]{indexName});
            } else {
                this.warning(String.format(ENTITY_DOES_NOT_EXIST_IN_CONTEXT, INDEX_ENTITY, indexName), feature, "IndexNotExist", new String[]{indexName});
            }
        }
    }

    @Check
    public void checkIndexNotExist(CreateIndexStatement stmt) {
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0) && ModelUtil.hasIfNotExistsClause(stmt)) {
            return;
        }
        this.assertIndexNotExist(this.contextProvider.get(stmt), stmt.getIndex(), (EStructuralFeature)CqlPackage.Literals.CREATE_INDEX_STATEMENT__INDEX);
    }

    private void assertIndexNotExist(CqlContext context, IndexEntity indexEntity, EStructuralFeature feature) {
        if (context.isIndexExistInCurrentContext(indexEntity)) {
            String indexName = ModelUtil.stripName(indexEntity.getName());
            if (context.isIndexExistInDatabase(indexEntity)) {
                this.error(String.format(ENTITY_ALREADY_EXISTS, INDEX_ENTITY, indexName), feature, "IndexExist", new String[]{indexName});
            } else {
                this.warning(String.format(ENTITY_ALREADY_EXISTS_IN_CONTEXT, INDEX_ENTITY, indexName), feature, "IndexExist", new String[]{indexName});
            }
        }
    }

    @Check
    public void checkTriggerExist(DropTriggerStatement stmt) {
        if (!this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0)) {
            return;
        }
        TriggerEntity triggerEntity = stmt.getTrigger();
        if (triggerEntity == null) {
            return;
        }
        String triggerName = this.getOrResolveTriggerName(stmt);
        this.assertTriggerExist(this.contextProvider.get(stmt), triggerEntity, triggerName, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_TRIGGER_REF__TRIGGER);
    }

    private void assertTriggerExist(CqlContext context, TriggerEntity triggerEntity, String triggerName, EStructuralFeature feature) {
        if (!context.isTriggerExistInCurrentContext(triggerEntity)) {
            if (!context.isTriggerExistInDatabase(triggerEntity)) {
                this.error(String.format(ENTITY_DOES_NOT_EXIST, TRIGGER_ENTITY, triggerName), feature, "TriggerNotExist", new String[]{triggerName});
            } else {
                this.warning(String.format(ENTITY_DOES_NOT_EXIST_IN_CONTEXT, TRIGGER_ENTITY, triggerName), feature, "TriggerNotExist", new String[]{triggerName});
            }
        }
    }

    @Check
    public void checkTriggerNotExist(CreateTriggerStatement stmt) {
        if (!this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0)) {
            return;
        }
        this.assertTriggerNotExist(this.contextProvider.get(stmt), stmt.getTrigger(), (EStructuralFeature)CqlPackage.Literals.CREATE_TRIGGER_STATEMENT__TRIGGER);
    }

    private void assertTriggerNotExist(CqlContext context, TriggerEntity triggerEntity, EStructuralFeature feature) {
        if (context.isTriggerExistInCurrentContext(triggerEntity)) {
            String triggerName = ModelUtil.stripName(triggerEntity.getName());
            if (context.isTriggerExistInDatabase(triggerEntity)) {
                this.error(String.format(ENTITY_ALREADY_EXISTS, TRIGGER_ENTITY, triggerName), feature, "TriggerExist", new String[]{triggerName});
            } else {
                this.warning(String.format(ENTITY_ALREADY_EXISTS_IN_CONTEXT, TRIGGER_ENTITY, triggerName), feature, "TriggerExist", new String[]{triggerName});
            }
        }
    }

    @Check
    public void checkColumnExist(RulesWithColumnsRef rule) {
        CqlStatement stmt = ModelUtil.getCqlStatement(rule);
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0) && ModelUtil.hasIfExistsClause(stmt)) {
            return;
        }
        String tableName = ModelUtil.stripName(this.getOrResolveTableName((RulesWithTableRef)((Object)stmt)));
        int index = 0;
        for (ColumnEntity columnEntity : rule.getColumns()) {
            String columnName = ModelUtil.stripName(this.getOrResolveColumnName(rule, index));
            this.assertColumnExistInTable(this.contextProvider.get(stmt), columnEntity, columnName, ModelUtil.getKeyspace(stmt), ModelUtil.getTable(stmt), tableName, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMNS_REF__COLUMNS, index);
            ++index;
        }
    }

    @Check
    public void checkColumnExist(RulesWithColumnRef rule) {
        CqlStatement stmt = ModelUtil.getCqlStatement(rule);
        if (stmt instanceof CreateTableStatement) {
            return;
        }
        if (stmt instanceof AlterTableStatement) {
            this.checkAlterTableColumns((AlterTableStatement)stmt);
            return;
        }
        if (stmt instanceof SelectStatement && this.isAlias((SelectStatement)stmt, this.getOrResolveColumnName(rule))) {
            return;
        }
        ColumnEntity columnEntity = rule.getColumn();
        if (columnEntity == null) {
            return;
        }
        if (ModelUtil.isInFunction(rule, "token") || ModelUtil.isInFunction(rule, "now")) {
            return;
        }
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0) && ModelUtil.hasIfExistsClause(stmt)) {
            return;
        }
        String tableName = ModelUtil.stripName(this.getOrResolveTableName(stmt));
        String columnName = ModelUtil.stripName(this.getOrResolveColumnName(rule));
        this.assertColumnExistInTable(this.contextProvider.get(stmt), rule.getColumn(), columnName, ModelUtil.getKeyspace(stmt), ModelUtil.getTable(stmt), tableName, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, -1);
    }

    private void assertColumnExistInTable(CqlContext context, ColumnEntity columnEntity, String columnName, KeyspaceEntity keyspaceEntity, TableEntity tableEntity, String tableName, EStructuralFeature feature, int index) {
        if (!context.isIdExistInTableInCurrentContext(columnEntity, keyspaceEntity, tableEntity)) {
            EObject sourceObject = columnEntity.getSourceObject();
            if (!context.isIdExistInTableInDatabase(columnEntity, keyspaceEntity, tableEntity)) {
                if (sourceObject == null) {
                    this.issueError(String.format(ENTITY_DOES_NOT_EXIST_IN_ENTITY, COLUMN_ENTITY, columnName, TABLE_ENTITY, tableName), feature, index, "ColumnNotExist", columnName);
                } else {
                    this.error(String.format(ENTITY_DOES_NOT_EXIST_IN_ENTITY, COLUMN_ENTITY, columnName, TABLE_ENTITY, tableName), sourceObject, null, index, "ColumnNotExist", new String[]{columnName});
                }
            } else if (sourceObject == null) {
                this.issueWarning(String.format(ENTITY_DOES_NOT_EXIST_IN_ENTITY_IN_CONTEXT, COLUMN_ENTITY, columnName, TABLE_ENTITY, tableName), feature, index, "ColumnNotExist", columnName);
            } else {
                this.warning(String.format(ENTITY_DOES_NOT_EXIST_IN_ENTITY, COLUMN_ENTITY, columnName, TABLE_ENTITY, tableName), sourceObject.eContainer(), sourceObject.eContainingFeature(), index, "ColumnNotExist", new String[0]);
            }
        }
    }

    private void checkAlterTableColumns(AlterTableStatement stmt) {
        String op = stmt.getOperation().toLowerCase();
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace(stmt);
        TableEntity tableEntity = ModelUtil.getTable(stmt);
        String tableName = ModelUtil.stripName(this.getOrResolveTableName(stmt));
        if (op.equals(ALTER_TABLE_OP_RENAME)) {
            int idx = 0;
            for (ColumnEntity columnEntity : stmt.getNewColumns()) {
                this.assertColumnNotExistInTable(this.contextProvider.get(stmt), columnEntity, keyspaceEntity, tableEntity, (EStructuralFeature)CqlPackage.Literals.ALTER_TABLE_STATEMENT__NEW_COLUMNS, idx);
                ++idx;
            }
            idx = 0;
            List<INode> nodes = this.getCrossReferenceNames(stmt, (EStructuralFeature)CqlPackage.Literals.ALTER_TABLE_STATEMENT__OLD_COLUMNS);
            for (ColumnEntity columnEntity : stmt.getOldColumns()) {
                String columnName = columnEntity.getName() != null ? columnEntity.getName() : nodes.get(idx).getText().trim();
                this.assertColumnExistInTable(this.contextProvider.get(stmt), columnEntity, ModelUtil.stripName(columnName), keyspaceEntity, tableEntity, tableName, (EStructuralFeature)CqlPackage.Literals.ALTER_TABLE_STATEMENT__OLD_COLUMNS, idx);
                ++idx;
            }
        } else if (op.equals(ALTER_TABLE_OP_ADD) && stmt.getAddColumn() != null) {
            ColumnEntity columnEntity = stmt.getAddColumn();
            this.assertColumnNotExistInTable(this.contextProvider.get(stmt), columnEntity, keyspaceEntity, tableEntity, (EStructuralFeature)CqlPackage.Literals.ALTER_TABLE_STATEMENT__ADD_COLUMN, -1);
        } else if ((op.equals(ALTER_TABLE_OP_ALTER) || op.equals(ALTER_TABLE_OP_DROP)) && stmt.getColumn() != null) {
            this.assertColumnExistInTable(this.contextProvider.get(stmt), stmt.getColumn(), ModelUtil.stripName(this.getOrResolveColumnName(stmt)), keyspaceEntity, tableEntity, tableName, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, -1);
        }
    }

    private void assertColumnNotExistInTable(CqlContext context, ColumnEntity columnEntity, KeyspaceEntity keyspaceEntity, TableEntity tableEntity, EStructuralFeature feature, int index) {
        if (context.isIdExistInTableInCurrentContext(columnEntity, keyspaceEntity, tableEntity)) {
            String columnName = ModelUtil.stripName(columnEntity.getName());
            String tableName = ModelUtil.stripName(tableEntity.getName());
            if (context.isIdExistInTableInDatabase(columnEntity, keyspaceEntity, tableEntity)) {
                this.issueError(String.format(ENTITY_ALREADY_EXISTS_IN_ENTITY, COLUMN_ENTITY, columnName, TABLE_ENTITY.toLowerCase(), tableName), feature, index, "ColumnExist", columnName);
            } else {
                this.issueWarning(String.format(ENTITY_ALREADY_EXISTS_IN_ENTITY_IN_CONTEXT, COLUMN_ENTITY, columnName, TABLE_ENTITY.toLowerCase(), tableName), feature, index, "ColumnExist", columnName);
            }
        }
    }

    private void issueError(String message, EStructuralFeature feature, int index, String code, String ... issueData) {
        if (index >= 0) {
            this.error(message, feature, index, code, issueData);
        } else {
            this.error(message, feature, code, issueData);
        }
    }

    private void issueWarning(String message, EStructuralFeature feature, int index, String code, String ... issueData) {
        if (index >= 0) {
            this.warning(message, feature, index, code, issueData);
        } else {
            this.warning(message, feature, code, issueData);
        }
    }

    @Check
    public void checkTableOrderingColumnExist(TableOrdering rule) {
        CreateTableStatement stmt = ModelUtil.getAncestorOfType(rule, CreateTableStatement.class);
        if (stmt == null) {
            return;
        }
        String columnName = ModelUtil.stripName(this.getOrResolveColumnName(rule));
        this.assertTableOrderingColumnExistInCreateTable(stmt, rule.getColumn(), columnName);
    }

    private void assertTableOrderingColumnExistInCreateTable(CreateTableStatement stmt, ColumnEntity columnEntity, String columnName) {
        ArrayList<String> tableColumnNames = new ArrayList<String>();
        for (ColumnDef columnDef : stmt.getColumnDefinitions()) {
            if (columnDef.getColumn() == null || columnDef.getColumn().getName() == null) continue;
            tableColumnNames.add(columnDef.getColumn().getName());
        }
        if (columnEntity != null) {
            String tableName = ModelUtil.stripName(this.getOrResolveTableName(stmt));
            if (!tableColumnNames.contains(columnEntity.getName())) {
                this.issueError(String.format(ENTITY_DOES_NOT_EXIST_IN_ENTITY, COLUMN_ENTITY, columnName, TABLE_ENTITY, tableName), (EStructuralFeature)CqlPackage.Literals.RULES_WITH_COLUMN_REF__COLUMN, -1, "ColumnNotExist", columnName);
            }
        }
    }

    @Check
    public void checkPrimaryKeyIdExist(ColumnDef columnDef) {
        CreateTableStatement stmt = ModelUtil.getAncestorOfType(columnDef, CreateTableStatement.class);
        if (stmt == null) {
            return;
        }
        EList<PrimaryKeyDefinition> primaryKeyDefinitions = columnDef.getPrimaryKeyDefinitions();
        if (primaryKeyDefinitions == null || primaryKeyDefinitions.size() == 0) {
            return;
        }
        this.assertPartitionKeyPosition(primaryKeyDefinitions);
        this.assertPKColumnsExistInCreateTable(stmt, (List<PrimaryKeyDefinition>)primaryKeyDefinitions);
    }

    private void assertPartitionKeyPosition(EList<PrimaryKeyDefinition> primaryKeyDefinitions) {
        int checkIdx = 0;
        for (PrimaryKeyDefinition pkDef : primaryKeyDefinitions) {
            if (pkDef.getColumn() == null && checkIdx != 0) {
                this.error(PK_PARTITION_KEY_NOT_FIRST, (EStructuralFeature)CqlPackage.Literals.COLUMN_DEF__PRIMARY_KEY_DEFINITIONS, checkIdx, "partitionKeyError", new String[0]);
            }
            ++checkIdx;
        }
    }

    private void errorPKColumnDoesNotExist(ColumnEntity columnEntity, TableEntity tableEntity, int index) {
        this.error(String.format(PK_COLUMN_MUST_BE_DECLARED, ModelUtil.stripName(columnEntity.getName()), ModelUtil.stripName(tableEntity.getName())), (EStructuralFeature)CqlPackage.Literals.COLUMN_DEF__PRIMARY_KEY_DEFINITIONS, index, "primaryKeysDontExist", new String[0]);
    }

    private void assertPKColumnsExistInCreateTable(CreateTableStatement stmt, List<PrimaryKeyDefinition> primaryKeyDefinitions) {
        ArrayList<String> tableColumnNames = new ArrayList<String>();
        for (ColumnDef columnDef : stmt.getColumnDefinitions()) {
            if (columnDef.getColumn() == null || columnDef.getColumn().getName() == null) continue;
            tableColumnNames.add(columnDef.getColumn().getName());
        }
        HashSet<String> declaredColumns = new HashSet<String>();
        int pkColumnPosition = 0;
        for (PrimaryKeyDefinition pkdef : primaryKeyDefinitions) {
            ColumnEntity pkDefColumnEntity = pkdef.getColumn();
            if (pkDefColumnEntity != null) {
                if (!tableColumnNames.contains(pkDefColumnEntity.getName())) {
                    this.errorPKColumnDoesNotExist(pkDefColumnEntity, ModelUtil.getTable(stmt), pkColumnPosition);
                }
                this.assertPKColumnNotRepeated(declaredColumns, pkDefColumnEntity, pkColumnPosition);
            } else {
                int partitionKeyPosition = 0;
                for (ColumnEntity partitionKeyColumnEntity : pkdef.getColumns()) {
                    if (!StringUtils.isEmpty((String)partitionKeyColumnEntity.getName())) {
                        if (!tableColumnNames.contains(partitionKeyColumnEntity.getName())) {
                            this.errorPKColumnDoesNotExist(partitionKeyColumnEntity, ModelUtil.getTable(stmt), partitionKeyPosition);
                        }
                        this.assertPKColumnNotRepeated(declaredColumns, partitionKeyColumnEntity, partitionKeyPosition);
                    }
                    ++partitionKeyPosition;
                }
            }
            ++pkColumnPosition;
        }
    }

    private void assertPKColumnNotRepeated(Set<String> declaredColumns, ColumnEntity pkDefColumnEntity, int pkColumnPosition) {
        if (declaredColumns.contains(pkDefColumnEntity.getName())) {
            this.error(String.format(PK_COLUMN_REPEATED, ModelUtil.stripName(pkDefColumnEntity.getName())), (EStructuralFeature)CqlPackage.Literals.COLUMN_DEF__PRIMARY_KEY_DEFINITIONS, pkColumnPosition, "MULTIPLE_DEFINITION_OF_IDENTIFIER_", new String[0]);
        } else {
            declaredColumns.add(pkDefColumnEntity.getName());
        }
    }

    @Check
    public void checkFieldExist(Selector rule) {
        if (rule.getUserTypeFields() == null || rule.getUserTypeFields().size() == 0) {
            return;
        }
        CqlStatement stmt = ModelUtil.getCqlStatement(rule);
        if (this.isCurrentVersionGreaterOrEqual(CqlConstants.CASSANDRA_2_0_0) && ModelUtil.hasIfExistsClause(stmt)) {
            return;
        }
        ColumnEntity columnEntity = rule.getColumn();
        Column columnMeta = this.contextProvider.get(stmt).getColumnMeta(stmt, columnEntity);
        if (columnMeta != null) {
            UserDefinedTypeCqlDataType colDataType = (UserDefinedTypeCqlDataType)columnMeta.getType();
            UserType userTypeMeta = colDataType.getUserType();
            int index = 0;
            while (index < rule.getUserTypeFields().size()) {
                String fieldName = ModelUtil.stripName(this.getOrResolveFieldName(rule, index));
                UserTypeField userTypeField = userTypeMeta != null ? userTypeMeta.getField(fieldName) : null;
                this.assertFieldExistInType(this.contextProvider.get(stmt), userTypeField, fieldName, ModelUtil.getKeyspace(stmt), userTypeMeta, userTypeMeta.getName(), (EStructuralFeature)CqlPackage.Literals.RULES_WITH_FIELDS_REF__USER_TYPE_FIELDS, index);
                ++index;
            }
        }
    }

    private void assertFieldExistInType(CqlContext context, UserTypeField userTypeField, String fieldName, KeyspaceEntity keyspaceEntity, UserType userType, String typeName, EStructuralFeature feature, int index) {
        if (!context.isFieldExistInTypeInCurrentContext(userTypeField, keyspaceEntity, typeName)) {
            if (!context.isFieldExistInTypeInDatabase(userTypeField, keyspaceEntity, typeName)) {
                this.issueError(String.format(ENTITY_DOES_NOT_EXIST_IN_ENTITY, FIELD_ENTITY, fieldName, TYPE_ENTITY, typeName), feature, index, "FieldNotExist", fieldName);
            } else {
                this.issueWarning(String.format(ENTITY_DOES_NOT_EXIST_IN_ENTITY_IN_CONTEXT, FIELD_ENTITY, fieldName, TYPE_ENTITY, typeName), feature, index, "FieldNotExist", fieldName);
            }
        }
    }

    @Check
    public void checkAlterTypeColumns(AlterTypeStatement stmt) {
        String op = stmt.getOperation().toLowerCase();
        KeyspaceEntity keyspaceEntity = ModelUtil.getKeyspace(stmt);
        TypeEntity typeEntity = ModelUtil.getUserType(stmt);
        String typeName = ModelUtil.stripName(this.getOrResolveTypeName(stmt));
        if (op.equals(ALTER_TABLE_OP_RENAME)) {
            int idx = 0;
            for (FieldEntity fieldEntity : stmt.getNewuserTypeFields()) {
                this.assertFieldNotExistInType(this.contextProvider.get(stmt), fieldEntity, keyspaceEntity, typeEntity, (EStructuralFeature)CqlPackage.Literals.ALTER_TYPE_STATEMENT__NEWUSER_TYPE_FIELDS, idx);
                ++idx;
            }
            idx = 0;
            List<INode> nodes = this.getCrossReferenceNames(stmt, (EStructuralFeature)CqlPackage.Literals.ALTER_TYPE_STATEMENT__OLDUSER_TYPE_FIELDS);
            for (FieldEntity fieldEntity : stmt.getOlduserTypeFields()) {
                String fieldName = fieldEntity.getName() != null ? fieldEntity.getName() : nodes.get(idx).getText().trim();
                this.assertFieldExistInType(this.contextProvider.get(stmt), fieldEntity, ModelUtil.stripName(fieldName), keyspaceEntity, typeEntity, typeName, (EStructuralFeature)CqlPackage.Literals.ALTER_TYPE_STATEMENT__OLDUSER_TYPE_FIELDS, idx);
                ++idx;
            }
        } else if (op.equals(ALTER_TABLE_OP_ADD) && stmt.getAdduserTypeField() != null) {
            FieldEntity fieldEntity = stmt.getAdduserTypeField();
            this.assertFieldNotExistInType(this.contextProvider.get(stmt), fieldEntity, keyspaceEntity, typeEntity, (EStructuralFeature)CqlPackage.Literals.ALTER_TYPE_STATEMENT__ADDUSER_TYPE_FIELD, -1);
        } else if (op.equals(ALTER_TABLE_OP_ALTER) && stmt.getUserTypeField() != null) {
            this.assertFieldExistInType(this.contextProvider.get(stmt), stmt.getUserTypeField(), ModelUtil.stripName(this.getOrResolveFieldName(stmt)), keyspaceEntity, typeEntity, typeName, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_FIELD_REF__USER_TYPE_FIELD, -1);
        }
    }

    private void assertFieldExistInType(CqlContext context, FieldEntity fieldEntity, String fieldName, KeyspaceEntity keyspaceEntity, TypeEntity typeEntity, String typeName, EStructuralFeature feature, int index) {
        if (!context.isFieldExistInTypeInCurrentContext(fieldEntity, keyspaceEntity, typeEntity)) {
            if (!context.isFieldExistInTypeInDatabase(fieldEntity, keyspaceEntity, typeEntity)) {
                this.issueError(String.format(ENTITY_DOES_NOT_EXIST_IN_ENTITY, FIELD_ENTITY, fieldName, TYPE_ENTITY, typeName), feature, index, "FieldNotExist", fieldName);
            } else {
                this.issueWarning(String.format(ENTITY_DOES_NOT_EXIST_IN_ENTITY_IN_CONTEXT, FIELD_ENTITY, fieldName, TYPE_ENTITY, typeName), feature, index, "FieldNotExist", fieldName);
            }
        }
    }

    private void assertFieldNotExistInType(CqlContext context, FieldEntity fieldEntity, KeyspaceEntity keyspaceEntity, TypeEntity typeEntity, EStructuralFeature feature, int index) {
        if (context.isFieldExistInTypeInCurrentContext(fieldEntity, keyspaceEntity, typeEntity)) {
            String fieldName = ModelUtil.stripName(fieldEntity.getName());
            String typeName = ModelUtil.stripName(typeEntity.getName());
            if (context.isFieldExistInTypeInDatabase(fieldEntity, keyspaceEntity, typeEntity)) {
                this.issueError(String.format(ENTITY_ALREADY_EXISTS_IN_ENTITY, FIELD_ENTITY, fieldName, TYPE_ENTITY.toLowerCase(), typeName), feature, index, "FieldExist", fieldName);
            } else {
                this.issueWarning(String.format(ENTITY_ALREADY_EXISTS_IN_ENTITY_IN_CONTEXT, FIELD_ENTITY, fieldName, TYPE_ENTITY.toLowerCase(), typeName), feature, index, "FieldExist", fieldName);
            }
        }
    }
}

