/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.assignment.AssignabilityType;
import com.datastax.devcenter.cql.validation.assignment.Assignment;
import com.datastax.devcenter.cql.validation.assignment.AssignmentTester;
import com.datastax.devcenter.schema.BuiltInFunctionsRegistry;
import com.datastax.devcenter.schema.FunctionParameter;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CqlDataTypeFactory;
import com.datastax.devcenter.schema.types.UnknownCqlDataType;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class FunctionUtil {
    public static Keyspace functionKeyspace(Schema schema, com.datastax.devcenter.cql.cql.Function function) {
        if (schema != null && function != null) {
            return schema.getKeyspace(function.getKeyspace());
        }
        return null;
    }

    public static List<SchemaFunction> findMatchingFunctions(com.datastax.devcenter.cql.cql.Function function, List<Assignment> arguments, Schema schema, boolean requireExactMatch) {
        List<SchemaFunction> candidates = FunctionUtil.findFunctionsByName(function, schema);
        AbstractList compatibleFunctions = new LinkedList<SchemaFunction>();
        for (SchemaFunction f : candidates) {
            AssignabilityType assignabilityType = FunctionUtil.matchArguments(f, arguments, schema, schema.getCurrentKeyspace());
            if (assignabilityType.isExactMatch()) {
                compatibleFunctions = new ArrayList();
                compatibleFunctions.add((SchemaFunction)f);
                return compatibleFunctions;
            }
            if (requireExactMatch || !assignabilityType.isWeaklyAssignable()) continue;
            compatibleFunctions.add(f);
        }
        return compatibleFunctions;
    }

    public static AssignabilityType matchArguments(SchemaFunction f, List<Assignment> arguments, Schema schema, Keyspace ks) {
        if (f.getFunctionParameters().size() != arguments.size() && (f.getFunctionParameters().size() != 1 || f.getFunctionParameters().get(0).getType() != UnknownCqlDataType.INSTANCE)) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        AssignabilityType result = AssignabilityType.EXACT_MATCH;
        int index = 0;
        while (index < arguments.size()) {
            Assignment assignment = arguments.get(index);
            CqlDataType typeExpected = f.getFunctionParameters().get(index).getType();
            AssignabilityType assignabilityType = null;
            assignabilityType = typeExpected == UnknownCqlDataType.INSTANCE ? AssignabilityType.WEAKLY_ASSIGNABLE : AssignmentTester.testAssignment(assignment, typeExpected, schema, ks);
            if (assignabilityType.isWeaklyAssignable()) {
                result = AssignabilityType.WEAKLY_ASSIGNABLE;
            } else if (assignabilityType.isNotAssignable()) {
                return AssignabilityType.NOT_ASSIGNABLE;
            }
            ++index;
        }
        return result;
    }

    public static List<SchemaFunction> findFunctionsByName(com.datastax.devcenter.cql.cql.Function function, Schema schema) {
        ArrayList<SchemaFunction> matchingFunctions = new ArrayList<SchemaFunction>();
        if (function != null && schema != null) {
            List<SchemaFunction> builtIn;
            Keyspace ks = schema.getKeyspace(function.getKeyspace());
            if (ks != null) {
                matchingFunctions.addAll(ks.findMatchingFunctions(ModelUtil.stripName(function.getName())));
            }
            if ((builtIn = BuiltInFunctionsRegistry.getFunctionsWithName(function.getName())) != null) {
                matchingFunctions.addAll(builtIn);
            }
        }
        return matchingFunctions;
    }

    public static List<Assignment> createAssignmentsFromTypes(List<Type> types, Keyspace ksMeta) {
        LinkedList<Assignment> signature = new LinkedList<Assignment>();
        if (types != null) {
            for (Type t : types) {
                signature.add(Assignment.create(CqlDataTypeFactory.fromGrammarType(t, ksMeta), null));
            }
        }
        return signature;
    }

    public static String getFunctionProposalString(SchemaFunction function, boolean parameterized) {
        StringBuilder builder = new StringBuilder("");
        if (function != null) {
            builder.append(function.getFunctionName());
            LinkedList<String> paramNames = new LinkedList<String>();
            for (FunctionParameter fp : function.getFunctionParameters()) {
                if (parameterized) {
                    paramNames.add("${" + fp.getName() + "}");
                    continue;
                }
                paramNames.add(fp.getName());
            }
            builder.append("(");
            builder.append(Joiner.on((String)", ").join(paramNames));
            builder.append(")");
        }
        return builder.toString();
    }

    public static String getFunctionDisplayString(SchemaFunction function) {
        StringBuilder builder = new StringBuilder("");
        if (function != null) {
            builder.append(function.getFunctionName());
            LinkedList<CqlDataType> types = new LinkedList<CqlDataType>();
            for (FunctionParameter fp : function.getFunctionParameters()) {
                types.add(fp.getType());
            }
            builder.append("(");
            builder.append(FunctionUtil.getUnfrozenSignature(types));
            builder.append(")");
        }
        return builder.toString();
    }

    public static String getUnfrozenSignature(List<Assignment> argumentTypes, Schema schema) {
        List<CqlDataType> argumentSignature = FunctionUtil.getArgumentAssignments(argumentTypes, schema);
        String unfrozenSignature = FunctionUtil.getUnfrozenSignature(argumentSignature);
        return unfrozenSignature;
    }

    public static String getUnfrozenSignature(List<CqlDataType> argumentSignature) {
        List<String> unfrozenSignatureStrings = FunctionUtil.getUnfrozenTypeStrings(argumentSignature);
        String unfrozenSignature = Joiner.on((String)", ").join(unfrozenSignatureStrings);
        return unfrozenSignature;
    }

    public static List<String> getUnfrozenTypeStrings(List<CqlDataType> argumentSignature) {
        return Lists.transform(argumentSignature, (Function)new Function<CqlDataType, String>(){

            public String apply(CqlDataType input) {
                return input.toCanonicalString();
            }
        });
    }

    public static List<CqlDataType> getArgumentAssignments(List<Assignment> argumentTypes, Schema schema) {
        LinkedList<CqlDataType> signature = new LinkedList<CqlDataType>();
        for (Assignment assignment : argumentTypes) {
            if (assignment.getTerm().isPresent()) {
                signature.add(CqlDataTypeFactory.fromTermType((Term)assignment.getTerm().get(), schema, schema.getCurrentKeyspace()));
                continue;
            }
            if (!assignment.getColumnType().isPresent()) continue;
            signature.add((CqlDataType)assignment.getColumnType().get());
        }
        return signature;
    }
}

