/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.CreateAggregateFunctionStatement;
import com.datastax.devcenter.cql.cql.CreateFunctionStatement;
import com.datastax.devcenter.cql.cql.DropFunctionStatement;
import com.datastax.devcenter.cql.cql.FieldEntity;
import com.datastax.devcenter.cql.cql.Function;
import com.datastax.devcenter.cql.cql.FunctionDeclarationStatement;
import com.datastax.devcenter.cql.cql.FunctionParameter;
import com.datastax.devcenter.cql.cql.FunctionResource;
import com.datastax.devcenter.cql.cql.KeyspaceEntity;
import com.datastax.devcenter.cql.cql.RulesWithFunctionArgs;
import com.datastax.devcenter.cql.cql.SelectStatement;
import com.datastax.devcenter.cql.cql.Selector;
import com.datastax.devcenter.cql.cql.SelectorFunction;
import com.datastax.devcenter.cql.cql.StatementsWithIfNotExists;
import com.datastax.devcenter.cql.cql.StatementsWithOrReplace;
import com.datastax.devcenter.cql.cql.TableEntity;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.FunctionUtil;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.cql.validation.assignment.Assignment;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.CqlDataTypeFactory;
import com.datastax.devcenter.schema.types.UnknownCqlDataType;
import com.datastax.devcenter.schema.types.UserDefinedTypeCqlDataType;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class FunctionValidator
extends UtilityValidator {
    @Check
    public void checkFunctionNameIsValid(RulesWithFunctionArgs rule) {
        Schema schema = this.getSchemaToCheck(rule);
        this.assertValidFunctionName(rule.getFunctionName(), schema, (EStructuralFeature)CqlPackage.Literals.RULES_WITH_FUNCTION_ARGS__FUNCTION_NAME);
    }

    @Check
    public void checkFunctionNameIsValid(SelectorFunction function) {
        Schema schema = this.getSchemaToCheck(function);
        this.assertValidFunctionName(function.getFunctionName(), schema, (EStructuralFeature)CqlPackage.Literals.SELECTOR_FUNCTION__FUNCTION_NAME);
    }

    @Check
    public void checkFunctionNameIsValid(DropFunctionStatement drop) {
        Schema schema = this.getSchemaToCheck(drop);
        if (!drop.isIfExists()) {
            this.assertValidDropFunction(drop, schema, (EStructuralFeature)CqlPackage.Literals.DROP_FUNCTION_STATEMENT__FUNCTION);
        }
    }

    @Check
    public void checkNaming(Function function) {
        if (ModelUtil.isUnquotedMixedCase(function.getName()) && !function.getName().equals("fromJson") && !function.getName().equals("toJson")) {
            this.warning("unquoted function name is case insensitive", (EStructuralFeature)CqlPackage.Literals.FUNCTION__NAME, "caseInsensitiveName", new String[0]);
        }
    }

    @Check
    public void checkFunctionResourceKeyspace(FunctionResource functionResource) {
        if (functionResource.getFunctionName() != null) {
            Function functionName = functionResource.getFunctionName();
            KeyspaceEntity keyspace = functionName.getKeyspace();
            if (keyspace == null || keyspace.getName().isEmpty()) {
                this.error("Function name not fully qualified", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_FUNCTION_ARGS__FUNCTION_NAME, "FUNCTION_NAME_NOT_FULLY_QUALIFIED", new String[0]);
            } else if ("system".equalsIgnoreCase(keyspace.getName())) {
                this.error("Altering permissions on builtin functions is not supported", (EStructuralFeature)CqlPackage.Literals.RULES_WITH_FUNCTION_ARGS__FUNCTION_NAME, "ALTERING_PERMISSIONS_ON_BUILTIN_FUNCTIONS_IS_NOT_SUPPORTED", new String[0]);
            }
        }
    }

    @Check
    public void checkValidFunctionDeclaration(FunctionDeclarationStatement functionStatement) {
        if (functionStatement.getFunction() != null) {
            Schema schema = this.getSchemaToCheck(functionStatement);
            Keyspace ks = schema.getKeyspace(functionStatement.getFunction().getKeyspace());
            if (ks == null) {
                this.error("Functions must be fully qualified with a keyspace", (EStructuralFeature)functionStatement.getFunction().eContainmentFeature(), "CREATE_FUNCTION_MISSING_KEYSPACE", new String[0]);
            } else {
                StatementsWithIfNotExists ifNotExistsStatement = (StatementsWithIfNotExists)((Object)functionStatement);
                StatementsWithOrReplace orReplace = (StatementsWithOrReplace)((Object)functionStatement);
                if (!ifNotExistsStatement.isIfNotExists() && !orReplace.isReplace()) {
                    this.assertFunctionDoesNotExistInKeyspace(functionStatement, schema, ks);
                }
            }
        }
    }

    private void assertFunctionDoesNotExistInKeyspace(FunctionDeclarationStatement functionStatement, Schema schema, Keyspace ks) {
        List<Assignment> typeArguments = this.getParameterTypesFromFunctionDeclaration(functionStatement, schema);
        Schema dbSchema = this.getDatabaseSchema(functionStatement);
        SchemaFunction existingFunction = this.findExistingFunctionInSchema(functionStatement.getFunction(), typeArguments, dbSchema);
        if (existingFunction != null) {
            this.error(this.getFunctionExistsString(existingFunction), (EStructuralFeature)CqlPackage.Literals.FUNCTION_DECLARATION_STATEMENT__FUNCTION, "FunctionExists", new String[0]);
        } else {
            existingFunction = this.findExistingFunctionInSchema(functionStatement.getFunction(), typeArguments, schema);
            if (existingFunction != null) {
                this.warning(this.getFunctionExistsString(existingFunction), (EStructuralFeature)CqlPackage.Literals.FUNCTION_DECLARATION_STATEMENT__FUNCTION, "FunctionExists", new String[0]);
            }
        }
    }

    private List<Assignment> getParameterTypesFromFunctionDeclaration(FunctionDeclarationStatement functionStatement, Schema schema) {
        LinkedList<Type> functionParameterTypes = new LinkedList<Type>();
        if (functionStatement instanceof CreateFunctionStatement) {
            EList<FunctionParameter> functionParams = ((CreateFunctionStatement)functionStatement).getFunctionParameters();
            for (FunctionParameter fp : functionParams) {
                functionParameterTypes.add(fp.getType());
            }
        } else if (functionStatement instanceof CreateAggregateFunctionStatement) {
            functionParameterTypes = ((CreateAggregateFunctionStatement)functionStatement).getFunctionParameterTypes();
        }
        List<Assignment> arguments = FunctionUtil.createAssignmentsFromTypes(functionParameterTypes, FunctionUtil.functionKeyspace(schema, functionStatement.getFunction()));
        return arguments;
    }

    private SchemaFunction findExistingFunctionInSchema(Function function, List<Assignment> arguments, Schema schemaToSearch) {
        List<SchemaFunction> existingFunction = FunctionUtil.findMatchingFunctions(function, arguments, schemaToSearch, true);
        return existingFunction.size() > 0 ? existingFunction.get(0) : null;
    }

    private String getFunctionExistsString(SchemaFunction function) {
        StringBuilder builder = new StringBuilder("Function ");
        builder.append(function.getKeyspace().getName());
        builder.append(".");
        builder.append(function.getFunctionName());
        builder.append("(");
        builder.append(StringUtils.join(this.getCqlDataTypesFromFunctionParameters(function), (String)", "));
        builder.append(") already exists");
        return builder.toString();
    }

    @Check
    public void checkFunctionUsageLocationValid(Term term) {
        Schema schema = this.getSchemaToCheck(term);
        if (term != null) {
            this.assertFunctionUsageLocationValid(term.getFunctionName(), term, schema);
        }
    }

    @Check
    public void checkFunctionUsageLocationValid(SelectorFunction selectorFunction) {
        Schema schema = this.getSchemaToCheck(selectorFunction);
        if (selectorFunction != null) {
            this.assertFunctionUsageLocationValid(selectorFunction.getFunctionName(), selectorFunction, schema);
        }
    }

    @Check
    public void checkSelectorFunctionArgCount(SelectorFunction selectorFunction) {
        if (selectorFunction.getArgs() != null && selectorFunction.getFunctionName() != null) {
            this.validateFunctionArgumentCount(selectorFunction.getFunctionName(), selectorFunction.getArgs().getSelectors().size(), selectorFunction.getArgs().eContainingFeature());
        }
    }

    @Check
    public void checkFunctionArgCount(RulesWithFunctionArgs rule) {
        if (rule.getArgs() != null && rule.getFunctionName() != null) {
            this.validateFunctionArgumentCount(rule.getFunctionName(), rule.getArgs().getArgs().size(), rule.getArgs().eContainingFeature());
        }
    }

    @Check
    public CqlDataType checkFunctionCallArguments(RulesWithFunctionArgs rule) {
        if (rule.getFunctionName() != null) {
            Function cqlFunction = rule.getFunctionName();
            Schema schema = this.getSchemaToCheck(rule);
            List<Assignment> arguments = CqlDataTypeFactory.fromFunctionArgumentTypes(rule.getFunctionName(), rule.getArgs(), schema);
            return this.validateFunctionSignature(cqlFunction, arguments, schema, rule.getArgs().eContainingFeature(), true, true, false, false);
        }
        return UnknownCqlDataType.INSTANCE;
    }

    @Check
    public void checkDropFunctionValid(DropFunctionStatement drop) {
        if (drop.getFunction() != null && !drop.isIfExists()) {
            Schema schema = this.getSchemaToCheck(drop);
            Keyspace ksMeta = schema.getKeyspace(drop.getFunction().getKeyspace());
            List<Assignment> arguments = FunctionUtil.createAssignmentsFromTypes(drop.getTypes(), ksMeta);
            this.validateFunctionSignature(drop.getFunction(), arguments, schema, (EStructuralFeature)CqlPackage.Literals.DROP_FUNCTION_STATEMENT__FUNCTION, true, false, true, false);
        }
    }

    @Check
    public void checkFunctionCallArguments(SelectorFunction selectorFunction) {
        SelectStatement selectStatement = ModelUtil.getAncestorOfType(selectorFunction, SelectStatement.class);
        if (selectStatement != null && selectStatement.getSelectClause() != null && selectStatement.getSelectClause().getSelectors() != null) {
            EList<Selector> selectors = selectStatement.getSelectClause().getSelectors();
            for (Selector selector : selectors) {
                if (selector.getFunction() == null) continue;
                this.validateFunctionArgumentsInSelector(selector.getFunction(), selectStatement.getTable(), true);
            }
        }
    }

    @Check
    public void checkCreateAggregateReferencesValidFunctions(CreateAggregateFunctionStatement aggregate) {
        Schema schema = this.getSchemaToCheck(aggregate);
        Keyspace ks = schema.getKeyspace(aggregate.getFunction() != null ? aggregate.getFunction().getKeyspace() : null);
        if (aggregate.getFunction() != null && aggregate.getFunction().getKeyspace() != null) {
            ks = schema.getKeyspace(aggregate.getFunction().getKeyspace());
        }
        if (ks != null && aggregate.getStateType() != null) {
            CqlDataType stateDataType = CqlDataTypeFactory.fromGrammarType(aggregate.getStateType(), ks);
            this.validateFinalFunction(aggregate, schema, ks);
            this.validateStateFunction(aggregate, stateDataType, schema, ks);
        }
    }

    private CqlDataType validateFinalFunction(CreateAggregateFunctionStatement aggregate, Schema schema, Keyspace ks) {
        CqlDataType returnType = null;
        Function finalFunction = aggregate.getFinalFunction();
        if (finalFunction != null) {
            this.validateKeyspaceForFunctionReferencedByUDF(schema, ks, finalFunction, (EStructuralFeature)CqlPackage.Literals.CREATE_AGGREGATE_FUNCTION_STATEMENT__FINAL_FUNCTION);
            ArrayList functionTypeParameters = Lists.newArrayList((Object[])new Type[]{aggregate.getStateType()});
            List<Assignment> functionSignature = FunctionUtil.createAssignmentsFromTypes(functionTypeParameters, ks);
            if (this.assertValidFunctionNameInAggregate(finalFunction, functionSignature, schema, (EStructuralFeature)CqlPackage.Literals.CREATE_AGGREGATE_FUNCTION_STATEMENT__FINAL_FUNCTION)) {
                returnType = this.validateFunctionSignature(finalFunction, functionSignature, schema, (EStructuralFeature)CqlPackage.Literals.CREATE_AGGREGATE_FUNCTION_STATEMENT__FINAL_FUNCTION, true, false, true, true);
            }
        }
        return returnType;
    }

    private void validateStateFunction(CreateAggregateFunctionStatement aggregate, CqlDataType stateDataType, Schema schema, Keyspace ks) {
        EList<Type> typeParameters = aggregate.getFunctionParameterTypes();
        Function stateFunction = aggregate.getStateFunction();
        Type stateType = aggregate.getStateType();
        if (stateType != null && stateFunction != null && typeParameters != null) {
            CqlDataType sfuncReturnType;
            this.validateKeyspaceForFunctionReferencedByUDF(schema, ks, stateFunction, (EStructuralFeature)CqlPackage.Literals.CREATE_AGGREGATE_FUNCTION_STATEMENT__STATE_FUNCTION);
            LinkedList stateFunctionTypeParameters = Lists.newLinkedList(typeParameters);
            stateFunctionTypeParameters.add(0, stateType);
            List<Assignment> stateFunctionSignature = FunctionUtil.createAssignmentsFromTypes(stateFunctionTypeParameters, ks);
            if (this.assertValidFunctionNameInAggregate(stateFunction, stateFunctionSignature, schema, (EStructuralFeature)CqlPackage.Literals.CREATE_AGGREGATE_FUNCTION_STATEMENT__STATE_FUNCTION) && (sfuncReturnType = this.validateFunctionSignature(stateFunction, stateFunctionSignature, schema, (EStructuralFeature)CqlPackage.Literals.CREATE_AGGREGATE_FUNCTION_STATEMENT__STATE_FUNCTION, true, false, true, true)) != null && sfuncReturnType != UnknownCqlDataType.INSTANCE && !sfuncReturnType.equals(stateDataType)) {
                this.error(String.format("State function(sfunc) return type is %s but must be the same type as the state data type(stype): %s", sfuncReturnType, stateDataType), (EStructuralFeature)CqlPackage.Literals.CREATE_AGGREGATE_FUNCTION_STATEMENT__STATE_FUNCTION, "NOT_EQUAL_TYPE", new String[0]);
            }
        }
    }

    private void validateKeyspaceForFunctionReferencedByUDF(Schema schema, Keyspace statementKeyspace, Function function, EStructuralFeature feature) {
        Keyspace stateFunctionKS;
        if (function.getKeyspace() != null && !(stateFunctionKS = schema.getKeyspace(function.getKeyspace())).equals(statementKeyspace)) {
            this.error(String.format("A user defined aggregate in keyspace %s cannot refer to a user defined function in keyspace %s; User defined aggregates can only reference functions from the same keyspace they are defined in", statementKeyspace.getName(), stateFunctionKS.getName()), feature, "AGGREGATES_CAN_ONLY_REFERENCE_FUNCTIONS_IN_THE_SAME_KEYSPACE", new String[0]);
        }
    }

    protected CqlDataType validateFunctionSignature(Function function, List<Assignment> typeSignature, Schema schema, EStructuralFeature feature, boolean assertErrors, boolean isFunctionCall, boolean requireExactMatch, boolean requireScalar) {
        CqlDataType returnTypeOfFunction = null;
        List<SchemaFunction> functionsMatchedByName = FunctionUtil.findFunctionsByName(function, schema);
        List<SchemaFunction> compatibleFunctions = FunctionUtil.findMatchingFunctions(function, typeSignature, schema, requireExactMatch);
        if (compatibleFunctions.size() > 1) {
            this.ambiguousFunctionReference(isFunctionCall, feature, compatibleFunctions, function);
        } else {
            if (compatibleFunctions.size() == 1) {
                SchemaFunction matchingFunction = compatibleFunctions.get(0);
                if (matchingFunction.isAggregate() && requireScalar) {
                    this.aggregateFunctionNotAllowed(feature, typeSignature, function, schema);
                }
                returnTypeOfFunction = matchingFunction.getReturnType();
            }
            if (returnTypeOfFunction == null && functionsMatchedByName != null && functionsMatchedByName.size() > 0 && assertErrors) {
                ArrayList<SchemaFunction> functionsMatchingArgCount = new ArrayList<SchemaFunction>();
                for (SchemaFunction schemaFunction : functionsMatchedByName) {
                    if (schemaFunction.getFunctionParameters().size() != typeSignature.size()) continue;
                    functionsMatchingArgCount.add(schemaFunction);
                }
                if (functionsMatchingArgCount.size() == 1) {
                    this.invalidArgumentTypesError(feature, typeSignature, (SchemaFunction)functionsMatchingArgCount.get(0), schema);
                } else if (functionsMatchedByName.size() > 0) {
                    if (isFunctionCall || typeSignature.size() > 0) {
                        this.noFunctionWithMatchingSignatureError(feature, typeSignature, function, schema);
                    } else if (!isFunctionCall && typeSignature.size() == 0 && functionsMatchedByName.size() > 1) {
                        this.ambiguousFunctionReference(isFunctionCall, feature, functionsMatchedByName, function);
                    }
                }
            }
        }
        return returnTypeOfFunction;
    }

    protected CqlDataType validateFunctionArgumentsInSelector(SelectorFunction selectorFunction, TableEntity table, boolean assertErrors) {
        Function cqlFunction = selectorFunction.getFunctionName();
        Schema schema = this.getSchemaToCheck(cqlFunction);
        Keyspace ks = schema.getKeyspace(cqlFunction.getKeyspace());
        EReference feature = CqlPackage.Literals.SELECTOR_FUNCTION__FUNCTION_NAME;
        List<Assignment> argTypes = this.determineSelectorFunctionArgumentTypes(selectorFunction, schema, ks);
        return this.validateFunctionSignature(cqlFunction, argTypes, schema, (EStructuralFeature)feature, assertErrors, true, false, false);
    }

    private List<Assignment> determineSelectorFunctionArgumentTypes(SelectorFunction selectorFunction, Schema schema, Keyspace ks) {
        LinkedList<Assignment> argumentTypes = new LinkedList<Assignment>();
        if (selectorFunction != null && selectorFunction.getArgs().getSelectors() != null) {
            for (Selector selector : selectorFunction.getArgs().getSelectors()) {
                CqlDataType argumentType = UnknownCqlDataType.INSTANCE;
                if (selector.getColumn() != null) {
                    argumentType = this.findColumnReferenceType(schema, ks, selector);
                } else if (selector.getFunction() != null) {
                    List<Assignment> argTypes = this.determineSelectorFunctionArgumentTypes(selector.getFunction(), schema, ks);
                    List<SchemaFunction> matchingFunctions = FunctionUtil.findMatchingFunctions(selector.getFunction().getFunctionName(), argTypes, schema, false);
                    if (matchingFunctions.size() == 1) {
                        argumentType = matchingFunctions.get(0).getReturnType();
                    }
                }
                argumentTypes.add(Assignment.create(argumentType, null));
            }
        }
        return argumentTypes;
    }

    private CqlDataType findColumnReferenceType(Schema schema, Keyspace ks, Selector selector) {
        Column column;
        CqlDataType argumentType = UnknownCqlDataType.INSTANCE;
        Table table = this.getTableMeta(selector);
        if (table != null && (column = this.getColumnMetadata(selector.getColumn(), table)) != null) {
            argumentType = column.getType() instanceof UserDefinedTypeCqlDataType ? this.findFinalTypeUsedInUserDefinedType(selector, (UserDefinedTypeCqlDataType)column.getType()) : column.getType();
        }
        return argumentType;
    }

    private CqlDataType findFinalTypeUsedInUserDefinedType(Selector selector, UserDefinedTypeCqlDataType selectedType) {
        CqlDataType argumentType = UnknownCqlDataType.INSTANCE;
        if (selector.getUserTypeFields() != null && selector.getUserTypeFields().size() > 0) {
            UserType currentUserType = selectedType.getUserType();
            UserTypeField udtField = null;
            for (FieldEntity fieldEntity : selector.getUserTypeFields()) {
                udtField = currentUserType.getField(ModelUtil.stripName(fieldEntity.getName()));
                if (udtField == null) continue;
                currentUserType = udtField.getUserType();
            }
            if (udtField != null) {
                argumentType = udtField.getType();
            }
        } else {
            argumentType = selectedType;
        }
        return argumentType;
    }

    private void aggregateFunctionNotAllowed(EStructuralFeature feature, List<Assignment> typeSignature, Function function, Schema schema) {
        String unfrozenSignature = FunctionUtil.getUnfrozenSignature(typeSignature, schema);
        StringBuilder builder = new StringBuilder("Function ");
        builder.append(function.getName());
        builder.append("(");
        builder.append(unfrozenSignature);
        builder.append(")");
        builder.append(" does not exist or is not a scalar function");
        this.error(builder.toString(), feature, "SFUNC_FFUNC_MUST_BE_SCALAR_FUNCTIONS", new String[0]);
    }

    private void noFunctionWithMatchingSignatureError(EStructuralFeature feature, List<Assignment> argumentTypes, Function f, Schema schema) {
        String unfrozenSignature = FunctionUtil.getUnfrozenSignature(argumentTypes, schema);
        StringBuilder builder = new StringBuilder("Function ");
        builder.append(f.getName());
        builder.append("(");
        builder.append(unfrozenSignature);
        builder.append(")");
        builder.append(" does not exist");
        this.error(builder.toString(), feature, "FUNCTION_ARG_TYPES_DO_NOT_MATCH_FUNCTION", new String[0]);
    }

    private void ambiguousFunctionReference(boolean isFunctionCall, EStructuralFeature feature, List<SchemaFunction> compatibleFunctions, Function f) {
        StringBuilder builder = new StringBuilder("Ambiguous reference to function ");
        builder.append(f.getName());
        builder.append(" (can be matched by the following signatures: ");
        Object[] parameterStrings = new String[compatibleFunctions.size()];
        int index = 0;
        while (index < compatibleFunctions.size()) {
            SchemaFunction compatibleFunction = compatibleFunctions.get(index);
            StringBuilder argBuilder = new StringBuilder();
            argBuilder.append(compatibleFunction.getKeyspace().getName());
            argBuilder.append(".");
            argBuilder.append(compatibleFunction.getFunctionName());
            argBuilder.append(" : ");
            argBuilder.append("(");
            argBuilder.append(StringUtils.join(this.getCqlDataTypesFromFunctionParameters(compatibleFunction), (String)", "));
            argBuilder.append(")");
            argBuilder.append(" -> ");
            argBuilder.append(compatibleFunction.getReturnType());
            parameterStrings[index] = argBuilder.toString();
            ++index;
        }
        builder.append(StringUtils.join((Object[])parameterStrings, (String)", "));
        builder.append(")");
        if (isFunctionCall) {
            builder.append(": use type casts to disambiguate");
        }
        this.error(builder.toString(), feature, "FUNCTION_ARG_TYPES_DO_NOT_MATCH_FUNCTION", new String[0]);
    }

    private void invalidArgumentTypesError(EStructuralFeature feature, List<Assignment> argumentTypes, SchemaFunction f, Schema schema) {
        StringBuilder builder = new StringBuilder("The function ");
        builder.append(f.getFunctionName());
        builder.append("(");
        List<CqlDataType> parameterTypes = this.getCqlDataTypesFromFunctionParameters(f);
        String unfrozenSignature = FunctionUtil.getUnfrozenSignature(argumentTypes, schema);
        LinkedList<String> expectedSignature = new LinkedList<String>();
        for (CqlDataType cdt : parameterTypes) {
            if (cdt instanceof UserDefinedTypeCqlDataType) {
                expectedSignature.add(this.buildUDTString((UserDefinedTypeCqlDataType)cdt));
                continue;
            }
            expectedSignature.add(cdt.toString());
        }
        builder.append(StringUtils.join(expectedSignature, (String)", "));
        builder.append(")");
        builder.append(" is not applicable for the arguments: ");
        builder.append("(");
        builder.append(unfrozenSignature);
        builder.append(")");
        this.error(builder.toString(), feature, "FUNCTION_ARG_TYPES_DO_NOT_MATCH_FUNCTION", new String[0]);
    }

    private List<CqlDataType> getCqlDataTypesFromFunctionParameters(SchemaFunction f) {
        LinkedList<CqlDataType> parameterTypes = new LinkedList<CqlDataType>();
        for (com.datastax.devcenter.schema.FunctionParameter fp : f.getFunctionParameters()) {
            parameterTypes.add(fp.getType());
        }
        return parameterTypes;
    }

    protected boolean assertValidFunctionName(Function functionName, Schema schema, EStructuralFeature feature) {
        boolean valid = true;
        if (functionName != null && !this.functionNameIsValid(functionName, schema, new Predicate[0])) {
            valid = false;
            this.error(String.format("Unknown CQL3 function %s", ModelUtil.stripName(functionName.getName())), feature, "UNKNOWN_CQL3_FUNCTION_CALLED", new String[0]);
        }
        return valid;
    }

    protected boolean assertValidFunctionNameInAggregate(Function functionName, List<Assignment> functionSignature, Schema schema, EStructuralFeature feature) {
        boolean valid = true;
        Predicate<SchemaFunction> notBuiltinFilter = new Predicate<SchemaFunction>(){

            public boolean apply(SchemaFunction input) {
                return !input.isBuiltin();
            }
        };
        if (functionName != null && !this.functionNameIsValid(functionName, schema, notBuiltinFilter)) {
            valid = false;
            this.aggregateFunctionNotAllowed(feature, functionSignature, functionName, schema);
        }
        return valid;
    }

    protected boolean assertValidDropFunction(final DropFunctionStatement dropStatement, Schema schema, EStructuralFeature feature) {
        boolean valid = true;
        Function function = dropStatement.getFunction();
        Predicate<SchemaFunction> aggregateFilter = new Predicate<SchemaFunction>(){

            public boolean apply(SchemaFunction input) {
                return input.isAggregate() == dropStatement.isAggregate();
            }
        };
        Predicate<SchemaFunction> notBuiltinFilter = new Predicate<SchemaFunction>(){

            public boolean apply(SchemaFunction input) {
                return !input.isBuiltin();
            }
        };
        if (function != null && function.getName() != null && !this.functionNameIsValid(dropStatement.getFunction(), schema, aggregateFilter, notBuiltinFilter)) {
            valid = false;
            this.error(String.format("Unknown" + (dropStatement.isAggregate() ? " aggregate" : "") + " function %s", ModelUtil.stripName(function.getName())), feature, "UNKNOWN_CQL3_FUNCTION_CALLED", new String[0]);
        }
        return valid;
    }

    protected boolean functionNameIsValid(Function function, Schema schema, Predicate<SchemaFunction> ... functionFilters) {
        Collection<SchemaFunction> matching = FunctionUtil.findFunctionsByName(function, schema);
        if (functionFilters != null && functionFilters.length > 0) {
            Predicate<SchemaFunction>[] predicateArray = functionFilters;
            int n = functionFilters.length;
            int n2 = 0;
            while (n2 < n) {
                Predicate<SchemaFunction> filter = predicateArray[n2];
                matching = Collections2.filter(matching, filter);
                ++n2;
            }
        }
        return matching != null && matching.size() > 0;
    }

    protected void assertFunctionUsageLocationValid(Function function, EObject functionSource, Schema schema) {
        if (function != null && this.functionNameIsValid(function, schema, new Predicate[0]) && !this.isValidContainingStatementForFunction(function, functionSource)) {
            String functionName = function.getName();
            if ("toJson".equalsIgnoreCase(functionName)) {
                this.error(String.format("toJson() may only be used within the selection clause of SELECT statements", new Object[0]), functionSource, (EStructuralFeature)function.eContainmentFeature(), "INVALID_FUNCTION_USAGE_LOCATION", new String[0]);
            } else if ("fromJson".equalsIgnoreCase(functionName)) {
                this.error(String.format("fromJson() cannot be used in the selection clause of a SELECT statement", new Object[0]), functionSource, (EStructuralFeature)function.eContainmentFeature(), "INVALID_FUNCTION_USAGE_LOCATION", new String[0]);
            } else {
                this.error(String.format("Function %s cannot be used here", functionName), functionSource, (EStructuralFeature)function.eContainmentFeature(), "INVALID_FUNCTION_USAGE_LOCATION", new String[0]);
            }
        }
    }

    private boolean isValidContainingStatementForFunction(Function function, EObject container) {
        Schema schema = this.getSchemaToCheck(function);
        List<SchemaFunction> matchingFunctions = FunctionUtil.findFunctionsByName(function, schema);
        Iterator<SchemaFunction> iterator = matchingFunctions.iterator();
        if (iterator.hasNext()) {
            SchemaFunction f = iterator.next();
            return f == null || f.getContainingStatementType() == null || f.getContainingStatementType().isSuperTypeOf(container.eClass());
        }
        return false;
    }

    protected void validateFunctionArgumentCount(Function function, int argCount, EStructuralFeature structuralFeature) {
        Schema schema = this.getSchemaToCheck(function);
        List<SchemaFunction> matchingFunctions = FunctionUtil.findFunctionsByName(function, schema);
        if (matchingFunctions.size() == 1) {
            this.assertFunctionArgumentCount(matchingFunctions.get(0), argCount, structuralFeature);
        }
    }

    protected void assertFunctionArgumentCount(SchemaFunction function, int size, EStructuralFeature feature) {
        if (!(function == null || function.getFunctionParameters().size() == size || function.getFunctionParameters().size() == 1 && function.getFunctionParameters().get(0).getType() instanceof UnknownCqlDataType)) {
            this.error(String.format("Invalid number of arguments in call to function %s: %d required but %d provided", function.getName(), function.getFunctionParameters().size(), size), feature, "INVALID_NUMBER_OF_ARGUMENTS_IN_CALL_TO_FUNCTION_REQUIRED_BUT_PROVIDED", new String[0]);
        }
    }
}

