/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.cql.validation;

import com.datastax.devcenter.cql.cql.CqlPackage;
import com.datastax.devcenter.cql.cql.DataResource;
import com.datastax.devcenter.cql.cql.FunctionResource;
import com.datastax.devcenter.cql.cql.GrantStatement;
import com.datastax.devcenter.cql.cql.PermissionOrAll;
import com.datastax.devcenter.cql.cql.Resource;
import com.datastax.devcenter.cql.cql.RevokeStatement;
import com.datastax.devcenter.cql.cql.RoleResource;
import com.datastax.devcenter.cql.cql.UserOrRoleEntity;
import com.datastax.devcenter.cql.validation.UtilityValidator;
import com.datastax.devcenter.schema.Permission;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class GrantRevokeStatementValidator
extends UtilityValidator {
    @Check
    public void checkRoleNotGrantedtoSelf(GrantStatement stmt) {
        UserOrRoleEntity userOrRole = stmt.getUserOrRole();
        if (userOrRole == null || userOrRole.getName() == null) {
            return;
        }
        UserOrRoleEntity grantee = stmt.getGrantee();
        if (grantee == null || grantee.getName() == null) {
            return;
        }
        if (userOrRole.getName().equals(grantee.getName())) {
            this.error(String.format("%s is a member of %s", grantee.getName(), userOrRole.getName()), (EStructuralFeature)CqlPackage.Literals.GRANT_STATEMENT__GRANTEE, "GRANTEE_ALREADY_A_MEMBER_OF_USER_OR_ROLE", new String[0]);
        }
    }

    @Check
    public void checkResourceSupportsPermission(GrantStatement stmt) {
        PermissionOrAll permissionOrAll = stmt.getPermissionOrAll();
        if (permissionOrAll == null || permissionOrAll.isAll()) {
            return;
        }
        Resource resource = stmt.getResource();
        if (resource == null) {
            return;
        }
        Permission permission = Permission.valueOf(permissionOrAll.getPermission().toUpperCase());
        this.checkResourceSupportsPermission(resource, permission, (EStructuralFeature)CqlPackage.Literals.GRANT_STATEMENT__PERMISSION_OR_ALL);
    }

    @Check
    public void checkResourceSupportsPermission(RevokeStatement stmt) {
        PermissionOrAll permissionOrAll = stmt.getPermissionOrAll();
        if (permissionOrAll == null || permissionOrAll.isAll()) {
            return;
        }
        Resource resource = stmt.getResource();
        if (resource == null) {
            return;
        }
        Permission permission = Permission.valueOf(permissionOrAll.getPermission().toUpperCase());
        this.checkResourceSupportsPermission(resource, permission, (EStructuralFeature)CqlPackage.Literals.REVOKE_STATEMENT__PERMISSION_OR_ALL);
    }

    private void checkResourceSupportsPermission(Resource resource, Permission permission, EStructuralFeature feature) {
        if (resource.getDataResource() != null) {
            DataResource dataResource = resource.getDataResource();
            if (dataResource.isAll() || dataResource.isKeyspaceResource()) {
                if (!Permission.KEYSPACE_LEVEL_PERMISSIONS.contains((Object)permission)) {
                    this.raiseErrorForPermissionOnResource(permission, "Keyspace", feature);
                }
            } else if (!Permission.TABLE_LEVEL_PERMISSIONS.contains((Object)permission)) {
                this.raiseErrorForPermissionOnResource(permission, "Table", feature);
            }
        } else if (resource.getFunctionResource() != null) {
            FunctionResource functionResource = resource.getFunctionResource();
            if (functionResource.isAll() || functionResource.isAllInKeyspace()) {
                if (!Permission.MULTIPLE_FUNCTION_PERMISSIONS.contains((Object)permission)) {
                    this.raiseErrorForPermissionOnResource(permission, "Function", feature);
                }
            } else if (!Permission.SINGLE_FUNCTION_PERMISSIONS.contains((Object)permission)) {
                this.raiseErrorForPermissionOnResource(permission, "Function", feature);
            }
        } else {
            RoleResource roleResource = resource.getRoleResource();
            if (roleResource.isAll()) {
                if (!Permission.MULTIPLE_ROLE_PERMISSIONS.contains((Object)permission)) {
                    this.raiseErrorForPermissionOnResource(permission, "Role", feature);
                }
            } else if (!Permission.SINGLE_ROLE_PERMISSIONS.contains((Object)permission)) {
                this.raiseErrorForPermissionOnResource(permission, "Role", feature);
            }
        }
    }

    private void raiseErrorForPermissionOnResource(Permission permission, String resourceType, EStructuralFeature feature) {
        this.error(String.format("Permission %s is not supported by a %s resource", new Object[]{permission, resourceType}), feature, "PERMISSION_IS_NOT_SUPPORTED", new String[0]);
    }
}

